/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.startup.util;

import com.kingdee.eas.client.startup.config.ClientConfigUtil;
import com.kingdee.eas.client.startup.exception.EASClientException;
import com.kingdee.eas.client.startup.exception.NetworkException;
import com.kingdee.eas.client.startup.log.ClientStartLogger;
import com.kingdee.eas.client.startup.precess.UpdateListener;
import com.kingdee.eas.client.startup.util.NetworkExceptionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;

public class HttpUtil {
    static final Logger logger = ClientStartLogger.getLogger();

    private static void testConnectJnlp() {
        String downloadAddress = ClientConfigUtil.getUpdateUrl() + "JnlpVersion";
        URL url = null;
        try {
            url = new URL(downloadAddress);
        }
        catch (MalformedURLException e) {
            throw new EASClientException("\u9519\u8bef\u7684URL\u683c\u5f0f" + downloadAddress, e);
        }
        try {
            HttpUtil.testConnection(url, ClientConfigUtil.getWaittime());
        }
        catch (Throwable t) {
            throw EASClientException.convert("\u66f4\u65b0\u670d\u52a1\u4e0d\u53ef\u7528,", t);
        }
    }

    private static void testConnection(URL url, int timeout) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Connection", "Close");
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(timeout * 1000);
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (200 != responseCode) {
                NetworkException ex = new NetworkException("\u8bf7\u6c42\u5931\u8d25\uff0c\u8fd4\u56de\u7684\u54cd\u5e94\u7801\u662f\"" + responseCode + "\"");
                ex.setSolution("\u670d\u52a1\u5668\u90e8\u7f72\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u89e3\u51b3\u3002\u786e\u4fdd\u901a\u8fc7IE\u53ef\u4ee5\u8bbf\u95ee" + url);
                throw ex;
            }
        }
        catch (IOException e) {
            throw NetworkExceptionHandler.handle(url, e);
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    public static void testDownloadFromeUpdateServer() {
        String url = ClientConfigUtil.getUpdateServer() + "download/downloadservice.test";
        String logTitle = "[\u6d4b\u8bd5\u4e0b\u8f7d\u670d\u52a1:" + url + "] ";
        logger.info((Object)(logTitle + "\u6d4b\u8bd5\u5f00\u59cb..."));
        URL downloadServiceTestUrl = null;
        try {
            downloadServiceTestUrl = new URL(url);
            URLConnection cn = downloadServiceTestUrl.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(((HttpURLConnection)cn).getInputStream()));
            String line = in.readLine();
            while (line != null) {
                logger.info((Object)(logTitle + "\u8bfb\u53d6\u5230: " + line));
                if ("download service is available!".equals(line.trim())) {
                    logger.info((Object)(logTitle + "\u6d4b\u8bd5\u7ed3\u679c\uff1a\u4e0b\u8f7d\u670d\u52a1\u53ef\u7528"));
                    return;
                }
                line = in.readLine();
            }
        }
        catch (IOException e) {
            if (HttpUtil.testDownloadFromeServerByFile_SetUrlBat()) {
                return;
            }
            NetworkException networkException = NetworkExceptionHandler.handle(downloadServiceTestUrl, e);
            throw EASClientException.convert("\u4e0b\u8f7d\u670d\u52a1\u4e0d\u53ef\u7528", networkException);
        }
    }

    private static boolean testDownloadFromeServerByFile_SetUrlBat() {
        String url = ClientConfigUtil.getUpdateServer() + "bin/set-url.bat";
        String logTitle = "[\u6d4b\u8bd5\u4e0b\u8f7d\u670d\u52a1:" + url + "] ";
        logger.info((Object)(logTitle + "\u670d\u52a1\u5668\u662f705\u4e4b\u524d\u7684\u7248\u672c"));
        logger.info((Object)(logTitle + "\u6d4b\u8bd5\u5f00\u59cb..."));
        try {
            URL downloadServiceTestUrl = new URL(url);
            URLConnection cn = downloadServiceTestUrl.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(((HttpURLConnection)cn).getInputStream()));
            String line = in.readLine();
            StringBuffer sb = new StringBuffer();
            while (line != null) {
                logger.info((Object)(logTitle + "\u8bfb\u53d6\u5230: " + line));
                line = in.readLine();
                sb.append(line);
            }
            if (sb.length() > 0) {
                logger.info((Object)(logTitle + "\u6d4b\u8bd5\u7ed3\u679c\uff1a\u4e0b\u8f7d\u670d\u52a1\u53ef\u7528"));
                return true;
            }
            logger.info((Object)(logTitle + "\u6d4b\u8bd5\u7ed3\u679c\uff1a\u4e0b\u8f7d\u670d\u52a1\u4e0d\u53ef\u7528"));
            return false;
        }
        catch (IOException e) {
            logger.error((Object)"\u6d4b\u8bd5\u7ed3\u679c\uff1a\u4e0b\u8f7d\u670d\u52a1\u4e0d\u53ef\u7528", (Throwable)e);
            return false;
        }
    }

    public static void testEasUpdateServer() {
        UpdateListener.startStep("\u68c0\u6d4beas\u66f4\u65b0\u670d\u52a1\u662f\u5426\u53ef\u7528");
        HttpUtil.testConnectJnlp();
        HttpUtil.testDownloadFromeUpdateServer();
        UpdateListener.stopStep();
    }

    public static void testDownloadServer() {
        UpdateListener.startStep("\u68c0\u6d4b\u4e0b\u8f7d\u670d\u52a1\u662f\u5426\u53ef\u7528");
        HttpUtil.testDownloadFromeUpdateServer();
        UpdateListener.stopStep();
    }
}

