/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command;

import com.kingdee.bos.cloud.command.ICommand;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CommandFactory {
    private static final String CONFIG_FILE_NAME = "configs/commands.properties";
    private static final String REQUEST_KEY_COMMAND = "command";
    private Properties commandMap = new Properties();
    private static CommandFactory instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandFactory getInstance() throws IOException {
        Class<CommandFactory> clazz = CommandFactory.class;
        synchronized (CommandFactory.class) {
            if (instance == null) {
                instance = new CommandFactory();
                instance.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CommandFactory() {
    }

    private void init() throws IOException {
        try (InputStream resourceAsStream = null;){
            resourceAsStream = CommandFactory.class.getResourceAsStream(CONFIG_FILE_NAME);
            this.commandMap.load(resourceAsStream);
        }
    }

    public ICommand createCommand(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String commandString = request.getParameter(REQUEST_KEY_COMMAND);
        if (StringUtils.isEmpty((String)commandString)) {
            response.sendError(401, "command can't be null!");
            return null;
        }
        String commandClass = this.commandMap.getProperty(commandString);
        if (StringUtils.isEmpty((String)commandClass)) {
            response.sendError(401, "unknown command :" + commandString);
            return null;
        }
        try {
            ICommand command = (ICommand)Class.forName(commandClass).newInstance();
            command.setContext(request, response);
            return command;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }
}

