/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command.impl;

import com.kingdee.bos.cloud.bean.AppInfo;
import com.kingdee.bos.cloud.bean.AppManager;
import com.kingdee.bos.cloud.command.AbstractCommand;
import com.kingdee.bos.cloud.command.CommandHelper;
import com.kingdee.bos.cloud.utils.LogUtil;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.tools.BizMetadataUtil;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.servlet.ServletException;

public class DeleteDynamicMDCommand
extends AbstractCommand {
    @Override
    public boolean doCheckValidate() throws IOException, ServletException {
        String p = this.request.getParameter("metadatapks");
        logger.info((Object)LogUtil.filterLogForging(this.getUserName() + " request delete metdata :" + p));
        String[] pks = p.split(";");
        if (pks.length > 1) {
            for (int i = 0; i < pks.length; ++i) {
                if (pks[i].endsWith("package") || pks[i].endsWith("resource")) continue;
                this.response.sendError(-10006, "\u65e0\u6cd5\u5220\u9664\u975e\u8d44\u6e90\u548c\u5305\u5143\u6570\u636e");
                return false;
            }
        } else if (pks.length == 0 && !pks[0].endsWith("bizunit") && !pks[0].endsWith("biztemplate")) {
            this.response.sendError(-10006, "\u65e0\u6cd5\u5220\u9664\u975e\u8d44\u6e90\u548c\u5305\u5143\u6570\u636e");
            return false;
        }
        return true;
    }

    @Override
    public void execute() throws IOException, ServletException {
        String[] paths = this.getPaths();
        if (!this.updateDB(paths)) {
            return;
        }
        this.delFromDisk(paths);
        this.delFromDB(paths);
    }

    private void delFromDisk(String[] paths) throws IOException {
        String userName = this.getUserName();
        AppInfo info = AppManager.getAppInfo(this.getProjectName());
        File deletedMetas = new File(info.getProject().getSrcMetadataDir().getParentFile(), "deleted");
        if (!deletedMetas.exists()) {
            deletedMetas.mkdirs();
        }
        FileUtils fu = FileUtils.getFileUtils();
        for (int i = 0; i < paths.length; ++i) {
            File file = new File(info.getProject().getSrcMetadataDir(), paths[i]);
            if (file.exists()) {
                logger.info((Object)LogUtil.filterLogForging("Metadata deleted:" + file.getAbsolutePath() + " by " + userName));
                fu.copyFile(file, new File(deletedMetas, paths[i]));
                file.delete();
                continue;
            }
            logger.info((Object)LogUtil.filterLogForging("Metadata deleted:" + file.getAbsolutePath() + " but not exists " + userName));
        }
    }

    private void delFromDB(String[] paths) throws IOException {
        MetaDataPK2[] pks2 = new MetaDataPK2[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            pks2[i] = CommandHelper.getMetadataPK(paths[i]);
        }
        IServerMetadataStore store = this.getServerMetadataStore();
        try {
            store.deleteMetadata(pks2, DEFAULT_PROJECT.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private String[] getPaths() throws IOException {
        int i;
        String p = this.request.getParameter("metadatapks");
        String[] pks = p.split(";");
        String projectName = this.getProjectName();
        AppInfo info = AppManager.getAppInfo(projectName);
        String[] paths = null;
        IMDProject project = info.getProject();
        ArrayList list = new ArrayList();
        IMDFolder root = project.getRoot();
        for (i = 0; i < pks.length; ++i) {
            IMDFile file = root.getChildFile(pks[i]);
            BizMetadataUtil.getBizRelateMetas((IMDFile)file, list, (boolean)true);
        }
        paths = new String[list.size()];
        int n = list.size();
        for (i = 0; i < n; ++i) {
            IMDFile file = (IMDFile)list.get(i);
            paths[i] = file.getPath();
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDB(String[] paths) throws IOException {
        String projectName = this.getProjectName();
        String userName = this.getUserName();
        String sql = "SELECT count(1) FROM T_BIM_MDVIEW WHERE fProjectName=? AND fCreator=? AND (fcheckOutUser is null OR fCheckOutUser=?) AND (";
        String deleteSql = "DELETE FROM T_BIM_MDVIEW WHERE fProjectName=? AND (";
        int count = 0;
        for (int i = 0; i < paths.length; ++i) {
            if (StringUtils.isEmpty((String)paths[i])) continue;
            ++count;
            if (i > 0) {
                sql = sql + " OR";
                deleteSql = deleteSql + " OR";
            }
            sql = sql + " fPath=?";
            deleteSql = deleteSql + " fPath=?";
        }
        sql = sql + ")";
        deleteSql = deleteSql + ")";
        if (count == 0) {
            return true;
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            conn.setAutoCommit(true);
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.setString(1, projectName);
            stmt.setString(2, userName);
            stmt.setString(3, userName);
            for (int i = 0; i < paths.length; ++i) {
                stmt.setString(i + 4, paths[i]);
            }
            ResultSet rs = stmt.executeQuery();
            if (rs.next() && count != rs.getInt(1)) {
                this.response.sendError(-10003, "fail to delete metadata, metadata must not be checken out by others and create by current user!");
                boolean bl = false;
                return bl;
            }
            PreparedStatement stmt1 = conn.prepareStatement(deleteSql);
            stmt1.setString(1, projectName);
            for (int i = 0; i < paths.length; ++i) {
                stmt1.setString(i + 2, paths[i]);
            }
            stmt1.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.response.sendError(401, this.getTrace(ex));
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

