/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command.impl;

import com.kingdee.bos.cloud.bean.AppInfo;
import com.kingdee.bos.cloud.bean.AppManager;
import com.kingdee.bos.cloud.bean.DynamicMDBean;
import com.kingdee.bos.cloud.command.AbstractCommand;
import com.kingdee.bos.md.cache.AliasUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;

public class ListDynamicMetadataCommand
extends AbstractCommand {
    private static final String SQL_SELECT = "SELECT fPath, fAlias, fMD5, fCheckOutUser, fLastModifyUser, fLastModifyTime, fDeployTime, fCreator, fCreateTime FROM T_BIM_MDVIEW WHERE fProjectName=?";

    @Override
    public void execute() throws IOException, ServletException {
        DynamicMDBean[] allBeans;
        try {
            allBeans = this.getBeansFromDB();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
        Map map = this.createResultMap(allBeans);
        this.writeMap2Response(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicMDBean[] getBeansFromDB() throws SQLException, ClassNotFoundException {
        Connection conn = null;
        String projectName = this.getProjectName();
        ArrayList<DynamicMDBean> mds = new ArrayList<DynamicMDBean>();
        try {
            conn = this.getConnection();
            PreparedStatement pstmt = conn.prepareStatement(SQL_SELECT);
            pstmt.setString(1, projectName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                mds.add(this.createBean(rs));
            }
            rs.close();
            pstmt.close();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return mds.toArray(new DynamicMDBean[mds.size()]);
    }

    private DynamicMDBean createBean(ResultSet rs) throws SQLException {
        DynamicMDBean bean = new DynamicMDBean();
        bean.setPath(rs.getString(1));
        bean.setAlias(rs.getString(2));
        bean.setMd5(rs.getString(3));
        bean.setCheckoutUser(rs.getString(4));
        bean.setLastModifyUser(rs.getString(5));
        Timestamp time = rs.getTimestamp(6);
        if (time != null) {
            bean.setLastModifyTime(time.getTime());
        }
        if ((time = rs.getTimestamp(7)) != null) {
            bean.setDeployTime(time.getTime());
        }
        bean.setCreator(rs.getString(8));
        time = rs.getTimestamp(9);
        if (time != null) {
            bean.setCreateTime(time.getTime());
        }
        return bean;
    }

    private Map createResultMap(DynamicMDBean[] beans) {
        AppInfo info = AppManager.getAppInfo(this.getProjectName());
        IMDFolder root = info.getProject().getRoot();
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        for (int i = 0; i < beans.length; ++i) {
            DynamicMDBean bean = beans[i];
            IMDFile file = root.getChildFile(bean.getPath());
            if (!file.toFile().exists()) continue;
            bean.setAlias(AliasUtil.getAlias((IMDResource)file));
            Properties prop = new Properties();
            prop.setProperty("md5", bean.getMd5());
            if (!StringUtils.isEmpty((String)bean.getAlias())) {
                prop.setProperty("alias", bean.getAlias());
            }
            if (!StringUtils.isEmpty((String)bean.getCheckoutUser())) {
                prop.setProperty("checkoutuser", bean.getCheckoutUser());
            }
            if (!StringUtils.isEmpty((String)bean.getLastModifyUser())) {
                prop.setProperty("lastmodifyuser", bean.getLastModifyUser());
            }
            prop.setProperty("lastmodifytime", String.valueOf(bean.getLastModifyTime()));
            prop.setProperty("deploytime", String.valueOf(bean.getDeployTime()));
            prop.setProperty("createtime", String.valueOf(bean.getCreateTime()));
            if (!StringUtils.isEmpty((String)bean.getCreator())) {
                prop.setProperty("creator", bean.getCreator());
            }
            map.put(bean.getPath(), prop);
        }
        return map;
    }

    private void writeMap2Response(Map map) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(map);
        out.flush();
        ServletOutputStream rOut = this.response.getOutputStream();
        rOut.write(bout.toByteArray());
        rOut.flush();
        rOut.close();
    }
}

