/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.command.impl;

import com.kingdee.bos.cloud.bean.AppInfo;
import com.kingdee.bos.cloud.bean.AppManager;
import com.kingdee.bos.cloud.command.AbstractCommand;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.servlet.ServletException;

public class QueryUpdatedMetadataCommand
extends AbstractCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException, ServletException {
        String pks = this.request.getParameter("metadatapks");
        if (StringUtils.isEmpty((String)pks)) {
            this.response.sendError(401, "must set metadatapks parameter");
        }
        String[] pkList = pks.split(";");
        boolean hasMenu = false;
        for (int i = 0; i < pkList.length; ++i) {
            if (!"FnMenuTree.xml".equals(pkList[i])) continue;
            hasMenu = true;
            break;
        }
        String projectName = this.getProjectName();
        AppInfo info = AppManager.getAppInfo(projectName);
        try {
            pkList = this.getRelationMetas(pkList);
        }
        catch (Exception e) {
            this.response.sendError(401, this.getTrace(e));
            return;
        }
        if (pkList.length == 0) {
            if (hasMenu) {
                pkList = new String[]{"FnMenuTree.xml"};
            } else {
                return;
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT fPath, fMD5 FROM T_BIM_MDVIEW WHERE fProjectName=? AND (");
        for (int i = 0; i < pkList.length; ++i) {
            if (i > 0) {
                sql.append(" OR ");
            }
            sql.append("fPath = ?");
        }
        sql.append(")");
        Connection conn = null;
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<String> md5s = new ArrayList<String>();
        try {
            conn = this.getConnection();
            PreparedStatement stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, projectName);
            for (int i = 0; i < pkList.length; ++i) {
                stmt.setString(i + 2, pkList[i]);
            }
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                paths.add(rs.getString(1));
                md5s.add(rs.getString(2));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.response.sendError(401, this.getTrace(ex));
            return;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        PrintWriter writer = this.response.getWriter();
        IMDFolder root = info.getProject().getRoot();
        int n = paths.size();
        for (int i = 0; i < n; ++i) {
            String path = (String)paths.get(i);
            if (!root.getChildFile(path).toFile().exists()) continue;
            writer.println(path + ":" + md5s.get(i));
        }
        writer.flush();
        writer.close();
    }
}

