/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud.servlet;

import com.kingdee.bos.cloud.bean.ProjectInfo;
import com.kingdee.bos.cloud.bean.ProjectInfoManager;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CloudCoreServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String COMMAND_KEY = "action";
    public static final String COMMAND_LOGIN = "chk";
    public static final String COMMAND_LOGOUT = "LOGOUT";
    public static final String COMMAND_RETR_APP_INFO = "getProjectInfo";
    public static final String COMMAND_LIST_APP = "listProjects";

    public void init(ServletConfig config) throws ServletException {
        String path = config.getServletContext().getRealPath("/");
        System.setProperty("%cloud_web_root%", path);
        super.init(config);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String command = request.getParameter(COMMAND_KEY);
        if (command == null) {
            response.sendError(401);
            return;
        }
        if (COMMAND_LOGIN.equals(command)) {
            this.doLogin(request, response);
            return;
        }
        if (COMMAND_LOGOUT.equals(command)) {
            this.doLogout(request, response);
            return;
        }
        if (!this.isLogin(request)) {
            response.sendError(401);
            return;
        }
        if (COMMAND_RETR_APP_INFO.equals(command)) {
            this.retrieveProjectInfo(request, response);
            return;
        }
        if (COMMAND_LIST_APP.equals(command)) {
            this.listProjects(request, response);
            return;
        }
        response.sendError(401);
    }

    private void retrieveProjectInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String projectName = request.getParameter("projid");
        String userName = (String)request.getSession().getAttribute("userName");
        String password = (String)request.getSession().getAttribute("password");
        if (ProjectInfoManager.checkValid(userName, projectName) != 0) {
            response.sendError(-10002, "user:" + userName + " doesn't have permission to access project:" + projectName);
            return;
        }
        if (!userName.equals(password)) {
            response.sendError(401, "user name or password error!");
            return;
        }
        ProjectInfo info = ProjectInfoManager.getProjectInfo(projectName);
        PrintWriter writer = response.getWriter();
        writer.println(info.getUrl());
        writer.flush();
    }

    private void listProjects(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String password;
        String userName = (String)request.getSession().getAttribute("userName");
        if (!userName.equals(password = (String)request.getSession().getAttribute("password"))) {
            response.sendError(401, "user name or password error!");
            return;
        }
        ProjectInfo[] infos = ProjectInfoManager.listProjectInfo(userName);
        PrintWriter writer = response.getWriter();
        for (int i = 0; i < infos.length; ++i) {
            writer.println(infos[i].getName());
        }
        writer.flush();
        writer.close();
    }

    private void doLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String user = request.getParameter("username");
        String psw = request.getParameter("password");
        if (user == null) {
            response.sendError(401);
            return;
        }
        if (!user.equals(psw)) {
            response.sendError(401, "wrong username and password");
            return;
        }
        request.getSession().setAttribute("login_time", (Object)Long.toString(System.currentTimeMillis()));
        request.getSession().setAttribute("userName", (Object)user);
        request.getSession().setAttribute("password", (Object)psw);
    }

    private void doLogout(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().removeAttribute("login_time");
    }

    private boolean isLogin(HttpServletRequest request) {
        return request.getSession().getAttribute("login_time") != null;
    }
}

