/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.eventbus.converter.ConvertersXmlParser;
import com.kingdee.bos.eventbus.converter.IConverterRegister;
import com.kingdee.bos.eventbus.exception.ConverterException;
import com.kingdee.bos.eventbus.parse.ParserContext;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.log4j.Logger;

public abstract class AbstractConverterRegister
implements IConverterRegister {
    private static final Logger logger = Logger.getLogger(AbstractConverterRegister.class);

    protected final void parseConverterConfigFile(ParserContext pc) throws BOSException {
        ConvertersXmlParser parser = new ConvertersXmlParser(pc, this);
        parser.parse();
    }

    @Override
    public void registerConverter(String converterName, String[] types) {
        Converter converter = this.createConverterInstance(converterName);
        for (String type : types) {
            ConvertUtils.register((Converter)converter, (Class)this.forName(type));
            logger.debug((Object)String.format("\u4e3a\u951f\u65a4\u62f7\u951f\u9175\u2605\u62f7%s\u951f\u65a4\u62f7\u6ce8\u951f\u65a4\u62f7Converter\u951f\u65a4\u62f7%s\u951f\u65a4\u62f7", type, converterName));
        }
    }

    private Converter createConverterInstance(String converterName) {
        try {
            Class converterClass = this.forName(converterName);
            Converter converter = (Converter)converterClass.newInstance();
            return converter;
        }
        catch (InstantiationException e) {
            throw new ConverterException(e);
        }
        catch (IllegalAccessException e) {
            throw new ConverterException(e);
        }
    }

    private Class forName(String className) {
        Class<?> converterClass;
        try {
            converterClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ConverterException(e);
        }
        return converterClass;
    }
}

