/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.converter;

import com.kingdee.bos.eventbus.exception.ConverterException;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.Converter;

public class EnumConverter
implements Converter {
    public Object convert(Class type, Object value) {
        if (!(value instanceof String)) {
            return null;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return this.getStaticMethod(type, "getEnum", new Class[]{String.class}, new Object[]{value});
        }
        if (java.lang.Enum.class.isAssignableFrom(type)) {
            String v = (String)value;
            return java.lang.Enum.valueOf(type, v.toUpperCase());
        }
        throw new ConverterException(String.format("Unknown enumeration type [%s]", type.getName()), null);
    }

    private Object getStaticMethod(Class type, String methodName, Class[] parameterTypes, Object[] values) {
        try {
            Method method = type.getMethod("getEnum", String.class);
            return method.invoke((Object)type, values);
        }
        catch (SecurityException e) {
            throw new ConverterException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ConverterException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ConverterException(e);
        }
        catch (IllegalAccessException e) {
            throw new ConverterException(e);
        }
        catch (InvocationTargetException e) {
            throw new ConverterException(e);
        }
    }
}

