/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.eventbus.support;

import com.kingdee.bos.eventbus.HandlerExecutor;
import com.kingdee.bos.eventbus.IEventBus;
import com.kingdee.bos.eventbus.IEventBusMonitor;
import com.kingdee.bos.eventbus.IEventFilter;
import com.kingdee.bos.eventbus.IEventHandler;
import com.kingdee.bos.eventbus.IFilterRegistration;
import com.kingdee.bos.eventbus.IHandlerRegistration;
import com.kingdee.bos.eventbus.KDEvent;
import com.kingdee.bos.eventbus.annotation.EventHandler;
import com.kingdee.bos.eventbus.definition.Handler;
import com.kingdee.bos.eventbus.exception.EventHandlerExecuteException;
import com.kingdee.bos.eventbus.exception.KDEventException;
import com.kingdee.bos.eventbus.support.EventBusDebugLogMonitor;
import com.kingdee.eas.util.AbortException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public final class SimpleEventBus
implements IEventBus {
    private static final String FILTER_GLOBAL = "FILTER_GLOBAL";
    private static final Logger logger = Logger.getLogger(SimpleEventBus.class);
    private final Map<Class<? extends KDEvent>, Map<Object, List<IEventHandler>>> handlers = new HashMap<Class<? extends KDEvent>, Map<Object, List<IEventHandler>>>();
    private boolean filteringEnabled = true;
    private final Map<Object, List<IEventFilter>> filters = new HashMap<Object, List<IEventFilter>>();
    private Map<Class<? extends KDEvent>, Map<Object, List<IEventHandler>>> superTypeHandlers = new HashMap<Class<? extends KDEvent>, Map<Object, List<IEventHandler>>>();
    private Map<KDEvent, List<IEventHandler>> frozenHandlers = new HashMap<KDEvent, List<IEventHandler>>();
    private List<IEventBusMonitor> monitorList = new ArrayList<IEventBusMonitor>();
    private HandlerExecutor handlerExecutor = HandlerExecutor.createHandlerExecutor();
    private boolean supportSuperTypeEvent = true;

    public void setSupportSuperTypeEvent(boolean supportSuperTypeEvent) {
        this.supportSuperTypeEvent = supportSuperTypeEvent;
    }

    public SimpleEventBus() {
        this.addEventBusMonitor(new EventBusDebugLogMonitor());
    }

    @Override
    public IFilterRegistration addEventFilter(IEventFilter filter) {
        return this.doAddFilter(FILTER_GLOBAL, filter);
    }

    @Override
    public IFilterRegistration addEventFilter(Class<? extends KDEvent> eventClass, IEventFilter filter) {
        return this.doAddFilter(eventClass, filter);
    }

    IFilterRegistration doAddFilter(final Object key, final IEventFilter filter) {
        List<IEventFilter> filterList = this.ensureFilterList(key);
        if (filterList.contains(filter)) {
            logger.debug((Object)String.format("\u91cd\u590d\u8ba2\u9605Filter\uff1akey(%s), filter(%s)", key.toString(), filter.getClass().toString()));
        } else {
            filterList.add(filter);
            this.monitorOnFilterSubscribtion(key, filter);
        }
        return new IFilterRegistration(){

            @Override
            public void removeFilter() {
                SimpleEventBus.this.doRemoveFilter(key, filter);
            }
        };
    }

    private void monitorOnFilterSubscribtion(Object key, IEventFilter filter) {
        for (IEventBusMonitor monitor : this.monitorList) {
            monitor.onSubscribeEventFilter(key, filter);
        }
    }

    private void doRemoveFilter(Object key, IEventFilter filter) {
        List<IEventFilter> l = this.getFilterList(key);
        boolean removed = l.remove(filter);
        assert (removed) : "redundant remove call";
    }

    private List<IEventFilter> ensureFilterList(Object key) {
        List<IEventFilter> filterList = this.filters.get(key);
        if (filterList == null) {
            filterList = new CopyOnWriteArrayList<IEventFilter>();
            this.filters.put(key, filterList);
        }
        return filterList;
    }

    private List<IEventFilter> getFilterList(Object key) {
        List<IEventFilter> filterList = this.filters.get(key);
        List<IEventFilter> globalList = this.filters.get(FILTER_GLOBAL);
        if (filterList == null && globalList == null) {
            return new ArrayList<IEventFilter>(0);
        }
        if (filterList == null) {
            filterList = new ArrayList<IEventFilter>();
        }
        if (globalList != null) {
            filterList.addAll(globalList);
        }
        return filterList;
    }

    @Override
    public IHandlerRegistration addHandler(Class<? extends KDEvent> eventClass, IEventHandler handler) throws KDEventException {
        if (eventClass == null) {
            throw new NullPointerException("Cannot add a handler with a null type");
        }
        if (handler == null) {
            throw new NullPointerException("Cannot add a null handler");
        }
        return this.doAddNow(eventClass, null, handler);
    }

    private IHandlerRegistration doAddNow(final Class<? extends KDEvent> eventClass, final Object source, final IEventHandler handler) {
        List<IEventHandler> l = this.ensureHandlerList(eventClass, source);
        if (l.contains(handler)) {
            logger.debug((Object)String.format("\u91cd\u590d\u8ba2\u9605EventHandler\uff1aevent(%s), source(%s), handler(%s)", eventClass.toString(), source != null ? source.toString() : "", handler.getClass().getName()));
        } else {
            l.add(handler);
            this.monitorOnHandlerSubscribtion(eventClass, source, handler);
        }
        return new IHandlerRegistration(){

            @Override
            public void removeHandler() {
                SimpleEventBus.this.doRemoveNow(eventClass, source, handler, false);
            }
        };
    }

    private void monitorOnHandlerSubscribtion(Class<? extends KDEvent> eventClass, Object source, IEventHandler handler) {
        for (IEventBusMonitor monitor : this.monitorList) {
            monitor.onSubscribeEventHandler(eventClass, source, handler);
        }
    }

    private List<IEventHandler> ensureHandlerList(Class<? extends KDEvent> eventClass, Object source) {
        List<IEventHandler> handlers;
        Map<Object, List<IEventHandler>> sourceMap = this.handlers.get(eventClass);
        if (sourceMap == null) {
            sourceMap = new HashMap<Object, List<IEventHandler>>();
            this.handlers.put(eventClass, sourceMap);
        }
        if ((handlers = sourceMap.get(source)) == null) {
            handlers = new CopyOnWriteArrayList<IEventHandler>();
            sourceMap.put(source, handlers);
        }
        return handlers;
    }

    @Override
    public void fireEvent(KDEvent event) {
        if (event == null) {
            throw new NullPointerException("Cannot fire null event");
        }
        this.doFire(event, null);
    }

    @Override
    public IHandlerRegistration addHandlerToSource(Class<? extends KDEvent> eventClass, Object source, IEventHandler handler) {
        if (eventClass == null) {
            throw new NullPointerException("Cannot add a handler with a null type");
        }
        if (source == null) {
            throw new NullPointerException("Cannot add a handler with a null source");
        }
        if (handler == null) {
            throw new NullPointerException("Cannot add a null handler");
        }
        return this.doAddNow(eventClass, source, handler);
    }

    private List<IEventHandler> getDispatchListSupportSubType(Class<? extends KDEvent> eventClass, Object source) {
        List<IEventHandler> handlers = this.getDispatchList(eventClass, source, true);
        Class<? extends KDEvent> clzSuper = eventClass.getSuperclass();
        if (clzSuper != null && !clzSuper.equals(Object.class)) {
            List<IEventHandler> lstSuper = this.getDispatchListSupportSubType(clzSuper, source);
            handlers.addAll(lstSuper);
        }
        return handlers;
    }

    private void doFire(KDEvent event, Object source) {
        if (!event.isLive()) {
            return;
        }
        boolean accept = this.filterEvent(event);
        if (!accept) {
            return;
        }
        List<IEventHandler> handlers = null;
        handlers = !event.isIgnoreSource() ? this.getDispatchList(event.getClass(), source, false) : this.getDispatchListIgnoreSource(event.getClass(), source, false);
        handlers = this.findSuperTypeHandlers(event, source, handlers);
        this.monitorOnBeginFireEvent(event, source, handlers);
        this.fireEvent(event, handlers);
        this.monitorOnEndFireEvent(event, source, handlers);
    }

    private List<IEventHandler> findSuperTypeHandlers(KDEvent event, Object source, List<IEventHandler> handlers) {
        if (!this.supportSuperTypeEvent) {
            return handlers;
        }
        Class<?> clzSuper = event.getClass().getSuperclass();
        List<IEventHandler> lstSuper = this.getDispatchListSupportSubType(clzSuper, source);
        if (handlers.size() == 0) {
            handlers = lstSuper;
        } else {
            handlers.addAll(lstSuper);
        }
        return handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(KDEvent event, List<IEventHandler> handlers) {
        IEventHandler handler;
        boolean isAsynchronouse = false;
        ListIterator<IEventHandler> it = handlers.listIterator();
        try {
            while (it.hasNext()) {
                handler = it.next();
                if (!event.isLive() && Handler.getHandlerLevel(handler.getClass()) == 0) continue;
                if (isAsynchronouse) {
                    this.freezeHandler(event, handler);
                    continue;
                }
                isAsynchronouse = this.fireAEvent(event, handler);
            }
        }
        finally {
            while (it.hasNext()) {
                handler = it.next();
                if (Handler.getHandlerLevel(handler.getClass()) != 2) continue;
                isAsynchronouse = this.fireAEvent(event, handler);
            }
        }
    }

    private boolean fireAEvent(KDEvent event, IEventHandler handler) {
        boolean isAsynchronouse = this.isAsynchronouse(handler.getClass());
        try {
            this.monitorOnBeginExecuteEventHandler(event, handler);
            this.handlerExecutor.executeHandler(event, handler);
            String handlerName = handler.getClass().getName();
            if (handler.getClass().toString().indexOf("WebAnnotationEventHandler") > 0) {
                Method m = handler.getClass().getMethod("getInvoker", new Class[0]);
                handlerName = m.invoke((Object)handler, new Object[0]).getClass().toString();
                handlerName = handlerName.substring(6);
            }
            this.monitorOnEndExecuteEventHandler(event, handler);
        }
        catch (AbortException e) {
            throw e;
        }
        catch (EventHandlerExecuteException e) {
            if (e.getCause() instanceof InvocationTargetException && e.getCause().getCause() instanceof AbortException) {
                throw (AbortException)e.getCause().getCause();
            }
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new EventHandlerExecuteException(e);
        }
        return isAsynchronouse;
    }

    private void freezeHandler(KDEvent event, IEventHandler handler) {
        List<IEventHandler> handlers = this.frozenHandlers.get(event);
        if (handlers == null) {
            handlers = new CopyOnWriteArrayList<IEventHandler>();
            this.frozenHandlers.put(event, handlers);
        }
        handlers.add(handler);
    }

    private boolean isAsynchronouse(Class handlerClass) {
        if (!handlerClass.isAnnotationPresent(EventHandler.class)) {
            return false;
        }
        EventHandler eh = handlerClass.getAnnotation(EventHandler.class);
        return eh.asynchronous();
    }

    private void monitorOnBeginFireEvent(KDEvent event, Object source, List<IEventHandler> handlers) {
        for (IEventBusMonitor monitor : this.monitorList) {
            monitor.beginFireEvent(event, source, handlers);
        }
    }

    private void monitorOnEndFireEvent(KDEvent event, Object source, List<IEventHandler> handlers) {
        for (IEventBusMonitor monitor : this.monitorList) {
            monitor.endFireEvent(event, source, handlers);
        }
    }

    private void monitorOnBeginExecuteEventHandler(KDEvent event, IEventHandler handler) {
        for (IEventBusMonitor monitor : this.monitorList) {
            monitor.beginExecuteEventHandler(event, handler);
        }
    }

    private void monitorOnEndExecuteEventHandler(KDEvent event, IEventHandler handler) {
        for (IEventBusMonitor monitor : this.monitorList) {
            monitor.endExecuteEventHandler(event, handler);
        }
    }

    private List<IEventHandler> getDispatchListIgnoreSource(Class<? extends KDEvent> eventClass, Object source, boolean isSuper) {
        List<IEventHandler> directHandlers = this.getHandlerListIgnoreSource(eventClass, source, isSuper);
        if (source == null) {
            return directHandlers;
        }
        List<IEventHandler> globalHandlers = this.getHandlerListIgnoreSource(eventClass, null, isSuper);
        ArrayList<IEventHandler> rtn = new ArrayList<IEventHandler>(directHandlers);
        rtn.addAll(globalHandlers);
        return rtn;
    }

    private List<IEventHandler> getHandlerListIgnoreSource(Class<? extends KDEvent> eventClass, Object source, boolean isSuper) {
        Map<Object, List<IEventHandler>> sourceMap = null;
        sourceMap = !isSuper ? this.handlers.get(eventClass) : this.superTypeHandlers.get(eventClass);
        if (sourceMap == null) {
            return new ArrayList<IEventHandler>(0);
        }
        ArrayList<IEventHandler> handlers = new ArrayList<IEventHandler>();
        Iterator<List<IEventHandler>> iter = sourceMap.values().iterator();
        if (iter.hasNext()) {
            handlers.addAll((Collection<IEventHandler>)iter.next());
        }
        return handlers;
    }

    private List<IEventHandler> getDispatchList(Class<? extends KDEvent> eventClass, Object source, boolean isSuper) {
        List<IEventHandler> directHandlers = this.getHandlerList(eventClass, source, isSuper);
        if (source == null) {
            return directHandlers;
        }
        List<IEventHandler> globalHandlers = this.getHandlerList(eventClass, null, isSuper);
        ArrayList<IEventHandler> rtn = new ArrayList<IEventHandler>(directHandlers);
        rtn.addAll(globalHandlers);
        return rtn;
    }

    private List<IEventHandler> getHandlerList(Class<? extends KDEvent> eventClass, Object source, boolean isSuper) {
        Map<Object, List<IEventHandler>> sourceMap = null;
        sourceMap = !isSuper ? this.handlers.get(eventClass) : this.superTypeHandlers.get(eventClass);
        if (sourceMap == null) {
            return new ArrayList<IEventHandler>(0);
        }
        List<IEventHandler> handlers = sourceMap.get(source);
        if (handlers == null) {
            return new ArrayList<IEventHandler>(0);
        }
        return handlers;
    }

    @Override
    public void fireEventFromSource(KDEvent event, Object source) {
        if (event == null) {
            throw new NullPointerException("Cannot fire null event");
        }
        if (source == null) {
            throw new NullPointerException("Cannot fire from a null source");
        }
        this.doFire(event, source);
    }

    protected boolean filterEvent(KDEvent event) {
        boolean ret = true;
        if (this.filteringEnabled) {
            ret = this.doFilterEvent(event);
        }
        return ret;
    }

    private boolean doFilterEvent(KDEvent event) {
        List<IEventFilter> eventFilters = this.getFilterList(event.getClass());
        int filterCount = eventFilters.size();
        for (int i = 0; i < filterCount; ++i) {
            IEventFilter filter = eventFilters.get(i);
            this.monitorOnBeginExecuteEventFilter(event, filter);
            boolean accept = filter.accept(event);
            this.monitorOnEndExecuteEventFilter(event, filter);
            if (accept) continue;
            return false;
        }
        return true;
    }

    private void monitorOnBeginExecuteEventFilter(KDEvent event, IEventFilter filter) {
        for (IEventBusMonitor monitor : this.monitorList) {
            monitor.beginExecuteEventFilter(event, filter);
        }
    }

    private void monitorOnEndExecuteEventFilter(KDEvent event, IEventFilter filter) {
        for (IEventBusMonitor monitor : this.monitorList) {
            monitor.endExecuteEventFilter(event, filter);
        }
    }

    @Override
    public IHandlerRegistration addHandlerToSourceForSuper(Class<? extends KDEvent> eventClass, Object source, IEventHandler handler) {
        if (eventClass == null) {
            throw new NullPointerException("Cannot add a handler with a null type");
        }
        if (source == null) {
            throw new NullPointerException("Cannot add a handler with a null source");
        }
        if (handler == null) {
            throw new NullPointerException("Cannot add a null handler");
        }
        return this.doAddNowForSuper(eventClass, source, handler);
    }

    private List<IEventHandler> ensureHandlerListSupportSubType(Class<? extends KDEvent> eventClass, Object source) {
        List<IEventHandler> handlers;
        Map<Object, List<IEventHandler>> sourceMap = this.superTypeHandlers.get(eventClass);
        if (sourceMap == null) {
            sourceMap = new HashMap<Object, List<IEventHandler>>();
            this.superTypeHandlers.put(eventClass, sourceMap);
        }
        if ((handlers = sourceMap.get(source)) == null) {
            handlers = new CopyOnWriteArrayList<IEventHandler>();
            sourceMap.put(source, handlers);
        }
        return handlers;
    }

    @Override
    public IHandlerRegistration addHandlerForSuper(Class<? extends KDEvent> eventClass, IEventHandler handler) {
        if (eventClass == null) {
            throw new NullPointerException("Cannot add a handler with a null type");
        }
        if (handler == null) {
            throw new NullPointerException("Cannot add a null handler");
        }
        return this.doAddNowForSuper(eventClass, null, handler);
    }

    private IHandlerRegistration doAddNowForSuper(final Class<? extends KDEvent> eventClass, final Object source, final IEventHandler handler) {
        List<IEventHandler> l = this.ensureHandlerListSupportSubType(eventClass, source);
        l.add(handler);
        this.monitorOnHandlerSubscribtion(eventClass, source, handler);
        return new IHandlerRegistration(){

            @Override
            public void removeHandler() {
                SimpleEventBus.this.doRemoveNow(eventClass, source, handler, false);
            }
        };
    }

    private void doRemoveNow(Class<? extends KDEvent> eventClass, Object source, IEventHandler handler, boolean isSuper) {
        List<IEventHandler> l = this.getHandlerList(eventClass, source, isSuper);
        boolean removed = l.remove(handler);
        assert (removed) : "redundant remove call";
        if (removed && l.isEmpty()) {
            this.prune(eventClass, source, isSuper);
        }
    }

    private void prune(Class<? extends KDEvent> eventClass, Object source, boolean isSuper) {
        if (!isSuper) {
            this.prune(eventClass, source, this.handlers);
        } else {
            this.prune(eventClass, source, this.superTypeHandlers);
        }
    }

    private void prune(Class<? extends KDEvent> eventClass, Object source, Map<Class<? extends KDEvent>, Map<Object, List<IEventHandler>>> map) {
        Map<Object, List<IEventHandler>> sourceMap = map.get(eventClass);
        List<IEventHandler> pruned = sourceMap.remove(source);
        assert (pruned != null) : "Can't prune what wasn't there";
        assert (pruned.isEmpty()) : "Pruned unempty list!";
        if (sourceMap.isEmpty()) {
            map.remove(eventClass);
        }
    }

    @Override
    public void resumeFireEvent(KDEvent event) {
        List<IEventHandler> handlers = this.frozenHandlers.get(event);
        if (handlers == null) {
            return;
        }
        this.fireEvent(event, handlers);
    }

    @Override
    public void addEventBusMonitor(IEventBusMonitor monitor) {
        String monitorName = monitor.getClass().getName();
        for (IEventBusMonitor ebm : this.monitorList) {
            if (!ebm.getClass().getName().equals(monitorName)) continue;
            return;
        }
        this.monitorList.add(monitor);
    }

    @Override
    public void removeEventBusMonitor(String monitorName) {
        Iterator<IEventBusMonitor> it = this.monitorList.iterator();
        while (it.hasNext()) {
            IEventBusMonitor ebm = it.next();
            if (!ebm.getClass().getName().equals(monitorName)) continue;
            it.remove();
        }
    }
}

