/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.expression;

import com.kingdee.bos.expression.ExpressionEvaluateException;
import com.kingdee.bos.expression.datameta.Variable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class VariableContainer {
    private static ThreadLocal<Map<String, Variable>> variableMapThreadLocal = new ThreadLocal();

    public static Map<String, Variable> getVariableMap() {
        Map<String, Variable> variableMap = variableMapThreadLocal.get();
        if (variableMap == null) {
            variableMap = new HashMap<String, Variable>();
            variableMapThreadLocal.set(variableMap);
        }
        return variableMap;
    }

    public static void setVariableMap(Map<String, Variable> variableMap) {
        VariableContainer.removeVariableMap();
        if (variableMap != null) {
            variableMapThreadLocal.set(variableMap);
        }
    }

    public static void removeVariableMap() {
        Map<String, Variable> variableMap = variableMapThreadLocal.get();
        if (variableMap != null) {
            variableMap.clear();
        }
        variableMapThreadLocal.remove();
    }

    public static void addVariable(Variable variable) {
        if (variable != null) {
            VariableContainer.getVariableMap().put(variable.getVariableName(), variable);
        }
    }

    public static Variable getVariable(String variableName) {
        if (variableName != null) {
            Variable var = VariableContainer.getVariableMap().get(variableName);
            if (var == null && variableName.indexOf(46) > 0) {
                return VariableContainer.getNestedVariable(variableName);
            }
            return var;
        }
        return null;
    }

    private static Variable getNestedVariable(String variableName) {
        String prefix = variableName.substring(0, variableName.indexOf(46));
        Variable varPrefix = VariableContainer.getVariableMap().get(prefix);
        if (varPrefix == null) {
            return null;
        }
        Object valuePrefix = varPrefix.getDataValue();
        String suffix = variableName.substring(variableName.indexOf(46) + 1);
        try {
            Object value = new PropertyUtilsBean().getNestedProperty(valuePrefix, suffix);
            Variable variable = Variable.createVariable(variableName, value);
            return variable;
        }
        catch (Exception e) {
            throw new ExpressionEvaluateException("\u5d4c\u5957\u8868\u8fbe\u5f0f\u53d8\u91cf\u3010" + variableName + "\u3011\u6c42\u503c\u5f02\u5e38", e);
        }
    }

    public static Variable removeVariable(String variableName) {
        return VariableContainer.getVariableMap().remove(variableName);
    }

    public static Variable removeVariable(Variable variable) {
        if (variable != null) {
            return VariableContainer.getVariableMap().remove(variable.getVariableName());
        }
        return null;
    }
}

