/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.expression.function;

import com.kingdee.bos.eventbus.parse.ParserContext;
import com.kingdee.bos.expression.function.FunctionXmlParser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class FunctionLoader {
    private static final String FILE_NAME = "com/kingdee/bos/expression/IKExpression.cfg.xml";
    static final Logger logger = Logger.getLogger(FunctionLoader.class);
    private static final FunctionLoader single = new FunctionLoader();
    private static HashMap<String, FunctionInvoker> functionMap;

    private FunctionLoader() {
        functionMap = new HashMap();
        try {
            this.init();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void init() throws Exception {
        ParserContext pc = new ParserContext(FILE_NAME);
        pc.setClassPath(true);
        FunctionXmlParser parser = new FunctionXmlParser(pc);
        parser.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFunction(String functionName, Object instance, Method method) {
        if (functionName == null || instance == null || method == null) {
            return;
        }
        HashMap<String, FunctionInvoker> hashMap = functionMap;
        synchronized (hashMap) {
            functionMap.put(functionName, new FunctionInvoker(method, instance));
        }
    }

    public static Method loadFunction(String functionName) throws NoSuchMethodException {
        FunctionInvoker f = functionMap.get(functionName);
        if (f == null) {
            throw new NoSuchMethodException();
        }
        return f.method;
    }

    public static Object invokeFunction(String functionName, Object[] parameters) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        FunctionInvoker f = functionMap.get(functionName);
        if (f == null) {
            throw new NoSuchMethodException();
        }
        return f.invoke(parameters);
    }

    private static class FunctionInvoker {
        Method method;
        Object instance;

        public FunctionInvoker(Method m, Object i) {
            this.method = m;
            this.instance = i;
        }

        public Object invoke(Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            return this.method.invoke(this.instance, args);
        }
    }
}

