/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.amqp.impl.recovery;

import com.kingdee.bos.rabbitmq.amqp.Command;
import com.kingdee.bos.rabbitmq.amqp.MetricsCollector;
import com.kingdee.bos.rabbitmq.amqp.NoOpMetricsCollector;
import com.kingdee.bos.rabbitmq.amqp.impl.AMQConnection;
import com.kingdee.bos.rabbitmq.amqp.impl.AMQImpl;
import com.kingdee.bos.rabbitmq.amqp.impl.ChannelN;
import com.kingdee.bos.rabbitmq.amqp.impl.ConsumerWorkService;
import java.io.IOException;

public class RecoveryAwareChannelN
extends ChannelN {
    private volatile long maxSeenDeliveryTag = 0L;
    private volatile long activeDeliveryTagOffset = 0L;

    public RecoveryAwareChannelN(AMQConnection connection, int channelNumber, ConsumerWorkService workService) {
        this(connection, channelNumber, workService, new NoOpMetricsCollector());
    }

    public RecoveryAwareChannelN(AMQConnection connection, int channelNumber, ConsumerWorkService workService, MetricsCollector metricsCollector) {
        super(connection, channelNumber, workService, metricsCollector);
    }

    @Override
    protected void processDelivery(Command command, AMQImpl.Basic.Deliver method) {
        long tag = method.getDeliveryTag();
        if (tag > this.maxSeenDeliveryTag) {
            this.maxSeenDeliveryTag = tag;
        }
        super.processDelivery(command, this.offsetDeliveryTag(method));
    }

    private AMQImpl.Basic.Deliver offsetDeliveryTag(AMQImpl.Basic.Deliver method) {
        return new AMQImpl.Basic.Deliver(method.getConsumerTag(), method.getDeliveryTag() + this.activeDeliveryTagOffset, method.getRedelivered(), method.getExchange(), method.getRoutingKey());
    }

    @Override
    public void basicAck(long deliveryTag, boolean multiple) throws IOException {
        long realTag = deliveryTag - this.activeDeliveryTagOffset;
        if (realTag > 0L || multiple && realTag == 0L) {
            this.transmit(new AMQImpl.Basic.Ack(realTag, multiple));
            this.metricsCollector.basicAck(this, deliveryTag, multiple);
        }
    }

    @Override
    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) throws IOException {
        long realTag = deliveryTag - this.activeDeliveryTagOffset;
        if (realTag > 0L || multiple && realTag == 0L) {
            this.transmit(new AMQImpl.Basic.Nack(realTag, multiple, requeue));
            this.metricsCollector.basicNack(this, deliveryTag);
        }
    }

    @Override
    public void basicReject(long deliveryTag, boolean requeue) throws IOException {
        long realTag = deliveryTag - this.activeDeliveryTagOffset;
        if (realTag > 0L) {
            this.transmit(new AMQImpl.Basic.Reject(realTag, requeue));
            this.metricsCollector.basicReject(this, deliveryTag);
        }
    }

    void inheritOffsetFrom(RecoveryAwareChannelN other) {
        this.activeDeliveryTagOffset = other.getActiveDeliveryTagOffset() + other.getMaxSeenDeliveryTag();
        this.maxSeenDeliveryTag = 0L;
    }

    public long getMaxSeenDeliveryTag() {
        return this.maxSeenDeliveryTag;
    }

    public long getActiveDeliveryTagOffset() {
        return this.activeDeliveryTagOffset;
    }
}

