/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.rabbitmq.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesUtils {
    private static Logger log = Logger.getLogger((String)PropertiesUtils.class.getName());
    private static final String PROP_PATH = "/com/kingdee/bos/rabbitmq/config.properties";

    public static synchronized Properties loadProperties() {
        Properties properties = new Properties();
        BufferedReader reader = null;
        try {
            Object sysType;
            InputStream in = PropertiesUtils.class.getResourceAsStream(PROP_PATH);
            reader = new BufferedReader(new InputStreamReader(in));
            properties.load(reader);
            Object deafultTag = properties.get("mq.debug.queue.tag");
            if (deafultTag != null) {
                System.setProperty("mq.debug.queue.tag", deafultTag.toString());
            }
            if (null != (sysType = properties.get("mq.server.type"))) {
                System.setProperty("mq.server.type", sysType.toString());
            }
        }
        catch (IOException e) {
            log.error((Object)"the path:/com/kingdee/bos/rabbitmq/config.properties properties file read failed.");
            throw new RuntimeException("the path:/com/kingdee/bos/rabbitmq/config.properties properties file read failed.exception info:" + e.getMessage());
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
        }
        return properties;
    }

    public static void main(String[] args) {
        Properties p = PropertiesUtils.loadProperties();
        System.out.println(p);
    }
}

