/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rabbitmq.rabbit.app.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.rabbitmq.entity.RabbitAPIInvokeEntity;
import com.kingdee.bos.rabbitmq.util.RabbitMQHttpAPIUtils;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.rabbitmq.rabbit.app.api.AbstractRabbitAPI;
import com.kingdee.eas.rabbitmq.rabbit.common.QueueDetailInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueueDetailAPI
extends AbstractRabbitAPI {
    private static final String API_KEY = "/api/queues/";

    public static String getURL(RabbitAPIInvokeEntity param, String queueName) {
        return API_KEY + param.getVhost() + "/" + queueName;
    }

    public static List<QueueDetailInfo> getDetails(RabbitAPIInvokeEntity param, List<String> queueList) throws BOSException {
        ArrayList<QueueDetailInfo> list = new ArrayList<QueueDetailInfo>();
        String name = null;
        int consumerCount = 0;
        int msgCount = 0;
        int readCount = 0;
        int unAckCount = 0;
        long memory = 0L;
        List<String> resultList = RabbitMQHttpAPIUtils.doGet(param, queueList);
        String eachResult = null;
        int j = resultList.size();
        for (int i = 0; i < j; ++i) {
            String key;
            JSONObject argJson;
            eachResult = resultList.get(i);
            QueueDetailInfo detail = new QueueDetailInfo();
            JSONObject resultJson = JSONObject.parseObject((String)eachResult);
            if (resultJson.containsKey((Object)"messages")) {
                msgCount = resultJson.getIntValue("messages");
            }
            detail.setTotalSize(msgCount);
            if (resultJson.containsKey((Object)"messages_ready")) {
                readCount = resultJson.getIntValue("messages_ready");
            }
            detail.setReadySize(readCount);
            if (resultJson.containsKey((Object)"messages_unacknowledged")) {
                unAckCount = resultJson.getIntValue("messages_unacknowledged");
            }
            detail.setUnackedSize(unAckCount);
            if (resultJson.containsKey((Object)"message_bytes")) {
                memory = resultJson.getLong("message_bytes");
            }
            detail.setTotalBytes(memory);
            if (resultJson.containsKey((Object)"name")) {
                name = resultJson.getString("name");
                consumerCount = resultJson.getIntValue("consumers");
            }
            detail.setQueue(name);
            detail.setConsumerCount(consumerCount);
            String dParam = null;
            if (resultJson.containsKey((Object)"durable") && resultJson.getBoolean("durable").booleanValue() && resultJson.getBoolean("durable").booleanValue()) {
                dParam = "D;";
            }
            String adParam = null;
            if (resultJson.containsKey((Object)"auto_delete") && resultJson.getBoolean("auto_delete").booleanValue() && resultJson.getBoolean("auto_delete").booleanValue()) {
                adParam = "Auto_Delete;";
            }
            StringBuilder paramSb = new StringBuilder();
            if (!StringUtils.isEmpty((String)dParam)) {
                paramSb.append(dParam);
            }
            if (!StringUtils.isEmpty(adParam)) {
                paramSb.append(adParam);
            }
            if (resultJson.containsKey((Object)"arguments") && !(argJson = resultJson.getJSONObject("arguments")).isEmpty()) {
                paramSb.append(argJson.toJSONString()).append(";");
            }
            detail.setParameters(paramSb.toString());
            HashMap<String, Integer> channelMap = new HashMap<String, Integer>();
            if (resultJson.containsKey((Object)"consumer_details")) {
                JSONArray array = resultJson.getJSONArray("consumer_details");
                for (int k = 0; k < array.size(); ++k) {
                    Object detailJson;
                    JSONObject jObj = array.getJSONObject(k);
                    if (null == jObj || !jObj.containsKey((Object)"channel_details") || !((detailJson = jObj.get((Object)"channel_details")) instanceof JSONObject)) continue;
                    key = ((JSONObject)detailJson).getString("peer_host") + ":" + ((JSONObject)detailJson).getString("peer_port");
                    if (channelMap.containsKey(key)) {
                        channelMap.put(key, (Integer)channelMap.get(key) + 1);
                        continue;
                    }
                    channelMap.put(key, 1);
                }
            }
            ArrayList<String[]> ipList = new ArrayList<String[]>(channelMap.size());
            for (Map.Entry entry : channelMap.entrySet()) {
                String[] consulerArray = new String[3];
                key = (String)entry.getKey();
                consulerArray[0] = key.split(":")[0];
                consulerArray[1] = key.split(":")[1];
                consulerArray[2] = ((Integer)entry.getValue()).toString();
                ipList.add(consulerArray);
            }
            detail.setConsumerIPList(ipList);
            list.add(detail);
        }
        return list;
    }
}

