/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.apply.app.selfreq.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.base.apply.SelfReqBillCollection;
import com.kingdee.eas.base.apply.SelfReqBillFactory;
import com.kingdee.eas.base.apply.SelfReqBillInfo;
import com.kingdee.eas.base.apply.SelfReqException;
import com.kingdee.eas.base.apply.SelfReqTypeFactory;
import com.kingdee.eas.base.apply.SelfReqTypeInfo;
import com.kingdee.eas.base.apply.app.selfreq.handler.ISelfReqServiceHandler;
import com.kingdee.eas.base.apply.app.selfreq.handler.ReqBillExtendInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class BaseSelfReqServiceHandler
implements ISelfReqServiceHandler {
    private static Logger logger = Logger.getLogger(BaseSelfReqServiceHandler.class);
    protected String reqUserId = null;
    protected String[] mutexServices = null;
    protected boolean canIsUserHaveReq = false;

    @Override
    public void reqServiceBefore(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo extendInfo) throws EASBizException, BOSException {
        if (!this.canIsUserHaveReq && this.isUserHaveReq(ctx, info.getReqUser().getId().toString(), info.getSelfReqType())) {
            throw new SelfReqException(SelfReqException.HAVE_REPEATE_RUNINGREQ);
        }
        if (this.mutexServices != null) {
            this.checkServiceMutex(ctx, info, this.mutexServices);
        }
    }

    protected boolean isUserHaveReq(Context ctx, String reqUserId, SelfReqTypeInfo selfReqType) throws BOSException {
        String oql = "select id where reqUser.id = '" + reqUserId + "' and selfReqType.id = '" + selfReqType.getId().toString() + "' and statu in ('20','30','50','60')";
        SelfReqBillCollection selfReqBillCollection = SelfReqBillFactory.getLocalInstance(ctx).getSelfReqBillCollection(oql);
        return selfReqBillCollection != null && !selfReqBillCollection.isEmpty();
    }

    protected boolean isUserHaveReq(Context ctx, String reqUserId, String selfReqTypeNumber) throws BOSException, EASBizException {
        SelfReqTypeInfo selfReqTypeInfo = this.getSelfReqTypeInfo(ctx, selfReqTypeNumber);
        return this.isUserHaveReq(ctx, reqUserId, selfReqTypeInfo);
    }

    protected SelfReqTypeInfo getSelfReqTypeInfo(Context ctx, String selfReqTypeNumber) throws EASBizException, BOSException {
        String oql = "select * where number = '" + selfReqTypeNumber + "'";
        SelfReqTypeInfo selfReqTypeInfo = SelfReqTypeFactory.getLocalInstance(ctx).getSelfReqTypeInfo(oql);
        return selfReqTypeInfo;
    }

    protected void checkServiceMutex(Context ctx, SelfReqBillInfo selfReqBillInfo, String[] mutexReqTypes) throws SelfReqException, EASBizException, BOSException {
        String curSelfReqType;
        List<String> mutexReqTypesList = Arrays.asList(mutexReqTypes);
        if (mutexReqTypesList.contains(curSelfReqType = selfReqBillInfo.getSelfReqType().getNumber())) {
            for (String serviceType : mutexReqTypesList) {
                if (serviceType.equalsIgnoreCase(curSelfReqType)) continue;
                SelfReqTypeInfo selfReqTypeInfo = this.getSelfReqTypeInfo(ctx, serviceType);
                if (!this.isUserHaveReq(ctx, selfReqBillInfo.getReqUser().getId().toString(), selfReqTypeInfo)) continue;
                SelfReqTypeInfo curSelfReqTypeInfo = this.getSelfReqTypeInfo(ctx, curSelfReqType);
                throw new SelfReqException(SelfReqException.SERVICE_IS_MUTEX_EXCEPTION, new String[]{selfReqTypeInfo.getName(), curSelfReqTypeInfo.getName()});
            }
        }
    }

    public String getReqUserId() {
        if (StringUtils.isEmpty((CharSequence)this.reqUserId)) {
            this.reqUserId = ContextUtils.getContextFromSession().getCaller().toString();
        }
        return this.reqUserId;
    }

    public void setReqUserId(String reqUserId) {
        this.reqUserId = reqUserId;
    }

    public String[] getMutexServices() {
        return this.mutexServices;
    }

    public void setMutexServices(String[] mutexServices) {
        this.mutexServices = mutexServices;
    }

    public boolean isCanIsUserHaveReq() {
        return this.canIsUserHaveReq;
    }

    public void setCanIsUserHaveReq(boolean canIsUserHaveReq) {
        this.canIsUserHaveReq = canIsUserHaveReq;
    }
}

