/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.apply.app.selfreq.handler.ca;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.apply.CASelfReqException;
import com.kingdee.eas.base.apply.SelfReqBillInfo;
import com.kingdee.eas.base.apply.app.selfreq.handler.ReqBillExtendInfo;
import com.kingdee.eas.base.apply.app.selfreq.handler.ca.CABaseServiceHandler;
import com.kingdee.eas.base.permission.UsbKeyUserMapCollection;
import com.kingdee.eas.base.permission.UsbKeyUserMapFactory;
import com.kingdee.eas.base.permission.UsbKeyUserMapInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserUSBKeyStateEnum;
import com.kingdee.eas.common.EASBizException;

public class CAReportLostServiceHandler
extends CABaseServiceHandler {
    @Override
    public void reqServiceBefore(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo extendInfo) throws EASBizException, BOSException {
        super.reqServiceBefore(ctx, info, extendInfo);
        boolean isAssignCA = this.isAssignCA(ctx, info.getReqUser().getId().toString());
        if (!isAssignCA) {
            throw new CASelfReqException(CASelfReqException.NOT_OWN_CA);
        }
        UsbKeyUserMapInfo usbKeyUserMapInfo = this.getUsbKeyUserMapInfo(ctx, this.getReqUserId());
        if (usbKeyUserMapInfo != null) {
            if (UserUSBKeyStateEnum.LOST == usbKeyUserMapInfo.getState()) {
                throw new CASelfReqException(CASelfReqException.CA_HAVE_IS_LOST);
            }
            if (UserUSBKeyStateEnum.NOTINIT == usbKeyUserMapInfo.getState()) {
                throw new CASelfReqException(CASelfReqException.CA_NOT_INIT);
            }
        }
    }

    @Override
    public void invokeService(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo extendInfo) throws EASBizException, BOSException {
        this.reportCALost(ctx, info.getReqUser());
    }

    private void reportCALost(Context ctx, UserInfo userInfo) throws EASBizException, BOSException {
        UsbKeyUserMapInfo usbKeyUserInfo = this.getUsbKeyUserMapInfo(ctx, userInfo.getId().toString());
        usbKeyUserInfo.setUser(userInfo);
        usbKeyUserInfo.setState(UserUSBKeyStateEnum.LOST);
        UsbKeyUserMapCollection usbKeyUserMapCol = new UsbKeyUserMapCollection();
        usbKeyUserMapCol.add(usbKeyUserInfo);
        UsbKeyUserMapFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectStringPK(usbKeyUserInfo.getId().toString()), usbKeyUserInfo);
    }
}

