/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.apply.app.selfreq.handler.ca;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.apply.CASelfReqException;
import com.kingdee.eas.base.apply.SelfReqBillInfo;
import com.kingdee.eas.base.apply.app.selfreq.handler.ReqBillExtendInfo;
import com.kingdee.eas.base.apply.app.selfreq.handler.ca.CABaseServiceHandler;
import com.kingdee.eas.base.permission.UsbKeyUserMapCollection;
import com.kingdee.eas.base.permission.UsbKeyUserMapFactory;
import com.kingdee.eas.base.permission.UsbKeyUserMapInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserUSBKeyStateEnum;
import com.kingdee.eas.base.security.EASCertificateFactory;
import com.kingdee.eas.base.security.IEASCertificate;
import com.kingdee.eas.common.EASBizException;
import org.apache.log4j.Logger;

public class CAReqRecycleServiceHandler
extends CABaseServiceHandler {
    private static final Logger logger = CoreUIObject.getLogger(CAReqRecycleServiceHandler.class);

    @Override
    public void reqServiceBefore(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo extendInfo) throws EASBizException, BOSException {
        super.reqServiceBefore(ctx, info, extendInfo);
        boolean isAssignCA = this.isAssignCA(ctx, info.getReqUser().getId().toString());
        if (!isAssignCA) {
            throw new CASelfReqException(CASelfReqException.NOT_OWN_CA);
        }
    }

    @Override
    public void invokeService(Context ctx, SelfReqBillInfo info, ReqBillExtendInfo extendInfo) throws EASBizException, BOSException {
        this.callBackCA(ctx, info.getReqUser());
    }

    private void callBackCA(Context ctx, UserInfo userInfo) throws EASBizException, BOSException {
        UsbKeyUserMapInfo usbKeyUserInfo = this.getUsbKeyUserMapInfo(ctx, userInfo.getId().toString());
        usbKeyUserInfo.setUser(userInfo);
        usbKeyUserInfo.setState(UserUSBKeyStateEnum.NOTINIT);
        usbKeyUserInfo.setUsbkey(null);
        UsbKeyUserMapCollection usbKeyUserMapCol = new UsbKeyUserMapCollection();
        usbKeyUserMapCol.add(usbKeyUserInfo);
        UsbKeyUserMapFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectStringPK(usbKeyUserInfo.getId().toString()), usbKeyUserInfo);
        this.deleteCert(ctx, userInfo);
    }

    private void deleteCert(Context ctx, UserInfo userInfo) throws BOSException, EASBizException {
        IEASCertificate iEASCertificate = EASCertificateFactory.getLocalInstance((Context)ctx);
        String uid = userInfo.getId().toString();
        iEASCertificate.delete("where user.id='" + uid + "'");
        logger.info((Object)("delete cert successfully, user.id is:" + uid));
    }
}

