/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentObsHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentSizeFactory;
import com.kingdee.eas.base.attachment.AttachmentStorageTypeEnum;
import com.kingdee.eas.base.attachment.AttachmentTypeEnum;
import com.kingdee.eas.base.attachment.FtpConfigHelper;
import com.kingdee.eas.base.attachment.FtpConfigInfo;
import com.kingdee.eas.base.attachment.FtpHandleFacadeFactory;
import com.kingdee.eas.base.attachment.IAttachmentFtpHandleFacade;
import com.kingdee.eas.base.attachment.IAttachmentSize;
import com.kingdee.eas.base.attachment.ServerConfigHelper;
import com.kingdee.eas.base.attachment.app.AbstractAttachmentControllerBean;
import com.kingdee.eas.base.attachment.common.AttachmentHelper;
import com.kingdee.eas.base.attachment.ftp.AttachmentUploadServer;
import com.kingdee.eas.base.attachment.util.AttachmentEncryptUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class AttachmentControllerBean
extends AbstractAttachmentControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.app.AttachmentControllerBean");

    @Override
    protected boolean _isFileNameExistedByParam(Context ctx, String boID, String fileName, String param) throws BOSException {
        boolean isExisted = false;
        RowSet rs = null;
        RowSet rsFileName = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            String locale = ctx.getLocale().toString();
            if (fileName.contains("'")) {
                fileName = fileName.replaceAll("'", "''");
            }
            if (StringUtils.equalsIgnoreCase((String)"0", (String)param)) {
                isExisted = true;
            } else if (StringUtils.equalsIgnoreCase((String)"1", (String)param)) {
                String sql = "select count(*) from t_bas_attachment where fname_l2 = '" + fileName + "' or fname_l2 = '" + fileName + "'";
                rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
                rs.next();
                if (rs.getInt(1) != 0) {
                    isExisted = true;
                }
            } else if (StringUtils.equalsIgnoreCase((String)"2", (String)param)) {
                if (boID == null || boID.trim().length() <= 0) {
                    return false;
                }
                boID = boID.trim();
                String bosType = BOSUuid.read((String)boID).getType().toString();
                String sqlFileName = "select count(*) from t_bas_attachment where fname_l2 = '" + fileName + "'and fid in (select fattachmentid from t_bas_boattchasso where FASSOBUSOBJTYPE = '" + bosType + "')";
                rsFileName = SQLUtils.getJdbcRowSet((Connection)cn, (String)sqlFileName);
                rsFileName.next();
                if (rsFileName.getInt(1) != 0) {
                    isExisted = true;
                }
            } else if (StringUtils.equalsIgnoreCase((String)"3", (String)param)) {
                String fieldName = "fname_" + locale;
                String sql = "select count(*) from t_bas_attachment where " + fieldName + " = '" + fileName + "'  and fid in (select fattachmentid from t_bas_boattchasso where fboid = '" + boID + "')";
                rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
                rs.next();
                if (rs.getInt(1) != 0) {
                    isExisted = true;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return isExisted;
    }

    @Override
    protected boolean _isFileNameExisted(Context ctx, String boID, String filename) throws BOSException {
        boolean isExisted;
        block10: {
            isExisted = false;
            IRowSet rs = null;
            try {
                if (StringUtils.isEmpty((String)filename)) {
                    throw new AttachmentException(AttachmentException.FILENAMEISEMPTY);
                }
                String value = this._getInclosureNameDuplicate(ctx);
                String locale = ctx.getLocale().toString();
                String fieldName = "fname_" + locale;
                if ("1".equals(value)) {
                    String sql = "select top 1 fid from t_bas_attachment where " + fieldName + " = ?";
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{filename});
                    if (rs != null && rs.next()) {
                        isExisted = true;
                    }
                    break block10;
                }
                if ("2".equals(value)) {
                    if (boID == null || boID.trim().length() <= 0) {
                        return isExisted;
                    }
                    boID = boID.trim();
                    String bosType = BOSUuid.read((String)boID).getType().toString();
                    String sqlFileName = "select fid from t_bas_attachment where " + fieldName + " =  ? and fid in (select fattachmentid from t_bas_boattchasso where FASSOBUSOBJTYPE = ?)";
                    rs = DbUtil.executeQuery((Context)ctx, (String)sqlFileName, (Object[])new Object[]{filename, bosType});
                    if (rs != null && rs.next()) {
                        isExisted = true;
                    }
                    break block10;
                }
                if ("3".equals(value)) {
                    String sql = "select fid from t_bas_attachment where " + fieldName + " =  ? and fid in (select fattachmentid from t_bas_boattchasso where fboid = ?)";
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{filename, boID});
                    if (rs != null && rs.next()) {
                        isExisted = true;
                    }
                    break block10;
                }
                return isExisted;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return isExisted;
    }

    @Override
    public IObjectPK addnew(Context ctx, AttachmentInfo model) throws BOSException, EASBizException {
        ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
        return this._addnew(ctx, (IObjectValue)model);
    }

    @Override
    public void update(Context ctx, IObjectPK pk, AttachmentInfo model) throws BOSException, EASBizException {
        ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
        super._update(ctx, pk, (IObjectValue)model);
    }

    @Override
    public String _getInclosureNameDuplicate(Context ctx) throws BOSException, EASBizException {
        String value = null;
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        value = iParam.getParamValue(null, "InclosureNameDuplicate");
        return value;
    }

    @Override
    protected String _getAttchIDByFileName(Context ctx, String boID, String fileName) throws BOSException {
        String attchID = "";
        logger.info((Object)"......... getTest");
        RowSet rs = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            String locale = ctx.getLocale().toString();
            String sql = "select a.FID from T_BAS_Attachment a inner join T_BAS_BoAttchAsso b on a.FID=b.FAttachmentID where a.FName_" + locale + "='" + fileName + "' and b.FBoID='" + boID + "'";
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            rs.next();
            attchID = rs.getString(1);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
        return attchID;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
        this._delete(ctx, pk);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String storage;
        AttachmentInfo info = (AttachmentInfo)model;
        byte[] content = info.getFile();
        if (null == info.getAttachTypeEnum()) {
            info.setAttachTypeEnum(AttachmentTypeEnum.BillAttach);
        }
        if (!StringUtils.equalsIgnoreCase((String)"0", (String)(storage = AttachmentHelper.getParam(ctx)))) {
            info.setFile(null);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        if (StringUtils.equalsIgnoreCase((String)"1", (String)storage) && content != null && content.length > 0) {
            info.setId(BOSUuid.read((String)pk.toString()));
            info.setFile(content);
            AttachmentFtpHandleFacadeFactory.getLocalInstance(ctx).upload(info);
        } else if (StringUtils.equalsIgnoreCase((String)"2", (String)storage) && content != null && content.length > 0) {
            String serverPath = ServerConfigHelper.getEASServerPath(ctx, pk.toString());
            AttachmentUploadServer aus = new AttachmentUploadServer();
            aus.addServerContent(serverPath, content);
            ServerConfigHelper.saveServerPath(ctx, pk.toString(), serverPath);
        } else if (StringUtils.equalsIgnoreCase((String)"3", (String)storage) && content != null && content.length > 0) {
            info.setId(BOSUuid.read((String)pk.toString()));
            info.setFile(content);
            AttachmentObsHandleFacadeFactory.getLocalInstance(ctx).upload(info);
        }
        return pk;
    }

    @Override
    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        AttachmentStorageTypeEnum storage;
        AttachmentInfo info = (AttachmentInfo)model;
        byte[] content = info.getFile();
        if (content != null && content.length > 0) {
            try {
                IAttachmentSize attachmentFactory = AttachmentSizeFactory.getLocalInstance(ctx);
                boolean isEncrypt = attachmentFactory.isAttachmentEncrypt();
                if (isEncrypt) {
                    content = AttachmentEncryptUtil.encrypt(content);
                    info.setIsEncrypt(1);
                    info.setFile(content);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!AttachmentStorageTypeEnum.DATABASE.equals((Object)(storage = info.getStorageType()))) {
            info.setFile(null);
        }
        String bosID = AttachmentHandleFacadeFactory.getLocalInstance(ctx).getBosID(info.getId().toString());
        AttachmentInfo attachmentInfo = AttachmentFactory.getLocalInstance(ctx).getAttachmentInfo("select name where id = '" + info.getId().toString() + "'");
        String logName = this.getLogInfo(bosID) + " " + attachmentInfo.getName();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"delete", (BOSObjectType)new AttachmentInfo().getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)logName, (String)"bs_attachment_attachment_update");
        super._updatePartial(ctx, (IObjectValue)info, selector);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        if (AttachmentStorageTypeEnum.FTP.equals((Object)storage) && content != null && content.length > 0) {
            AttachmentFtpHandleFacadeFactory.getLocalInstance(ctx).updateContent(info.getId().toString(), content);
        } else if (AttachmentStorageTypeEnum.EASSERVER.equals((Object)storage) && content != null && content.length > 0) {
            ServerConfigHelper.updateContent(ctx, info.getId().toString(), content);
        } else if (AttachmentStorageTypeEnum.OBS.equals((Object)storage) && content != null && content.length > 0) {
            AttachmentInfo info2 = AttachmentHelper.getAttachmentInfoByObs(ctx, info.getId().toString());
            info2.setFile(content);
            AttachmentObsHandleFacadeFactory.getLocalInstance(ctx).delete(info2.getId().toString());
            AttachmentObsHandleFacadeFactory.getLocalInstance(ctx).updateContent(info2);
        }
    }

    @Override
    protected String _copyAttachment(Context ctx, String attachmentId) throws BOSException {
        logger.info((Object)"......... copyFile1");
        String newBosId = null;
        Connection cn = null;
        try {
            AttachmentStorageTypeEnum type = AttachmentHelper.getStorageType(ctx, attachmentId);
            BOSUuid newBosUuid = BOSUuid.create((BOSObjectType)this.getBOSType());
            newBosId = newBosUuid.toString();
            String sqlStr = "insert into T_Bas_attachment (FID ,FControlUnitID , FCreatorID , FCreateTime , FLastUpdateUserID , FLastUpdateTime ,   FName_L1 , FName_L2 , FName_L3 , FNumber , FDescription_L1 , FDescription_L2 , FDescription_L3 , FSimpleName , FType , FFile , FIsShared , FSharedDesc_L1 , FSharedDesc_L2 , FSharedDesc_L3 , FSize , FSizeInByte , FShareRange,FAttachID,FStorageType ,FFtpID,FRemotepath) (select '" + newBosId + "','" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "',FCreatorID , FCreateTime , FLastUpdateUserID , FLastUpdateTime , FName_L1 , FName_L2 , FName_L3 , FNumber , FDescription_L1 , FDescription_L2 , FDescription_L3 , FSimpleName ,  FType , FFile , FIsShared , FSharedDesc_L1 , FSharedDesc_L2 , FSharedDesc_L3 , FSize , FSizeInByte , FShareRange ,FAttachID,FStorageType,FFtpID ,FRemotepath from T_Bas_attachment where FID = '" + attachmentId + "')";
            DbUtil.execute((Context)ctx, (String)sqlStr);
            logger.info((Object)" sql is over1 ..");
            if (!AttachmentStorageTypeEnum.DATABASE.equals((Object)type)) {
                String storage;
                AttachmentInfo oldatt = this.getAttachmentInfo(ctx, (IObjectPK)new ObjectUuidPK(attachmentId));
                oldatt.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                IAttachmentFtpHandleFacade iAttachmentFtpHandleFacade = AttachmentFtpHandleFacadeFactory.getLocalInstance(ctx);
                byte[] content = oldatt.getFile();
                if (content == null || content.length == 0) {
                    content = iAttachmentFtpHandleFacade.download(attachmentId);
                    oldatt.setFile(content);
                }
                if (StringUtils.equalsIgnoreCase((String)"1", (String)(storage = AttachmentHelper.getParam(ctx))) && content != null && content.length > 0) {
                    AttachmentInfo newatt = this.getAttachmentInfo(ctx, (IObjectPK)new ObjectUuidPK(newBosId));
                    newatt.setFile(content);
                    FtpConfigInfo ftpConfigInfo = FtpConfigHelper.getFtpConfig(ctx);
                    String remotePath = FtpConfigHelper.getRemotePath(ctx, ftpConfigInfo.getRootPath(), newatt);
                    FtpHandleFacadeFactory.getLocalInstance(ctx).upload(ftpConfigInfo, content, remotePath);
                    newatt.setRemotePath(remotePath);
                    newatt.setStorageType(AttachmentStorageTypeEnum.FTP);
                    newatt.setFtp(ftpConfigInfo);
                    newatt.setFile(null);
                    this._update(ctx, (IObjectPK)new ObjectUuidPK(newBosId), (IObjectValue)newatt);
                } else if (StringUtils.equalsIgnoreCase((String)"2", (String)storage) && content != null && content.length > 0) {
                    String serverPath = ServerConfigHelper.getEASServerPath(ctx, newBosUuid.toString());
                    AttachmentUploadServer aus = new AttachmentUploadServer();
                    aus.addServerContent(serverPath, content);
                    ServerConfigHelper.saveServerPath(ctx, newBosUuid.toString(), serverPath);
                } else {
                    logger.error((Object)"copyAtt error,content is null");
                }
                newBosId = newBosUuid.toString();
            }
        }
        catch (Exception e) {
            logger.info((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (cn != null) {
                try {
                    cn.close();
                }
                catch (SQLException e) {
                    logger.info((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return newBosId;
    }

    @Override
    public String getInclosureNameDuplicate(Context ctx) throws BOSException, EASBizException {
        return this._getInclosureNameDuplicate(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachmentInfo getAttachmentInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        byte[] content;
        AttachmentInfo info = super.getAttachmentInfo(ctx, pk);
        InputStream input = null;
        if (info.getFile() == null && info.getFtp() == null && !StringUtils.equalsIgnoreCase((String)"3", (String)AttachmentHelper.getParam(ctx))) {
            input = ServerConfigHelper.getFileFromEASServer(ctx, pk.toString());
            try {
                byte[] file = new byte[input.available()];
                input.read(file, 0, file.length);
                info.setFile(file);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if ((content = info.getFile()) != null && content.length > 0 && info.getIsEncrypt() == 1) {
            try {
                content = AttachmentEncryptUtil.decrypt(content);
                info.setFile(content);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return info;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null || StringUtils.isEmpty((String)pk.toString())) {
            logger.error((Object)("\u8c03\u7528\u9644\u4ef6_delete(ctx, pk), pk\u4f20\u9012\u4e0d\u5408\u6cd5\uff1a" + ctx + "," + pk));
            return;
        }
        if (AttachmentStorageTypeEnum.FTP.equals((Object)AttachmentHelper.getStorageType(ctx, pk.toString()))) {
            AttachmentFtpHandleFacadeFactory.getLocalInstance(ctx).deleteFile(pk.toString());
        } else if (AttachmentStorageTypeEnum.EASSERVER.equals((Object)AttachmentHelper.getStorageType(ctx, pk.toString()))) {
            ServerConfigHelper.deleteFromEASServer(ctx, pk.toString());
        } else if (AttachmentStorageTypeEnum.OBS.equals((Object)AttachmentHelper.getStorageType(ctx, pk.toString()))) {
            AttachmentObsHandleFacadeFactory.getLocalInstance(ctx).delete(pk.toString());
        }
        super._delete(ctx, pk);
    }

    @Override
    protected String _getBoNumByBoIdAndTBName(Context ctx, String boId, String tableName) throws BOSException, EASBizException {
        RowSet rs = null;
        Connection cn = null;
        String boNumber = null;
        try {
            cn = this.getConnection(ctx);
            String sql = "select FNUMBER from " + tableName + " where FID='" + boId + "'";
            rs = SQLUtils.getJdbcRowSet((Connection)cn, (String)sql);
            rs.next();
            boNumber = rs.getString(1);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)cn);
        return boNumber;
    }

    private String getLogInfo(String boId) {
        String logName = "";
        BOSUuid uuid = BOSUuid.read((String)boId);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(uuid.getType());
        IObjectValue data = null;
        try {
            DataBaseInfo info;
            if (ConfigMDUtil.isClient()) {
                data = DynamicObjectFactory.getRemoteInstance().getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
            } else {
                Context ctx = ConfigMDUtil.getContext();
                data = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
            }
            if (data instanceof DataBaseInfo) {
                info = (DataBaseInfo)data;
                logName = entity.getAlias() + " " + info.getNumber();
            } else if (data instanceof CoreBillBaseInfo) {
                info = (CoreBillBaseInfo)data;
                logName = entity.getAlias() + " " + info.getNumber();
            } else {
                logName = entity.getAlias() + " " + boId;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return logName;
    }

    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        ServiceStateManager.getInstance().disableNextCallService("LOG_SERVICE");
        super._update(ctx, pk, (IObjectValue)model);
    }
}

