/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentStorageTypeEnum;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import java.text.NumberFormat;

public class AttachmentHelper {
    public static SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("size"));
        sic.add(new SelectorItemInfo("isShared"));
        sic.add(new SelectorItemInfo("isOnlySameBillShare"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        return sic;
    }

    public static AttachmentInfo getAttachmentInfo(Context ctx, String attachmentId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("boAttchAsso.assoBusObjType"));
        sic.add(new SelectorItemInfo("attachID"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("remotePath"));
        sic.add(new SelectorItemInfo("ftp"));
        AttachmentInfo attachmentInfo = AttachmentHelper.getIAttachment(ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachmentId), sic);
        return attachmentInfo;
    }

    public static AttachmentInfo getAttachmentInfoByObs(Context ctx, String attachmentId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("boAttchAsso.assoBusObjType"));
        sic.add(new SelectorItemInfo("attachID"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("remotePath"));
        sic.add(new SelectorItemInfo("obs"));
        sic.add(new SelectorItemInfo("name"));
        AttachmentInfo attachmentInfo = AttachmentHelper.getIAttachment(ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachmentId), sic);
        return attachmentInfo;
    }

    public static IAttachment getIAttachment(Context ctx) throws BOSException {
        if (ctx == null) {
            return AttachmentFactory.getRemoteInstance();
        }
        return AttachmentFactory.getLocalInstance(ctx);
    }

    public static AttachmentStorageTypeEnum getStorageType(Context ctx, String attachmentId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("storageType"));
        AttachmentInfo attachmentInfo = AttachmentFactory.getLocalInstance(ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachmentId), sic);
        return attachmentInfo.getStorageType();
    }

    public static String getParam(Context ctx) throws BOSException, EASBizException {
        return ParamManager.getParamValue((Context)ctx, null, (String)"ATTACHMENTSTORAGE");
    }

    public static String byteConvert(long size) {
        NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
        df.setMaximumFractionDigits(2);
        if (size < 1024L) {
            return df.format((double)size * 1.0) + "B";
        }
        if (size / 0x100000L < 1L) {
            return df.format((double)size / 1024.0) + "K";
        }
        if (size / 0x40000000L < 1L) {
            return df.format((double)size / 1048576.0) + "M";
        }
        return df.format((double)size / 1.073741824E9) + "G";
    }

    public static String kBConvert(long size) {
        NumberFormat df = CtrlFormatUtilities.getDecimalFormat();
        df.setMaximumFractionDigits(2);
        if (size < 1024L) {
            return df.format((double)size * 1.0) + "K";
        }
        if (size / 0x100000L < 1L) {
            return df.format((double)size / 1024.0) + "M";
        }
        if (size / 0x40000000L < 1L) {
            return df.format((double)size / 1048576.0) + "G";
        }
        return df.format((double)size / 1.073741824E9) + "T";
    }
}

