/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.util;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentHandleFacadeFactory;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.IBatchDownload;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class BatchUpDownLoadUtil {
    private FileGetter fg;
    private static BatchUpDownLoadUtil batchUpDownLoadUtil;
    Logger logger = Logger.getLogger(BatchUpDownLoadUtil.class.getName());

    private BatchUpDownLoadUtil() {
    }

    public static BatchUpDownLoadUtil initBatchUpDownLoadUtil() {
        if (batchUpDownLoadUtil == null) {
            batchUpDownLoadUtil = new BatchUpDownLoadUtil();
        }
        return batchUpDownLoadUtil;
    }

    private FileGetter getFileGetter() throws Exception {
        if (this.fg == null) {
            this.fg = new FileGetter(AttachmentFactory.getRemoteInstance(), AttachmentFtpFacadeFactory.getRemoteInstance());
        }
        return this.fg;
    }

    public void batchDownload(String[] bosID, IBatchDownload imd, Component owner) {
        if (bosID == null || bosID.length == 0) {
            return;
        }
        RealModeIDList id = null;
        try {
            List idList = AttachmentHandleFacadeFactory.getRemoteInstance().getAttachmentID(bosID);
            Iterator it = idList.iterator();
            while (it.hasNext()) {
                if (id == null) {
                    id = new RealModeIDList();
                }
                id.add(it.next().toString());
            }
            this.getFileGetter().downloadAttachment((IIDList)id, owner, imd);
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
    }

    public void batchUpLoad(IBatchDownload imd, Component owner) {
        this.batchUpLoad(imd, owner, true);
    }

    public void batchUpLoad(IBatchDownload imd, Component owner, boolean isMessage) {
        try {
            AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
            File[] attachFile = attachmentClientManager.showUploadFilesUI(owner);
            File[] tempFile = new File[1];
            File file = null;
            AttachmentUIContextInfo info = null;
            String filename = "";
            String bosID = "";
            if (attachFile != null && attachFile.length > 100) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.attachment.AttachmentResources", (String)"oneUploadMaxCount"));
                return;
            }
            for (int i = 0; i < attachFile.length; ++i) {
                file = attachFile[i];
                info = new AttachmentUIContextInfo();
                filename = file.getName();
                String extentionName = StringUtil4File.getExtendedFileName(filename);
                if (StringUtils.isEmpty((String)extentionName)) {
                    MsgBox.showInfo((String)"\u5b58\u5728\u9644\u4ef6\u6ca1\u6709\u6269\u5c55\u540d\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u4e0a\u4f20\uff01");
                    return;
                }
                bosID = imd.getBosID(filename = filename.substring(0, filename.lastIndexOf(".")));
                if (StringUtils.isEmpty((String)bosID)) continue;
                info.setBoID(bosID);
                info.setCode("");
                info.setEdit(true);
                tempFile[0] = file;
                attachmentClientManager.uploadFile(tempFile, owner, info, false);
            }
            if (isMessage) {
                MsgBox.showInfo((Component)owner, (String)Resrcs.getString("FileInputSuccess"));
            }
        }
        catch (BOSException be) {
            this.logger.info(be.getMessage());
        }
        catch (EASBizException e) {
            this.logger.info(e.getMessage());
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
    }
}

