/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.attachment.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.client.PicShowUI;
import com.kingdee.eas.base.attachment.common.FileOpenCacheManager;
import com.kingdee.eas.base.attachment.ftp.AttachmentDownloadClient;
import com.kingdee.eas.base.attachment.util.AttachmentPropertiesUtil;
import com.kingdee.eas.base.attachment.util.IBatchDownload;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.uiframe.client.LoginFrame;
import com.kingdee.eas.base.usermonitor.client.KDPromptPane;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.sso.client.CheckListLF;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.DataZipUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import sun.misc.Cleaner;
import sun.security.action.GetPropertyAction;

public class FileGetter {
    private IAttachment ia;
    private IAttachmentFtpFacade iAff;
    private int alreadyFileDealWay = -1;
    private OutputStream out;
    public static final int RET_VALUE_ALLREPLACE = 0;
    public static final int RET_VALUE_REPLACE = 1;
    public static final int RET_VALUE_CANCEL = 2;
    public static final int RET_VALUE_CLOSE = -1;
    public static final String FILE_PATH = "FILE_PATH";
    private static final String DEFAULT_PATH = System.getProperty("user.home") + File.separator + "TempDownloadedFiles";
    private byte[] waitTempFile = null;
    private String waitAttachmentId = "";
    private Component waitOwner;
    private static List tempAttachmentList;
    private static List tempAttachmentList1;
    private static List tempAttachmentFileList;
    private boolean isDownLoadOK = false;
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.attachment.util.FileGetter");

    public FileGetter(IAttachment ia, IAttachmentFtpFacade iAff) {
        this.ia = ia;
        this.iAff = iAff;
        tempAttachmentList = new ArrayList();
        tempAttachmentFileList = new ArrayList();
        tempAttachmentList1 = new ArrayList();
    }

    private String getFileName(String attchID) {
        AttachmentInfo ai;
        String name = "";
        String type = "";
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("simpleName"));
        try {
            ai = (AttachmentInfo)this.ia.getValue((IObjectPK)new ObjectUuidPK(attchID), sic);
        }
        catch (EASBizException e) {
            this.logger.info((Object)"", (Throwable)e);
            return "";
        }
        catch (BOSException e) {
            this.logger.info((Object)"", (Throwable)e);
            return "";
        }
        if (ai != null) {
            name = ai.getName();
            type = ai.getSimpleName();
            return StringUtils.cnulls((String)name) + "." + StringUtils.cnulls((String)type);
        }
        return "";
    }

    private byte[] getFileFromFtp(String attachmentID) throws EASBizException, BOSException {
        this.logger.error((Object)"****FileGetter.getFileFromFtp*********");
        AttachmentDownloadClient downloadClient = new AttachmentDownloadClient(this.iAff);
        downloadClient.setOutputStream(this.out);
        downloadClient.downLoad(attachmentID);
        return null;
    }

    private void downLoadFile() throws EASBizException, BOSException {
        this.waitTempFile = this.getFileFromFtp(this.waitAttachmentId);
    }

    private void waitForDownLoadFile() {
        this.logger.info((Object)"show waiting dialog");
        KDDialog dialog = null;
        Window win = null;
        if (this.waitOwner != null) {
            win = SwingUtilities.getWindowAncestor(this.waitOwner);
        }
        dialog = win != null && win instanceof KDDialog ? (KDDialog)win : new KDDialog();
        LongTimeDialog ltd = new LongTimeDialog((Dialog)dialog);
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    FileGetter.this.logger.error((Object)"***LongTimeDialog 1*********");
                    long begin = System.currentTimeMillis();
                    FileGetter.this.downLoadFile();
                    System.out.println("downLoadFile cost=" + (System.currentTimeMillis() - begin) / 1000L + " s");
                    FileGetter.this.isDownLoadOK = true;
                }
                catch (Exception e) {
                    FileGetter.this.logger.error((Object)e);
                    FileGetter.this.isDownLoadOK = false;
                    throw e;
                }
                return FileGetter.this.isDownLoadOK;
            }

            public void afterExec(Object arg0) throws Exception {
            }
        });
        ltd.show();
    }

    public File download4edit(String attchID) {
        String name = "";
        String type = "";
        File file = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("simpleName"));
            sic.add(new SelectorItemInfo("sizeInByte"));
            AttachmentInfo ai = (AttachmentInfo)this.ia.getValue((IObjectPK)new ObjectUuidPK(attchID), sic);
            this.waitAttachmentId = ai.getId().toString();
            type = ai.getSimpleName();
            file = File.createTempFile("KDTF" + name, "." + type);
            this.out = new FileOutputStream(file);
            this.waitForDownLoadFile();
            this.out.close();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return file;
    }

    public String download(String attchID, String path, String fileName, IBatchDownload imd) {
        String name = "";
        String type = "";
        String fullname = "";
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("simpleName"));
            sic.add(new SelectorItemInfo("sizeInByte"));
            AttachmentInfo ai = (AttachmentInfo)this.ia.getValue((IObjectPK)new ObjectUuidPK(attchID), sic);
            this.waitAttachmentId = ai.getId().toString();
            this.logger.error((Object)"*******before download********");
            File file = null;
            if (imd == null) {
                name = ai.getName();
            } else {
                fileName = null;
                String bosID = "";
                bosID = AttachmentHandleFacadeFactory.getRemoteInstance().getBosID(attchID);
                if (StringUtils.isEmpty((String)bosID)) {
                    return "";
                }
                name = imd.getFileName(bosID);
            }
            type = ai.getSimpleName();
            if (path.equals("")) {
                file = File.createTempFile("KDTF-" + name, "." + type);
                fullname = file.getPath();
            } else {
                fullname = fileName == null ? path + File.separator + name + "." + type : (path.endsWith(File.separator) ? path + fileName : path + File.separator + fileName);
                file = new File(fullname);
            }
            if (file.exists() && !path.equals("")) {
                if (1 == this.alreadyFileDealWay || this.alreadyFileDealWay == -1) {
                    this.alreadyFileDealWay = this.getFileDealWay(file.getName());
                }
                if (0 == this.alreadyFileDealWay || 1 == this.alreadyFileDealWay) {
                    file.delete();
                } else {
                    return "";
                }
            }
            this.out = new FileOutputStream(file);
            this.waitForDownLoadFile();
            this.out.close();
        }
        catch (Exception e) {
            MsgBox.showInfo((String)Resrcs.getString("PathNotExisted"));
            fullname = "";
        }
        return fullname;
    }

    public String download(String attchID, String path, String fileName) {
        return this.download(attchID, path, fileName, null);
    }

    private int getFileDealWay(String fileName) {
        try {
            UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            KDFrame iuiWindow = (KDFrame)LoginFrame.getLoginFrame();
            String msg = fileName + "  " + Resrcs.getString("FileExisted");
            String[] options = new String[]{Resrcs.getString("FileDealWay0"), Resrcs.getString("FileDealWay1"), Resrcs.getString("FileDealWay2")};
            String title = Resrcs.getString("FileDealWayTitle");
            KDPromptPane kdPromptPane = new KDPromptPane((Frame)iuiWindow, title, msg, null, options, 3, 1);
            kdPromptPane.show();
            return kdPromptPane.getResult();
        }
        catch (UIException e) {
            this.logger.info((Object)"", (Throwable)e);
            return -1;
        }
    }

    public String download(String attchID, String path) {
        return this.download(attchID, path, null);
    }

    public String downloadAttachment(String attchID, Component owner) {
        this.waitOwner = owner;
        if (attchID != null && !attchID.trim().equals("")) {
            RealModeIDList attchIDList = new RealModeIDList();
            attchIDList.add(attchID);
            return this.downloadAttachment((IIDList)attchIDList, owner);
        }
        return "";
    }

    public String downloadAttachment(IIDList attchIDList, Component owner, IBatchDownload imd) {
        if (attchIDList == null || attchIDList.size() == 0) {
            return "";
        }
        this.waitOwner = owner;
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hisPath = System.getProperty("user.home");
        try {
            hisPath = new FileOpenCacheManager().getMemorizeAssistorInfo(userID, "downloadcatch");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        KDFileChooser fc = new KDFileChooser(hisPath);
        boolean isMutiDownload = false;
        if (attchIDList.size() > 1 || imd != null) {
            isMutiDownload = true;
            fc.setFileSelectionMode(1);
        } else {
            isMutiDownload = false;
            fc.setFileSelectionMode(0);
            fc.setSelectedFile(new File(this.getFileName(attchIDList.getID(0))));
        }
        fc.setMultiSelectionEnabled(false);
        fc.setAcceptAllFileFilterUsed(true);
        boolean isPathValid = false;
        String path = "";
        String fileNameUser = null;
        while (!isPathValid) {
            String tempMayPath;
            int rv = fc.showSaveDialog(owner);
            if (rv == 1) {
                return "";
            }
            File rf = fc.getSelectedFile();
            if (rf.exists()) {
                isPathValid = true;
                path = isMutiDownload ? fc.getSelectedFile().getPath() : fc.getCurrentDirectory().getPath();
                tempMayPath = fc.getSelectedFile().toString();
                fileNameUser = tempMayPath.substring(tempMayPath.lastIndexOf(File.separator) + 1, tempMayPath.length());
            } else {
                int lastPos;
                tempMayPath = rf.getPath();
                String tempPath = tempMayPath.substring(0, lastPos = tempMayPath.lastIndexOf(File.separator));
                File tempFile = new File(tempPath);
                if (tempFile.exists() && !tempFile.isFile()) {
                    path = tempPath;
                    fileNameUser = tempMayPath.substring(lastPos + 1, tempMayPath.length());
                    isPathValid = true;
                } else {
                    MsgBox.showInfo((String)Resrcs.getString("PathNotExisted"));
                }
            }
            this.alreadyFileDealWay = -1;
        }
        String fullname = null;
        for (int i = 0; i < attchIDList.size(); ++i) {
            fullname = attchIDList.size() > 1 ? this.download(attchIDList.getID(i).toString(), path, null, imd) : this.download(attchIDList.getID(i).toString(), path, fileNameUser, imd);
        }
        if (attchIDList.size() == 1) {
            if (!StringUtils.isEmpty(fullname)) {
                try {
                    Class<?> clazz = Class.forName("com.kingdee.eas.mm.common.client.AdvMsgBox");
                    Method m = clazz.getMethod("createAdvMsgBox", Component.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE);
                    Object o = m.invoke(clazz, this.waitOwner, null, MessageFormat.format(Resrcs.getString("DownloadFinished"), fullname), null, 1, 0);
                    Method method = clazz.getMethod("show", new Class[0]);
                    method.invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                    e.printStackTrace();
                }
                FileOpenCacheManager fm = new FileOpenCacheManager();
                try {
                    fm.memorizeAssistorInfo(path, userID, "downloadcatch");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return fullname;
        }
        MsgBox.showInfo((String)Resrcs.getString("DownloadAllFinished"));
        FileOpenCacheManager fm = new FileOpenCacheManager();
        try {
            fm.memorizeAssistorInfo(path, userID, "downloadcatch");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String downloadAttachment(IIDList attchIDList, Component owner) {
        return this.downloadAttachment(attchIDList, owner, null);
    }

    public File downloadAttachment4edit(String attchID) {
        return this.download4edit(attchID);
    }

    public String downloadAttachment(String attchID) {
        String fullname = this.download(attchID, "");
        return fullname;
    }

    private String checkStringIncludeChar(String str, String inStr) {
        while (str.indexOf(inStr) != -1) {
            int num = str.indexOf(inStr);
            str = str.substring(0, num) + str.substring(num + 1, str.length());
        }
        return str;
    }

    public void viewAttachment(String attchID, Component owner, KDTable table) {
        Properties pro;
        List<String> list = null;
        if (table != null) {
            CheckListLF clfl = new CheckListLF();
            list = clfl.getSelctList((Object)table, "id");
        }
        if (list == null || list.size() == 0) {
            list = new ArrayList<String>();
            list.add(attchID);
        }
        if ((pro = AttachmentPropertiesUtil.getProperties("Attachment.properties")).getProperty("attachmentViewWindows") != null) {
            if (pro.getProperty("attachmentViewWindows").toString().equalsIgnoreCase("true")) {
                this.viewWindows(attchID, owner, list);
            } else {
                this.viewEas(attchID, owner, list);
            }
        } else {
            this.viewEas(attchID, owner, list);
        }
    }

    private void viewEas(String attchID, Component owner, List list) {
        ArrayList<String> filePathay = new ArrayList<String>();
        String picBMP = "BMP";
        String picGIF = "GIF";
        String picPNG = "PNG";
        String[] pics = new String[]{"PCX", "JPEG", "JPG", "TIFF", "DXF", "CGM", "CDR", "WMF", "EPS", "EMF", "PICT"};
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            MsgBox.showInfo((String)Resrcs.getString("NotWindowsOS"));
            return;
        }
        String fullname = "";
        String temp = "";
        String houzhui = "";
        ArrayList<String> filelist = new ArrayList<String>();
        try {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                boolean isBMP = false;
                boolean isPIC = false;
                temp = this.download(it.next().toString(), "");
                houzhui = temp.substring(temp.lastIndexOf(".") + 1, temp.length()).toUpperCase();
                if (picBMP.equals(houzhui) || picGIF.equals(houzhui) || picPNG.equals(houzhui)) {
                    isBMP = true;
                }
                for (int i = 0; i < pics.length; ++i) {
                    if (!houzhui.equals(pics[i])) continue;
                    isPIC = true;
                    break;
                }
                if (isBMP) {
                    filelist.add(temp);
                }
                if (isPIC) {
                    filePathay.add(temp);
                }
                if (isBMP || isPIC) continue;
                filelist.add(temp);
            }
            if (filelist != null && filelist.size() != 0) {
                this.openMoreFile(filelist);
            }
            if (filePathay == null || filePathay.size() == 0) {
                if (!StringUtils.isEmpty((String)fullname)) {
                    filePathay.add(fullname);
                } else {
                    return;
                }
            }
            if (filePathay != null || filePathay.size() != 0) {
                HashMap<String, ArrayList<String>> ctx = new HashMap<String, ArrayList<String>>();
                ctx.put(FILE_PATH, filePathay);
                PicShowUI pp = new PicShowUI(owner, ctx);
                pp.show();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void viewWindows(String attchID, Component owner, List list) {
        GetPropertyAction a = new GetPropertyAction("java.io.tmpdir");
        String tmpdir = new Date().toString();
        tmpdir = this.checkStringIncludeChar(tmpdir, " ");
        tmpdir = this.checkStringIncludeChar(tmpdir, ":");
        tmpdir = AccessController.doPrivileged(a) + tmpdir;
        new File(tmpdir).mkdir();
        tempAttachmentFileList.add(tmpdir);
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            MsgBox.showInfo((String)Resrcs.getString("NotWindowsOS"));
            return;
        }
        String temp = "";
        ArrayList<String> filelist = new ArrayList<String>();
        try {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                temp = this.download(it.next().toString(), tmpdir);
                if (StringUtils.isEmpty((String)temp)) continue;
                filelist.add(temp);
            }
            if (filelist != null && filelist.size() != 0) {
                this.openMoreFile(filelist);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void openMoreFile(List filelist) throws Exception {
        Iterator itfile = filelist.iterator();
        while (itfile.hasNext()) {
            this.openFile(itfile.next().toString());
        }
    }

    public void openFile(String path) throws Exception {
        String path2 = path;
        File readytToRename = null;
        String repalceName = null;
        try {
            Desktop.getDesktop().open(new File(path));
        }
        catch (Exception e1) {
            this.logger.error((Object)"\u9996\u6b21\u6253\u5f00\u5931\u8d25\uff0c\u5f00\u59cb\u4e8c\u6b21\u5c1d\u8bd5", (Throwable)e1);
            path2 = path;
            readytToRename = new File(path);
            repalceName = path.substring(0, path2.lastIndexOf(File.separator) + 1) + new SimpleDateFormat("yyyyMMddhhmmssSSS").format(new Date()) + path.substring(path.lastIndexOf("."));
            readytToRename.renameTo(new File(repalceName));
            Runtime.getRuntime().exec("cmd /c start /I " + repalceName);
        }
        catch (Throwable th) {
            this.logger.error((Object)"\u9996\u6b21\u6253\u5f00\u5931\u8d25\uff0c\u8bb0\u5f55\u9519\u8bef", th);
        }
    }

    public void viewAttachment(String attchID, Component owner) {
        this.viewAttachment(attchID, owner, null);
    }

    public void viewAttachment(String attchID) {
        this.viewAttachment(attchID, null);
    }

    public static byte[] getPackedBytesFromFile(File file) throws Exception {
        return FileGetter.getBytesFromFile(file, true);
    }

    public static byte[] getBytesFromFile(File file) throws Exception {
        return FileGetter.getBytesFromFile(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytesFromFile(File file, boolean isZip) throws Exception {
        byte[] b = null;
        FileInputStream fis = null;
        if (file == null) {
            throw new AttachmentException(AttachmentException.FILENOTFOUND);
        }
        if (!file.canRead()) {
            throw new AttachmentException(AttachmentException.FILECANNOTREAD);
        }
        try {
            fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            long size = fc.size();
            b = new byte[new Long(size).intValue()];
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            mbb.get(b);
            mbb.clear();
            FileGetter.clean(mbb);
            fc.close();
            if (isZip) {
                byte[] bb;
                byte[] byArray = bb = DataZipUtils.pack((byte[])b);
                return byArray;
            }
            byte[] byArray = b;
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private static void clean(final Object buffer) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                    getCleanerMethod.setAccessible(true);
                    Cleaner cleaner = (Cleaner)getCleanerMethod.invoke(buffer, new Object[0]);
                    cleaner.clean();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public void unloadTempFile() {
        if (tempAttachmentFileList != null && tempAttachmentFileList.size() != 0) {
            Iterator it = tempAttachmentFileList.iterator();
            File f = null;
            while (it.hasNext()) {
                f = new File(it.next().toString());
                f.delete();
                File[] subs = f.listFiles();
                for (int i = 0; i < subs.length; ++i) {
                    subs[i].delete();
                }
                f.delete();
            }
        } else if (tempAttachmentList1 != null && tempAttachmentList1.size() != 0) {
            this.deleteTempFile(tempAttachmentList1);
        }
        if (tempAttachmentList != null && tempAttachmentList.size() != 0) {
            this.deleteTempFile(tempAttachmentList);
        }
    }

    private void deleteTempFile(List list) {
        Iterator it = tempAttachmentList.iterator();
        File f = null;
        while (it.hasNext()) {
            f = new File(it.next().toString());
            f.delete();
        }
    }

    class AllFileFilter
    extends FileFilter {
        AllFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return true;
        }

        @Override
        public String getDescription() {
            return "*.*";
        }
    }
}

