/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.app.AbstractBOTRelationControllerBean;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.util.MappingCache;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentException;

public class BOTRelationControllerBean
extends AbstractBOTRelationControllerBean {
    public static final String TRACEUP = "1";
    public static final String TRACEDOWN = "0";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";

    @Override
    protected ArrayList _getDestObjIdByDestType(Context ctx, String srcObjId, String destType) throws BOSException {
        boolean hasFilter = false;
        ArrayList<String> destObjIdList = new ArrayList<String>();
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sqlToGetDestObjId = new StringBuffer("SELECT FDESTOBJECTID FROM T_BOT_RELATION ");
        if (srcObjId != null && srcObjId.length() > 0) {
            if (!hasFilter) {
                sqlToGetDestObjId.append(" WHERE");
                hasFilter = true;
            }
            sqlToGetDestObjId.append(" FSRCOBJECTID=?");
            params.add(srcObjId);
        }
        if (destType != null && destType.length() > 0) {
            if (!hasFilter) {
                sqlToGetDestObjId.append(" WHERE");
                hasFilter = true;
            } else {
                sqlToGetDestObjId.append(" AND");
            }
            sqlToGetDestObjId.append(" FDESTENTITYID=?");
            params.add(destType);
        }
        IRowSet rsToGetDestObjId = DbUtil.executeQuery((Context)ctx, (String)sqlToGetDestObjId.toString(), (Object[])params.toArray());
        try {
            while (rsToGetDestObjId.next()) {
                destObjIdList.add(rsToGetDestObjId.getString("FDESTOBJECTID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return destObjIdList;
    }

    @Override
    protected List _getNoRepSrcObjIdByDestType(Context ctx, List srcObjIdList, String destType) throws BOSException {
        boolean hasFilter = false;
        ArrayList newSrcIdList = new ArrayList();
        ArrayList tmpDestIdList = new ArrayList();
        int batchSize = 500;
        if (srcObjIdList.size() >= batchSize) {
            ArrayList srcListList = new ArrayList();
            ArrayList tempList = new ArrayList();
            for (int i = 0; i < srcObjIdList.size(); ++i) {
                tempList.add(srcObjIdList.get(i));
                if (tempList.size() < batchSize) continue;
                srcListList.add(tempList);
                tempList = new ArrayList();
            }
            if (tempList.size() > 0) {
                srcListList.add(tempList);
            }
            for (int k = 0; k < srcListList.size(); ++k) {
                List temp = (List)srcListList.get(k);
                this.getNoRepSrcObjIdByDestType(ctx, temp, destType, hasFilter, newSrcIdList, tmpDestIdList);
            }
        } else {
            this.getNoRepSrcObjIdByDestType(ctx, srcObjIdList, destType, hasFilter, newSrcIdList, tmpDestIdList);
        }
        return newSrcIdList;
    }

    private void getNoRepSrcObjIdByDestType(Context ctx, List srcObjIdList, String destType, boolean hasFilter, ArrayList newSrcIdList, ArrayList tmpDestIdList) throws BOSException {
        ArrayList params = new ArrayList();
        StringBuffer sqlToGetDestObjId = new StringBuffer("SELECT FDESTOBJECTID,FSRCOBJECTID FROM T_BOT_RELATION ");
        if (srcObjIdList != null && srcObjIdList.size() > 0) {
            if (!hasFilter) {
                sqlToGetDestObjId.append(" WHERE");
                hasFilter = true;
            }
            sqlToGetDestObjId.append(" FSRCOBJECTID in (");
            for (int i = 0; i < srcObjIdList.size(); ++i) {
                String temp = "?";
                if (i < srcObjIdList.size() - 1) {
                    temp = temp + ",";
                }
                sqlToGetDestObjId.append(temp);
                params.add(srcObjIdList.get(i));
            }
            sqlToGetDestObjId.append(")");
        }
        if (destType != null && destType.length() > 0) {
            if (!hasFilter) {
                sqlToGetDestObjId.append(" WHERE");
                hasFilter = true;
            } else {
                sqlToGetDestObjId.append(" AND");
            }
            sqlToGetDestObjId.append(" FDESTENTITYID=?");
            params.add(destType);
        }
        IRowSet rsToGetDestObjId = DbUtil.executeQuery((Context)ctx, (String)sqlToGetDestObjId.toString(), (Object[])params.toArray());
        try {
            while (rsToGetDestObjId.next()) {
                String destObjId = rsToGetDestObjId.getString("FDESTOBJECTID");
                String srcObjId = rsToGetDestObjId.getString("FSRCOBJECTID");
                if (tmpDestIdList.contains(destObjId)) continue;
                tmpDestIdList.add(destObjId);
                if (newSrcIdList.contains(srcObjId)) continue;
                newSrcIdList.add(srcObjId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected ArrayList _getSrcObjIdBySrcType(Context ctx, String destObjId, String srcBosType) throws BOSException {
        boolean hasFilter = false;
        ArrayList<String> srcObjIdList = new ArrayList<String>();
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sqlToGetObjId = new StringBuffer("SELECT FSRCOBJECTID FROM T_BOT_RELATION ");
        if (destObjId != null && destObjId.length() > 0) {
            if (!hasFilter) {
                sqlToGetObjId.append(" WHERE");
                hasFilter = true;
            }
            sqlToGetObjId.append(" FDESTOBJECTID=?");
            params.add(destObjId);
        }
        if (srcBosType != null && srcBosType.length() > 0) {
            if (!hasFilter) {
                sqlToGetObjId.append(" WHERE");
                hasFilter = true;
            } else {
                sqlToGetObjId.append(" AND");
            }
            sqlToGetObjId.append(" FSRCENTITYID=?");
            params.add(srcBosType);
        }
        IRowSet rsToGetObjId = DbUtil.executeQuery((Context)ctx, (String)sqlToGetObjId.toString(), (Object[])params.toArray());
        try {
            while (rsToGetObjId.next()) {
                srcObjIdList.add(rsToGetObjId.getString("FSRCOBJECTID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return srcObjIdList;
    }

    @Override
    protected void _removeRelationBySrcObjId(Context ctx, String srcObjId, String destBosType) throws BOSException {
        BOTRelationCollection botRelationCols;
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        FilterInfo filterInfo = new FilterInfo();
        evi.setFilter(filterInfo);
        if (srcObjId != null && srcObjId.length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcObjId));
        }
        if (destBosType != null && destBosType.length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBosType));
        }
        if ((botRelationCols = super.getCollection(ctx, evi)) != null) {
            int count = botRelationCols.size();
            for (int i = 0; i < count; ++i) {
                this._delete(ctx, (IObjectPK)new ObjectUuidPK(botRelationCols.get(i).getId().toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _removeRelationByDestObjId(Context ctx, String destObjId, String srcBosType) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        FilterInfo filterInfo = new FilterInfo();
        evi.setFilter(filterInfo);
        if (destObjId != null && destObjId.length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destObjId));
        }
        if (srcBosType != null && srcBosType.length() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcBosType));
        }
        if (!StringUtils.isEmpty((String)destObjId)) {
            Connection cn = null;
            try {
                cn = this.getConnection(ctx);
                IORMappingDAO idao = this.getDAO(ctx, cn);
                idao.delete(filterInfo);
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
        }
    }

    @Override
    public List<String> _getDestVoucherColsNumber(Context ctx, IObjectCollection srcBillCols, boolean isOnlyShowLast) throws BOSException {
        ArrayList<String> voucherNumberList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer("SELECT VOUCHER.FNUMBER, VOUCHER.FCREATETIME FROM T_GL_VOUCHER VOUCHER INNER JOIN T_BOT_RELATION RELATION ON VOUCHER.FID = RELATION.FDESTOBJECTID ");
        int size = srcBillCols.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                sb.append(" AND (");
            } else {
                sb.append(" OR");
            }
            sb.append(" FSRCOBJECTID = '");
            sb.append(srcBillCols.getObject(i).get("id").toString());
            sb.append("'");
        }
        sb.append(" ) ORDER BY VOUCHER.FCREATETIME DESC");
        IRowSet rsToGetVoucherNumber = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            Timestamp lastCreateTime = null;
            while (rsToGetVoucherNumber.next()) {
                String voucherNumber = rsToGetVoucherNumber.getString("FNUMBER");
                Timestamp voucherCreateTime = rsToGetVoucherNumber.getTimestamp("FCREATETIME");
                if (lastCreateTime == null) {
                    lastCreateTime = voucherCreateTime;
                    voucherNumberList.add(voucherNumber);
                    continue;
                }
                if (!isOnlyShowLast) {
                    voucherNumberList.add(voucherNumber);
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return voucherNumberList;
    }

    @Override
    protected ArrayList _getAllUpstreamObjIdByDestID(Context ctx, String destObjId) throws BOSException {
        ArrayList ObjIdList = new ArrayList();
        if (StringUtils.isEmpty((String)destObjId)) {
            return ObjIdList;
        }
        ArrayList upstreamObjIdList = this._getUpstreamObjIdByDestID(ctx, destObjId);
        if (null == upstreamObjIdList || upstreamObjIdList.size() == 0) {
            return ObjIdList;
        }
        while (true) {
            ArrayList tempObjId = new ArrayList();
            ObjIdList.addAll(upstreamObjIdList);
            for (Object object : upstreamObjIdList) {
                ArrayList upstreamObjIdList2 = this._getUpstreamObjIdByDestID(ctx, (String)object);
                if (null == upstreamObjIdList2 || upstreamObjIdList2.size() <= 0) continue;
                tempObjId.addAll(upstreamObjIdList2);
            }
            if (null == tempObjId || tempObjId.size() == 0) break;
            upstreamObjIdList = tempObjId;
        }
        logger.error((Object)("destId = " + destObjId + ",result = " + ObjIdList.toString()));
        return ObjIdList;
    }

    @Override
    protected ArrayList _getUpstreamObjIdByDestID(Context ctx, String destObjId) throws BOSException {
        ArrayList<String> srcObjIdList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)destObjId)) {
            return srcObjIdList;
        }
        IRowSet rsToGetDestObjId = DbUtil.executeQuery((Context)ctx, (String)"SELECT FSRCOBJECTID FROM T_BOT_RELATION  WHERE FDESTOBJECTID=?", (Object[])new String[]{destObjId});
        try {
            while (rsToGetDestObjId.next()) {
                srcObjIdList.add(rsToGetDestObjId.getString("FSRCOBJECTID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return srcObjIdList;
    }

    @Override
    protected HashSet _getAllRelativeBillIDList(Context ctx, String billID, String destBOStype, String flag, boolean ignoreLevel) throws BOSException {
        HashSet objIdList = new HashSet();
        if (StringUtils.isEmpty((String)billID) || StringUtils.isEmpty((String)flag)) {
            return objIdList;
        }
        if (!ignoreLevel) {
            ArrayList result = this.getRelativeBillIDList(ctx, billID, flag, destBOStype);
            objIdList.addAll(result);
            return objIdList;
        }
        ArrayList relativeBillIDList = this.getRelativeBillIDList(ctx, billID, flag, null);
        if (relativeBillIDList == null || relativeBillIDList.size() == 0) {
            return objIdList;
        }
        while (true) {
            ArrayList tempObjId = new ArrayList();
            objIdList.addAll(relativeBillIDList);
            for (Object object : relativeBillIDList) {
                ArrayList relativeBillIDList2 = this.getRelativeBillIDList(ctx, (String)object, flag, null);
                if (relativeBillIDList2 == null || relativeBillIDList2.size() <= 0) continue;
                tempObjId.addAll(relativeBillIDList2);
            }
            if (tempObjId == null || tempObjId.size() == 0) break;
            relativeBillIDList = tempObjId;
        }
        objIdList = this.checkBOSType(objIdList, destBOStype);
        return objIdList;
    }

    private ArrayList getRelativeBillIDList(Context ctx, String billID, String flag, String destType) throws BOSException {
        String destBillFieldName;
        ArrayList<String> destObjectIDList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)billID)) {
            return destObjectIDList;
        }
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sqlToGetDestObjID = new StringBuffer();
        params.add(billID);
        if (!StringUtils.isEmpty((String)flag) && TRACEDOWN.equals(flag)) {
            sqlToGetDestObjID.append("SELECT FDESTOBJECTID FROM T_BOT_RELATION WHERE FSRCOBJECTID = ? ");
            destBillFieldName = "FDESTOBJECTID";
            if (!StringUtils.isEmpty((String)destType)) {
                sqlToGetDestObjID.append("AND FDESTENTITYID = ?");
                params.add(destType);
            }
        } else if (!StringUtils.isEmpty((String)flag) && TRACEUP.equals(flag)) {
            sqlToGetDestObjID.append("SELECT FSRCOBJECTID FROM T_BOT_RELATION WHERE FDESTOBJECTID = ? ");
            destBillFieldName = "FSRCOBJECTID";
            if (!StringUtils.isEmpty((String)destType)) {
                sqlToGetDestObjID.append("AND FSRCENTITYID = ?");
                params.add(destType);
            }
        } else {
            throw new BOSException("\u6807\u5fd7\u4f4dflag\u53c2\u6570\u9519\u8bef\uff0c\u4e0a\u67e5\u4f20\u90121\uff0c\u4e0b\u67e5\u4f20\u90120");
        }
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sqlToGetDestObjID.toString(), (Object[])params.toArray());
        try {
            while (result.next()) {
                destObjectIDList.add(result.getString(destBillFieldName));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return destObjectIDList;
    }

    private HashSet checkBOSType(HashSet<String> objIdSet, String destType) {
        if (StringUtils.isEmpty((String)destType)) {
            return objIdSet;
        }
        HashSet<String> result = new HashSet<String>();
        for (String id : objIdSet) {
            BOSUuid uuid = BOSUuid.read((String)id);
            BOSObjectType type = uuid.getType();
            if (!type.toString().equalsIgnoreCase(destType)) continue;
            result.add(id);
        }
        return result;
    }

    @Override
    protected boolean _checkRebuild(Context ctx, List srcBillIdList, List destBillIdList, String mappingId) throws BOSException, EASBizException {
        String destId;
        BOSObjectType destType;
        if (srcBillIdList == null || srcBillIdList.size() == 0 || StringUtils.isEmpty((String)mappingId)) {
            throw new BOSException("Invalid parameter! SrcBillIdList or mappingId is invalid!");
        }
        BOTMappingInfo mappingInfo = MappingCache.getInstance(ctx).getMappingInfo(mappingId, ctx);
        BOSObjectType destBosType = null;
        destBosType = mappingInfo.getDestEntity() == null ? BOSObjectType.create((String)mappingInfo.getDestEntityName()) : mappingInfo.getDestEntity().getBOSType();
        if (destBillIdList != null && destBillIdList.size() > 0 && !destBosType.equals((Object)(destType = BOSUuid.read((String)(destId = destBillIdList.get(0).toString())).getType()))) {
            throw new BOSException("Invalid parameter! DestBillId doesn't match the mappingInfo!");
        }
        String reBuildControl = "";
        String extconfig = mappingInfo.getExtConfig();
        BotpExtConfigHelper.ExtConfigInfo info = null;
        BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper.XMLProcessor(new BotpExtConfigHelper());
        if (extconfig != null && !extconfig.equals("")) {
            try {
                info = processor.marshallingExtConfig(extconfig);
                reBuildControl = info.getReBuildControl();
                if (reBuildControl.equals("2") && this.hasReBuild(ctx, srcBillIdList, destBillIdList, destBosType.toString())) {
                    return false;
                }
            }
            catch (DocumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    private boolean hasReBuild(Context ctx, List idlist, List destList, String destBillTypeBOSType) throws BOSException {
        String billIds = StringUtils.arrayToString((Object[])idlist.toArray(), (String)",");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        FilterInfo filterMapping = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billIds, CompareType.INCLUDE));
        if (destList != null && destList.size() > 0) {
            String destbillIds = StringUtils.arrayToString((Object[])destList.toArray(), (String)",");
            filterBill.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destbillIds, CompareType.NOTINCLUDE));
        }
        filterMapping.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBillTypeBOSType, CompareType.EQUALS));
        filterBill.mergeFilter(filterMapping, "And");
        viewInfo.setFilter(filterBill);
        BOTRelationCollection relations = BOTRelationFactory.getLocalInstance(ctx).getCollection(viewInfo);
        return relations != null && relations.size() != 0;
    }

    @Override
    protected List _getRelativeInfoByCreateTime(Context ctx, String billID, String destBOStype, String flag, boolean ignoreLevel, String sortType) throws BOSException {
        List<Object> resultList = new ArrayList();
        ArrayList<BOTRelationInfo> relationList = new ArrayList<BOTRelationInfo>();
        if (StringUtils.isEmpty((String)billID) || StringUtils.isEmpty((String)flag)) {
            return resultList;
        }
        if (!ignoreLevel) {
            BOTRelationCollection relationCollection = this.getRelativeRelationInfo(ctx, billID, flag, destBOStype, sortType);
            Iterator iterator = relationCollection.iterator();
            while (iterator.hasNext()) {
                BOTRelationInfo info = (BOTRelationInfo)iterator.next();
                relationList.add(info);
            }
            resultList = this.transRelationInfo2CustomInfo(flag, relationList);
            return resultList;
        }
        BOTRelationCollection relationCollection = this.getRelativeRelationInfo(ctx, billID, flag, null, sortType);
        if (relationCollection.size() == 0) {
            return resultList;
        }
        while (true) {
            BOTRelationCollection tempCol = new BOTRelationCollection();
            Iterator itr = relationCollection.iterator();
            BOTRelationInfo info = null;
            BOTRelationCollection relationCollection2 = null;
            while (itr.hasNext()) {
                info = (BOTRelationInfo)itr.next();
                relationList.add(info);
                relationCollection2 = TRACEDOWN.equals(flag) ? this.getRelativeRelationInfo(ctx, info.getDestObjectID(), flag, null, sortType) : this.getRelativeRelationInfo(ctx, info.getSrcObjectID(), flag, null, sortType);
                tempCol.addCollection(relationCollection2);
            }
            if (tempCol.size() == 0) break;
            relationCollection = tempCol;
        }
        if (ASC.equals(sortType)) {
            Collections.sort(relationList, new Comparator<BOTRelationInfo>(){

                @Override
                public int compare(BOTRelationInfo o1, BOTRelationInfo o2) {
                    int i = o1.getDate().compareTo(o2.getDate());
                    return i;
                }
            });
        } else {
            Collections.sort(relationList, new Comparator<BOTRelationInfo>(){

                @Override
                public int compare(BOTRelationInfo o1, BOTRelationInfo o2) {
                    int i = o1.getDate().compareTo(o2.getDate());
                    return i * -1;
                }
            });
        }
        resultList = this.transRelationInfo2CustomInfo(flag, relationList);
        return resultList;
    }

    private List<HashMap<String, Object>> transRelationInfo2CustomInfo(String flag, ArrayList<BOTRelationInfo> relationList) throws BOSException {
        ArrayList<HashMap<String, Object>> resultList = new ArrayList<HashMap<String, Object>>();
        String billId = "";
        String bostype = "";
        for (int i = 0; i < relationList.size(); ++i) {
            BOTRelationInfo info = relationList.get(i);
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (TRACEDOWN.equals(flag)) {
                infoMap.put("traceType", "traceDown");
                billId = info.getDestObjectID();
                bostype = info.getDestEntityID();
            } else if (TRACEUP.equals(flag)) {
                infoMap.put("traceType", "traceUp");
                billId = info.getSrcObjectID();
                bostype = info.getSrcEntityID();
            } else {
                throw new BOSException("wrong param : flag.");
            }
            infoMap.put("billId", billId);
            infoMap.put("bostype", bostype);
            infoMap.put("createTime", info.getDate());
            infoMap.put("creator", info.getOperatorID());
            infoMap.put("mappingId", info.getBOTMappingID());
            infoMap.put("isEffected", info.isIsEffected());
            resultList.add(infoMap);
        }
        return resultList;
    }

    private BOTRelationCollection getRelativeRelationInfo(Context ctx, String billID, String flag, String destType, String sortType) throws BOSException {
        BOTRelationCollection collection = new BOTRelationCollection();
        if (StringUtils.isEmpty((String)billID)) {
            return collection;
        }
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (!StringUtils.isEmpty((String)flag) && TRACEDOWN.equals(flag)) {
                filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billID, CompareType.EQUALS));
                if (!StringUtils.isEmpty((String)destType)) {
                    filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destType, CompareType.EQUALS));
                }
            } else if (!StringUtils.isEmpty((String)flag) && TRACEUP.equals(flag)) {
                filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)billID, CompareType.EQUALS));
                if (!StringUtils.isEmpty((String)destType)) {
                    filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)destType, CompareType.EQUALS));
                }
            } else {
                throw new BOSException("\u6807\u5fd7\u4f4dflag\u53c2\u6570\u9519\u8bef\uff0c\u4e0a\u67e5\u4f20\u90121\uff0c\u4e0b\u67e5\u4f20\u90120");
            }
            view.setFilter(filter);
            SorterItemInfo sorterInfo = new SorterItemInfo("date");
            if (DESC.equals(sortType)) {
                sorterInfo.setSortType(SortType.DESCEND);
            } else {
                sorterInfo.setSortType(SortType.ASCEND);
            }
            view.getSorter().add(sorterInfo);
            collection = BOTRelationFactory.getLocalInstance(ctx).getCollection(view);
        }
        catch (Exception e) {
            logger.error((Object)"fail to get relative BOTRelationCollection;", (Throwable)e);
        }
        return collection;
    }
}

