/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery;

import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.base.commonquery.ColumnItemData;
import com.kingdee.eas.base.commonquery.UserCustomConfigItemData;
import com.kingdee.eas.base.commonquery.UserPreferenceData;
import com.kingdee.eas.framework.util.Version;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class TableXMLHelper {
    private static final Logger logger = Logger.getLogger(TableXMLHelper.class);
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DATA_VERSION = "dataversion";
    private static String RESNAME = "com.kingdee.eas.framework.config.Preferences";
    private static ResourceBundleHelper resHelper = new ResourceBundleHelper(RESNAME);
    public static final String SPLIT_CHAR = "\u03b1";
    public static final String OLD_SPLIT_CHAR = ",";

    public static UserPreferenceData loadPreferenceData(String xmlStr) throws JDOMException, IOException {
        if (xmlStr == null || xmlStr.trim().equals("")) {
            return null;
        }
        Document doc = XMLParser.parseXML((Reader)new StringReader(xmlStr));
        Element rootElement = doc.getRootElement();
        List children = rootElement.getChildren();
        UserPreferenceData data = new UserPreferenceData();
        data.setVersion(Version.parseVersion((String)rootElement.getAttributeValue(DATA_VERSION)));
        for (int i = 0; i < children.size(); ++i) {
            Element tableEl = (Element)children.get(i);
            String tableName = tableEl.getAttributeValue("name");
            data.getSolutions().put(tableName, TableXMLHelper.loadTableItemData(tableEl));
        }
        return data;
    }

    public static void saveData(UserPreferenceData data, Writer writer) throws IOException {
        TableXMLHelper.saveData(data, writer, DEFAULT_ENCODING);
    }

    public static String ConfigItemDataToXml(UserCustomConfigItemData itemData) {
        try {
            UserPreferenceData userData = new UserPreferenceData();
            userData.setVersion(UserPreferenceData.VER_2_0_0);
            userData.getSolutions().put("solution", itemData);
            StringWriter writer = null;
            writer = new StringWriter();
            TableXMLHelper.saveData(userData, writer, DEFAULT_ENCODING);
            return writer.toString();
        }
        catch (Exception e) {
            logger.error((Object)"save xml file error.", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static void saveData(UserPreferenceData data, Writer writer, String encoding) throws IOException {
        Format format = Format.getRawFormat();
        format.setEncoding(encoding);
        XMLOutputter outputter = new XMLOutputter(format);
        outputter.output(TableXMLHelper.prepareDocument(data), writer);
    }

    private static Document prepareDocument(UserPreferenceData data) {
        Element el = new Element("userconfig");
        el.setAttribute(DATA_VERSION, data.getVersion().getVerString());
        Document doc = new Document(el);
        Map tables = data.getSolutions();
        for (String tableName : tables.keySet()) {
            Element dataEl;
            UserCustomConfigItemData itemData = (UserCustomConfigItemData)tables.get(tableName);
            Element solutionEl = new Element("table");
            solutionEl.setAttribute("name", tableName);
            if (itemData == null) continue;
            Element itemDataEl = new Element("generic");
            for (String key : itemData.getGenericData().keySet()) {
                String value = (String)itemData.getGenericData().get(key);
                Element dataEl2 = new Element("data");
                dataEl2.setAttribute("name", key);
                dataEl2.setAttribute("value", value);
                itemDataEl.addContent((Content)dataEl2);
            }
            solutionEl.addContent((Content)itemDataEl);
            Element itemDataE2 = new Element("columndata");
            for (String key : itemData.getColumnData().keySet()) {
                String value = itemData.getColumnData().get(key).toString();
                dataEl = new Element("data");
                dataEl.setAttribute("name", key);
                dataEl.setAttribute("value", value);
                itemDataE2.addContent((Content)dataEl);
            }
            solutionEl.addContent((Content)itemDataE2);
            if (itemData.getTotalColumns() != null) {
                Element itemDataE3 = new Element("totalcolumns");
                for (String key : itemData.getTotalColumns()) {
                    dataEl = new Element("data");
                    dataEl.setAttribute("name", key);
                    itemDataE3.addContent((Content)dataEl);
                }
                solutionEl.addContent((Content)itemDataE3);
            }
            el.addContent((Content)solutionEl);
        }
        return doc;
    }

    private static UserCustomConfigItemData loadTableItemData(Element tableEl) {
        Element dataEl;
        int i;
        UserCustomConfigItemData itemData = new UserCustomConfigItemData();
        List itemDatas = tableEl.getChild("generic").getChildren();
        for (i = 0; i < itemDatas.size(); ++i) {
            dataEl = (Element)itemDatas.get(i);
            itemData.getGenericData().put(dataEl.getAttributeValue("name"), dataEl.getAttributeValue("value"));
        }
        itemDatas = tableEl.getChild("columndata").getChildren();
        for (i = 0; i < itemDatas.size(); ++i) {
            dataEl = (Element)itemDatas.get(i);
            if (dataEl.getAttributeValue("value") instanceof String) {
                itemData.getColumnData().put(dataEl.getAttributeValue("name"), TableXMLHelper.stringToColumnData(dataEl.getAttributeValue("value")));
                continue;
            }
            itemData.getColumnData().put(dataEl.getAttributeValue("name"), dataEl.getAttributeValue("value"));
        }
        if (tableEl.getChild("totalcolumns") != null) {
            itemDatas = tableEl.getChild("totalcolumns").getChildren();
            ArrayList<String> list = new ArrayList<String>();
            for (int i2 = 0; i2 < itemDatas.size(); ++i2) {
                Element dataEl2 = (Element)itemDatas.get(i2);
                list.add(dataEl2.getAttributeValue("name"));
            }
            itemData.setTotalColumns(list);
        }
        return itemData;
    }

    private static ColumnItemData stringToColumnData(String values) {
        if (values == null) {
            return null;
        }
        String[] value = values.split(SPLIT_CHAR);
        if (value.length == 1) {
            value = values.split(OLD_SPLIT_CHAR);
        }
        if (value.length < 7) {
            return null;
        }
        ColumnItemData data = new ColumnItemData();
        data.setTitle(value[0]);
        data.setWidth(Integer.parseInt(value[1]));
        data.setAlign(TableXMLHelper.getAlign(value[2]));
        data.setSorted(Boolean.valueOf(value[3]));
        data.setHidden(Boolean.valueOf(value[4]));
        data.setLocked(Boolean.valueOf(value[5]));
        data.setIndex(Integer.parseInt(value[6]));
        if (value.length >= 9) {
            data.setDynField(Boolean.valueOf(value[7]));
            data.setRowLocked(Boolean.valueOf(value[8]));
        }
        return data;
    }

    public static Styles.HorizontalAlignment getAlign(String str) {
        if (str.equalsIgnoreCase("left")) {
            return Styles.HorizontalAlignment.LEFT;
        }
        if (str.equalsIgnoreCase("center")) {
            return Styles.HorizontalAlignment.CENTER;
        }
        if (str.equalsIgnoreCase("right")) {
            return Styles.HorizontalAlignment.RIGHT;
        }
        return TableXMLHelper.getAlignFromSource(str);
    }

    private static Styles.HorizontalAlignment getAlignFromSource(String str) {
        if (str.equalsIgnoreCase(resHelper.getString("left"))) {
            return Styles.HorizontalAlignment.LEFT;
        }
        if (str.equalsIgnoreCase(resHelper.getString("center"))) {
            return Styles.HorizontalAlignment.CENTER;
        }
        if (str.equalsIgnoreCase(resHelper.getString("right"))) {
            return Styles.HorizontalAlignment.RIGHT;
        }
        return Styles.HorizontalAlignment.LEFT;
    }
}

