/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.BaseDataAccess;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.PermissionChecker;
import com.kingdee.eas.base.commonquery.QueryColumnInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionUtils;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.app.AbstractQuerySolutionFacadeControllerBean;
import com.kingdee.eas.base.commonquery.app.QuerySolutionCacheUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class QuerySolutionFacadeControllerBean
extends AbstractQuerySolutionFacadeControllerBean {
    private static final Logger logger = Logger.getLogger(QuerySolutionFacadeControllerBean.class);

    @Override
    protected IObjectCollection _getQuerySolutions(Context ctx, String parentUIName, String queryName) throws BOSException, EASBizException {
        try {
            String userID = ctx.getCaller().toString();
            String orgID = QueryUtils.getOrgID(queryName, ctx).toString();
            return this._getQuerySolutions(ctx, parentUIName, queryName, orgID, userID);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected boolean _hasDefaultSolution(Context ctx, String parentUIName, String queryName) throws BOSException, EASBizException {
        QuerySolutionInfo defaultSolution = (QuerySolutionInfo)this._getDefaultSolution(ctx, parentUIName, queryName);
        return defaultSolution != null;
    }

    @Override
    protected IObjectValue _getDefaultSolution(Context ctx, String parentUIName, String queryName) throws BOSException, EASBizException {
        QuerySolutionInfo ret = null;
        try {
            String userID = ctx.getCaller().toString();
            String orgID = QueryUtils.getOrgID(queryName, ctx).toString();
            ret = (QuerySolutionInfo)this._getDefaultSolution(ctx, parentUIName, queryName, orgID, userID);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private QuerySolutionInfo getDefaultSolution(Context ctx, QuerySolutionCollection querySolutionCollection, String parentUIName, String queryName) throws Exception {
        if (querySolutionCollection == null || querySolutionCollection.size() <= 0) {
            return null;
        }
        if (querySolutionCollection.size() == 1) {
            return querySolutionCollection.get(0);
        }
        QuerySolutionInfo ret = null;
        for (int i = querySolutionCollection.size() - 1; i >= 0; --i) {
            QuerySolutionInfo temp = querySolutionCollection.get(i);
            if (temp.getOrgID() == null) continue;
            ret = temp;
            break;
        }
        if (ret == null) {
            ret = querySolutionCollection.get(0);
        }
        return ret;
    }

    @Override
    protected int _getMaxNumView(Context ctx, String parentUIName, String queryName) throws BOSException, EASBizException {
        int maxNum = 0;
        QuerySolutionInfo info = (QuerySolutionInfo)this._getDefaultSolution(ctx, parentUIName, queryName);
        if (info != null) {
            maxNum = info.getRowCount();
        }
        return maxNum;
    }

    @Override
    protected IObjectValue _getDefaultFilterInfo(Context ctx, String parentUIName, String queryName) throws BOSException, EASBizException {
        QuerySolutionInfo info = (QuerySolutionInfo)this._getDefaultSolution(ctx, parentUIName, queryName);
        if (info == null) {
            return null;
        }
        EntityViewInfo returnEntityViewInfo = new EntityViewInfo();
        if (info.getEntityViewInfo() != null) {
            returnEntityViewInfo = this.getInnerFilterInfo(ctx, info);
        }
        return returnEntityViewInfo;
    }

    private EntityViewInfo getInnerFilterInfo(Context ctx, QuerySolutionInfo querySolutionInfo) throws BOSException, EASBizException {
        return QueryUtils.getInnerFilterInfo(ctx, querySolutionInfo);
    }

    @Override
    protected IObjectCollection _getQuerySolutions(Context ctx, String parentUIName, String queryName, String orgID, String userID) throws BOSException, EASBizException {
        QuerySolutionCollection ret = null;
        try {
            userID = userID == null ? ctx.getCaller().toString() : userID;
            orgID = orgID == null ? QueryUtils.getOrgID(queryName, ctx).toString() : orgID;
            ret = QuerySolutionCacheUtils.getMytQuerySolutionsFromCache(ctx, userID, orgID, parentUIName, queryName);
            if (ret != null) {
                return ret;
            }
            boolean hasQueryManagePerm = PermissionChecker.hasEditOtherCQSolutionPerm(ctx);
            ret = this.getQuerySolutionCollection(ctx, parentUIName, queryName, userID, orgID, hasQueryManagePerm);
            ret = this.checkDefaultSolution(ctx, parentUIName, queryName, ret);
            QuerySolutionCacheUtils.putMyQuerySolutionsToCache(ctx, userID, orgID, parentUIName, queryName, ret);
            return ret;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private QuerySolutionCollection getQuerySolutionCollection(Context ctx, String parentUIName, String queryName, String userID, String orgID, boolean hasQueryManagePerm) throws BOSException {
        QuerySolutionCollection querySolutionCollection;
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sql.append("SELECT FID FROM T_QUERY_QuerySolution WHERE ");
            sql.append("FQueryObjectName = ? AND FParentUIName = ? ");
            sql.append("AND FShareType = ? AND FOwner = ? AND FOrgID = ? ");
            sql.append("UNION ALL ");
            sql.append("SELECT FID FROM T_QUERY_QuerySolution WHERE ");
            sql.append("FQueryObjectName = ? AND FParentUIName = ? ");
            sql.append("AND FShareType = ? AND FOwner = ? ");
            if (hasQueryManagePerm) {
                sql.append("UNION ALL ");
                sql.append("SELECT FID FROM T_QUERY_QuerySolution WHERE ");
                sql.append("FQueryObjectName = ? AND FParentUIName = ? AND FShareType = ? ");
                sql.append("AND FOwner <> ? AND FSolutionType <> ? AND FOrgID = ? ");
            }
            conn = EJBFactory.getConnection((Context)ctx);
            ps = BaseDataAccess.prepareStatement((Connection)conn, (String)sql.toString());
            ps.setString(1, queryName);
            ps.setString(2, parentUIName);
            ps.setInt(3, 1);
            ps.setString(4, userID);
            ps.setString(5, orgID);
            ps.setString(6, queryName);
            ps.setString(7, parentUIName);
            ps.setInt(8, 16);
            ps.setString(9, userID);
            if (hasQueryManagePerm) {
                ps.setString(10, queryName);
                ps.setString(11, parentUIName);
                ps.setInt(12, 1);
                ps.setString(13, userID);
                ps.setInt(14, Integer.valueOf("10"));
                ps.setString(15, orgID);
            }
            rs = ps.executeQuery();
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString(1));
            }
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            entityViewInfo.setSelector(QuerySolutionUtils.getSimpleQuerySolutionSelector());
            SorterItemCollection sortCol = new SorterItemCollection();
            sortCol.add(new SorterItemInfo("name"));
            entityViewInfo.setSorter(sortCol);
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filterInfo.setMaskString("#0");
            entityViewInfo.setFilter(filterInfo);
            IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance(ctx);
            querySolutionCollection = iQuerySolution.getQuerySolutionCollection(entityViewInfo);
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("333 sql is:" + sql), (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return querySolutionCollection;
    }

    private QuerySolutionCollection checkDefaultSolution(Context ctx, String parentUIName, String queryName, QuerySolutionCollection querySolutionCol) throws Exception {
        boolean hasSystem = false;
        boolean hasUserDefault = false;
        IObjectPK currentUserPK = ctx.getCaller();
        String currentUserPKStr = StringUtils.cnulls((Object)currentUserPK);
        int size = querySolutionCol.size();
        for (int i = 0; i < size; ++i) {
            QuerySolutionInfo info = querySolutionCol.get(i);
            if (SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)info.getSolutionType())) {
                hasSystem = true;
            }
            if (info.isIsUserDefaultSolu() && currentUserPKStr.equals(StringUtils.cnulls((Object)info.getOwner()))) {
                hasUserDefault = true;
            }
            if (hasUserDefault && hasSystem) break;
        }
        if (!hasSystem) {
            QuerySolutionInfo temp = QuerySolutionUtils.createSysDefaultSolutionInfo(ctx, parentUIName, queryName);
            IObjectPK solutionPK = QuerySolutionFactory.getLocalInstance(ctx).addnew(temp);
            temp.setId(BOSUuid.read((String)StringUtils.cnulls((Object)solutionPK)));
            querySolutionCol.addObject((IObjectValue)temp);
        }
        return querySolutionCol;
    }

    @Override
    protected boolean _hasDefaultSolution(Context ctx, String parentUIName, String queryName, String orgID, String userID) throws BOSException, EASBizException {
        QuerySolutionInfo defaultSolutionInfo = (QuerySolutionInfo)this._getDefaultSolution(ctx, parentUIName, queryName, orgID, userID);
        return defaultSolutionInfo != null;
    }

    @Override
    protected IObjectValue _getDefaultSolution(Context ctx, String parentUIName, String queryName, String orgID, String userID) throws BOSException, EASBizException {
        QuerySolutionInfo ret = null;
        try {
            userID = userID == null ? ctx.getCaller().toString() : userID;
            orgID = orgID == null ? QueryUtils.getOrgID(queryName, ctx).toString() : orgID;
            ret = QuerySolutionCacheUtils.getDefaultQuerySolutionFromCache(userID, orgID, parentUIName, queryName);
            if (ret != null) {
                return ret;
            }
            QuerySolutionCollection querySolutionCollection = this.getDefaultQuerySolutionCollection(ctx, parentUIName, queryName, userID, orgID);
            ret = this.getDefaultSolution(ctx, querySolutionCollection, parentUIName, queryName);
            QuerySolutionCacheUtils.putDefaultQuerySolutionToCache(userID, orgID, parentUIName, queryName, ret);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private QuerySolutionCollection getDefaultQuerySolutionCollection(Context ctx, String parentUIName, String queryName, String userID, String orgID) throws BOSException {
        QuerySolutionCollection querySolutionCollection;
        StringBuffer sql = new StringBuffer();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sql.append("SELECT FID FROM T_QUERY_QuerySolution WHERE ");
            sql.append("FQueryObjectName = ? AND FParentUIName = ? AND FIsUserDefaultSolu = ? ");
            sql.append("AND FShareType = ? AND FOwner = ? AND FOrgID = ? ");
            sql.append("UNION ALL ");
            sql.append("SELECT FID FROM T_QUERY_QuerySolution WHERE ");
            sql.append("FQueryObjectName = ? AND FParentUIName = ? AND FIsUserDefaultSolu = ? ");
            sql.append("AND FShareType = ? AND FOwner = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            ps = BaseDataAccess.prepareStatement((Connection)conn, (String)sql.toString());
            ps.setString(1, queryName);
            ps.setString(2, parentUIName);
            ps.setInt(3, 1);
            ps.setInt(4, 1);
            ps.setString(5, userID);
            ps.setString(6, orgID);
            ps.setString(7, queryName);
            ps.setString(8, parentUIName);
            ps.setInt(9, 1);
            ps.setInt(10, 16);
            ps.setString(11, userID);
            rs = ps.executeQuery();
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString(1));
            }
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            SorterItemCollection sortCol = new SorterItemCollection();
            sortCol.add(new SorterItemInfo("name"));
            entityViewInfo.setSorter(sortCol);
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filterInfo.setMaskString("#0");
            entityViewInfo.setFilter(filterInfo);
            IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance(ctx);
            querySolutionCollection = iQuerySolution.getQuerySolutionCollection(entityViewInfo);
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("333 sql is:" + sql), (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return querySolutionCollection;
    }

    @Override
    protected int _getMaxNumView(Context ctx, String parentUIName, String queryName, String orgID, String userID) throws BOSException, EASBizException {
        userID = userID == null ? ctx.getCaller().toString() : userID;
        orgID = orgID == null ? QueryUtils.getOrgID(queryName, ctx).toString() : orgID;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String maskString = null;
        int maxNum = 0;
        FilterItemInfo queryFilterItem = new FilterItemInfo("queryObjectName", (Object)queryName);
        FilterItemInfo parentUIFilterItem = new FilterItemInfo("parentUIName", (Object)parentUIName);
        FilterItemInfo ownerFilterItem = new FilterItemInfo("owner", (Object)userID);
        FilterItemInfo isUserDefaultFilterItem = new FilterItemInfo("isUserDefaultSolu", (Object)true);
        FilterItemInfo filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(ShareTypeEnum.USER_LEVEL.getValue()));
        filterInfo.getFilterItems().add(queryFilterItem);
        filterInfo.getFilterItems().add(parentUIFilterItem);
        filterInfo.getFilterItems().add(ownerFilterItem);
        filterInfo.getFilterItems().add(isUserDefaultFilterItem);
        filterInfo.getFilterItems().add(filterItemInfo);
        FilterItemInfo orgFilterItem = new FilterItemInfo("orgID", (Object)orgID);
        filterInfo.getFilterItems().add(orgFilterItem);
        maskString = " #0 and #1 and #2 and #3 and #4 and #5";
        filterInfo.setMaskString(maskString);
        entityViewInfo.setFilter(filterInfo);
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance(ctx);
        QuerySolutionCollection querySolutionCollection = iQuerySolution.getQuerySolutionCollection(entityViewInfo);
        if (querySolutionCollection.size() == 1) {
            maxNum = ((QuerySolutionInfo)querySolutionCollection.getObject(0)).getRowCount();
        }
        return maxNum;
    }

    @Override
    protected IObjectValue _getDefaultFilterInfo(Context ctx, String parentUIName, String queryName, String orgID, String userID) throws BOSException, EASBizException {
        QuerySolutionInfo querySolutionInfo = (QuerySolutionInfo)this._getDefaultSolution(ctx, parentUIName, queryName, orgID, userID);
        if (querySolutionInfo == null) {
            return null;
        }
        EntityViewInfo returnEntityViewInfo = new EntityViewInfo();
        if (querySolutionInfo != null && querySolutionInfo.getEntityViewInfo() != null) {
            returnEntityViewInfo = this.getInnerFilterInfo(ctx, querySolutionInfo);
        }
        return returnEntityViewInfo;
    }

    protected boolean _saveDefaultSolution(Context ctx, String currentSolutionID, String parentUIName, String queryName, int rowCount, boolean isUserDefaultSolu) throws EASBizException, BOSException {
        String orgID = QueryUtils.getOrgID(queryName, ctx).toString();
        String userID = ctx.getCaller().toString();
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance(ctx);
        QuerySolutionInfo querySolutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(currentSolutionID));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        filter.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentUIName));
        filter.getFilterItems().add(new FilterItemInfo("owner", (Object)userID));
        filter.getFilterItems().add(new FilterItemInfo("queryObjectName", (Object)queryName));
        filter.getFilterItems().add(new FilterItemInfo("isUserDefaultSolu", (Object)true));
        evi.setFilter(filter);
        QuerySolutionCollection querySolutionCollection = iQuerySolution.getQuerySolutionCollection(evi);
        QuerySolutionInfo querySolutionInfoOld = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isUserDefaultSolu"));
        querySolutionInfo.setRowCount(rowCount);
        querySolutionInfo.setIsUserDefaultSolu(isUserDefaultSolu);
        if (querySolutionCollection.size() != 0 && !(querySolutionInfoOld = querySolutionCollection.get(0)).getId().toString().equals(querySolutionInfo.getId().toString())) {
            querySolutionInfoOld.setIsUserDefaultSolu(false);
            iQuerySolution.updatePartial(querySolutionInfoOld, selector);
        }
        selector.add(new SelectorItemInfo("rowCount"));
        iQuerySolution.updatePartial(querySolutionInfo, selector);
        QuerySolutionCacheUtils.removeQuerySolutionCache(ctx, querySolutionInfo);
        return true;
    }

    @Override
    protected IObjectCollection _getQuerySolutions(Context ctx, String parentUIName, String queryName, String shareType) throws BOSException, EASBizException {
        FilterItemInfo filterItemInfo;
        String userID = ctx.getCaller().toString();
        String orgID = QueryUtils.getOrgID(queryName, ctx).toString();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String maskString = null;
        Object org = null;
        int currentShareType = 10;
        if (shareType != null) {
            currentShareType = Integer.parseInt(shareType);
        }
        FilterItemInfo queryFilterItem = new FilterItemInfo("queryObjectName", (Object)queryName);
        FilterItemInfo parentUIFilterItem = new FilterItemInfo("parentUIName", (Object)parentUIName);
        filterInfo.getFilterItems().add(queryFilterItem);
        filterInfo.getFilterItems().add(parentUIFilterItem);
        if (currentShareType == 1) {
            FilterItemInfo ownerFilterItem = new FilterItemInfo("owner", (Object)userID);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo("shareType", (Object)String.valueOf(ShareTypeEnum.USER_LEVEL.getValue()));
            filterInfo.getFilterItems().add(ownerFilterItem);
            filterInfo.getFilterItems().add(filterItemInfo2);
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", null));
            maskString = " #0 and #1 and #2 and #3 and (#4 OR #5) ";
        } else if (currentShareType == 2) {
            filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(ShareTypeEnum.ORG_LEVEL.getValue()));
            FilterItemInfo orgFilterItem = new FilterItemInfo("orgID", (Object)orgID);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.getFilterItems().add(orgFilterItem);
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", null));
            maskString = " #0 and #1 and #2 and (#3 OR #4) ";
        } else if (currentShareType == 4) {
            filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(ShareTypeEnum.PUBLIC_LEVEL.getValue()));
            maskString = " #0 and #1 and #2 ";
            filterInfo.getFilterItems().add(filterItemInfo);
        } else if (currentShareType == 8) {
            FilterItemInfo orgFilterItem = new FilterItemInfo("orgID", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            FilterItemInfo filterItemInfo3 = new FilterItemInfo("shareType", (Object)String.valueOf(ShareTypeEnum.PUBLIC_LEVEL.getValue()));
            maskString = " #0 and #1 and #2 and #3 ";
            filterInfo.getFilterItems().add(orgFilterItem);
            filterInfo.getFilterItems().add(filterItemInfo3);
        }
        filterInfo.setMaskString(maskString);
        entityViewInfo.setFilter(filterInfo);
        IQuerySolution querySolution = QuerySolutionFactory.getLocalInstance(ctx);
        return querySolution.getQuerySolutionCollection(entityViewInfo);
    }

    @Override
    protected IObjectValue _getDefaultSolution(Context ctx, String parentUIName, String queryName, String shareType) throws BOSException, EASBizException {
        FilterItemInfo orgFilterItem;
        FilterItemInfo filterItemInfo;
        String userID = ctx.getCaller().toString();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        int currentShareType = 10;
        if (shareType != null) {
            currentShareType = Integer.parseInt(shareType);
        }
        String maskString = null;
        String orgID = null;
        FilterItemInfo queryFilterItem = new FilterItemInfo("queryObjectName", (Object)queryName);
        FilterItemInfo parentUIFilterItem = new FilterItemInfo("parentUIName", (Object)parentUIName);
        FilterItemInfo isUserDefaultFilterItem = new FilterItemInfo("isUserDefaultSolu", (Object)true);
        orgID = QueryUtils.getOrgID(queryName, ctx).toString();
        filterInfo.getFilterItems().add(queryFilterItem);
        filterInfo.getFilterItems().add(parentUIFilterItem);
        filterInfo.getFilterItems().add(isUserDefaultFilterItem);
        if (currentShareType == 1) {
            FilterItemInfo ownerFilterItem = new FilterItemInfo("owner", (Object)userID);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo("shareType", (Object)String.valueOf(ShareTypeEnum.USER_LEVEL.getValue()));
            filterInfo.getFilterItems().add(ownerFilterItem);
            filterInfo.getFilterItems().add(filterItemInfo2);
            FilterItemInfo orgFilterItem2 = new FilterItemInfo("orgID", (Object)orgID);
            filterInfo.getFilterItems().add(orgFilterItem2);
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", null));
            maskString = " #0 and #1 and #2 and #3 and #4 and (#5 or #6) ";
        } else if (currentShareType == 2) {
            filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(ShareTypeEnum.ORG_LEVEL.getValue()));
            filterInfo.getFilterItems().add(filterItemInfo);
            orgFilterItem = new FilterItemInfo("orgID", (Object)orgID);
            filterInfo.getFilterItems().add(orgFilterItem);
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", null));
            maskString = " #0 and #1 and #2 and #3 and (#5 or #6)";
        } else if (currentShareType == 4) {
            filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(ShareTypeEnum.PUBLIC_LEVEL.getValue()));
            maskString = " #0 and #1 and #2 and #3  ";
            filterInfo.getFilterItems().add(filterItemInfo);
        } else if (currentShareType == 8) {
            filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(ShareTypeEnum.CU_LEVEL.getValue()));
            orgFilterItem = new FilterItemInfo("orgID", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo.getFilterItems().add(orgFilterItem);
            maskString = " #0 and #1 and #2 and #3 and #4 ";
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        filterInfo.setMaskString(maskString);
        entityViewInfo.setFilter(filterInfo);
        IQuerySolution querySolution = QuerySolutionFactory.getLocalInstance(ctx);
        QuerySolutionCollection querySolutionCollection = querySolution.getQuerySolutionCollection(entityViewInfo);
        if (querySolutionCollection.size() == 1) {
            return querySolutionCollection.get(0);
        }
        return null;
    }

    @Override
    protected IObjectValue _getDefaultFilterInfo(Context ctx, String parentUIName, String queryName, String shareType) throws BOSException, EASBizException {
        QuerySolutionInfo info = (QuerySolutionInfo)this._getDefaultSolution(ctx, parentUIName, queryName, shareType);
        if (info == null) {
            return null;
        }
        EntityViewInfo returnEntityViewInfo = new EntityViewInfo();
        if (info.getEntityViewInfo() != null) {
            returnEntityViewInfo = this.getInnerFilterInfo(ctx, info);
        }
        return returnEntityViewInfo;
    }

    @Override
    protected boolean _hasDefaultSolution(Context ctx, String parentUIName, String queryName, String shareType) throws BOSException, EASBizException {
        QuerySolutionInfo info = (QuerySolutionInfo)this._getDefaultSolution(ctx, parentUIName, queryName, shareType);
        return info != null;
    }

    @Override
    protected IObjectValue _getDefaultSolutionInfo(Context ctx, String parentUIName, String queryName) throws BOSException, EASBizException {
        String userID = ctx.getCaller().toString();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String maskString = null;
        String orgID = null;
        FilterItemInfo parentUIFilterItem = new FilterItemInfo("parentUIName", (Object)parentUIName);
        FilterItemInfo ownerFilterItem = new FilterItemInfo("owner", (Object)userID);
        FilterItemInfo filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(ShareTypeEnum.USER_LEVEL.getValue()));
        FilterItemInfo isUserDefaultFilterItem = new FilterItemInfo("solutionType", (Object)"10");
        orgID = QueryUtils.getOrgID(queryName, ctx).toString();
        filterInfo.getFilterItems().add(parentUIFilterItem);
        filterInfo.getFilterItems().add(ownerFilterItem);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterInfo.getFilterItems().add(isUserDefaultFilterItem);
        FilterItemInfo orgFilterItem = new FilterItemInfo("orgID", (Object)orgID);
        filterInfo.getFilterItems().add(orgFilterItem);
        maskString = " #0 and #1 and #2 and #3 and #4 ";
        filterInfo.setMaskString(maskString);
        entityViewInfo.setFilter(filterInfo);
        IQuerySolution querySolution = QuerySolutionFactory.getLocalInstance(ctx);
        QuerySolutionCollection querySolutionCollection = querySolution.getQuerySolutionCollection(entityViewInfo);
        if (querySolutionCollection.size() == 1) {
            return querySolutionCollection.get(0);
        }
        if (querySolutionCollection.size() > 1) {
            int size = querySolutionCollection.size();
            for (int i = 0; i < size; ++i) {
                QuerySolutionInfo info = querySolutionCollection.get(i);
                if (info.getTableParams() == null) continue;
                return info;
            }
            return null;
        }
        return null;
    }

    @Override
    protected Map _getColMaxLength(Context ctx, String queryInfo) throws BOSException, EASBizException {
        HashMap<String, QueryColumnInfo> hs = new HashMap<String, QueryColumnInfo>();
        MetaDataPK queryPK = new MetaDataPK(queryInfo);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        QueryInfo qInfo = loader.getQuery((IMetaDataPK)queryPK);
        QueryFieldInfo queryFieldInfo = new QueryFieldInfo();
        PropertyUnitCollection propertyUnitCollection = qInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo)) continue;
            queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i);
            PropertyRefCollection propertyRefCollection = queryFieldInfo.getPropertyRefs();
            int propertyRefCollectionSize = propertyRefCollection.size();
            int colLength = 0;
            for (int j = 0; j < propertyRefCollectionSize; ++j) {
                QueryColumnInfo tmpCInfo;
                int len;
                PropertyRefInfo propertyRefInfo = propertyRefCollection.get(j);
                PropertyInfo propInfo = propertyRefInfo.getRefProperty();
                ColumnInfo col = null;
                try {
                    col = QueryUtil.getColumnInfoByProp((PropertyInfo)propInfo, (SubEntityInfo)propertyRefInfo.getSubEntity());
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
                if (col == null) continue;
                QueryColumnInfo qcInfo = new QueryColumnInfo();
                colLength = col.getLength();
                if (hs.get(queryFieldInfo.getName()) != null && (len = (tmpCInfo = (QueryColumnInfo)hs.get(queryFieldInfo.getName())).getColumnLength()) > colLength) {
                    colLength = len;
                }
                qcInfo.setColumnLength(colLength);
                qcInfo.setColumnName(queryFieldInfo.getName());
                qcInfo.setColumnType(col.getTypeName());
                hs.put(qcInfo.getColumnName(), qcInfo);
            }
        }
        return hs;
    }
}

