/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.apiservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.apiservice.AbstractGLUnitServiceFacadeControllerBean;
import com.kingdee.eas.base.evs.app.apiservice.api.DataProcessUtil;
import com.kingdee.eas.base.evs.app.apiservice.api.Message;
import com.kingdee.eas.base.evs.app.datapool.CompanyInfo;
import com.kingdee.eas.base.evs.app.datapool.DataRangeInfo;
import com.kingdee.eas.base.evs.app.datapool.VoucherEntryUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.VoucherEntryUnitInfo;
import com.kingdee.eas.base.evs.app.datapool.VoucherUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.VoucherUnitFactory;
import com.kingdee.eas.base.evs.app.datapool.VoucherUnitInfo;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.CheckUtil;
import com.kingdee.eas.base.evs.util.EVSSet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLUnitServiceFacadeControllerBean
extends AbstractGLUnitServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.evs.app.apiservice.GLUnitServiceFacadeControllerBean");

    @Override
    protected String _dataProcess(Context ctx, String jsonDatas) throws BOSException, EASBizException {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonDatas);
        EVSSet evsSet = EVSSet.builder().add("UnifiedSocialCreditCodeOfAccountingEntity").add("NameOfAccountingEntity").add("PeriodNumber").add("PeriodYear");
        try {
            CheckUtil.checkNULL(ctx, (Map)jsonObject, evsSet.get());
        }
        catch (EASBizException e) {
            return Message.error(e.getMessage());
        }
        CompanyInfo companyInfo = DataProcessUtil.processCompany(ctx, jsonObject);
        DataRangeInfo dataRangeInfo = DataProcessUtil.processDataRange(ctx, jsonObject, companyInfo);
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        return this.processVouchers(ctx, dataRangeInfo, datas);
    }

    public String processVouchers(Context ctx, DataRangeInfo dataRangeInfo, JSONArray datas) throws BOSException, EASBizException {
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < datas.size(); ++i) {
            Map voucher = (Map)datas.get(i);
            VoucherUnitInfo info = this.processVoucher(ctx, voucher, dataRangeInfo);
            colls.add((CoreBaseInfo)info);
        }
        VoucherUnitFactory.getLocalInstance(ctx).saveBatchData(colls);
        return Message.success();
    }

    public VoucherUnitInfo processVoucher(Context ctx, Map voucher, DataRangeInfo dataRangeInfo) throws EASBizException, BOSException {
        VoucherUnitCollection oldUnit = VoucherUnitFactory.getLocalInstance(ctx).getVoucherUnitCollection("where voucherPK = '" + voucher.get("PK") + "'");
        VoucherUnitInfo unitInfo = null;
        unitInfo = oldUnit != null && oldUnit.size() > 0 ? oldUnit.get(0) : new VoucherUnitInfo();
        unitInfo.getEntry().clear();
        unitInfo.setDataRange(dataRangeInfo);
        unitInfo.setPostingDate(voucher.get("PostingDate").toString());
        unitInfo.setVoucherNumber(voucher.get("NumberOfAccountingDocuments").toString());
        unitInfo.setVoucherPK(voucher.get("PK").toString());
        unitInfo.setSummary(AS.valueOf(voucher.get("SummaryOfAccountingDocuments"), ""));
        if (voucher.get("InformationOfDebitAndCreditEntryTuple") != null) {
            JSONArray entrys = (JSONArray)voucher.get("InformationOfDebitAndCreditEntryTuple");
            VoucherEntryUnitCollection euColl = new VoucherEntryUnitCollection();
            for (int i = 0; i < entrys.size(); ++i) {
                Map entry = (Map)entrys.get(i);
                VoucherEntryUnitInfo eunit = new VoucherEntryUnitInfo();
                eunit.setRecordedAmount(AS.valueOf(entry.get("RecordedAmount"), ""));
                eunit.setDebitOrCredit(AS.valueOf(entry.get("DebitOrCredit"), ""));
                eunit.setGlSubject(AS.valueOf(entry.get("NameOfGeneralLedgerSubject"), ""));
                eunit.setSlSubject(AS.valueOf(entry.get("NameOfSubsidiaryLedgerSubject"), ""));
                euColl.add(eunit);
            }
            unitInfo.put("entry", (Object)euColl);
        }
        return unitInfo;
    }
}

