/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.apiservice.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.apiservice.api.DataProcessUtil;
import com.kingdee.eas.base.evs.app.apiservice.api.Message;
import com.kingdee.eas.base.evs.app.apiservice.process.IProcessor;
import com.kingdee.eas.base.evs.app.datapool.BillInvoiceEntryUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.BillInvoiceEntryUnitInfo;
import com.kingdee.eas.base.evs.app.datapool.BillUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.BillUnitFactory;
import com.kingdee.eas.base.evs.app.datapool.BillUnitInfo;
import com.kingdee.eas.base.evs.app.datapool.BillVoucherEntryUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.BillVoucherEntryUnitInfo;
import com.kingdee.eas.base.evs.app.datapool.CompanyInfo;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.CheckUtil;
import com.kingdee.eas.base.evs.util.EVSSet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizProcessor
implements IProcessor {
    private Logger logger = Logger.getLogger(BizProcessor.class);

    @Override
    public void checkRequired(Context ctx, JSONObject jsonObject) throws EASBizException {
        EVSSet evsSet = EVSSet.builder().add("PK").add("WhetherInputVatHasBeenTransferredOut").add("AmountOfTransferredOutInputVat").add("WhetherInvoiceIsRedInvoice").add("WhetherInvoiceHasBeenChecked").add("WhetherInvoiceUsageHasBeenConfirmed").add("WhetherInvoiceHasBeenBooked").add("Vouchers").add("BillPK").add("BillNumber");
        EVSSet invoiceSet1 = EVSSet.builder().add("SerialNumber");
        EVSSet invoiceSet2 = EVSSet.builder().add("InvoiceNumber").add("InvoiceCode");
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            CheckUtil.checkNULL(ctx, bill, evsSet.get());
            if (bill.get("Invoices") == null) continue;
            JSONArray invoices = (JSONArray)bill.get("Invoices");
            for (int j = 0; j < invoices.size(); ++j) {
                Map invoice = (Map)invoices.get(j);
                CheckUtil.checkNULL(ctx, invoice, invoiceSet1.get(), invoiceSet2.get());
            }
        }
        HashSet<String> checkDupDateSet = new HashSet<String>();
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            if (checkDupDateSet.contains(bill.get("PK") + "")) {
                this.logger.error((Object)("BizProcessor\u88ab\u4e22\u5f03\u7684\u91cd\u590d\u6570\u636e\uff1a" + bill.get("PK")));
                datas.remove(i);
                --i;
            }
            checkDupDateSet.add(bill.get("PK") + "");
        }
    }

    @Override
    public String process(Context ctx, JSONObject jsonObject) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        CompanyInfo companyInfo = DataProcessUtil.processCompany(ctx, jsonObject);
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            BillUnitCollection oldUnit = BillUnitFactory.getLocalInstance(ctx).getBillUnitCollection("where uniquePK = '" + bill.get("PK") + "'");
            BillUnitInfo unitInfo = new BillUnitInfo();
            if (oldUnit != null && oldUnit.size() > 0) {
                unitInfo.setId(oldUnit.get(0).getId());
            }
            unitInfo.setBillNumber(AS.valueOf(bill.get("BillNumber"), ""));
            unitInfo.setUniquePK(bill.get("PK") + "");
            unitInfo.setBillPK(AS.valueOf(bill.get("BillPK"), ""));
            unitInfo.setHasBeenTransferredOut(AS.valueOf(bill.get("WhetherInputVatHasBeenTransferredOut"), ""));
            unitInfo.setTransferredOutAmount(AS.valueOf(bill.get("AmountOfTransferredOutInputVat"), ""));
            unitInfo.setContractNumber(AS.valueOf(bill.get("ContractNumber"), ""));
            unitInfo.setMatchingState(AS.valueOf(bill.get("MatchingStateBetweenBusinessDocumentsAndVatEInvoice"), ""));
            unitInfo.setDepreciation(AS.valueOf(bill.get("DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets"), ""));
            unitInfo.setFactoredSoldSecuritized(AS.valueOf(bill.get("WhetherInvoiceHasBeenFactoredSoldOrSecuritized"), ""));
            unitInfo.setRedInvoice(AS.valueOf(bill.get("WhetherInvoiceIsRedInvoice"), ""));
            unitInfo.setHasBeenChecked(AS.valueOf(bill.get("WhetherInvoiceHasBeenChecked"), ""));
            unitInfo.setHasBeenConfirmed(AS.valueOf(bill.get("WhetherInvoiceUsageHasBeenConfirmed"), ""));
            unitInfo.setUsageConfirmation(AS.valueOf(bill.get("UsageConfirmation"), ""));
            unitInfo.setPeriodOfUsage(AS.valueOf(bill.get("PeriodOfUsageConfirmation"), ""));
            unitInfo.setHasBeenBooked(AS.valueOf(bill.get("WhetherInvoiceHasBeenBooked"), ""));
            unitInfo.setHasBeenPaid(AS.valueOf(bill.get("WhetherInvoiceHasBeenPaid"), ""));
            unitInfo.setReceipt(AS.valueOf(bill.get("NumberOfBankElectronicReceipt"), ""));
            JSONArray invoices = (JSONArray)bill.get("Invoices");
            BillInvoiceEntryUnitCollection invoiceEntry = new BillInvoiceEntryUnitCollection();
            for (int j = 0; j < invoices.size(); ++j) {
                Map invoice = (Map)invoices.get(j);
                BillInvoiceEntryUnitInfo info = new BillInvoiceEntryUnitInfo();
                info.setInvoiceType(AS.valueOf(invoice.get("InvoiceType"), ""));
                info.setSerialNO(AS.valueOf(invoice.get("SerialNumber"), ""));
                info.setInvoiceCode(AS.valueOf(invoice.get("InvoiceCode"), ""));
                info.setInvoiceNO(AS.valueOf(invoice.get("InvoiceNumber"), ""));
                invoiceEntry.add(info);
            }
            unitInfo.put("entry", (Object)invoiceEntry);
            BillVoucherEntryUnitCollection voucherEntry = new BillVoucherEntryUnitCollection();
            String[] vouchers = AS.valueOf(bill.get("Vouchers"), "").split(",");
            for (int j = 0; j < vouchers.length; ++j) {
                BillVoucherEntryUnitInfo info = new BillVoucherEntryUnitInfo();
                info.setVoucherId(vouchers[j]);
                voucherEntry.add(info);
            }
            unitInfo.put("voucherEntry", (Object)voucherEntry);
            unitInfo.setCompany(companyInfo);
            DataProcessUtil.fillAuditData(ctx, unitInfo);
            colls.add((CoreBaseInfo)unitInfo);
        }
        if (!colls.isEmpty()) {
            BillUnitFactory.getLocalInstance(ctx).saveBatchData(colls);
        }
        return Message.success();
    }
}

