/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.apiservice.process;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.apiservice.api.Message;
import com.kingdee.eas.base.evs.app.apiservice.process.BizProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.BkerProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.BkrsProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.IProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.invoice.AtrInvoiceProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.invoice.EfiInvoiceProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.invoice.EinvOrdInvoiceProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.invoice.EinvSpclInvoiceProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.invoice.GpmInvoiceProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.invoice.OrdInvoiceProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.invoice.RaiInvoiceProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.invoice.SpclInvoiceProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.invoice.TlfInvoiceProcessor;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;
import java.util.Map;

public class ProcessorFactory {
    static Map<String, IProcessor> map = new HashMap<String, IProcessor>();

    public static String process(Context ctx, JSONObject jsonObject, String type) throws EASBizException, BOSException {
        IProcessor processor = map.get(type);
        if (processor != null) {
            try {
                processor.checkRequired(ctx, jsonObject);
            }
            catch (EASBizException e) {
                return Message.error(e.getMessage());
            }
            return processor.process(ctx, jsonObject);
        }
        throw new EASBizException(new NumericExceptionSubItem("00-00", "\u3010" + type + "\u3011\u4e0d\u652f\u6301\u7684\u7c7b\u578b"));
    }

    static {
        map.put("bker_processor", new BkerProcessor());
        map.put("bkrs_processor", new BkrsProcessor());
        map.put("biz_processor", new BizProcessor());
        map.put("spcl_processor", new SpclInvoiceProcessor());
        map.put("tlf_processor", new TlfInvoiceProcessor());
        map.put("ord_processor", new OrdInvoiceProcessor());
        map.put("gpm_processor", new GpmInvoiceProcessor());
        map.put("atr_processor", new AtrInvoiceProcessor());
        map.put("rai_processor", new RaiInvoiceProcessor());
        map.put("efi_processor", new EfiInvoiceProcessor());
        map.put("einv_ord_processor", new EinvOrdInvoiceProcessor());
        map.put("einv_spcl_processor", new EinvSpclInvoiceProcessor());
    }
}

