/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.apiservice.process.invoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.apiservice.api.DataProcessUtil;
import com.kingdee.eas.base.evs.app.apiservice.api.Message;
import com.kingdee.eas.base.evs.app.apiservice.process.IProcessor;
import com.kingdee.eas.base.evs.app.datapool.CompanyInfo;
import com.kingdee.eas.base.evs.app.datapool.EinvOrdInvoiceUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.EinvOrdInvoiceUnitFactory;
import com.kingdee.eas.base.evs.app.datapool.EinvOrdInvoiceUnitInfo;
import com.kingdee.eas.base.evs.app.datapool.InvoiceUnitBillCollection;
import com.kingdee.eas.base.evs.app.datapool.InvoiceUnitBillInfo;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.CheckUtil;
import com.kingdee.eas.base.evs.util.EVSSet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class EinvOrdInvoiceProcessor
implements IProcessor {
    private Logger logger = Logger.getLogger(EinvOrdInvoiceProcessor.class);

    @Override
    public void checkRequired(Context ctx, JSONObject jsonObject) throws EASBizException {
        EVSSet evsSet = EVSSet.builder().add("UniqueCodeOfInvoice").add("SellerName").add("SellerIdNum").add("TotalAmWithoutTax").add("TotalTaxAmount").add("TaxIncludedAmountInFigures").add("DateOfIssue").add("WhetherInvoiceIsRedInvoice").add("WhetherInvoiceHasBeenChecked").add("UniquePK");
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            CheckUtil.checkNULL(ctx, bill, evsSet.get());
        }
        HashSet<String> checkDupDateSet = new HashSet<String>();
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            if (checkDupDateSet.contains(bill.get("UniquePK") + "")) {
                this.logger.error((Object)("EinvOrdInvoiceProcessor\u88ab\u4e22\u5f03\u7684\u91cd\u590d\u6570\u636e\uff1a" + bill.get("UniquePK")));
                datas.remove(i);
                --i;
            }
            checkDupDateSet.add(bill.get("UniquePK") + "");
        }
    }

    @Override
    public String process(Context ctx, JSONObject jsonObject) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        CompanyInfo companyInfo = DataProcessUtil.processCompany(ctx, jsonObject);
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            EinvOrdInvoiceUnitCollection oldUnit = EinvOrdInvoiceUnitFactory.getLocalInstance(ctx).getEinvOrdInvoiceUnitCollection("where uniquePK = '" + bill.get("UniquePK") + "'");
            EinvOrdInvoiceUnitInfo unitInfo = new EinvOrdInvoiceUnitInfo();
            if (oldUnit != null && oldUnit.size() > 0) {
                unitInfo.setId(oldUnit.get(0).getId());
            }
            unitInfo.setUniqueCode(AS.valueOf(bill.get("UniqueCodeOfInvoice"), ""));
            unitInfo.setSellerName(AS.valueOf(bill.get("SellerName"), ""));
            unitInfo.setSellerIdNum(AS.valueOf(bill.get("SellerIdNum"), ""));
            unitInfo.setTotalAmWithoutTax(AS.valueOf(bill.get("TotalAmWithoutTax"), ""));
            unitInfo.setTotalTaxAmount(AS.valueOf(bill.get("TotalTaxAmount"), ""));
            unitInfo.setTaxInAmInFigures(AS.valueOf(bill.get("TaxIncludedAmountInFigures"), ""));
            unitInfo.setDateOfIssue(AS.valueOf(bill.get("DateOfIssue"), ""));
            unitInfo.setTotalTaxAmount(AS.valueOf(bill.get("TotalTaxAmount"), ""));
            unitInfo.setDateOfIssue(AS.valueOf(bill.get("DateOfIssue"), ""));
            unitInfo.setIsRedInvoice(AS.valueOf(bill.get("WhetherInvoiceIsRedInvoice"), ""));
            unitInfo.setHasBeenChecked(AS.valueOf(bill.get("WhetherInvoiceHasBeenChecked"), ""));
            unitInfo.setUniquePK(AS.valueOf(bill.get("UniquePK"), ""));
            InvoiceUnitBillCollection billEntry = new InvoiceUnitBillCollection();
            String[] bills = AS.valueOf(bill.get("Bills"), "").split(",");
            for (int j = 0; j < bills.length; ++j) {
                InvoiceUnitBillInfo info = new InvoiceUnitBillInfo();
                info.setBillId(bills[j]);
                billEntry.add(info);
            }
            unitInfo.put("bill", (Object)billEntry);
            unitInfo.setInvoiceCode(AS.valueOf(bill.get("InvoiceCode"), ""));
            unitInfo.setInvoiceNO(AS.valueOf(bill.get("InvoiceNO"), ""));
            unitInfo.setSerialNO(AS.valueOf(bill.get("SerialNO"), ""));
            unitInfo.setInvoiceType(AS.valueOf(bill.get("InvoiceType"), ""));
            unitInfo.setInvoiceTypeName(AS.valueOf(bill.get("InvoiceTypeName"), ""));
            unitInfo.setOriginalurl(AS.valueOf(bill.get("Originalurl"), ""));
            unitInfo.setPdfurl(AS.valueOf(bill.get("Pdfurl"), ""));
            unitInfo.setSnapshoturl(AS.valueOf(bill.get("Snapshoturl"), ""));
            unitInfo.setXbrlurl(AS.valueOf(bill.get("IssuerXbrlurl"), ""));
            unitInfo.setXbrlname(AS.valueOf(bill.get("IssuerXbrlName"), ""));
            unitInfo.setCompany(companyInfo);
            DataProcessUtil.fillAuditData(ctx, unitInfo);
            colls.add((CoreBaseInfo)unitInfo);
        }
        if (!colls.isEmpty()) {
            EinvOrdInvoiceUnitFactory.getLocalInstance(ctx).saveBatchData(colls);
        }
        return Message.success();
    }
}

