/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.apiservice.process.invoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.apiservice.api.DataProcessUtil;
import com.kingdee.eas.base.evs.app.apiservice.api.Message;
import com.kingdee.eas.base.evs.app.apiservice.process.IProcessor;
import com.kingdee.eas.base.evs.app.apiservice.process.invoice.GpmInvoiceProcessor;
import com.kingdee.eas.base.evs.app.datapool.CompanyInfo;
import com.kingdee.eas.base.evs.app.datapool.InvoiceUnitBillCollection;
import com.kingdee.eas.base.evs.app.datapool.InvoiceUnitBillInfo;
import com.kingdee.eas.base.evs.app.datapool.OrdInvoiceUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.OrdInvoiceUnitFactory;
import com.kingdee.eas.base.evs.app.datapool.OrdInvoiceUnitInfo;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.CheckUtil;
import com.kingdee.eas.base.evs.util.EVSSet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrdInvoiceProcessor
implements IProcessor {
    private Logger logger = Logger.getLogger(GpmInvoiceProcessor.class);

    @Override
    public void checkRequired(Context ctx, JSONObject jsonObject) throws EASBizException {
        EVSSet evsSet = EVSSet.builder().add("UniqueCodeOfInvoice").add("NameOfSeller").add("TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller").add("TotalAmountExcludingTax").add("TotalTaxAmount").add("TaxIncludedAmountInFigures").add("DateOfIssue").add("WhetherInvoiceIsRedInvoice").add("WhetherInvoiceHasBeenChecked").add("UniquePK");
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            CheckUtil.checkNULL(ctx, bill, evsSet.get());
        }
        HashSet<String> checkDupDateSet = new HashSet<String>();
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            if (checkDupDateSet.contains(bill.get("UniquePK") + "")) {
                this.logger.error((Object)("OrdInvoiceProcessor\u88ab\u4e22\u5f03\u7684\u91cd\u590d\u6570\u636e\uff1a" + bill.get("UniquePK")));
                datas.remove(i);
                --i;
            }
            checkDupDateSet.add(bill.get("UniquePK") + "");
        }
    }

    @Override
    public String process(Context ctx, JSONObject jsonObject) throws EASBizException, BOSException {
        CoreBaseCollection colls = new CoreBaseCollection();
        CompanyInfo companyInfo = DataProcessUtil.processCompany(ctx, jsonObject);
        JSONArray datas = (JSONArray)jsonObject.get((Object)"Datas");
        for (int i = 0; i < datas.size(); ++i) {
            Map bill = (Map)datas.get(i);
            OrdInvoiceUnitCollection oldUnit = OrdInvoiceUnitFactory.getLocalInstance(ctx).getOrdInvoiceUnitCollection("where uniquePK = '" + bill.get("UniquePK") + "'");
            OrdInvoiceUnitInfo unitInfo = new OrdInvoiceUnitInfo();
            if (oldUnit != null && oldUnit.size() > 0) {
                unitInfo.setId(oldUnit.get(0).getId());
            }
            unitInfo.setUniqueCode(AS.valueOf(bill.get("UniqueCodeOfInvoice"), ""));
            unitInfo.setPreTaxDedCompleted(AS.valueOf(bill.get("WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted"), ""));
            unitInfo.setTotalAmExcludTax(AS.valueOf(bill.get("TotalAmountExcludingTax"), ""));
            unitInfo.setMatchingState(AS.valueOf(bill.get("MatchingStateBetweenBusinessDocumentsAndVatEInvoice"), ""));
            unitInfo.setContractNumber(AS.valueOf(bill.get("ContractNumber"), ""));
            unitInfo.setPaid(AS.valueOf(bill.get("WhetherInvoiceHasBeenPaid"), ""));
            unitInfo.setBankEleReceiptNum(AS.valueOf(bill.get("NumberOfBankElectronicReceipt"), ""));
            unitInfo.setTaxInAmInFigures(AS.valueOf(bill.get("TaxIncludedAmountInFigures"), ""));
            unitInfo.setPretaxdudectBeginyear(AS.valueOf(bill.get("BeginningOfPreTaxDeductionYearOfIncomeTax"), ""));
            unitInfo.setPretaxdudectEndyear(AS.valueOf(bill.get("EndOfPreTaxDeductionYearOfIncomeTax"), ""));
            unitInfo.setExpPeriodBegin(AS.valueOf(bill.get("BeginningOfExpenditurePeriodUnderAccrualBasis"), ""));
            unitInfo.setExpPeriodEnd(AS.valueOf(bill.get("EndOfExpenditurePeriodUnderAccrualBasis"), ""));
            unitInfo.setDepmethod(AS.valueOf(bill.get("DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets"), ""));
            unitInfo.setDateOfIssue(AS.valueOf(bill.get("DateOfIssue"), ""));
            unitInfo.setFsOrAbs(AS.valueOf(bill.get("WhetherInvoiceHasBeenFactoredSoldOrSecuritized"), ""));
            unitInfo.setNameOfSeller(AS.valueOf(bill.get("NameOfSeller"), ""));
            unitInfo.setCreditCodeOfSeller(AS.valueOf(bill.get("TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller"), ""));
            unitInfo.setTotalTaxAmount(AS.valueOf(bill.get("TotalTaxAmount"), ""));
            unitInfo.setFsOrAbs(AS.valueOf(bill.get("WhetherInvoiceHasBeenFactoredSoldOrSecuritized"), ""));
            unitInfo.setIsRedInvoice(AS.valueOf(bill.get("WhetherInvoiceIsRedInvoice"), ""));
            unitInfo.setHasBeenChecked(AS.valueOf(bill.get("WhetherInvoiceHasBeenChecked"), ""));
            unitInfo.setUniquePK(AS.valueOf(bill.get("UniquePK"), ""));
            InvoiceUnitBillCollection billEntry = new InvoiceUnitBillCollection();
            String[] bills = AS.valueOf(bill.get("Bills"), "").split(",");
            for (int j = 0; j < bills.length; ++j) {
                InvoiceUnitBillInfo info = new InvoiceUnitBillInfo();
                info.setBillId(bills[j]);
                billEntry.add(info);
            }
            unitInfo.put("bill", (Object)billEntry);
            unitInfo.setInvoiceCode(AS.valueOf(bill.get("InvoiceCode"), ""));
            unitInfo.setInvoiceNO(AS.valueOf(bill.get("InvoiceNO"), ""));
            unitInfo.setSerialNO(AS.valueOf(bill.get("SerialNO"), ""));
            unitInfo.setInvoiceType(AS.valueOf(bill.get("InvoiceType"), ""));
            unitInfo.setInvoiceTypeName(AS.valueOf(bill.get("InvoiceTypeName"), ""));
            unitInfo.setOriginalurl(AS.valueOf(bill.get("Originalurl"), ""));
            unitInfo.setPdfurl(AS.valueOf(bill.get("Pdfurl"), ""));
            unitInfo.setSnapshoturl(AS.valueOf(bill.get("Snapshoturl"), ""));
            unitInfo.setXbrlurl(AS.valueOf(bill.get("IssuerXbrlurl"), ""));
            unitInfo.setXbrlname(AS.valueOf(bill.get("IssuerXbrlName"), ""));
            unitInfo.setCompany(companyInfo);
            DataProcessUtil.fillAuditData(ctx, unitInfo);
            colls.add((CoreBaseInfo)unitInfo);
        }
        if (!colls.isEmpty()) {
            OrdInvoiceUnitFactory.getLocalInstance(ctx).saveBatchData(colls);
        }
        return Message.success();
    }
}

