/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.IDataConverter;
import com.kingdee.eas.base.evs.app.datapool.BkrsInvoiceEntryUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.BkrsInvoiceEntryUnitInfo;
import com.kingdee.eas.base.evs.app.datapool.BkrsInvoiceUnitCollection;
import com.kingdee.eas.base.evs.app.datapool.BkrsInvoiceUnitFactory;
import com.kingdee.eas.base.evs.app.datapool.BkrsInvoiceUnitInfo;
import com.kingdee.eas.base.evs.app.elcertificate.BkrsInvoiceFactory;
import com.kingdee.eas.base.evs.app.elcertificate.BkrsInvoiceInfo;
import com.kingdee.eas.base.evs.app.elcertificate.helper.EleCertificatePoolHelperFactory;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BkrsConverter
implements IDataConverter {
    public String getSql() {
        return "select a.FPrintTimes,a.FReserveBalanceAtTheEnd,a.FYearOfBankReconciliation,a.FIdentificationCodeOfIssuer,a.FCustomerSettlementBankAccount,a.FPrintDate, a.FCurrency,a.FNumberOfBankBranch,a.FNameOfCustomerAccount,a.FOverdraftBalanceAtEnd,a.FMonthOfBankReconciliation,a.FAccountBalanceAtTheEnd, a.FileName,a.FBillPK,a.FBillNumber,a.FrozenBalanceAtTheEnd,a.FCodeOfBankCustomer,a.FAvailableBalanceAtTheEnd, g.FCompanyName,g.FCompanyCreaditCode,f.FPeriodNumber,f.FPeriodYear from T_EVS_BkrsInvoiceUnit a inner join T_EVS_DataRange f on a.FDataRangeId = f.fid inner join T_EVS_Company g on g.fid = f.FCompanyId ";
    }

    @Override
    public void converter(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber) throws Exception {
        this.converter(ctx, companyInfo, periodYear, periodNumber, null);
    }

    @Override
    public void converter(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> bankAccounts) throws Exception {
        String sql1 = this.getSql();
        sql1 = sql1 + "where g.FCompanyCreaditCode = '" + companyInfo.getTaxNumber() + "' and f.FPeriodYear = " + periodYear + " and f.FPeriodNumber = " + periodNumber + " ";
        if (bankAccounts != null && !bankAccounts.isEmpty()) {
            sql1 = sql1 + " and a.FCustomerSettlementBankAccount in (" + SQLUtils.getSQL(bankAccounts) + ")";
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql1);
        this.saveData(ctx, rowSet, companyInfo, periodYear, periodNumber, bankAccounts);
    }

    public void saveData(Context ctx, IRowSet rowSet, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> bankAccounts) throws Exception {
        CoreBaseCollection collection = new CoreBaseCollection();
        String taxNumber = "";
        Map<String, String> reconcileDetailsTuple = this.getReconcileDetailsTuple(ctx, companyInfo.getTaxNumber(), periodYear, periodNumber, bankAccounts);
        while (rowSet.next()) {
            BkrsInvoiceInfo info = new BkrsInvoiceInfo();
            info.setPrintTimes(rowSet.getString("FPrintTimes"));
            info.setReserveBalanceEnd(rowSet.getString("FReserveBalanceAtTheEnd"));
            info.setYear(rowSet.getString("FYearOfBankReconciliation"));
            info.setIdentificationCode(rowSet.getString("FIdentificationCodeOfIssuer"));
            info.setCustomerBankAccount(rowSet.getString("FCustomerSettlementBankAccount"));
            info.setPrintDate(rowSet.getString("FPrintDate"));
            info.setCurrency(rowSet.getString("FCurrency"));
            info.setBankBranchNumber(rowSet.getString("FNumberOfBankBranch"));
            info.setCustomerAccountName(rowSet.getString("FNameOfCustomerAccount"));
            info.setOverdraftBalanceEnd(rowSet.getString("FOverdraftBalanceAtEnd"));
            info.setMonth(rowSet.getString("FMonthOfBankReconciliation"));
            info.setAccountBalanceEnd(rowSet.getString("FAccountBalanceAtTheEnd"));
            info.setBillPK(rowSet.getString("FBillPK"));
            info.setBillNumber(rowSet.getString("FBillNumber"));
            info.setFrozenBalanceEnd(rowSet.getString("FrozenBalanceAtTheEnd"));
            info.setBankCustomerCode(rowSet.getString("FCodeOfBankCustomer"));
            info.setAvailableBalanceEnd(rowSet.getString("FAvailableBalanceAtTheEnd"));
            info.setPeriodYear(rowSet.getInt("FPeriodYear"));
            info.setPeriodNumber(rowSet.getInt("FPeriodNumber"));
            String fCompanyCreaditCode = rowSet.getString("FCompanyCreaditCode");
            taxNumber = StringUtils.isEmpty((String)taxNumber) ? fCompanyCreaditCode : taxNumber;
            info.setCreditCode(fCompanyCreaditCode);
            info.setAccountName(rowSet.getString("FCompanyName"));
            info.setFileName(rowSet.getString("FileName"));
            info.setReconcileDetailsTuple(reconcileDetailsTuple.get(info.getYear() + info.getMonth() + info.getCustomerBankAccount()));
            collection.add((CoreBaseInfo)info);
        }
        HashSet<String> customerBankAccount = new HashSet<String>();
        String oql = "where periodYear = " + periodYear + " and periodNumber = " + periodNumber + " and creditCode = '" + companyInfo.getTaxNumber() + "'";
        if (bankAccounts != null && !bankAccounts.isEmpty()) {
            customerBankAccount.addAll(bankAccounts);
            oql = oql + " and customerBankAccount in (" + SQLUtils.getSQL(bankAccounts) + ")";
        }
        BkrsInvoiceFactory.getLocalInstance(ctx).delete(oql);
        EleCertificatePoolHelperFactory.getInstance(ctx, "bkrs").syncExportRecord2New(ctx, collection, periodYear, periodNumber, taxNumber, customerBankAccount);
        BkrsInvoiceFactory.getLocalInstance(ctx).saveBatchData(collection);
    }

    private Map<String, String> getReconcileDetailsTuple(Context ctx, String creditCode, int year, int month, List<String> bankAccounts) throws BOSException {
        String oql = "where dataRange.periodYear = " + year + " and dataRange.periodNumber = " + month + " and dataRange.company.companyCreaditCode = '" + creditCode + "' ";
        if (bankAccounts != null && !bankAccounts.isEmpty()) {
            oql = oql + " and customerSettlementBankAccount in (" + SQLUtils.getSQL(bankAccounts) + ")";
        }
        BkrsInvoiceUnitCollection unitCollection = BkrsInvoiceUnitFactory.getLocalInstance(ctx).getBkrsInvoiceUnitCollection("select customerSettlementBankAccount,yearOfBankReconciliation,monthOfBankReconciliation,entry.* " + oql + " ");
        HashMap<String, String> result = new HashMap<String, String>(unitCollection.size());
        for (int i = 0; i < unitCollection.size(); ++i) {
            BkrsInvoiceUnitInfo info = unitCollection.get(i);
            JSONArray arr = new JSONArray();
            BkrsInvoiceEntryUnitCollection entry = info.getEntry();
            for (int j = 0; j < entry.size(); ++j) {
                BkrsInvoiceEntryUnitInfo entryUnitInfo = entry.get(j);
                JSONObject obj = new JSONObject();
                obj.put("DateOfBookkeeping", (Object)entryUnitInfo.getBookKeepingDate());
                obj.put("TypesOfBusinessProducts", (Object)entryUnitInfo.getBusinessProType());
                obj.put("BusinessSerialNumber", (Object)entryUnitInfo.getBusinessSerialNumber());
                obj.put("TypeOfSourceDocument", (Object)entryUnitInfo.getSourceDocumentType());
                obj.put("NumberOfSourceDocument", (Object)entryUnitInfo.getSourceDocumentNumber());
                obj.put("NotesOfBankElectronicReceipt", (Object)entryUnitInfo.getReceiptNotes());
                obj.put("IdentificationOfCreditOrDebit", (Object)entryUnitInfo.getCreditOrDebit());
                obj.put("TransactionAmount", (Object)entryUnitInfo.getTransactionAmount());
                obj.put("DebitOrCreditOfBalance", (Object)entryUnitInfo.getDebitOrCreditOfBalance());
                obj.put("AccountBalance", (Object)entryUnitInfo.getAccountBalance());
                obj.put("TransactionCode", (Object)entryUnitInfo.getTransactionCode());
                obj.put("AccountOfCounterparty", (Object)entryUnitInfo.getAccountOfCounterparty());
                obj.put("NameOfCounterparty", (Object)entryUnitInfo.getCounterpartyName());
                obj.put("DepositoryBankOfCounterparty", (Object)entryUnitInfo.getDepositoryBankOfCounterparty());
                obj.put("Bookkeeper", (Object)entryUnitInfo.getBookkeeper());
                obj.put("TimeOfBookkeeping", (Object)entryUnitInfo.getBookkeepingTime());
                obj.put("JournalAccountOfBookkeeping", (Object)entryUnitInfo.getAccountOfBookkeepingJournal());
                obj.put("OtherAccountingInformation", (Object)entryUnitInfo.getOtherAccountingInformation());
                obj.put("NumberOfBankElectronicReceipt", (Object)entryUnitInfo.getReceiptNumber());
                arr.add((Object)obj);
            }
            result.put(info.getYearOfBankReconciliation() + info.getMonthOfBankReconciliation() + info.getCustomerSettlementBankAccount(), arr.toJSONString());
        }
        return result;
    }
}

