/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.ConverterFactory;
import com.kingdee.eas.base.evs.app.converter.IDataConverter;
import com.kingdee.eas.base.evs.app.converter.Msg;
import com.kingdee.eas.base.evs.app.converter.Status;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataConverterEngine {
    private static Logger logger = Logger.getLogger(DataConverterEngine.class);

    public static Msg converter(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber) {
        return DataConverterEngine.converter(ctx, companyInfo, periodYear, periodNumber, null);
    }

    public static Msg converter(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> standardTypes) {
        return DataConverterEngine.converter(ctx, companyInfo, periodYear, periodNumber, standardTypes, null);
    }

    public static Msg converter(Context ctx, CompanyOrgUnitInfo companyInfo, int periodYear, int periodNumber, List<String> standardTypes, List<String> ids) {
        if (standardTypes == null || standardTypes.isEmpty()) {
            standardTypes = new ArrayList<String>();
            Set<String> set = ConverterFactory.converterMap.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                standardTypes.add(iterator.next());
            }
        }
        Msg result = Msg.success();
        for (int i = 0; i < standardTypes.size(); ++i) {
            try {
                IDataConverter converter = ConverterFactory.converter(ctx, standardTypes.get(i));
                converter.converter(ctx, companyInfo, periodYear, periodNumber, ids);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.addErrorMsg(standardTypes.get(i), AS.getThrowableDetail(e));
            }
        }
        if (standardTypes.size() > 0) {
            if (result.getError().isEmpty()) {
                result.setStatus(Status.ALLSUCCESS);
            } else if (result.getError().size() < standardTypes.size()) {
                result.setStatus(Status.PARTSUCCESS);
            } else {
                result.setStatus(Status.FAIL);
            }
        }
        return result;
    }
}

