/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.elcertificate.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.evs.app.elcertificate.CertificatePoolDataRangeInfo;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceExportRecordCollection;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceExportRecordFactory;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceExportRecordInfo;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryCollection;
import com.kingdee.eas.base.evs.app.elcertificate.helper.IEleCertificatePoolHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractInvoiceHelper
implements IEleCertificatePoolHelper {
    public abstract String getInvoiceUniqueCodeFieldName();

    public abstract String getStandardType();

    public abstract BOSObjectType getBosType();

    public abstract String getTableName();

    @Override
    public void UpdateOrAddNewInvoiceExportInfo(Context ctx, Set<String> uniqueCodes, String standardTypes, CertificatePoolDataRangeInfo dataRange, boolean whetherExported, IObjectPK recordId) throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("periodYear", (Object)dataRange.getPeriodYear(), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("periodNumber", (Object)dataRange.getPeriodNumber(), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("creditCode", (Object)dataRange.getTaxNumber(), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo(this.getInvoiceUniqueCodeFieldName(), uniqueCodes, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = entityViewInfo.getSelector();
        selectorItemCollection.add(new SelectorItemInfo("invoiceExportRecord.exportRecordIds"));
        selectorItemCollection.add(new SelectorItemInfo("invoiceExportRecord.exportStatus"));
        selectorItemCollection.add(new SelectorItemInfo(this.getInvoiceUniqueCodeFieldName()));
        entityViewInfo.setBaseOnSelector(true);
        IObjectCollection invoiceCollection = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(this.getBosType(), entityViewInfo);
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
        ArrayList<Object[]> addNewParams = new ArrayList<Object[]>();
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        for (int i = invoiceCollection.size() - 1; i >= 0; --i) {
            IObjectValue invoiceInfo = invoiceCollection.getObject(i);
            InvoiceExportRecordInfo exportRecord = (InvoiceExportRecordInfo)invoiceInfo.get("invoiceExportRecord");
            if (exportRecord == null) {
                InvoiceExportRecordInfo recordInfo = new InvoiceExportRecordInfo();
                BOSUuid id = BOSUuid.create((BOSObjectType)recordInfo.getBOSType());
                recordInfo.setId(id);
                recordInfo.setExportRecordIds(recordId.toString());
                recordInfo.setInvoiceType(standardTypes);
                recordInfo.setExportStatus(whetherExported);
                recordInfo.setDataRange(dataRange);
                recordInfo.setUniqueCode(invoiceInfo.get(this.getInvoiceUniqueCodeFieldName()).toString());
                coreBaseCollection.add((CoreBaseInfo)recordInfo);
                addNewParams.add(new Object[]{id.toString(), invoiceInfo.get("id").toString()});
                continue;
            }
            String exportRecords = StringUtils.isEmpty((CharSequence)exportRecord.getExportRecordIds()) ? recordId.toString() : exportRecord.getExportRecordIds() + ";" + recordId.toString();
            updateParams.add(new Object[]{exportRecords, whetherExported, exportRecord.getId().toString()});
        }
        if (updateParams.size() > 0) {
            String updateSql = "update T_EVS_InvoiceExportRecord set FExportRecordIds = ? , FExportStatus = ? where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)updateSql, updateParams);
        }
        if (addNewParams.size() > 0) {
            InvoiceExportRecordFactory.getLocalInstance(ctx).addnewBatchData(coreBaseCollection);
            String updateSql = "update " + this.getTableName() + " set FInvoiceExportRecord = ? where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)updateSql, addNewParams);
        }
    }

    @Override
    public List<String> getExportRecordIds(Context ctx, int periodYear, int periodNumber, String creditCode, String uniqueCode) throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("invoiceType", (Object)this.getStandardType(), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("dataRange.periodYear", (Object)periodYear, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("dataRange.periodNumber", (Object)periodNumber, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("dataRange.taxNumber", (Object)creditCode, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("uniqueCode", (Object)uniqueCode, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = entityViewInfo.getSelector();
        selectorItemCollection.add(new SelectorItemInfo("exportRecordIds"));
        entityViewInfo.setBaseOnSelector(true);
        InvoiceExportRecordCollection recordCollection = InvoiceExportRecordFactory.getLocalInstance(ctx).getInvoiceExportRecordCollection(entityViewInfo);
        if (recordCollection.size() == 0) {
            return Collections.emptyList();
        }
        String exportRecordIds = recordCollection.get(0).getExportRecordIds();
        if (StringUtils.isEmpty((CharSequence)exportRecordIds)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(exportRecordIds.split(";")));
    }

    @Override
    public void syncExportRecord2New(Context ctx, CoreBaseCollection coreBaseCollection, int periodYear, int periodNumber, String taxNumber, Set<String> uniqueCodes) throws BOSException {
        int i;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("invoiceType", (Object)this.getStandardType(), CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("dataRange.periodYear", (Object)periodYear, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("dataRange.periodNumber", (Object)periodNumber, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("dataRange.taxNumber", (Object)taxNumber, CompareType.EQUALS));
        if (uniqueCodes != null && uniqueCodes.size() > 0) {
            filterItems.add(new FilterItemInfo("uniqueCode", uniqueCodes, CompareType.INCLUDE));
        }
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = entityViewInfo.getSelector();
        selectorItemCollection.add(new SelectorItemInfo("uniqueCode"));
        selectorItemCollection.add(new SelectorItemInfo("id"));
        entityViewInfo.setBaseOnSelector(true);
        InvoiceExportRecordCollection recordCollection = InvoiceExportRecordFactory.getLocalInstance(ctx).getInvoiceExportRecordCollection(entityViewInfo);
        HashMap<String, String> recordMap = new HashMap<String, String>();
        for (i = recordCollection.size() - 1; i >= 0; --i) {
            InvoiceExportRecordInfo recordInfo = recordCollection.get(i);
            recordMap.put(recordInfo.getUniqueCode(), recordInfo.getId().toString());
        }
        for (i = 0; i < coreBaseCollection.size(); ++i) {
            CoreBaseInfo info = coreBaseCollection.get(i);
            info.put("invoiceExportRecord", recordMap.get(info.get(this.getInvoiceUniqueCodeFieldName())));
        }
    }

    @Override
    public Map<String, List<String>> getInvoiceVoucherIds(Context ctx, Set<String> invoiceIds) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItemCollection = filterInfo.getFilterItems();
        filterItemCollection.add(new FilterItemInfo("id", invoiceIds, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = entityViewInfo.getSelector();
        selector.add(new SelectorItemInfo(this.getInvoiceUniqueCodeFieldName()));
        selector.add(new SelectorItemInfo("voucherEntry.voucherId"));
        entityViewInfo.setBaseOnSelector(true);
        IObjectCollection objectCollection = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(this.getBosType(), entityViewInfo);
        if (objectCollection.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (int i = 0; i < objectCollection.size(); ++i) {
            IObjectValue invoice = objectCollection.getObject(i);
            ArrayList<String> voucherIds = new ArrayList<String>();
            InvoiceVoucherEntryCollection voucherEntry = (InvoiceVoucherEntryCollection)((Object)invoice.get("voucherEntry"));
            if (voucherEntry != null && voucherEntry.size() > 0) {
                for (int j = 0; j < voucherEntry.size(); ++j) {
                    voucherIds.add(voucherEntry.get(j).getVoucherId());
                }
            }
            result.put((String)invoice.get(this.getInvoiceUniqueCodeFieldName()), voucherIds);
        }
        return result;
    }
}

