/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.thread;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.evsservice.ScaffoldFacadeFactory;
import com.kingdee.eas.base.evs.app.page.ExecuteRecordInfo;
import com.kingdee.eas.base.evs.app.page.ExecuteResult;
import com.kingdee.eas.base.evs.app.page.ExecuteState;
import com.kingdee.eas.base.evs.listener.EvsServiceGeneratorDataListener;
import com.kingdee.eas.base.evs.listener.ListenerManager;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExecuteSchemeThread
implements Runnable {
    private static Logger logger = Logger.getLogger(ExecuteSchemeThread.class);
    private Context ctx;
    private ExecuteRecordInfo executeRecordInfo;

    public ExecuteSchemeThread(Context ctx, ExecuteRecordInfo executeRecordInfo) {
        this.ctx = ctx;
        this.executeRecordInfo = executeRecordInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String uniqueCode = this.executeRecordInfo.getId().toString() + System.currentTimeMillis();
        ListenerManager.getInstance().registerListener(uniqueCode, new EvsServiceGeneratorDataListener());
        try {
            this.ctx.put((Object)"easBizUniqueCode4Evs", (Object)uniqueCode);
            ScaffoldFacadeFactory.getLocalInstance(this.ctx).engineScaffold(this.executeRecordInfo.getOrg(), this.executeRecordInfo.getPeriod() / 100, this.executeRecordInfo.getPeriod() % 100);
        }
        catch (Exception e) {
            String msg = "\u6267\u884c\u5931\u8d25-- period \uff1a " + this.executeRecordInfo.getPeriod() + "  company: " + this.executeRecordInfo.getOrg().getNumber() + "schemeInstId: " + this.executeRecordInfo.getSchemeInstId();
            logger.error((Object)(msg + e.getMessage()), (Throwable)e);
            ListenerManager.getInstance().publishError(this.ctx, uniqueCode, msg);
        }
        finally {
            this.updateExecuteResult(this.ctx, uniqueCode);
        }
    }

    private void updateExecuteResult(Context ctx, String uniqueCode) {
        ListenerManager instance = ListenerManager.getInstance();
        Map listenerResult = instance.getListenerResult(ctx, uniqueCode);
        ExecuteResult result = null;
        String summary = "";
        try {
            if ("true".equals(listenerResult.get("success"))) {
                result = ExecuteResult.SUCCESS;
            } else {
                result = ExecuteResult.ERROR;
                summary = (String)listenerResult.get("errMsg");
            }
            String sql = "update t_evs_ExecuteRecord set  FState = ? , FEnd = ? , FResult = ? , FSummary = ? where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{ExecuteState.END.getValue(), new Timestamp(System.currentTimeMillis()), result.getValue(), summary, this.executeRecordInfo.getId().toString()});
        }
        catch (Exception e) {
            logger.error((Object)("\u66f4\u65b0\u72b6\u6001\u5931\u8d25 id \uff1a" + this.executeRecordInfo.getId().toString()));
        }
        instance.removeListener(uniqueCode);
    }
}

