/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.unitdata.be.handler;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.evs.unitdata.be.BEDocUnit;
import com.kingdee.eas.base.evs.unitdata.be.BkerDocUnit;
import com.kingdee.eas.base.evs.unitdata.billData.IBEInfoHandler;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.BeUtils;
import com.kingdee.eas.base.evs.util.DateFormatUtil;
import com.kingdee.eas.common.EASBizException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class EReceiptInvoiceInfoHandler
implements IBEInfoHandler {
    private static Logger logger = Logger.getLogger(EReceiptInvoiceInfoHandler.class);

    @Override
    public Map<String, BEDocUnit> getDocsByBillIds(Context ctx, List<String> ids) throws EASBizException {
        HashMap<String, BEDocUnit> maps = new HashMap<String, BEDocUnit>();
        Map<String, IObjectValue> eReceipt = BeUtils.getEReceipt(ctx, ids);
        for (Map.Entry<String, IObjectValue> entry : eReceipt.entrySet()) {
            String id = entry.getKey();
            IObjectValue objValue = entry.getValue();
            BkerDocUnit doc = new BkerDocUnit();
            doc.put("BillPK", id);
            String validCode = AS.valueOf(objValue.get("validCode"), "");
            if (StringUtils.isEmpty((CharSequence)validCode)) continue;
            doc.put("IdentifyingCode", validCode);
            doc.put("TransactionAmountInFigures", AS.valueOf(objValue.get("amount"), ""));
            doc.put("IssueDate", AS.valueOf(DateFormatUtil.format((Date)objValue.get("transDate"), "yyyy-MM-dd"), DateFormatUtil.format(new Date(), "yyyy-MM-dd")));
            doc.put("DateOfIssue", AS.valueOf(DateFormatUtil.format((Date)objValue.get("transDate"), "yyyy-MM-dd"), DateFormatUtil.format(new Date(), "yyyy-MM-dd")));
            doc.put("Currency", AS.valueOf(objValue.get("currency"), "") == null ? "" : AS.valueOf(((IObjectValue)objValue.get("currency")).get("isocode"), ""));
            doc.put("ContractNumber", objValue.get("billNumber"));
            doc.put("AmountPayableAndReceivable", objValue.get("amount"));
            doc.put("TransactionAmountInFigures", objValue.get("amount"));
            doc.put("BillNumber", objValue.get("number"));
            doc.put("TypeOfInvoice", objValue.get("busiType"));
            maps.put(id, doc);
        }
        return maps;
    }
}

