/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.unitdata.billData.handler;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.unitdata.InvoiceDocFactory;
import com.kingdee.eas.base.evs.unitdata.billData.BizDocUint;
import com.kingdee.eas.base.evs.unitdata.billData.InvoiceDoc;
import com.kingdee.eas.base.evs.unitdata.billData.InvoiceDocHandler;
import com.kingdee.eas.base.evs.unitdata.billData.InvoiceInfoHandler;
import com.kingdee.eas.base.evs.unitdata.billData.InvoiceTypeAdapter;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApOtherInvoiceInfoHandler
implements InvoiceInfoHandler,
InvoiceTypeAdapter {
    @Override
    public Map<String, BizDocUint> getDocsByBillIds(Context ctx, List<String> ids) throws EASBizException {
        Map<String, List<InvoiceDoc>> invoiceDocsByBillId = this.getInvoiceDocsByBillIds(ctx, ids);
        StringBuilder builder = new StringBuilder();
        builder.append(" select FId,FNumber,FInvoiceCode,FInvoiceNumber,FInvoiceType");
        builder.append(" from T_AP_OtherBill ");
        builder.append(" where Fid in (");
        builder.append(SQLUtils.getSQL(ids));
        builder.append(")");
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString());
            HashMap<String, BizDocUint> docMap = new HashMap<String, BizDocUint>();
            while (iRowSet.next()) {
                String FId = iRowSet.getString("FId");
                String FNumber = iRowSet.getString("FNumber");
                if (!invoiceDocsByBillId.containsKey(FId)) continue;
                BizDocUint bizDocUint = new BizDocUint();
                List<InvoiceDoc> invoiceDocs = invoiceDocsByBillId.get(FId);
                bizDocUint.put("Invoices", invoiceDocs);
                bizDocUint.put("BillPK", FId);
                bizDocUint.put("BillNumber", FNumber);
                bizDocUint.put("WhetherInputVatHasBeenTransferredOut", "false");
                bizDocUint.put("AmountOfTransferredOutInputVat", "0.00");
                bizDocUint.put("ContractNumber", FNumber);
                bizDocUint.put("MatchingStateBetweenBusinessDocumentsAndVatEInvoice", "");
                bizDocUint.put("DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets", "");
                bizDocUint.put("WhetherInvoiceHasBeenFactoredSoldOrSecuritized", "true");
                bizDocUint.put("WhetherInvoiceIsRedInvoice", "false");
                bizDocUint.put("WhetherInvoiceHasBeenChecked", "true");
                bizDocUint.put("WhetherInvoiceUsageHasBeenConfirmed", "false");
                bizDocUint.put("UsageConfirmation", "");
                bizDocUint.put("PeriodOfUsageConfirmation", "");
                bizDocUint.put("WhetherInvoiceHasBeenBooked", "true");
                bizDocUint.put("WhetherInvoiceHasBeenPaid", "true");
                bizDocUint.put("NumberOfBankElectronicReceipt", "");
                docMap.put(FId, bizDocUint);
            }
            return docMap;
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u5e94\u4ed8\u5355\u53d6\u53d1\u7968\u903b\u8f91\u5f02\u5e38"), (Throwable)e);
        }
    }

    public Map<String, List<InvoiceDoc>> getInvoiceDocsByBillIds(Context ctx, List<String> ids) throws EASBizException {
        List<InvoiceDocHandler> service = InvoiceDocFactory.getService(ctx, "48DA3A71");
        HashMap<String, List<InvoiceDoc>> result = new HashMap<String, List<InvoiceDoc>>();
        for (InvoiceDocHandler handler : service) {
            Map<String, List<InvoiceDoc>> invoiceDocs = handler.getInvoiceDocsByBillIds(ctx, ids);
            result.putAll(invoiceDocs);
        }
        return result;
    }

    @Override
    public String getFPInvoiceType(Context ctx, String easInvoiceType) {
        if ("1".equals(easInvoiceType)) {
            return "2";
        }
        if ("2".equals(easInvoiceType)) {
            return "2";
        }
        if ("3".equals(easInvoiceType)) {
            return "0";
        }
        if ("4".equals(easInvoiceType)) {
            return "1";
        }
        if ("5".equals(easInvoiceType)) {
            return "0";
        }
        return "-1";
    }
}

