/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.unitdata.pcloud.other;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.unitdata.billData.InvoiceDoc;
import com.kingdee.eas.base.evs.unitdata.pcloud.AtrInvoice;
import com.kingdee.eas.base.evs.unitdata.pcloud.EfiInvoice;
import com.kingdee.eas.base.evs.unitdata.pcloud.EinvOrdInvoice;
import com.kingdee.eas.base.evs.unitdata.pcloud.EinvSpclInvoice;
import com.kingdee.eas.base.evs.unitdata.pcloud.Invoice;
import com.kingdee.eas.base.evs.unitdata.pcloud.NtrevGpmInvoice;
import com.kingdee.eas.base.evs.unitdata.pcloud.OrdInvoice;
import com.kingdee.eas.base.evs.unitdata.pcloud.RaiInvoice;
import com.kingdee.eas.base.evs.unitdata.pcloud.SpcInvoice;
import com.kingdee.eas.base.evs.unitdata.pcloud.TlfInvoice;
import com.kingdee.eas.base.evs.unitdata.pcloud.fpy.FpyTicketAttrs;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.CheckUtil;
import com.kingdee.eas.base.evs.util.EVSSet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class InvoiceFactory {
    public static Invoice getUnit(Context ctx, InvoiceDoc doc, JSONObject json) throws EASBizException {
        String type = json.get((Object)FpyTicketAttrs.FPY_INVOICETYPE).toString();
        Invoice unit = InvoiceFactory.getUnit(ctx, type, json);
        InvoiceFactory.putGenericProp(ctx, doc, unit, json);
        return unit;
    }

    private static void putGenericProp(Context ctx, InvoiceDoc doc, Invoice unit, JSONObject json) {
        unit.put("IssuerXbrlurl", AS.valueOf(json.get((Object)"xbrlUrl")));
        unit.put("Pdfurl", AS.valueOf(json.get((Object)"pdfurl")));
        unit.put("Originalurl", AS.valueOf(json.get((Object)"ofdUrl")));
        unit.put("Snapshoturl", AS.valueOf(json.get((Object)"snapshotUrl")));
        String UniqueCodeOfInvoice = "UniqueCodeOfInvoice";
        String InvoiceCode = "InvoiceCode";
        String InvoiceNO = "InvoiceNO";
        String SerialNO = "SerialNO";
        String serial_No = AS.valueOf(json.get((Object)"serialNo"));
        String code_no = AS.valueOf(json.get((Object)"invoiceCode")) + AS.valueOf(json.get((Object)"invoiceNo"));
        String uniqueCode = StringUtils.isEmpty((CharSequence)code_no) ? serial_No : code_no;
        unit.put(UniqueCodeOfInvoice, uniqueCode);
        unit.put("UniquePK", doc.getBillPk() + uniqueCode);
        unit.put(InvoiceCode, AS.valueOf(json.get((Object)"invoiceCode")));
        unit.put(InvoiceNO, AS.valueOf(json.get((Object)"invoiceNo")));
        unit.put(SerialNO, AS.valueOf(json.get((Object)"serialNo")));
        unit.put("Bills", doc.getBillPk());
    }

    private static Invoice getUnit(Context ctx, String type, JSONObject json) throws EASBizException {
        if ("inv_ord".equals(type)) {
            return InvoiceFactory.getOrdInvoice(ctx, json);
        }
        if ("inv_spcl".equals(type)) {
            return InvoiceFactory.getSpcInvoice(ctx, json);
        }
        if ("rai".equals(type)) {
            return InvoiceFactory.getRaiInvoice(ctx, json);
        }
        if ("inv_tlf".equals(type)) {
            return InvoiceFactory.getTlfInvoice(ctx, json);
        }
        if ("atr".equals(type)) {
            return InvoiceFactory.getAtrInvoice(ctx, json);
        }
        if ("ntrev_gpm".equals(type)) {
            return InvoiceFactory.getGpmInvoice(ctx, json);
        }
        if ("efi".equals(type)) {
            return InvoiceFactory.getEfiInvoice(ctx, json);
        }
        if ("einv_ord".equals(type)) {
            return InvoiceFactory.getEinvOrdInvoice(ctx, json);
        }
        if ("einv_spcl".equals(type)) {
            return InvoiceFactory.getEinvSpclInvoice(ctx, json);
        }
        throw new EASBizException(new NumericExceptionSubItem("00", "\u6682\u4e0d\u652f\u6301\u7684\u7968\u79cd\u7c7b\u578b"));
    }

    private static Invoice getGpmInvoice(Context ctx, JSONObject json) throws EASBizException {
        NtrevGpmInvoice invoice = new NtrevGpmInvoice();
        String EINVOICE_ID = "EINVOICE_ID";
        String WhetherInvoiceHasBeenBooked = "WhetherInvoiceHasBeenBooked";
        String WhetherInvoiceHasBeenArchived = "WhetherInvoiceHasBeenArchived";
        String BILL_DATE = "BILL_DATE";
        String PAID_AMT = "PAID_AMT";
        String UniqueCodeOfInvoice = "UniqueCodeOfInvoice";
        String InvoiceCode = "InvoiceCode";
        String InvoiceNO = "InvoiceNO";
        String SerialNO = "SerialNO";
        String NameOfAccountingEntity = "NameOfAccountingEntity";
        String UnifiedSocialCreditCodeOfAccountingEntity = "UnifiedSocialCreditCodeOfAccountingEntity";
        String WhetherInvoiceIsRedInvoice = "WhetherInvoiceIsRedInvoice";
        String WhetherInvoiceHasBeenChecked = "WhetherInvoiceHasBeenChecked";
        invoice.put(UniqueCodeOfInvoice, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"serialNo"))) ? AS.valueOf(json.get((Object)"invoiceCode")) + AS.valueOf(json.get((Object)"invoiceNo")) : AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(InvoiceCode, AS.valueOf(json.get((Object)"invoiceCode")));
        invoice.put(InvoiceNO, AS.valueOf(json.get((Object)"invoiceNo")));
        invoice.put(SerialNO, AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(EINVOICE_ID, new StringBuilder().append(AS.valueOf(json.get((Object)"invoiceCode"))).append("-").append(AS.valueOf(json.get((Object)"invoiceNo"))).reverse().toString());
        invoice.put(BILL_DATE, AS.valueOf(json.get((Object)"invoiceDate"), ""));
        invoice.put(PAID_AMT, AS.valueOf(json.get((Object)"totalAmount"), ""));
        invoice.put(WhetherInvoiceIsRedInvoice, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"relatedInvoiceCode"), "")) ? "false" : AS.valueOf(json.get((Object)"relatedInvoiceCode"), ""));
        invoice.put(WhetherInvoiceHasBeenChecked, "1".equals(AS.valueOf(json.get((Object)"checkStatus"), "")) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenBooked, "true");
        invoice.put(WhetherInvoiceHasBeenArchived, "true");
        invoice.put(NameOfAccountingEntity, AS.valueOf(json.get((Object)"invoicingPartyName"), ""));
        invoice.put(UnifiedSocialCreditCodeOfAccountingEntity, AS.valueOf(json.get((Object)"invoicingPartyCode"), ""));
        return invoice;
    }

    private static Invoice getEfiInvoice(Context ctx, JSONObject json) throws EASBizException {
        EfiInvoice invoice = new EfiInvoice();
        String EInvoiceID = "EInvoiceID";
        String InvoicingPartyName = "InvoicingPartyName";
        String InvoicingPartyCode = "InvoicingPartyCode";
        String IssueDate = "IssueDate";
        String TotalAmount = "TotalAmount";
        String WhetherInvoiceHasBeenBooked = "WhetherInvoiceHasBeenBooked";
        String UniqueCodeOfInvoice = "UniqueCodeOfInvoice";
        String InvoiceCode = "InvoiceCode";
        String InvoiceNO = "InvoiceNO";
        String SerialNO = "SerialNO";
        String NameOfAccountingEntity = "NameOfAccountingEntity";
        String UnifiedSocialCreditCodeOfAccountingEntity = "UnifiedSocialCreditCodeOfAccountingEntity";
        String WhetherInvoiceIsRedInvoice = "WhetherInvoiceIsRedInvoice";
        String WhetherInvoiceHasBeenChecked = "WhetherInvoiceHasBeenChecked";
        invoice.put(UniqueCodeOfInvoice, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"serialNo"))) ? AS.valueOf(json.get((Object)"invoiceCode")) + AS.valueOf(json.get((Object)"invoiceNo")) : AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(InvoiceCode, AS.valueOf(json.get((Object)"invoiceCode")));
        invoice.put(InvoiceNO, AS.valueOf(json.get((Object)"invoiceNo")));
        invoice.put(SerialNO, AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(EInvoiceID, new StringBuilder().append(AS.valueOf(json.get((Object)"invoiceCode"))).append("-").append(AS.valueOf(json.get((Object)"invoiceNo"))).reverse().toString());
        invoice.put(WhetherInvoiceIsRedInvoice, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"relatedInvoiceCode"), "")) ? "false" : AS.valueOf(json.get((Object)"relatedInvoiceCode"), ""));
        invoice.put(WhetherInvoiceHasBeenChecked, "1".equals(AS.valueOf(json.get((Object)"checkStatus"), "")) ? "true" : "false");
        invoice.put(InvoicingPartyName, AS.valueOf(json.get((Object)"invoicingPartyName")));
        invoice.put(InvoicingPartyCode, AS.valueOf(json.get((Object)"invoicingPartyCode")));
        invoice.put(IssueDate, AS.valueOf(json.get((Object)"invoiceDate")));
        invoice.put(TotalAmount, AS.valueOf(json.get((Object)"totalAmount")));
        invoice.put(WhetherInvoiceHasBeenBooked, "true");
        invoice.put(NameOfAccountingEntity, AS.valueOf(json.get((Object)"invoicingPartyName"), ""));
        invoice.put(UnifiedSocialCreditCodeOfAccountingEntity, AS.valueOf(json.get((Object)"invoicingPartyCode"), ""));
        return invoice;
    }

    private static Invoice getEinvSpclInvoice(Context ctx, JSONObject json) throws EASBizException {
        EinvSpclInvoice invoice = new EinvSpclInvoice();
        String WhetherInvoiceHasBeenBooked = "WhetherInvoiceHasBeenBooked";
        String NameOfAccountingEntity = "NameOfAccountingEntity";
        String UnifiedSocialCreditCodeOfAccountingEntity = "UnifiedSocialCreditCodeOfAccountingEntity";
        String WhetherInvoiceIsRedInvoice = "WhetherInvoiceIsRedInvoice";
        String WhetherInvoiceHasBeenChecked = "WhetherInvoiceHasBeenChecked";
        String InformationOfAccountingDocumentsTuple2 = "InformationOfAccountingDocumentsTuple";
        String UniqueCodeOfInvoice = "UniqueCodeOfInvoice";
        String WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted = "WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted";
        String BeginningOfPreTaxDeductionYearOfIncomeTax = "BeginningOfPreTaxDeductionYearOfIncomeTax";
        String EndOfPreTaxDeductionYearOfIncomeTax = "EndOfPreTaxDeductionYearOfIncomeTax";
        String BeginningOfExpenditurePeriodUnderAccrualBasis = "BeginningOfExpenditurePeriodUnderAccrualBasis";
        String EndOfExpenditurePeriodUnderAccrualBasis = "EndOfExpenditurePeriodUnderAccrualBasis";
        String ContractNumber = "ContractNumber";
        String WhetherInvoiceHasBeenPaid = "WhetherInvoiceHasBeenPaid";
        String NumberOfBankElectronicReceipt = "NumberOfBankElectronicReceipt";
        String MatchingStateBetweenBusinessDocumentsAndVatEInvoice = "MatchingStateBetweenBusinessDocumentsAndVatEInvoice";
        String DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets = "DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets";
        String SellerName = "SellerName";
        String SellerIdNum = "SellerIdNum";
        String TotalAmWithoutTax = "TotalAmWithoutTax";
        String TotalTaxAmount = "TotalTaxAmount";
        String TaxIncludedAmountInFigures = "TaxIncludedAmountInFigures";
        String DateOfIssue = "DateOfIssue";
        String InvoiceCode = "InvoiceCode";
        String InvoiceNO = "InvoiceNO";
        String SerialNO = "SerialNO";
        invoice.put(UniqueCodeOfInvoice, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"serialNo"))) ? AS.valueOf(json.get((Object)"invoiceCode")) + AS.valueOf(json.get((Object)"invoiceNo")) : AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(InvoiceCode, AS.valueOf(json.get((Object)"invoiceCode")));
        invoice.put(InvoiceNO, AS.valueOf(json.get((Object)"invoiceNo")));
        invoice.put(SerialNO, AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted, "");
        invoice.put(MatchingStateBetweenBusinessDocumentsAndVatEInvoice, "");
        invoice.put(ContractNumber, "");
        invoice.put(WhetherInvoiceIsRedInvoice, "3".equalsIgnoreCase(AS.valueOf(json.get((Object)"invoiceStatus"))) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenChecked, "1".equals(AS.valueOf(json.get((Object)"checkStatus"), "")) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenBooked, "true");
        invoice.put(NameOfAccountingEntity, AS.valueOf(json.get((Object)"buyerName"), ""));
        invoice.put(UnifiedSocialCreditCodeOfAccountingEntity, AS.valueOf(json.get((Object)"buyerTaxNo"), ""));
        invoice.put(BeginningOfPreTaxDeductionYearOfIncomeTax, "");
        invoice.put(EndOfPreTaxDeductionYearOfIncomeTax, "");
        invoice.put(BeginningOfExpenditurePeriodUnderAccrualBasis, "");
        invoice.put(EndOfExpenditurePeriodUnderAccrualBasis, "");
        invoice.put(WhetherInvoiceHasBeenPaid, "true");
        invoice.put(DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets, "");
        invoice.put(SellerName, AS.valueOf(json.get((Object)"salerName"), ""));
        invoice.put(SellerIdNum, AS.valueOf(json.get((Object)"salerTaxNo"), ""));
        invoice.put(TotalAmWithoutTax, AS.valueOf(json.get((Object)"invoiceAmount"), ""));
        invoice.put(TotalTaxAmount, AS.valueOf(json.get((Object)"totalTaxAmount"), ""));
        invoice.put(TaxIncludedAmountInFigures, AS.valueOf(json.get((Object)"totalAmount"), ""));
        invoice.put(DateOfIssue, AS.valueOf(json.get((Object)"invoiceDate"), ""));
        return invoice;
    }

    private static Invoice getEinvOrdInvoice(Context ctx, JSONObject json) throws EASBizException {
        EinvOrdInvoice invoice = new EinvOrdInvoice();
        String WhetherInvoiceHasBeenBooked = "WhetherInvoiceHasBeenBooked";
        String NameOfAccountingEntity = "NameOfAccountingEntity";
        String UnifiedSocialCreditCodeOfAccountingEntity = "UnifiedSocialCreditCodeOfAccountingEntity";
        String WhetherInvoiceIsRedInvoice = "WhetherInvoiceIsRedInvoice";
        String WhetherInvoiceHasBeenChecked = "WhetherInvoiceHasBeenChecked";
        String InformationOfAccountingDocumentsTuple2 = "InformationOfAccountingDocumentsTuple";
        String UniqueCodeOfInvoice = "UniqueCodeOfInvoice";
        String WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted = "WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted";
        String BeginningOfPreTaxDeductionYearOfIncomeTax = "BeginningOfPreTaxDeductionYearOfIncomeTax";
        String EndOfPreTaxDeductionYearOfIncomeTax = "EndOfPreTaxDeductionYearOfIncomeTax";
        String BeginningOfExpenditurePeriodUnderAccrualBasis = "BeginningOfExpenditurePeriodUnderAccrualBasis";
        String EndOfExpenditurePeriodUnderAccrualBasis = "EndOfExpenditurePeriodUnderAccrualBasis";
        String ContractNumber = "ContractNumber";
        String WhetherInvoiceHasBeenPaid = "WhetherInvoiceHasBeenPaid";
        String NumberOfBankElectronicReceipt = "NumberOfBankElectronicReceipt";
        String MatchingStateBetweenBusinessDocumentsAndVatEInvoice = "MatchingStateBetweenBusinessDocumentsAndVatEInvoice";
        String DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets = "DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets";
        String SellerName = "SellerName";
        String SellerIdNum = "SellerIdNum";
        String TotalAmWithoutTax = "TotalAmWithoutTax";
        String TotalTaxAmount = "TotalTaxAmount";
        String TaxIncludedAmountInFigures = "TaxIncludedAmountInFigures";
        String DateOfIssue = "DateOfIssue";
        String InvoiceCode = "InvoiceCode";
        String InvoiceNO = "InvoiceNO";
        String SerialNO = "SerialNO";
        invoice.put(UniqueCodeOfInvoice, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"serialNo"))) ? AS.valueOf(json.get((Object)"invoiceCode")) + AS.valueOf(json.get((Object)"invoiceNo")) : AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(InvoiceCode, AS.valueOf(json.get((Object)"invoiceCode")));
        invoice.put(InvoiceNO, AS.valueOf(json.get((Object)"invoiceNo")));
        invoice.put(SerialNO, AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted, "");
        invoice.put(MatchingStateBetweenBusinessDocumentsAndVatEInvoice, "");
        invoice.put(ContractNumber, "");
        invoice.put(WhetherInvoiceIsRedInvoice, "3".equalsIgnoreCase(AS.valueOf(json.get((Object)"invoiceStatus"))) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenChecked, "1".equals(AS.valueOf(json.get((Object)"checkStatus"), "")) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenBooked, "true");
        invoice.put(NameOfAccountingEntity, AS.valueOf(json.get((Object)"buyerName"), ""));
        invoice.put(UnifiedSocialCreditCodeOfAccountingEntity, AS.valueOf(json.get((Object)"buyerTaxNo"), ""));
        invoice.put(BeginningOfPreTaxDeductionYearOfIncomeTax, "");
        invoice.put(EndOfPreTaxDeductionYearOfIncomeTax, "");
        invoice.put(BeginningOfExpenditurePeriodUnderAccrualBasis, "");
        invoice.put(EndOfExpenditurePeriodUnderAccrualBasis, "");
        invoice.put(WhetherInvoiceHasBeenPaid, "true");
        invoice.put(DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets, "");
        invoice.put(SellerName, AS.valueOf(json.get((Object)"salerName"), ""));
        invoice.put(SellerIdNum, AS.valueOf(json.get((Object)"salerTaxNo"), ""));
        invoice.put(TotalAmWithoutTax, AS.valueOf(json.get((Object)"invoiceAmount"), ""));
        invoice.put(TotalTaxAmount, AS.valueOf(json.get((Object)"totalTaxAmount"), ""));
        invoice.put(TaxIncludedAmountInFigures, AS.valueOf(json.get((Object)"totalAmount"), ""));
        invoice.put(DateOfIssue, AS.valueOf(json.get((Object)"invoiceDate"), ""));
        return invoice;
    }

    private static Invoice getNtrevInvoice(Context ctx, JSONObject json) {
        NtrevGpmInvoice invoice = new NtrevGpmInvoice();
        String EINVOICE_ID = "EINVOICE_ID";
        String WhetherInvoiceHasBeenBooked = "WhetherInvoiceHasBeenBooked";
        String WhetherInvoiceHasBeenArchived = "WhetherInvoiceHasBeenArchived";
        String BILL_DATE = "BILL_DATE";
        String PAID_AMT = "PAID_AMT";
        String UniqueCodeOfInvoice = "UniqueCodeOfInvoice";
        String InvoiceCode = "InvoiceCode";
        String InvoiceNO = "InvoiceNO";
        String SerialNO = "SerialNO";
        String NameOfAccountingEntity = "NameOfAccountingEntity";
        String UnifiedSocialCreditCodeOfAccountingEntity = "UnifiedSocialCreditCodeOfAccountingEntity";
        String WhetherInvoiceIsRedInvoice = "WhetherInvoiceIsRedInvoice";
        String WhetherInvoiceHasBeenChecked = "WhetherInvoiceHasBeenChecked";
        invoice.put(UniqueCodeOfInvoice, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"serialNo"))) ? AS.valueOf(json.get((Object)"invoiceCode")) + AS.valueOf(json.get((Object)"invoiceNo")) : AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(InvoiceCode, AS.valueOf(json.get((Object)"invoiceCode")));
        invoice.put(InvoiceNO, AS.valueOf(json.get((Object)"invoiceNo")));
        invoice.put(SerialNO, AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(EINVOICE_ID, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"serialNo"))) ? AS.valueOf(json.get((Object)"invoiceCode")) + AS.valueOf(json.get((Object)"invoiceNo")) : AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(BILL_DATE, AS.valueOf(json.get((Object)"invoiceDate"), ""));
        invoice.put(PAID_AMT, AS.valueOf(json.get((Object)"totalAmount"), ""));
        invoice.put(WhetherInvoiceIsRedInvoice, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"relatedInvoiceCode"), "")) ? "false" : AS.valueOf(json.get((Object)"relatedInvoiceCode"), ""));
        invoice.put(WhetherInvoiceHasBeenChecked, "1".equals(AS.valueOf(json.get((Object)"checkStatus"), "")) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenBooked, "true");
        invoice.put(WhetherInvoiceHasBeenArchived, "true");
        invoice.put(NameOfAccountingEntity, AS.valueOf(json.get((Object)"invoicingPartyName"), ""));
        invoice.put(UnifiedSocialCreditCodeOfAccountingEntity, AS.valueOf(json.get((Object)"invoicingPartyCode"), ""));
        return invoice;
    }

    private static Invoice getAtrInvoice(Context ctx, JSONObject json) throws EASBizException {
        AtrInvoice invoice = new AtrInvoice();
        String WhetherInvoiceHasBeenBooked = "WhetherInvoiceHasBeenBooked";
        String NameOfAccountingEntity = "NameOfAccountingEntity";
        String UnifiedSocialCreditCodeOfAccountingEntity = "UnifiedSocialCreditCodeOfAccountingEntity";
        String WhetherInvoiceIsRedInvoice = "WhetherInvoiceIsRedInvoice";
        String WhetherInvoiceHasBeenChecked = "WhetherInvoiceHasBeenChecked";
        String ElectronicInvoiceAirTransportReceiptNumber = "ElectronicInvoiceAirTransportReceiptNumber";
        String WhetherInvoiceHasBeenDeducted = "WhetherInvoiceHasBeenDeducted";
        String TaxPeriodOfInvoiceDeduction = "TaxPeriodOfInvoiceDeduction";
        String UniqueCodeOfInvoice = "UniqueCodeOfInvoice";
        String InvoiceCode = "InvoiceCode";
        String InvoiceNO = "InvoiceNO";
        String SerialNO = "SerialNO";
        String Fare = "Fare";
        String IssueParty = "IssueParty";
        String IssueDate = "IssueDate";
        invoice.put(UniqueCodeOfInvoice, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"serialNo"))) ? AS.valueOf(json.get((Object)"invoiceCode")) + AS.valueOf(json.get((Object)"invoiceNo")) : AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(InvoiceCode, AS.valueOf(json.get((Object)"invoiceCode")));
        invoice.put(InvoiceNO, AS.valueOf(json.get((Object)"invoiceNo")));
        invoice.put(SerialNO, AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(ElectronicInvoiceAirTransportReceiptNumber, AS.valueOf(json.get((Object)"invoiceNo"), ""));
        invoice.put(WhetherInvoiceIsRedInvoice, "3".equals(json.get((Object)"invoiceStatus")) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenChecked, "1".equals(AS.valueOf(json.get((Object)"checkStatus"), "")) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenBooked, "true");
        invoice.put(WhetherInvoiceHasBeenDeducted, "false");
        invoice.put(TaxPeriodOfInvoiceDeduction, "");
        invoice.put(NameOfAccountingEntity, AS.valueOf(json.get((Object)"buyerName"), ""));
        invoice.put(UnifiedSocialCreditCodeOfAccountingEntity, AS.valueOf(json.get((Object)"unifiedSocialCreditCodeOfPurchaser"), ""));
        invoice.put(Fare, AS.valueOf(json.get((Object)"invoiceAmount"), ""));
        invoice.put(IssueParty, AS.valueOf(json.get((Object)"fillingUnit"), ""));
        invoice.put(IssueDate, AS.valueOf(json.get((Object)"issueDate"), ""));
        return invoice;
    }

    private static Invoice getTlfInvoice(Context ctx, JSONObject json) throws EASBizException {
        TlfInvoice invoice = new TlfInvoice();
        String UniqueCodeOfInvoice = "UniqueCodeOfInvoice";
        String InvoiceCode = "InvoiceCode";
        String InvoiceNO = "InvoiceNO";
        String SerialNO = "SerialNO";
        String WhetherInvoiceIsRedInvoice = "WhetherInvoiceIsRedInvoice";
        String WhetherInvoiceHasBeenChecked = "WhetherInvoiceHasBeenChecked";
        String WhetherInvoiceHasBeenBooked = "WhetherInvoiceHasBeenBooked";
        String UnifiedSocialCreditCodeOfAccountingEntity = "UnifiedSocialCreditCodeOfAccountingEntity";
        String NameOfAccountingEntity = "NameOfAccountingEntity";
        String InformationOfAccountingDocumentsTuple2 = "InformationOfAccountingDocumentsTuple";
        String WhetherInputVatHasBeenTransferredOut = "WhetherInputVatHasBeenTransferredOut";
        String AmountOfTransferredOutInputVat = "AmountOfTransferredOutInputVat";
        String WhetherInvoiceUsageHasBeenConfirmed = "WhetherInvoiceUsageHasBeenConfirmed";
        String WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted = "WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted";
        String BeginningOfPreTaxDeductionYearOfIncomeTax = "BeginningOfPreTaxDeductionYearOfIncomeTax";
        String EndOfPreTaxDeductionYearOfIncomeTax = "EndOfPreTaxDeductionYearOfIncomeTax";
        String BeginningOfExpenditurePeriodUnderAccrualBasis = "BeginningOfExpenditurePeriodUnderAccrualBasis";
        String EndOfExpenditurePeriodUnderAccrualBasis = "EndOfExpenditurePeriodUnderAccrualBasis";
        String NameOfSeller = "NameOfSeller";
        String TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller = "TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller";
        String TotalAmountExcludingTax = "TotalAmountExcludingTax";
        String TotalTaxAmount = "TotalTaxAmount";
        String TaxIncludedAmountInFigures = "TaxIncludedAmountInFigures";
        String DateOfIssue = "DateOfIssue";
        String WhetherInvoiceHasBeenFactoredSoldOrSecuritized = "WhetherInvoiceHasBeenFactoredSoldOrSecuritized";
        String UsageConfirmation = "UsageConfirmation";
        String InputVatTransferredOutInformationAbstract = "InputVatTransferredOutInformationAbstract";
        invoice.put(InvoiceCode, AS.valueOf(json.get((Object)"invoiceCode")));
        invoice.put(InvoiceNO, AS.valueOf(json.get((Object)"invoiceNo")));
        invoice.put(SerialNO, AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted, "");
        invoice.put(WhetherInvoiceUsageHasBeenConfirmed, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"deductionPurpose"), "")) ? "false" : "true");
        invoice.put(WhetherInvoiceIsRedInvoice, "3".equals(AS.valueOf(json.get((Object)"invoiceStatus"))) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenChecked, "1".equals(AS.valueOf(json.get((Object)"checkStatus"), "")) ? "true" : "false");
        invoice.put(WhetherInputVatHasBeenTransferredOut, "false");
        invoice.put(AmountOfTransferredOutInputVat, "0");
        invoice.put(WhetherInvoiceHasBeenBooked, "true");
        invoice.put(NameOfAccountingEntity, AS.valueOf(json.get((Object)"buyerName"), ""));
        invoice.put(UnifiedSocialCreditCodeOfAccountingEntity, AS.valueOf(json.get((Object)"buyerTaxNo"), ""));
        invoice.put(NameOfSeller, AS.valueOf(json.get((Object)"salerName"), ""));
        invoice.put(TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller, AS.valueOf(json.get((Object)"salerTaxNo"), ""));
        invoice.put(TotalAmountExcludingTax, AS.valueOf(json.get((Object)"invoiceAmount"), ""));
        invoice.put(TotalTaxAmount, AS.valueOf(json.get((Object)"totalTaxAmount"), ""));
        invoice.put(TaxIncludedAmountInFigures, AS.valueOf(json.get((Object)"totalAmount"), ""));
        invoice.put(DateOfIssue, AS.valueOf(json.get((Object)"invoiceDate"), ""));
        invoice.put(UsageConfirmation, AS.valueOf(json.get((Object)"deductionPurpose"), ""));
        return invoice;
    }

    private static Invoice getRaiInvoice(Context ctx, JSONObject json) throws EASBizException {
        RaiInvoice invoice = new RaiInvoice();
        String WhetherInvoiceHasBeenBooked = "WhetherInvoiceHasBeenBooked";
        String NameOfAccountingEntity = "NameOfAccountingEntity";
        String UnifiedSocialCreditCodeOfAccountingEntity = "UnifiedSocialCreditCodeOfAccountingEntity";
        String WhetherInvoiceIsRedInvoice = "WhetherInvoiceIsRedInvoice";
        String WhetherInvoiceHasBeenChecked = "WhetherInvoiceHasBeenChecked";
        String InformationOfAccountingDocumentsTuple2 = "InformationOfAccountingDocumentsTuple";
        String ElectronicInvoiceRailwayETicketNumber = "ElectronicInvoiceRailwayETicketNumber";
        String WhetherInvoiceHasBeenDeducted = "WhetherInvoiceHasBeenDeducted";
        String TaxPeriodOfInvoiceDeduction = "TaxPeriodOfInvoiceDeduction";
        String UniqueCodeOfInvoice = "UniqueCodeOfInvoice";
        String InvoiceCode = "InvoiceCode";
        String InvoiceNO = "InvoiceNO";
        String SerialNO = "SerialNO";
        String DateOfIssue = "DateOfIssue";
        String TotalAmountExcludingTax = "TotalAmountExcludingTax";
        String TaxRate = "TaxRate";
        String TaxAmount = "TaxAmount";
        invoice.put(UniqueCodeOfInvoice, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"serialNo"))) ? AS.valueOf(json.get((Object)"invoiceCode")) + AS.valueOf(json.get((Object)"invoiceNo")) : AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(InvoiceCode, AS.valueOf(json.get((Object)"invoiceCode")));
        invoice.put(InvoiceNO, AS.valueOf(json.get((Object)"invoiceNo")));
        invoice.put(SerialNO, AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(WhetherInvoiceHasBeenChecked, "1".equals(AS.valueOf(json.get((Object)"checkStatus"), "")) ? "true" : "false");
        invoice.put(ElectronicInvoiceRailwayETicketNumber, AS.valueOf(json.get((Object)"invoiceNo"), ""));
        invoice.put(WhetherInvoiceIsRedInvoice, "false");
        invoice.put(WhetherInvoiceHasBeenBooked, "true");
        invoice.put(WhetherInvoiceHasBeenDeducted, "false");
        invoice.put(TaxPeriodOfInvoiceDeduction, "");
        invoice.put(DateOfIssue, AS.valueOf(json.get((Object)"issueDate"), ""));
        invoice.put(TotalAmountExcludingTax, AS.valueOf(json.get((Object)"invoiceAmount"), ""));
        invoice.put(TaxRate, AS.valueOf(json.get((Object)"taxRate"), ""));
        invoice.put(TaxAmount, AS.valueOf(json.get((Object)"totalTaxAmount"), ""));
        invoice.put(NameOfAccountingEntity, AS.valueOf(json.get((Object)"buyerName"), ""));
        invoice.put(UnifiedSocialCreditCodeOfAccountingEntity, AS.valueOf(json.get((Object)"buyerTaxNo"), ""));
        return invoice;
    }

    private static Invoice getSpcInvoice(Context ctx, JSONObject json) throws EASBizException {
        SpcInvoice invoice = new SpcInvoice();
        String WhetherInvoiceHasBeenBooked = "WhetherInvoiceHasBeenBooked";
        String NameOfAccountingEntity = "NameOfAccountingEntity";
        String UnifiedSocialCreditCodeOfAccountingEntity = "UnifiedSocialCreditCodeOfAccountingEntity";
        String WhetherInvoiceIsRedInvoice = "WhetherInvoiceIsRedInvoice";
        String WhetherInvoiceHasBeenChecked = "WhetherInvoiceHasBeenChecked";
        String InformationOfAccountingDocumentsTuple2 = "InformationOfAccountingDocumentsTuple";
        String UniqueCodeOfInvoice = "UniqueCodeOfInvoice";
        String WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted = "WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted";
        String BeginningOfPreTaxDeductionYearOfIncomeTax = "BeginningOfPreTaxDeductionYearOfIncomeTax";
        String EndOfPreTaxDeductionYearOfIncomeTax = "EndOfPreTaxDeductionYearOfIncomeTax";
        String BeginningOfExpenditurePeriodUnderAccrualBasis = "BeginningOfExpenditurePeriodUnderAccrualBasis";
        String EndOfExpenditurePeriodUnderAccrualBasis = "EndOfExpenditurePeriodUnderAccrualBasis";
        String ContractNumber = "ContractNumber";
        String WhetherInvoiceHasBeenPaid = "WhetherInvoiceHasBeenPaid";
        String NumberOfBankElectronicReceipt = "NumberOfBankElectronicReceipt";
        String MatchingStateBetweenBusinessDocumentsAndVatEInvoice = "MatchingStateBetweenBusinessDocumentsAndVatEInvoice";
        String DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets = "DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets";
        String NameOfSeller = "NameOfSeller";
        String TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller = "TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller";
        String TotalAmountExcludingTax = "TotalAmountExcludingTax";
        String TotalTaxAmount = "TotalTaxAmount";
        String TaxIncludedAmountInFigures = "TaxIncludedAmountInFigures";
        String DateOfIssue = "DateOfIssue";
        String WhetherInvoiceHasBeenFactoredSoldOrSecuritized = "WhetherInvoiceHasBeenFactoredSoldOrSecuritized";
        String InvoiceCode = "InvoiceCode";
        String InvoiceNO = "InvoiceNO";
        String SerialNO = "SerialNO";
        invoice.put(UniqueCodeOfInvoice, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"serialNo"))) ? AS.valueOf(json.get((Object)"invoiceCode")) + AS.valueOf(json.get((Object)"invoiceNo")) : AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(InvoiceCode, AS.valueOf(json.get((Object)"invoiceCode")));
        invoice.put(InvoiceNO, AS.valueOf(json.get((Object)"invoiceNo")));
        invoice.put(SerialNO, AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted, "");
        invoice.put(MatchingStateBetweenBusinessDocumentsAndVatEInvoice, "");
        invoice.put(ContractNumber, "");
        invoice.put(WhetherInvoiceIsRedInvoice, "3".equalsIgnoreCase(AS.valueOf(json.get((Object)"invoiceStatus"))) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenChecked, "1".equals(AS.valueOf(json.get((Object)"checkStatus"), "")) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenBooked, "true");
        invoice.put(NameOfAccountingEntity, AS.valueOf(json.get((Object)"buyerName"), ""));
        invoice.put(UnifiedSocialCreditCodeOfAccountingEntity, AS.valueOf(json.get((Object)"buyerTaxNo"), ""));
        invoice.put(BeginningOfPreTaxDeductionYearOfIncomeTax, "");
        invoice.put(EndOfPreTaxDeductionYearOfIncomeTax, "");
        invoice.put(BeginningOfExpenditurePeriodUnderAccrualBasis, "");
        invoice.put(EndOfExpenditurePeriodUnderAccrualBasis, "");
        invoice.put(WhetherInvoiceHasBeenPaid, "true");
        invoice.put(DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets, "");
        invoice.put(NameOfSeller, AS.valueOf(json.get((Object)"salerName"), ""));
        invoice.put(TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller, AS.valueOf(json.get((Object)"salerTaxNo"), ""));
        invoice.put(TotalAmountExcludingTax, AS.valueOf(json.get((Object)"invoiceAmount"), ""));
        invoice.put(TotalTaxAmount, AS.valueOf(json.get((Object)"totalTaxAmount"), ""));
        invoice.put(TaxIncludedAmountInFigures, AS.valueOf(json.get((Object)"totalAmount"), ""));
        invoice.put(DateOfIssue, AS.valueOf(json.get((Object)"invoiceDate"), ""));
        invoice.put(WhetherInvoiceHasBeenFactoredSoldOrSecuritized, "");
        return invoice;
    }

    private static Invoice getOrdInvoice(Context ctx, JSONObject json) throws EASBizException {
        OrdInvoice invoice = new OrdInvoice();
        String WhetherInvoiceHasBeenBooked = "WhetherInvoiceHasBeenBooked";
        String NameOfAccountingEntity = "NameOfAccountingEntity";
        String UnifiedSocialCreditCodeOfAccountingEntity = "UnifiedSocialCreditCodeOfAccountingEntity";
        String WhetherInvoiceIsRedInvoice = "WhetherInvoiceIsRedInvoice";
        String WhetherInvoiceHasBeenChecked = "WhetherInvoiceHasBeenChecked";
        String InformationOfAccountingDocumentsTuple2 = "InformationOfAccountingDocumentsTuple";
        String UniqueCodeOfInvoice = "UniqueCodeOfInvoice";
        String WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted = "WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted";
        String BeginningOfPreTaxDeductionYearOfIncomeTax = "BeginningOfPreTaxDeductionYearOfIncomeTax";
        String EndOfPreTaxDeductionYearOfIncomeTax = "EndOfPreTaxDeductionYearOfIncomeTax";
        String BeginningOfExpenditurePeriodUnderAccrualBasis = "BeginningOfExpenditurePeriodUnderAccrualBasis";
        String EndOfExpenditurePeriodUnderAccrualBasis = "EndOfExpenditurePeriodUnderAccrualBasis";
        String ContractNumber = "ContractNumber";
        String WhetherInvoiceHasBeenPaid = "WhetherInvoiceHasBeenPaid";
        String NumberOfBankElectronicReceipt = "NumberOfBankElectronicReceipt";
        String MatchingStateBetweenBusinessDocumentsAndVatEInvoice = "MatchingStateBetweenBusinessDocumentsAndVatEInvoice";
        String DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets = "DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets";
        String NameOfSeller = "NameOfSeller";
        String TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller = "TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller";
        String TotalAmountExcludingTax = "TotalAmountExcludingTax";
        String TotalTaxAmount = "TotalTaxAmount";
        String TaxIncludedAmountInFigures = "TaxIncludedAmountInFigures";
        String DateOfIssue = "DateOfIssue";
        String WhetherInvoiceHasBeenFactoredSoldOrSecuritized = "WhetherInvoiceHasBeenFactoredSoldOrSecuritized";
        String InvoiceCode = "InvoiceCode";
        String InvoiceNO = "InvoiceNO";
        String SerialNO = "SerialNO";
        invoice.put(UniqueCodeOfInvoice, StringUtils.isEmpty((CharSequence)AS.valueOf(json.get((Object)"serialNo"))) ? AS.valueOf(json.get((Object)"invoiceCode")) + AS.valueOf(json.get((Object)"invoiceNo")) : AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(InvoiceCode, AS.valueOf(json.get((Object)"invoiceCode")));
        invoice.put(InvoiceNO, AS.valueOf(json.get((Object)"invoiceNo")));
        invoice.put(SerialNO, AS.valueOf(json.get((Object)"serialNo")));
        invoice.put(WhetherPreTaxDeductionOfIncomeTaxHasBeenCompleted, "");
        invoice.put(MatchingStateBetweenBusinessDocumentsAndVatEInvoice, "");
        invoice.put(ContractNumber, "");
        invoice.put(WhetherInvoiceIsRedInvoice, "3".equalsIgnoreCase(AS.valueOf(json.get((Object)"invoiceStatus"))) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenChecked, "1".equals(AS.valueOf(json.get((Object)"checkStatus"), "")) ? "true" : "false");
        invoice.put(WhetherInvoiceHasBeenBooked, "true");
        invoice.put(NameOfAccountingEntity, AS.valueOf(json.get((Object)"buyerName"), ""));
        invoice.put(UnifiedSocialCreditCodeOfAccountingEntity, AS.valueOf(json.get((Object)"buyerTaxNo"), ""));
        invoice.put(BeginningOfPreTaxDeductionYearOfIncomeTax, "");
        invoice.put(EndOfPreTaxDeductionYearOfIncomeTax, "");
        invoice.put(BeginningOfExpenditurePeriodUnderAccrualBasis, "");
        invoice.put(EndOfExpenditurePeriodUnderAccrualBasis, "");
        invoice.put(WhetherInvoiceHasBeenPaid, "true");
        invoice.put(DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets, "");
        invoice.put(NameOfSeller, AS.valueOf(json.get((Object)"salerName"), ""));
        invoice.put(TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller, AS.valueOf(json.get((Object)"salerTaxNo"), ""));
        invoice.put(TotalAmountExcludingTax, AS.valueOf(json.get((Object)"invoiceAmount"), ""));
        invoice.put(TotalTaxAmount, AS.valueOf(json.get((Object)"totalTaxAmount"), ""));
        invoice.put(TaxIncludedAmountInFigures, AS.valueOf(json.get((Object)"totalAmount"), ""));
        invoice.put(DateOfIssue, AS.valueOf(json.get((Object)"invoiceDate"), ""));
        invoice.put(WhetherInvoiceHasBeenFactoredSoldOrSecuritized, "");
        return invoice;
    }

    private static void checkNull(Context ctx, EVSSet evsSet, JSONObject invoiceInfo) throws EASBizException {
        CheckUtil.checkNULL(ctx, (Map)JSONObject.parseObject((String)invoiceInfo.toJSONString(), Map.class), evsSet.get());
    }
}

