/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extendcontrols;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.BizComboQueryAgent;
import com.kingdee.bos.ctrl.extendcontrols.KDBizComboBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizComboBoxMultiColumnItem;
import com.kingdee.bos.ctrl.extendcontrols.util.BosHelper;
import com.kingdee.bos.ctrl.swing.KDComboBoxMultiColumnItem;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class KDBizComboboxModel
extends DefaultComboBoxModel {
    private static final Logger logger = Logger.getLogger(KDBizComboboxModel.class);
    private KDBizComboBox box = null;
    private BizComboQueryAgent queryAgent = null;
    private boolean isNeedReQuery = true;
    private List propSet = new Vector(2);
    private QueryInfo tempQueryInfo = null;

    public KDBizComboboxModel(BizComboQueryAgent agent) {
        this.queryAgent = agent;
    }

    public void setPropSet(List props) {
        this.propSet = props;
    }

    public List getPropSet() {
        return this.propSet;
    }

    public void setNeedReQuery(boolean isNeed) {
        this.isNeedReQuery = isNeed;
    }

    public boolean isNeedReQuery() {
        return this.isNeedReQuery;
    }

    @Override
    public Object getElementAt(int index) {
        return super.getElementAt(index);
    }

    public void initData() {
        if (this.isNeedReQuery) {
            IRowSet rs = this.queryAgent.executeQuery(0, -1);
            this.initDataByQuery(rs);
            this.isNeedReQuery = false;
        }
    }

    protected void initDataByQuery(IRowSet rs) {
        Object[] o = this.buildReturnValue(rs, rs.size());
        o = this.reOrderData(o);
        this.addData(o);
    }

    protected Object[] reOrderData(Object[] itemDatas) {
        return itemDatas;
    }

    protected void addData(Object[] itemDatas) {
        this.removeAllElements();
        if (itemDatas != null) {
            for (int i = 0; i < itemDatas.length; ++i) {
                Object tmp = itemDatas[i];
                if (!(tmp instanceof IObjectValue)) continue;
                IObjectValue ov = (IObjectValue)tmp;
                this.addOneObjectValueToThis(ov);
            }
        }
    }

    protected String[] getComboDisplayProp() {
        if (this.propSet.size() > 0) {
            return this.propSet.toArray(new String[0]);
        }
        return null;
    }

    protected void addOneObjectValueToThis(IObjectValue ov) {
        String[] props = this.getComboDisplayProp();
        String[] values = new String[props.length];
        for (int i = 0; i < props.length; ++i) {
            Object tmpValue = ov.get(props[i]);
            if (tmpValue != null) {
                if (tmpValue instanceof Date) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime((Date)tmpValue);
                    StringBuffer sb = new StringBuffer();
                    sb.append(cal.get(1));
                    sb.append("-");
                    sb.append(cal.get(2) + 1);
                    sb.append("-");
                    sb.append(cal.get(5));
                    values[i] = sb.toString();
                    continue;
                }
                values[i] = tmpValue.toString();
                continue;
            }
            values[i] = "";
        }
        KDComboBoxMultiColumnItem item = this.getBizComboBoxMultiColumnItem(values, ov);
        item.setUserObject((Object)ov);
        this.addBizComboBoxMultiColumnItem(item);
    }

    protected KDComboBoxMultiColumnItem getBizComboBoxMultiColumnItem(String[] values, IObjectValue ov) {
        return new KDBizComboBoxMultiColumnItem(values);
    }

    protected void addBizComboBoxMultiColumnItem(KDComboBoxMultiColumnItem item) {
        this.addElement(item);
    }

    protected Object[] buildReturnValue(IRowSet rw, int size) {
        Object[] ret = new Object[size];
        Object value = null;
        String id = "";
        boolean valid = true;
        String mainKey = BosHelper.getMainObjectPKField(this.queryAgent.getQueryInfoPK());
        if (StringUtil.isEmptyString((String)mainKey)) {
            return ret;
        }
        try {
            rw.beforeFirst();
            for (int i = 0; i < size; ++i) {
                valid = rw.next();
                if (!valid || (id = (value = rw.getObject(mainKey)) != null ? value.toString() : "").length() <= 0) continue;
                ret[i] = value = BosHelper.getRemoteValue(id, this.getBOSTypeFromQueryMainObject(), this.queryAgent.getSelectorCollection());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    private BOSObjectType getBOSTypeFromQueryMainObject() {
        BOSObjectType bostype = null;
        try {
            QueryInfo qi = this.getTempQueryInfo();
            EntityObjectInfo eoi = (EntityObjectInfo)qi.getMainObject().get("entityRef");
            bostype = eoi.getType();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return bostype;
    }

    private QueryInfo getTempQueryInfo() {
        if (this.tempQueryInfo == null && this.getQueryInfoPK() != null) {
            this.tempQueryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)this.getQueryInfoPK());
        }
        return this.tempQueryInfo;
    }

    private MetaDataPK getQueryInfoPK() {
        return this.queryAgent.getQueryInfoPK();
    }
}

