/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.rpc.io.loadbalance.JobManager;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobServiceStatus;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.wrapper.InterfaceWrapper;
import com.kingdee.bos.util.rpc.Ajax;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.store.util.BackgroundJobUpgrade;
import com.kingdee.bos.workflow.store.util.JobServiceUtil;
import com.kingdee.eas.base.job.IJobServiceUIFacade;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobServiceUIFacade
implements IJobServiceUIFacade {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.job.app.JobServiceUIFacade");
    Context ctx;

    public JobServiceUIFacade(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void release(ProcessDef process) throws BOSException {
        JobDef def = JobServiceUtil.toJobDef((Context)this.ctx, (ProcessDef)process);
        Trigger trigger = JobServiceUtil.toTrigger((JobDef)def, (ProcessDef)process);
        IJobService svc = JobServiceFactory.getLocalInstance((Context)this.ctx);
        svc.createJobDef(def, trigger, true);
    }

    @Override
    public int abort(String[] jobInstIds) throws BOSException {
        return JobServiceFactory.getLocalInstance((Context)this.ctx).abort(jobInstIds);
    }

    @Override
    public void cleanWasteJobDef() throws BOSException {
        JobServiceFactory.getLocalInstance((Context)this.ctx).cleanWasteJobDef();
    }

    @Override
    public int delete(String[] jobInstIds) throws BOSException {
        return JobServiceFactory.getLocalInstance((Context)this.ctx).delete(jobInstIds);
    }

    @Override
    public void disableTrigger(String triggerId) throws BOSException {
        JobServiceFactory.getLocalInstance((Context)this.ctx).disableTrigger(triggerId);
    }

    @Override
    public void enableTrigger(String triggerId) throws BOSException {
        JobServiceFactory.getLocalInstance((Context)this.ctx).enableTrigger(triggerId);
    }

    @Override
    public String getJobException(String jobInstId) throws BOSException {
        return JobServiceFactory.getLocalInstance((Context)this.ctx).getJobException(jobInstId);
    }

    @Override
    public String getServiceStatus() {
        JobServiceStatus status = JobServiceFactory.getLocalInstance((Context)this.ctx).getServiceStatus();
        return status.toString();
    }

    @Override
    public int moveToHistory(String[] jobInstIds) throws BOSException {
        return JobServiceFactory.getLocalInstance((Context)this.ctx).moveToHistory(jobInstIds);
    }

    @Override
    public int restart(String[] jobInstIds) throws BOSException {
        return JobServiceFactory.getLocalInstance((Context)this.ctx).restart(jobInstIds);
    }

    @Override
    public int resume(String[] jobInstIds) throws BOSException {
        return JobServiceFactory.getLocalInstance((Context)this.ctx).resume(jobInstIds);
    }

    @Override
    public int suspend(String[] jobInstIds) throws BOSException {
        return JobServiceFactory.getLocalInstance((Context)this.ctx).suspend(jobInstIds);
    }

    @Override
    public String createJobInstance(String jobDefId, Object param, Timestamp scheduledTime) throws BOSException {
        return JobServiceFactory.getLocalInstance((Context)this.ctx).createJobInstance(jobDefId, param, scheduledTime);
    }

    @Override
    public String testJobDef(ProcessDef process) throws BOSException {
        JobDef def = JobServiceUtil.toJobDef((Context)this.ctx, (ProcessDef)process);
        ExtendedAttributeDef extendedAttributeDef = process.getExtendedAttributes().get("selectedServer");
        String selectedServer = null;
        if (extendedAttributeDef != null) {
            selectedServer = extendedAttributeDef.getValue();
        }
        return JobServiceFactory.getLocalInstance((Context)this.ctx).testJobDef(def, selectedServer, null);
    }

    @Override
    public void createUpgradeJobDef() throws BOSException {
        String packageName = null;
        String title = "~\u540e\u53f0\u4e8b\u52a1\u5347\u7ea7";
        String description = null;
        String proxyUserID = null;
        String proxyOrgID = null;
        boolean isPersistent = true;
        InterfaceWrapper wrapper = new InterfaceWrapper((Object)new BackgroundJobUpgrade());
        JobDef def = new JobDef(this.ctx, packageName, title, description, proxyUserID, proxyOrgID, isPersistent, (Wrapper)wrapper);
        JobServiceFactory.getLocalInstance((Context)this.ctx).createJobDef(def);
    }

    @Override
    public boolean isReleased(String jobDefId) throws BOSException {
        String id = jobDefId.substring(0, 36) + "BGJOBDEF";
        String sql = "select 1 from T_JOB_DEF WHERE fjobdefid='" + id + "'";
        return SQL.executeQuery((Context)this.ctx, (String)sql).size() > 0;
    }

    @Override
    public Map getJobInstance(String id) throws Exception {
        Job job = JobServiceFactory.getLocalInstance((Context)this.ctx).getJobInstance(id);
        HashMap<String, String> map = new HashMap<String, String>();
        String userId = null;
        String listener = null;
        if (job != null) {
            if (job.getJobDef() != null) {
                JobDef def = job.getJobDef();
                userId = def.getProxyUserID();
                listener = Ajax.toString((Object)def.getListeners());
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            map.put("jobTitle", job.getTitle());
            String userName = null;
            userName = !StringUtils.isEmpty((String)userId) ? UserFactory.getLocalInstance((Context)this.ctx).getUserByID((IObjectPK)new ObjectUuidPK(userId)).getName() : "administrator";
            map.put("jobUserName", userName);
            if (job.getCreatedTime() != null) {
                map.put("jobCreateTime", format.format(job.getCreatedTime()));
            }
            if (job.getExpiredTime() != null) {
                map.put("jobExpiredTime", format.format(job.getExpiredTime()));
            }
            if (job.getScheduledTime() != null) {
                map.put("jobPlanTime", format.format(job.getScheduledTime()));
            }
            if (job.getStartedTime() != null) {
                map.put("jobStartTime", format.format(job.getStartedTime()));
            }
            if (job.getPriorState() != null) {
                map.put("jobPreState", job.getPriorState().toString());
            }
            if (job.getState() != null) {
                map.put("jobCurrentState", job.getState().toString());
            }
            if (job.getStateChangedTime() != null) {
                map.put("jobstateChangeTime", format.format(job.getStateChangedTime()));
            }
            if (job.getResult() != null) {
                map.put("jobExecuteResult", job.getResult().toString());
            }
            map.put("jobIsolateLevel", job.getIsolationBoundary());
            map.put("jobExecuteServer", job.getHolderId());
            map.put("jobHashCode", String.valueOf(job.getHashCode()));
            map.put("jobIsSmallJob", String.valueOf(job.isSmallJob()));
            map.put("jobStaticPriority", String.valueOf(job.getStaticPriority()));
            map.put("jobMutexLogo", job.getMutex());
            map.put("jobInstIsolateLevel", job.getIsolationLevel().toString());
            map.put("jobExecuteProgress", job.getProgress());
            if (job.getParameters() != null) {
                map.put("jobParameters", Ajax.toString((Object)job.getParameters()));
            }
            map.put("jobListener", listener);
            if (job.getHandler() != null) {
                map.put("jobHandler", Ajax.toString((Object)job.getHandler()));
            }
            map.put("jobExceptionArea", job.getException());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList getJobServiceInstanceKeys_b() throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        Connection con = null;
        PreparedStatement psm = null;
        String sql = "SELECT finstanceId FROM T_JOB_SERVICE";
        ResultSet rs = null;
        String instanceKey = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            psm = con.prepareStatement(sql);
            rs = psm.executeQuery();
            while (rs.next()) {
                instanceKey = rs.getString("finstanceId");
                list.add(instanceKey);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u540e\u53f0\u4e8b\u52a1\u83b7\u53d6\u670d\u52a1\u5b9e\u4f8b\u51fa\u9519", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"\u540e\u53f0\u4e8b\u52a1\u83b7\u53d6\u670d\u52a1\u5b9e\u4f8b\u51fa\u9519", (Throwable)e);
            }
        }
        return list;
    }

    @Override
    public ArrayList getJobServiceInstanceKeys() throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        JobManager.RPCServerGroup serverGroup = JobManager.getServers();
        if (serverGroup != null && serverGroup.servers != null && serverGroup.servers.length > 0) {
            String serverName = null;
            String serverUrl = null;
            int beginIndex = 0;
            int endIndex = 0;
            for (int i = 0; i < serverGroup.servers.length; ++i) {
                serverName = serverGroup.servers[i].getName();
                serverUrl = serverGroup.servers[i].getUrl();
                if (StringUtils.isEmpty((String)serverName) || StringUtils.isEmpty((String)serverUrl)) continue;
                beginIndex = -1;
                endIndex = -1;
                if (serverUrl.indexOf("//") >= 0) {
                    beginIndex = serverUrl.lastIndexOf("//") + 2;
                }
                if (serverUrl.indexOf(":") >= 0) {
                    endIndex = serverUrl.lastIndexOf(":");
                }
                if (beginIndex < 0 || endIndex < 0) continue;
                String serverIP = serverUrl.substring(beginIndex, endIndex);
                list.add(serverName + "@" + serverIP);
            }
        }
        return list;
    }

    @Override
    public String getClusterIsolation() throws BOSException {
        return Configuration.clusterIsolation();
    }

    @Override
    public String[] getJobServiceInstanceKeys_c() throws BOSException {
        String[] r1 = ClusterStateManager.get((Context)this.ctx).getSameVersionServiceInstanceIds();
        String[] r2 = ClusterStateManager.get((Context)this.ctx).getSameVersionServiceClusters();
        String[] r3 = new String[r1.length + r2.length];
        System.arraycopy(r1, 0, r3, 0, r1.length);
        System.arraycopy(r2, 0, r3, r1.length, r2.length);
        return r3;
    }

    private static boolean isLocal(String url) {
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            return url.equals(Configuration.getRpcUrl());
        }
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getServiceStatusInfo() {
        String[] result = new String[2];
        IJobService iJobService = JobServiceFactory.getLocalInstance((Context)this.ctx);
        JobServiceStatus status = iJobService.getServiceStatus();
        result[0] = status.toString();
        result[1] = iJobService.getServiceConfigInfo(this.ctx.getAIS());
        return result;
    }

    @Override
    public String[] getServiceStatusInfo(String instanceId) throws BOSException {
        String[] result = new String[2];
        try {
            String rpcUrl = this.getRpcUrl(instanceId);
            IJobService jobService = this.getJobService(rpcUrl);
            if (jobService == null) {
                result[0] = result[1] = "\u65e0\u6cd5\u8fdc\u7a0b\u8c03\u7528\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u5b9e\u4f8b\uff1a" + Configuration.instanceId() + "\u4e0e\u5b9e\u4f8b\uff1a" + instanceId + "\u4e4b\u95f4\u901a\u8baf\u662f\u5426\u6b63\u5e38\u3002";
                return result;
            }
            result[0] = jobService.getServiceStatus().toString();
            result[1] = jobService.getServiceConfigInfo(this.ctx.getAIS());
        }
        catch (BOSException e) {
            result[0] = result[1] = e.getMessage() + "\uff0c\u65e0\u6cd5\u68c0\u6d4b\u4efb\u52a1\u4fe1\u606f\u3002";
        }
        return result;
    }

    public IJobService getJobService(String rpcUrl) {
        IJobService jobService = null;
        if (JobServiceUIFacade.isLocal(rpcUrl)) {
            jobService = JobServiceFactory.getLocalInstance((Context)this.ctx);
        } else {
            try {
                jobService = (IJobService)RPCEngineFactory.getEngine((String)rpcUrl).createObject("com.kingdee.bos.service.job.core.JobService", IJobService.class, new Class[]{Context.class}, new Object[]{this.ctx});
            }
            catch (Throwable e) {
                logger.info((Object)"RPCEngineFactory createObject failed", e);
                return null;
            }
        }
        return jobService;
    }

    public String getRpcUrl(String instanceId) throws BOSException {
        if (Configuration.instanceId().equals(instanceId)) {
            return Configuration.getRpcUrl();
        }
        String sql = "select frpcurl from t_job_service where finstanceid=?";
        int[] types = new int[]{12};
        Object[] values = new Object[]{instanceId};
        ArrayList rs = SQL.executeQuery((Context)this.ctx, (String)sql, (int[])types, (Object[])values);
        if (rs.size() == 0) {
            throw new BOSException("\u5b9e\u4f8b\u6ca1\u6709\u542f\u52a8\u540e\u53f0\u4e8b\u52a1\u670d\u52a1\u6216\u8005\u5df2\u505c\u673a");
        }
        if (((Map)rs.get(0)).get("frpcurl") == null) {
            throw new BOSException("\u65e0\u6cd5\u83b7\u53d6\u52a0\u8f7d\u5b9e\u4f8b\u7684 RPC\u8fde\u63a5");
        }
        return ((Map)rs.get(0)).get("frpcurl").toString();
    }

    @Override
    public String checkJob(String jobId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        IJobService jobService = JobServiceFactory.getLocalInstance((Context)this.ctx);
        Job job = jobService.getJobInstance(jobId);
        if (job != null) {
            JobServiceStatus jobServiceStatus;
            sb.append("\u4efb\u52a1\u72b6\u6001\u4e3a\uff1a").append(job.getState().getText()).append("\uff1b\r\n");
            String isolationBoundary = job.getIsolationBoundary();
            sb.append("\u9694\u79bb\u8fb9\u754c\u4e3a\uff1a").append(isolationBoundary).append("\uff1b\r\n");
            String holderId = job.getHolderId();
            if (holderId != null) {
                sb.append("\u52a0\u8f7d\u5b9e\u4f8b\u4e3a\uff1a").append(holderId).append("\uff1b\r\n");
                try {
                    String rpcUrl = this.getRpcUrl(holderId);
                    jobService = this.getJobService(rpcUrl);
                    if (jobService == null) {
                        sb.append("\u65e0\u6cd5\u8fdc\u7a0b\u8c03\u7528\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u5b9e\u4f8b\uff1a").append(Configuration.instanceId()).append("\u4e0e\u5b9e\u4f8b\uff1a").append(holderId).append("\u4e4b\u95f4\u901a\u8baf\u662f\u5426\u6b63\u5e38\u3002");
                        return sb.toString();
                    }
                }
                catch (BOSException e) {
                    sb.append(e.getMessage() + "\uff0c\u65e0\u6cd5\u68c0\u6d4b\u4efb\u52a1\u4fe1\u606f\u3002");
                    return sb.toString();
                }
            }
            if (JobState.Created.equals((Object)job.getState()) || JobState.ReScheduled.equals((Object)job.getState())) {
                sb.append(this.checkIsolationBoundary(job.getContext(), isolationBoundary));
            } else if (JobState.Waiting.equals((Object)job.getState())) {
                jobServiceStatus = jobService.getServiceStatus();
                sb.append("\u52a0\u8f7d\u5b9e\u4f8b\u6267\u884c\u4e2d\u4efb\u52a1\u6570\uff1a").append(jobServiceStatus.runningJobCount).append("\r\n");
                sb.append("\u52a0\u8f7d\u5b9e\u4f8b\u5df2\u5c31\u7eea\u4efb\u52a1\u6570\uff1a").append(jobServiceStatus.readyJobCount).append("\r\n");
            } else if (JobState.Ready.equals((Object)job.getState())) {
                jobServiceStatus = jobService.getServiceStatus();
                sb.append("\u52a0\u8f7d\u5b9e\u4f8b\u6267\u884c\u4e2d\u4efb\u52a1\u6570\uff1a").append(jobServiceStatus.runningJobCount).append("\r\n");
                sb.append("\u52a0\u8f7d\u5b9e\u4f8b\u5df2\u5c31\u7eea\u4efb\u52a1\u6570\uff1a").append(jobServiceStatus.readyJobCount).append("\r\n");
                String title = jobService.getJobTitleByMutex(job.getMutex());
                if (title != null) {
                    sb.append("\u4e0e\u6267\u884c\u4e2d\u4efb\u52a1[").append(title).append("]\u62e5\u6709\u76f8\u540c\u4e92\u65a5\u63a7\u5236[").append("]\uff0c\u9700\u7b49\u5f85\u8be5\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u624d\u80fd\u6267\u884c\u5f53\u524d\u4efb\u52a1\u3002");
                }
            } else if (JobState.Running.equals((Object)job.getState())) {
                String threadDump = jobService.getJobThreadDump(job.getId());
                sb.append(threadDump);
            }
        }
        return sb.toString();
    }

    public String checkIsolationBoundary(Context ctx, String isolationBoundary) throws BOSException {
        if (isolationBoundary != null) {
            if (isolationBoundary.indexOf(":") > 0) {
                String sql = "select count(1) from t_job_service where finstanceid=?";
                int[] types = new int[]{12};
                Object[] values = new Object[]{isolationBoundary};
                ArrayList rs = SQL.executeQuery((Context)ctx, (String)sql, (int[])types, (Object[])values);
                if (rs.size() == 0) {
                    return "\u9694\u79bb\u8fb9\u754c\u6240\u6307\u5b9a\u5b9e\u4f8b\u6ca1\u6709\u542f\u52a8\u540e\u53f0\u4e8b\u52a1\u670d\u52a1\u6216\u8005\u5df2\u505c\u673a\u3002";
                }
                return "\u7b49\u5f85\u52a0\u8f7d\u3002";
            }
            if (JobIsolationLevel.FLR.getJobIsolationBoundary().equals(isolationBoundary) || JobIsolationLevel.None.getJobIsolationBoundary().equals(isolationBoundary)) {
                return "\u7b49\u5f85\u52a0\u8f7d\u3002";
            }
            String sql = "select count(1) from t_job_service where fserverId=? or fclustername=?";
            int[] types = new int[]{12, 12};
            Object[] values = new Object[]{isolationBoundary, isolationBoundary};
            ArrayList rs = SQL.executeQuery((Context)ctx, (String)sql, (int[])types, (Object[])values);
            if (rs.size() == 0) {
                return "\u9694\u79bb\u8fb9\u754c\u6240\u6307\u5b9a\u670d\u52a1\u5668\u6216\u96c6\u7fa4\uff0c\u6ca1\u6709\u5b9e\u4f8b\u542f\u52a8\u540e\u53f0\u4e8b\u52a1\u670d\u52a1\u6216\u8005\u5df2\u505c\u673a\u3002";
            }
            return "\u7b49\u5f85\u52a0\u8f7d\u3002";
        }
        return "\u9694\u79bb\u8fb9\u754c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u88ab\u52a0\u8f7d";
    }

    @Override
    public String checkTrigger(String triggerId) throws BOSException {
        StringBuffer sb;
        block7: {
            sb = new StringBuffer();
            IJobService jobService = JobServiceFactory.getLocalInstance((Context)this.ctx);
            String sql = "select fholderid,fisolationboundary,fisvalid from T_JOB_TRIGGER where fid=? or fjobdefid=?";
            int[] types = new int[]{12, 12};
            String defId = triggerId.substring(0, 36) + "BGJOBDEF";
            Object[] values = new Object[]{triggerId, defId};
            ArrayList rs = SQL.executeQuery((Context)this.ctx, (String)sql, (int[])types, (Object[])values);
            if (rs.size() > 0) {
                String isolationBoundary = (String)((Map)rs.get(0)).get("fisolationboundary");
                sb.append("\u9694\u79bb\u8fb9\u754c\u4e3a\uff1a").append(isolationBoundary).append("\uff1b\r\n");
                String holderId = (String)((Map)rs.get(0)).get("fholderid");
                if (holderId != null) {
                    sb.append("\u52a0\u8f7d\u5b9e\u4f8b\u4e3a\uff1a").append(holderId).append("\uff1b\r\n");
                    try {
                        String rpcUrl = this.getRpcUrl(holderId);
                        jobService = this.getJobService(rpcUrl);
                        if (jobService == null) {
                            sb.append("\u65e0\u6cd5\u8fdc\u7a0b\u8c03\u7528\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u5b9e\u4f8b\uff1a").append(Configuration.instanceId()).append("\u4e0e\u5b9e\u4f8b\uff1a").append(holderId).append("\u4e4b\u95f4\u901a\u8baf\u662f\u5426\u6b63\u5e38\u3002");
                            return sb.toString();
                        }
                        break block7;
                    }
                    catch (BOSException e) {
                        sb.append(e.getMessage() + "\uff0c\u65e0\u6cd5\u68c0\u6d4b\u4efb\u52a1\u4fe1\u606f\u3002");
                        return sb.toString();
                    }
                }
                String isValid = (String)((Map)rs.get(0)).get("fisvalid");
                if ("Y".equals(isValid)) {
                    sb.append(this.checkIsolationBoundary(this.ctx, isolationBoundary));
                } else {
                    sb.append("\u89e6\u53d1\u5668\u5df2").append("X".equals(isValid) ? "\u5931\u6548" : "\u7981\u7528").append("\uff0c\u8be6\u7ec6\u8bb0\u5f55\u53ef\u67e5\u770b\u65e5\u5fd7\u4fe1\u606f");
                }
            }
        }
        return sb.toString();
    }

    @Override
    public Map<String, Object> getThreadPoolSize(String instanceId) throws BOSException {
        String rpcUrl = this.getRpcUrl(instanceId);
        IJobService jobService = this.getJobService(rpcUrl);
        if (jobService == null) {
            throw new BOSException("\u65e0\u6cd5\u8fdc\u7a0b\u8c03\u7528\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u5b9e\u4f8b\uff1a" + Configuration.instanceId() + "\u4e0e\u5b9e\u4f8b\uff1a" + instanceId + "\u4e4b\u95f4\u901a\u8baf\u662f\u5426\u6b63\u5e38\u3002");
        }
        return jobService.getThreadPoolSize();
    }

    @Override
    public boolean setThreadPoolSize(String instanceId, int[] size, long nextAdjustTime) throws BOSException {
        String rpcUrl = this.getRpcUrl(instanceId);
        IJobService jobService = this.getJobService(rpcUrl);
        if (jobService == null) {
            throw new BOSException("\u65e0\u6cd5\u8fdc\u7a0b\u8c03\u7528\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u5b9e\u4f8b\uff1a" + Configuration.instanceId() + "\u4e0e\u5b9e\u4f8b\uff1a" + instanceId + "\u4e4b\u95f4\u901a\u8baf\u662f\u5426\u6b63\u5e38\u3002");
        }
        return jobService.setThreadPoolSize(size, nextAdjustTime);
    }

    @Override
    public List<String> enableTriggers(String[] triggerIds) throws BOSException {
        ArrayList<String> errorIds = new ArrayList<String>();
        for (int i = 0; i < triggerIds.length; ++i) {
            try {
                this.enableTrigger(triggerIds[i]);
                continue;
            }
            catch (BOSException e) {
                errorIds.add(triggerIds[i]);
                logger.error((Object)("Batch disableTriggers error, triggerId is " + triggerIds[i]), (Throwable)e);
            }
        }
        return errorIds;
    }

    @Override
    public List<String> disableTriggers(String[] triggerIds) throws BOSException {
        ArrayList<String> errorIds = new ArrayList<String>();
        for (int i = 0; i < triggerIds.length; ++i) {
            try {
                this.disableTrigger(triggerIds[i]);
                continue;
            }
            catch (BOSException e) {
                errorIds.add(triggerIds[i]);
                logger.error((Object)("Batch disableTriggers error, triggerId is " + triggerIds[i]), (Throwable)e);
            }
        }
        return errorIds;
    }
}

