/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.service.scheduler.IORMScheduler;
import com.kingdee.bos.service.scheduler.ORMScheduler;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.biz.FunctionHelper;
import com.kingdee.bos.workflow.define.FormalParameterCollection;
import com.kingdee.bos.workflow.define.FormalParameterDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.metas.ProcDefCollection;
import com.kingdee.bos.workflow.metas.ProcDefInfo;
import com.kingdee.bos.workflow.store.util.RelevantDatas;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.eas.base.job.ProcessDefInfo;
import com.kingdee.eas.base.job.app.AbstractProcessDefControllerBean;
import com.kingdee.eas.base.job.util.JobProcessDef;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProcessDefControllerBean
extends AbstractProcessDefControllerBean {
    private static final Logger logger = Logger.getLogger(ProcessDefControllerBean.class);
    private static final String RESXNAME = "com.kingdee.eas.base.job.app.ProcessDefResx";
    private static final String PROCESSTITLE = "processTitle";
    private static final String MANUAL_DEFAULT_LOGITEM = "manual_default_logitem";
    private static final String UPDATE = "Update";
    private static final String ADDNEW = "AddNew";
    private static final String DELETE = "Delete";

    protected IObjectCollection _getCollection(Context ctx, EntityViewInfo view) throws BOSException {
        return null;
    }

    @Override
    protected void _testJobDef(Context ctx, IObjectPK jobDefPK) throws BOSException, EASBizException {
        ProcessDefInfo processDefInfo = this.getValue(ctx, jobDefPK);
        ProcessDef pdef = KpdlParser.parseKpdl((String)processDefInfo.getProcessxml());
        JobProcessDef jobProcessDef = new JobProcessDef(pdef);
        ToolActivityDef toolActivityDef = jobProcessDef.getJobActivity();
        FunctionDef functionDef = toolActivityDef.getRelatedApplication().getFunction();
        String packageName = functionDef.getPackageName();
        String functionName = functionDef.getName();
        String operationName = functionDef.getOperation();
        FormalParameterCollection formalParameters = jobProcessDef.getFormalParameters();
        Object[] parameters = new Object[formalParameters.size()];
        RelevantDatas relevantDatas = new RelevantDatas();
        relevantDatas.initial(pdef.getDataFields());
        HashMap dataFieldValues = relevantDatas.readValue();
        int size = formalParameters.size();
        for (int i = 0; i < size; ++i) {
            FormalParameterDef formalParameterDef = formalParameters.get(i);
            parameters[i] = dataFieldValues.get(formalParameterDef.getName());
        }
        try {
            FunctionHelper.invokeAutomatic((Context)ctx, (String)packageName, (String)functionName, (String)operationName, (Object[])parameters);
        }
        catch (Throwable e) {
            throw new BOSException("job test failed!", e);
        }
    }

    @Override
    protected void _cleanWasteJobs(Context ctx) throws BOSException {
        try {
            IORMScheduler scheduler = ORMScheduler.getInstance((String)ctx.getAIS(), (String)ctx.getSolution());
            String[] jobGroupNames = scheduler.getJobGroupNames();
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            for (String groupName : jobGroupNames) {
                for (String jobName : scheduler.getJobNames(groupName)) {
                    if (StringUtils.isEmpty((String)jobName) || !BOSUuid.isValid((String)jobName, (boolean)false)) continue;
                    EntityViewInfo entityViewInfo = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("procdefID", (Object)jobName));
                    entityViewInfo.setFilter(filterInfo);
                    ProcDefCollection procDefCollection = (ProcDefCollection)iDynamicObject.getCollection(WfBOSObjectTypeUtil.PROCESSDEFBOT, entityViewInfo);
                    boolean exists = procDefCollection.size() > 0;
                    ProcDefInfo procDefInfo = null;
                    if (exists) {
                        procDefInfo = procDefCollection.get(0);
                    }
                    if (exists && (procDefInfo == null || !procDefInfo.getValidTo().before(new Date()))) continue;
                    scheduler.deleteJob(jobName, groupName);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException {
        ObjectUuidPK retPk = new ObjectUuidPK(((ProcessDefInfo)model).getProcessId());
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
            ProcessDefInfo processDefInfo = (ProcessDefInfo)model;
            appLogId = this.writeAppLog(ctx, appLog, (IObjectPK)retPk, processDefInfo, ADDNEW);
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for ProcessDef Operation.", (Throwable)e);
        }
        super._addnew(ctx, (IObjectPK)retPk, model);
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for ProcessDef Operation.", (Throwable)e);
        }
        return retPk;
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
            ProcessDefInfo processDefInfo = (ProcessDefInfo)model;
            appLogId = this.writeAppLog(ctx, appLog, pk, processDefInfo, ADDNEW);
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for ProcessDef Operation.", (Throwable)e);
        }
        super._addnew(ctx, pk, model);
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for ProcessDef Operation.", (Throwable)e);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
            ProcessDefInfo processDefInfo = (ProcessDefInfo)model;
            appLogId = this.writeAppLog(ctx, appLog, pk, processDefInfo, UPDATE);
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for ProcessDef Operation.", (Throwable)e);
        }
        super._update(ctx, pk, model);
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for ProcessDef Operation.", (Throwable)e);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException {
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
            ProcessDefInfo processDefInfo = this.getValue(ctx, pk);
            appLogId = this.writeAppLog(ctx, appLog, pk, processDefInfo, DELETE);
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for ProcessDef Operation.", (Throwable)e);
        }
        super._delete(ctx, pk);
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"fail to write AppLog for ProcessDef Operation.", (Throwable)e);
        }
    }

    protected IObjectPK writeAppLog(Context ctx, IAppLog appLog, IObjectPK pk, ProcessDefInfo processDefInfo, String methodName) throws BOSException {
        IObjectPK appLogId = null;
        if (appLog == null) {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
        }
        appLogId = appLog.writeLog(methodName, this.getBOSType(), pk, processDefInfo.getName(), MANUAL_DEFAULT_LOGITEM, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ResourceBase.getString((String)RESXNAME, (String)methodName, (Locale)ctx.getLocale()) + "(" + ResourceBase.getString((String)RESXNAME, (String)PROCESSTITLE, (Locale)ctx.getLocale()) + ":" + processDefInfo.getName() + "; processId:" + processDefInfo.getProcessId() + ")");
        return appLogId;
    }
}

