/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionCtrl;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.log.define.LogItemCollection;
import com.kingdee.bos.service.log.define.LogItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogInfo;
import com.kingdee.eas.base.log.ItemCollection;
import com.kingdee.eas.base.log.ItemInfo;
import com.kingdee.eas.base.log.LogException;
import com.kingdee.eas.base.log.LogInfo;
import com.kingdee.eas.base.log.app.AbstractAppLogControllerBean;
import com.kingdee.eas.base.log.app.AppLogHelper;
import com.kingdee.eas.base.log.app.LogDetailUtils;
import com.kingdee.eas.base.log.app.LogQueue;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.base.log.common.Resource;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AppLogControllerBean
extends AbstractAppLogControllerBean {
    static Logger logger = Logger.getLogger((String)AppLogControllerBean.class.getName());
    private static List logInfoList = null;
    private static int logNumber = 5000;
    private static Object lock = new Lock();
    private static final String ITEM_ALIAS = "FAlias";
    private static final String ITEM_DESCRIPTION = "FDescription";
    private static final String ITEM_GROUP = "FGroup";
    private static final int BASE_ITEM_NUM = 4;
    private static final int VAR_ITEM_NUM = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getLogInfoList() {
        Object object = lock;
        synchronized (object) {
            if (logInfoList == null) {
                logInfoList = new ArrayList(logNumber);
            }
            if (logInfoList.size() > 0) {
                logInfoList.clear();
            }
        }
        return logInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _clearLogInfoList(Context ctx) throws BOSException {
        Object object = lock;
        synchronized (object) {
            if (logInfoList != null) {
                logInfoList.clear();
                logInfoList = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _setLogNumber(Context ctx, int logNum) throws BOSException {
        Object object = lock;
        synchronized (object) {
            if (logNumber != logNum) {
                logNumber = logNum;
                if (logInfoList != null) {
                    logInfoList.clear();
                }
                logInfoList = new ArrayList(logNumber);
            }
        }
    }

    @Override
    protected int _getTotalNumber(Context ctx, int flag) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String strSelect = null;
        if (flag == 1) {
            strSelect = new String("select count(*) from T_LOG_App");
        } else if (flag == 2) {
            strSelect = new String("select count(*) from T_LOG_His");
        }
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(strSelect);
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
                stmt = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getLogInfoList(Context ctx, int flag, String filter, int endRecordNo, int lines) throws BOSException {
        List logInfoList = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String table = null;
        if (flag == 1) {
            table = "T_LOG_App";
        } else if (flag == 2) {
            table = "T_LOG_His";
        }
        StringBuffer strSelect = new StringBuffer();
        Locale currentLocale = ctx.getLocale();
        if (new Locale("L1").equals(currentLocale)) {
            strSelect.append("select b.FUserName, b.FCompanyName_L1, b.FClientIP, b.FClientName, ").append("b.FEntityAlias_L1, b.FInstanceNo, b.FAlias_L1, b.FOccurTime, b.ftype ").append("from (select top " + lines).append(" a.fid, a.FUserName, a.FCompanyName_L1, a.FClientIP, a.FClientName, ").append("a.FEntityAlias_L1, a.FInstanceNo, a.FAlias_L1, a.FOccurTime, a.ftype ").append("from (select top ").append(endRecordNo).append(" logs.fid, logs.FUserName, logs.FCompanyName_L1, logs.FClientIP, logs.FClientName, ").append("logs.FEntityAlias_L1, logs.FInstanceNo, item.FAlias_L1, logs.FOccurTime, item.ftype ").append("FROM T_LOG_LogItem AS item ").append("RIGHT OUTER JOIN ").append(table).append(" AS logs ").append("ON item.FName = logs.FItemName ").append("ORDER BY logs.FOccurTime DESC) as a ").append("order by a.foccurtime) as b ").append("order by b.foccurtime desc");
        } else if (new Locale("L2").equals(currentLocale)) {
            strSelect.append("select b.FUserName, b.FCompanyName_L2, b.FClientIP, b.FClientName, ").append("b.FEntityAlias_L2, b.FInstanceNo, b.FAlias_L2, b.FOccurTime, b.ftype ").append("from (select top " + lines).append(" a.fid, a.FUserName, a.FCompanyName_L2, a.FClientIP, a.FClientName, ").append("a.FEntityAlias_L2, a.FInstanceNo, a.FAlias_L2, a.FOccurTime, a.ftype ").append("from (select top ").append(endRecordNo).append(" logs.fid, logs.FUserName, logs.FCompanyName_L2, logs.FClientIP, logs.FClientName, ").append("logs.FEntityAlias_L2, logs.FInstanceNo, item.FAlias_L2, logs.FOccurTime, item.ftype ").append("FROM T_LOG_LogItem AS item ").append("RIGHT OUTER JOIN ").append(table).append(" AS logs ").append("ON item.FName = logs.FItemName ").append("ORDER BY logs.FOccurTime DESC) as a ").append("order by a.foccurtime) as b ").append("order by b.foccurtime desc");
        } else if (new Locale("L3").equals(currentLocale)) {
            strSelect.append("select b.FUserName, b.FCompanyName_L3, b.FClientIP, b.FClientName, ").append("b.FEntityAlias_L3, b.FInstanceNo, b.FAlias_L3, b.FOccurTime, b.ftype ").append("from (select top " + lines).append(" a.fid, a.FUserName, a.FCompanyName_L3, a.FClientIP, a.FClientName, ").append("a.FEntityAlias_L3, a.FInstanceNo, a.FAlias_L3, a.FOccurTime, a.ftype ").append("from (select top ").append(endRecordNo).append(" logs.fid, logs.FUserName, logs.FCompanyName_L3, logs.FClientIP, logs.FClientName, ").append("logs.FEntityAlias_L3, logs.FInstanceNo, item.FAlias_L3, logs.FOccurTime, item.ftype ").append("FROM T_LOG_LogItem AS item ").append("RIGHT OUTER JOIN ").append(table).append(" AS logs ").append("ON item.FName = logs.FItemName ").append("ORDER BY logs.FOccurTime DESC) as a ").append("order by a.foccurtime) as b ").append("order by b.foccurtime desc");
        }
        Object object = lock;
        synchronized (object) {
            try {
                conn = this.getConnection(ctx);
                stmt = conn.createStatement();
                rs = stmt.executeQuery(strSelect.toString());
                logInfoList = AppLogControllerBean.getLogInfoList();
                while (rs.next()) {
                    LogInfo logInfo = new LogInfo();
                    logInfo.setUserName(rs.getString(1) == null ? "" : rs.getString(1));
                    logInfo.setCompanyName(rs.getString(2) == null ? "" : rs.getString(2));
                    logInfo.setClientIP(rs.getString(3) == null ? "" : rs.getString(3));
                    logInfo.setClientName(rs.getString(4) == null ? "" : rs.getString(4));
                    logInfo.setEntityAlias(rs.getString(5) == null ? "" : rs.getString(5));
                    logInfo.setInstanceNo(rs.getString(6) == null ? "" : rs.getString(6));
                    logInfo.setItemAlias(rs.getString(7) == null ? "" : rs.getString(7));
                    logInfo.setOccurTime(rs.getTimestamp(8) == null ? null : rs.getTimestamp(8));
                    logInfo.setItemType(rs.getInt(9));
                    logInfoList.add(logInfo);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                    rs = null;
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                    stmt = null;
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                    conn = null;
                }
            }
            return logInfoList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getLogInfoListBetween(Context ctx, int flag, String filter, int startRecordNo, int endRecordNo) throws BOSException {
        List logInfoList = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String table = null;
        if (flag == 1) {
            table = "T_LOG_App";
        } else if (flag == 2) {
            table = "T_LOG_His";
        }
        StringBuffer selectSql = new StringBuffer("SELECT TOP ");
        selectSql.append(endRecordNo);
        Locale currentLocale = ctx.getLocale();
        if (new Locale("L1").equals(currentLocale)) {
            selectSql.append(" logs.FUserName, logs.FCompanyName_L1, logs.FClientIP, logs.FClientName, ");
            selectSql.append("logs.FEntityAlias_L1, logs.FInstanceNo, case when logs.FMethodDescription_L1 is not null and logs.FMethodDescription_L1 <> '' then logs.FMethodDescription_L1 else item.FAlias_L1 end, logs.FOccurTime, item.ftype ");
        } else if (new Locale("L2").equals(currentLocale)) {
            selectSql.append(" logs.FUserName, logs.FCompanyName_L2, logs.FClientIP, logs.FClientName, ");
            selectSql.append("logs.FEntityAlias_L2, logs.FInstanceNo, case when logs.FMethodDescription_L2 is not null and logs.FMethodDescription_L2 <> '' then logs.FMethodDescription_L2 else item.FAlias_L2 end, logs.FOccurTime, item.ftype ");
        } else if (new Locale("L3").equals(currentLocale)) {
            selectSql.append(" logs.FUserName, logs.FCompanyName_L3, logs.FClientIP, logs.FClientName, ");
            selectSql.append("logs.FEntityAlias_L3, logs.FInstanceNo, case when logs.FMethodDescription_L3 is not null and logs.FMethodDescription_L1 <> '' then logs.FMethodDescription_L3 else item.FAlias_L3 end, logs.FOccurTime, item.ftype ");
        }
        selectSql.append("FROM ");
        selectSql.append(table);
        selectSql.append(" AS logs ");
        selectSql.append("LEFT OUTER JOIN T_LOG_LogItem  AS item ");
        selectSql.append("ON item.FName = logs.FItemName ");
        selectSql.append("LEFT OUTER JOIN T_PM_USER  AS users ");
        selectSql.append("ON logs.FUserID = users.FID ");
        if (filter != null && filter.trim().length() != 0 && filter.indexOf("Item") == -1) {
            selectSql.append("WHERE ");
            selectSql.append(this.replaceFieldName(ctx, filter));
        }
        selectSql.append(" ORDER BY logs.FOccurTime DESC");
        Object object = lock;
        synchronized (object) {
            try {
                conn = this.getConnection(ctx);
                stmt = conn.createStatement();
                rs = stmt.executeQuery(selectSql.toString());
                for (int i = 1; i < startRecordNo; ++i) {
                    rs.next();
                }
                logInfoList = AppLogControllerBean.getLogInfoList();
                while (rs.next()) {
                    LogInfo logInfo = new LogInfo();
                    logInfo.setUserName(rs.getString(1) == null ? "" : rs.getString(1));
                    logInfo.setCompanyName(rs.getString(2) == null ? "" : rs.getString(2));
                    logInfo.setClientIP(rs.getString(3) == null ? "" : rs.getString(3));
                    logInfo.setClientName(rs.getString(4) == null ? "" : rs.getString(4));
                    logInfo.setEntityAlias(rs.getString(5) == null ? "" : rs.getString(5));
                    logInfo.setInstanceNo(rs.getString(6) == null ? "" : rs.getString(6));
                    logInfo.setItemAlias(rs.getString(7) == null ? "" : rs.getString(7));
                    logInfo.setOccurTime(rs.getTimestamp(8) == null ? null : rs.getTimestamp(8));
                    logInfo.setItemType(rs.getInt(9));
                    logInfoList.add(logInfo);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                    rs = null;
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                    stmt = null;
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                    conn = null;
                }
            }
            return logInfoList;
        }
    }

    @Override
    public void writeLog(Context ctx, HashMap logDatas) throws BOSException {
        this._writeLog(ctx, logDatas);
    }

    @Override
    protected void _writeLog(Context ctx, String itemName, IObjectValue info) throws BOSException {
        ItemInfo item = this.validateLogItemName(ctx, itemName);
        AppLogInfo model = (AppLogInfo)info;
        model.setLogItem(item);
        item.getAppLogs().add(model);
        if (model.getId() == null) {
            super.addnew(ctx, model);
        } else {
            super.addnew(ctx, (IObjectPK)new ObjectUuidPK(model.getId().toString()), model);
        }
    }

    @Override
    protected void _writeLog(Context ctx, HashMap logData) throws BOSException {
        block45: {
            if (!this.isSychronizedLogMode(logData) && LogQueue.getInstance().size() < 1024) {
                logData.put("context", ctx);
                LogQueue.getInstance().enqueue(logData);
            } else {
                Connection conn = this.getConnection(ctx);
                Statement stmtIns = null;
                Statement stmtUpdate = null;
                try {
                    if (logData.get("FID") == null) {
                        return;
                    }
                    boolean isSuccessed = false;
                    if (logData.get("isSuccessed") != null) {
                        isSuccessed = (Boolean)logData.get("isSuccessed");
                    }
                    if (!isSuccessed) {
                        String instanceNo;
                        StringBuffer strIns = new StringBuffer("INSERT INTO T_LOG_App");
                        strIns.append("(FID, FUserID, ");
                        strIns.append("FUserName, FUserType_L1, FUserType_L2, FUserType_L3, ");
                        strIns.append("FOccurTime, FClientIP, FClientName, FEntityID, FEntityName, ");
                        strIns.append("FEntityAlias_L1, FEntityAlias_L2, FEntityAlias_L3, FMethodName, ");
                        strIns.append("FMethodAlias_L1, FMethodAlias_L2, FMethodAlias_L3, FInstanceID, FInstanceNo, ");
                        strIns.append("FCompanyName_L1, FCompanyName_L2, FCompanyName_L3, ");
                        strIns.append("FItemName, FUserNumber, FCUID, FInstanceDetail, FIsSuccessed,FMethodDescription_L1,FMethodDescription_L2,FMethodDescription_L3) ");
                        strIns.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                        stmtIns = conn.prepareStatement(strIns.toString());
                        stmtIns.setString(1, logData.get("FID").toString());
                        stmtIns.setString(2, logData.get("FUserID") == null ? "" : logData.get("FUserID").toString());
                        stmtIns.setString(3, logData.get("FUserName") == null ? "" : logData.get("FUserName").toString());
                        stmtIns.setString(4, logData.get("FUserType_L1") == null ? "" : logData.get("FUserType_L1").toString());
                        stmtIns.setString(5, logData.get("FUserType_L2") == null ? "" : logData.get("FUserType_L2").toString());
                        stmtIns.setString(6, logData.get("FUserType_L3") == null ? "" : logData.get("FUserType_L3").toString());
                        stmtIns.setTimestamp(7, (Timestamp)logData.get("FOccurTime"));
                        stmtIns.setString(8, logData.get("FClientIP") == null ? "" : logData.get("FClientIP").toString());
                        stmtIns.setString(9, logData.get("FClientName") == null ? "" : logData.get("FClientName").toString());
                        stmtIns.setString(10, logData.get("FEntityID") == null ? "" : logData.get("FEntityID").toString());
                        stmtIns.setString(11, logData.get("FEntityName") == null ? "" : logData.get("FEntityName").toString());
                        stmtIns.setString(12, logData.get("FEntityAlias_L1") == null ? "" : logData.get("FEntityAlias_L1").toString());
                        stmtIns.setString(13, logData.get("FEntityAlias_L2") == null ? "" : logData.get("FEntityAlias_L2").toString());
                        stmtIns.setString(14, logData.get("FEntityAlias_L3") == null ? "" : logData.get("FEntityAlias_L3").toString());
                        stmtIns.setString(15, logData.get("FMethodName") == null ? "" : logData.get("FMethodName").toString());
                        stmtIns.setString(16, logData.get("FMethodAlias_L1") == null ? "" : logData.get("FMethodAlias_L1").toString());
                        stmtIns.setString(17, logData.get("FMethodAlias_L2") == null ? "" : logData.get("FMethodAlias_L2").toString());
                        stmtIns.setString(18, logData.get("FMethodAlias_L3") == null ? "" : logData.get("FMethodAlias_L3").toString());
                        stmtIns.setString(19, logData.get("FInstanceID") == null ? "" : logData.get("FInstanceID").toString());
                        String string = instanceNo = logData.get("FInstanceNo") == null ? "" : logData.get("FInstanceNo").toString();
                        if (instanceNo.length() >= 1200) {
                            instanceNo = instanceNo.substring(0, 1199);
                        }
                        stmtIns.setString(20, instanceNo);
                        stmtIns.setString(21, logData.get("FCompanyName_L1") == null ? "" : logData.get("FCompanyName_L1").toString());
                        stmtIns.setString(22, logData.get("FCompanyName_L2") == null ? "" : logData.get("FCompanyName_L2").toString());
                        stmtIns.setString(23, logData.get("FCompanyName_L3") == null ? "" : logData.get("FCompanyName_L3").toString());
                        if (logData.get("FItemName") == null) {
                            throw new BOSException(Resource.MUST_BIND_ONE_LOGITEM);
                        }
                        stmtIns.setString(24, logData.get("FItemName").toString());
                        stmtIns.setString(25, logData.get("FUserNumber") == null ? "" : logData.get("FUserNumber").toString());
                        stmtIns.setString(26, logData.get("FCUID") == null ? "" : logData.get("FCUID").toString());
                        byte[] detail = null;
                        if (logData.get("FInstanceDetail") != null) {
                            try {
                                detail = logData.get("FInstanceDetail").toString().getBytes("UTF-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        } else {
                            try {
                                detail = logData.get("FInstanceNo") == null ? null : logData.get("FInstanceNo").toString().getBytes("UTF-8");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                        stmtIns.setBytes(27, detail);
                        if (logData.get("successed") != null && ((Boolean)logData.get("successed")).booleanValue()) {
                            stmtIns.setInt(28, 1);
                        } else {
                            stmtIns.setInt(28, 0);
                        }
                        stmtIns.setString(29, logData.get("FMethodDescription_L1") == null ? "" : logData.get("FMethodDescription_L1").toString());
                        stmtIns.setString(30, logData.get("FMethodDescription_L2") == null ? "" : logData.get("FMethodDescription_L2").toString());
                        stmtIns.setString(31, logData.get("FMethodDescription_L3") == null ? "" : logData.get("FMethodDescription_L3").toString());
                        stmtIns.execute();
                        break block45;
                    }
                    if (logData.get("fInstanceNo") != null) {
                        String sql = "UPDATE T_LOG_App SET FIsSuccessed = 1, FInstanceNo = ? WHERE FID=?";
                        stmtIns = conn.prepareStatement(sql);
                        stmtIns.setString(1, logData.get("FInstanceNo").toString());
                        stmtIns.setString(2, logData.get("FID").toString());
                    } else {
                        String sql = "UPDATE T_LOG_App SET FIsSuccessed = 1 WHERE FID=?";
                        stmtIns = conn.prepareStatement(sql);
                        stmtIns.setString(1, logData.get("FID").toString());
                    }
                    stmtIns.execute();
                    LogDetailUtils.extractAndWriteLog(ctx, (String)logData.get("FID"), (Map)logData.get("appLogDetail"));
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (BOSException be) {
                    throw be;
                }
                finally {
                    if (stmtIns != null) {
                        try {
                            stmtIns.close();
                        }
                        catch (Exception exception) {}
                        stmtIns = null;
                    }
                    if (stmtUpdate != null) {
                        try {
                            stmtUpdate.close();
                        }
                        catch (Exception exception) {}
                        stmtUpdate = null;
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception exception) {}
                        conn = null;
                    }
                }
            }
        }
    }

    private boolean isSychronizedLogMode(HashMap logData) {
        Object obj;
        return logData != null && (obj = logData.get("LOG_HIDDEN_WRITE_MODE")) != null && obj.toString().equals("LOG_HIDDEN_WRITE_MODE");
    }

    @Override
    protected IObjectPK _writeLog(Context ctx, String methodName, BOSObjectType bizObjType, IObjectPK instancePK, String instanceDetail) throws BOSException {
        return this.writeLogWithDesc(ctx, methodName, bizObjType, instancePK, instanceDetail, null);
    }

    private IObjectPK writeLogWithDesc(Context ctx, String methodName, BOSObjectType bizObjType, IObjectPK instancePK, String instanceDetail, String methodDescription) throws BOSException {
        int logItemLevel = LogServerUtil.getLogItemLevel(ctx, "manual_default_logitem");
        int levelSetting = LogServerUtil.getCurrentLevelSetting(ctx);
        if (levelSetting == 3 && logItemLevel != 64) {
            return null;
        }
        if (levelSetting == 2 && logItemLevel == 256) {
            return null;
        }
        HashMap<String, String> hashLog = new HashMap<String, String>();
        hashLog.put("FEntityID", bizObjType.toString());
        LogServerUtil.setEntityAlias(ctx, bizObjType, hashLog);
        hashLog.put("FMethodName", methodName);
        hashLog.put("FMethodAlias_" + ctx.getLocale().toString().toUpperCase(), methodName);
        hashLog.put("FInstanceID", (String)instancePK);
        hashLog.put("FInstanceNo", instanceDetail);
        hashLog.put("FIsSuccessed", "0");
        hashLog.put("FItemName", "manual_default_logitem");
        LogServerUtil.setLogInfo(null, ctx, hashLog);
        this.putMethodDesc(hashLog, ctx, methodDescription);
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        this._writeLog(ctx, hashLog);
        return new ObjectUuidPK(BOSUuid.read((String)hashLog.get("FID").toString()));
    }

    private void putMethodDesc(Map hashLog, Context ctx, String methodDescription) {
        SolutionInfo soInfo = AppLogControllerBean.getSolutionInfo(ctx);
        LanguageCollection lC = soInfo.getLanguages();
        for (int i = 0; i < lC.size(); ++i) {
            LanguageInfo lInfo = lC.get(i);
            String key = "FMethodDescription_" + lInfo.getPostfix().toUpperCase();
            if (lInfo.getLocaleString().equals(Locale.TRADITIONAL_CHINESE.toString())) {
                hashLog.put(key, STConverter.sc2tc((String)methodDescription));
                continue;
            }
            if (lInfo.getLocaleString().equals(Locale.SIMPLIFIED_CHINESE.toString())) {
                hashLog.put(key, STConverter.tc2sc((String)methodDescription));
                continue;
            }
            hashLog.put(key, methodDescription);
        }
    }

    @Override
    protected IObjectPK _writeLog(Context ctx, String methodName, BOSObjectType bizObjType, IObjectPK instancePK, String instanceDetail, String logItemName) throws BOSException {
        int logItemLevel = LogServerUtil.getLogItemLevel(ctx, logItemName);
        int levelSetting = LogServerUtil.getCurrentLevelSetting(ctx);
        if (levelSetting == 3 && logItemLevel != 64) {
            return null;
        }
        if (levelSetting == 2 && logItemLevel == 256) {
            return null;
        }
        HashMap<String, String> hashLog = new HashMap<String, String>();
        hashLog.put("FEntityID", bizObjType.toString());
        LogServerUtil.setEntityAlias(ctx, bizObjType, hashLog);
        hashLog.put("FMethodName", methodName);
        hashLog.put("FMethodAlias_" + ctx.getLocale().toString().toUpperCase(), methodName);
        hashLog.put("FInstanceID", (String)instancePK);
        hashLog.put("FInstanceNo", instanceDetail);
        hashLog.put("FIsSuccessed", "0");
        hashLog.put("FItemName", logItemName);
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        LogServerUtil.setLogInfo(null, ctx, hashLog);
        this._writeLog(ctx, hashLog);
        return new ObjectUuidPK(BOSUuid.read((String)hashLog.get("FID").toString()));
    }

    protected IRowSet _getLogs(Context ctx, EntityViewInfo view) throws BOSException {
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _dump(Context ctx, int days) throws BOSException, LogException {
        Connection cn = null;
        Date currentDate = new Date(System.currentTimeMillis());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(currentDate);
        cal.set(5, cal.get(5) - days + 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date dumpDate = cal.getTime();
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (!AppLogHelper.requestMutex(ctx)) {
                throw new BOSException(Resource.IS_STORING_NOW + Resource.PLEASE_TRY_LATER);
            }
            cn = this.getConnection(ctx);
            String strIns = "INSERT INTO T_Log_His SELECT * FROM T_Log_App WHERE FOccurTime < {ts'" + formater.format(dumpDate) + "'}";
            String strDel = "DELETE FROM T_Log_App WHERE FOccurTime < {ts'" + formater.format(dumpDate) + "'}";
            SQLUtils.execute((Connection)cn, (String)strIns);
            SQLUtils.execute((Connection)cn, (String)strDel);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                AppLogHelper.releaseMutex(ctx);
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        AppLogHelper.releaseMutex(ctx);
        SQLUtils.cleanup((Connection)cn);
    }

    @Override
    protected void _dump(Context ctx) throws BOSException, LogException {
        this._dump(ctx, 0);
    }

    @Override
    protected void _dumpManual(Context ctx) throws BOSException, LogException {
        this._dump(ctx);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _setDumpPolicy(Context ctx, int upperLimit) throws BOSException, LogException {
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (!AppLogHelper.requestMutex(ctx)) {
                throw new LogException(LogException.NOWDUMPTOWAIT);
            }
            if (upperLimit < 0) {
                throw new LogException(LogException.STOREITEMMUSTBIGGERTHANONE);
            }
            cn = this.getConnection(ctx);
            String sql = "UPDATE T_LOG_DumpPolicy set FUpperLimit=?";
            stmt = cn.prepareStatement(sql);
            stmt.setInt(1, upperLimit);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                AppLogHelper.releaseMutex(ctx);
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        AppLogHelper.releaseMutex(ctx);
        SQLUtils.cleanup(rs);
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Connection)cn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int _getDumpPolicy(Context ctx) throws BOSException {
        int n;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            String sql = "SELECT * FROM T_LOG_DumpPolicy";
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            int upperLimit = 0;
            if (rs.next()) {
                if (rs.getInt(3) == 1) {
                    upperLimit = rs.getInt(1);
                }
            } else {
                sql = "INSERT INTO T_LOG_DumpPolicy (FUpperLimit, FIsDumping, FIsValidate) VALUES (?,?,?)";
                stmt = cn.prepareStatement(sql);
                stmt.setInt(1, 0);
                stmt.setInt(2, 0);
                stmt.setInt(3, 1);
                stmt.execute();
            }
            n = upperLimit;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Connection)cn);
        return n;
    }

    @Override
    protected void _deleteFromHistory(Context ctx, String id) throws BOSException {
    }

    @Override
    protected IObjectCollection _getLogItem(Context ctx, String itemName) throws BOSException {
        throw new BOSException(" useless method !");
    }

    private ItemInfo validateLogItemName(Context ctx, String itemName) throws BOSException {
        ItemCollection col = this.getLogItem(ctx, itemName.trim());
        if (col.size() == 0 || col.size() > 1) {
            throw new BOSException(Resource.CANNOT_FIND_ITEMINFO_BY_ITEMNAME);
        }
        return col.get(0);
    }

    @Override
    protected void _delete(Context ctx, Date startDate, Date endDate) throws BOSException {
        try {
            SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            StringBuffer delAppLogSql = new StringBuffer();
            delAppLogSql.append("DELETE FROM T_Log_App WHERE FID in (");
            delAppLogSql.append("SELECT FID From T_Log_App ");
            delAppLogSql.append("WHERE ");
            delAppLogSql.append("FOccurTime >= ");
            delAppLogSql.append("{ts'");
            Date tempDate = this.setDateToSpecificTime(startDate, 0, 0, 0);
            delAppLogSql.append(formater.format(tempDate)).append("'}  AND  ");
            tempDate = this.setDateToSpecificTime(endDate, 23, 59, 59);
            delAppLogSql.append("FOccurTime <= ");
            delAppLogSql.append("{ts'");
            delAppLogSql.append(formater.format(tempDate)).append("'})");
            String userName = ctx.getUserName();
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo("select id where number = '" + userName + "'");
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            String[] cus = LogServerUtil.getAdminCUs(ctx, (IObjectPK)userPK);
            if (cus != null && cus.length > 0) {
                delAppLogSql.append(" AND FCUID in (");
                for (int i = 0; i < cus.length; ++i) {
                    if (i < cus.length - 1) {
                        delAppLogSql.append("'").append(cus[i]).append("', ");
                        continue;
                    }
                    delAppLogSql.append("'").append(cus[i]).append("')");
                }
            }
            DbUtil.execute((Context)ctx, (String)delAppLogSql.toString());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private Date setDateToSpecificTime(Date date, int hour, int min, int sec) {
        if (date == null || hour > 24 || hour < 0 || min > 59 || min < 0 || sec > 59 || sec < 0) {
            return date;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        return cal.getTime();
    }

    @Override
    protected int _getLogNumberBetweenDates(Context ctx, int flag, Date fromDate, Date toDate) throws BOSException {
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer selectSql = new StringBuffer();
        if (flag == 1) {
            selectSql.append("SELECT COUNT(*) From T_Log_App ");
        } else {
            selectSql.append("SELECT COUNT(*) From T_Log_His ");
        }
        selectSql.append(" Where ");
        selectSql.append(" FOccurTime>=");
        selectSql.append("{ts'");
        Date tempDate = this.setDateToSpecificTime(fromDate, 0, 0, 0);
        selectSql.append(formater.format(tempDate)).append("'}  And  ");
        tempDate = this.setDateToSpecificTime(toDate, 23, 59, 59);
        selectSql.append(" FOccurTime<=");
        selectSql.append("{ts'");
        selectSql.append(formater.format(tempDate)).append("'} ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            rowSet.next();
            return rowSet.getInt(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected int _getLogNumberByFilter(Context ctx, int flag, String filter) throws BOSException {
        StringBuffer selectSql = new StringBuffer();
        if (flag == 1) {
            selectSql.append("SELECT COUNT(*) From T_Log_App logs LEFT OUTER JOIN T_Log_LogItem logItem ON logs.FItemName = logItem.FName LEFT OUTER JOIN T_PM_USER users ON logs.FUserID = users.FID ");
        } else {
            selectSql.append("SELECT COUNT(*) From T_Log_His logs LEFT OUTER JOIN T_Log_LogItem logItem ON logs.FItemName = logItem.FName LEFT OUTER JOIN T_PM_USER users ON logs.FUserID = users.FID ");
        }
        if (filter != null && filter.trim().length() != 0) {
            selectSql.append("WHERE ");
            selectSql.append(this.replaceFieldName(ctx, filter));
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectSql.toString());
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
                stmt = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
                conn = null;
            }
        }
    }

    private String replaceFieldName(Context ctx, String filter) {
        if (filter == null || filter.trim().length() == 0) {
            return filter;
        }
        String str = filter;
        boolean found = true;
        while (found) {
            found = false;
            int i = str.indexOf("companyName");
            if (i != -1) {
                if (new Locale("L1").equals(ctx.getLocale())) {
                    str = str.substring(0, i) + "logs.FCompanyName_L1" + str.substring(i + "companyName".length());
                }
                if (new Locale("L2").equals(ctx.getLocale())) {
                    str = str.substring(0, i) + "logs.FCompanyName_L2" + str.substring(i + "companyName".length());
                }
                if (new Locale("L3").equals(ctx.getLocale())) {
                    str = str.substring(0, i) + "logs.FCompanyName_L3" + str.substring(i + "companyName".length());
                }
                found = true;
            }
            if ((i = str.indexOf("userNumber")) != -1) {
                str = str.substring(0, i) + "logs.FUserNumber" + str.substring(i + "userNumber".length());
                found = true;
            }
            if ((i = str.indexOf("userName")) != -1) {
                str = str.substring(0, i) + "logs.FUserName" + str.substring(i + "userName".length());
                found = true;
            }
            if ((i = str.indexOf("userType")) != -1) {
                if (new Locale("L1").equals(ctx.getLocale())) {
                    str = str.substring(0, i) + "logs.FUserType_L1" + str.substring(i + "userType".length());
                }
                if (new Locale("L2").equals(ctx.getLocale())) {
                    str = str.substring(0, i) + "logs.FUserType_L2" + str.substring(i + "userType".length());
                }
                if (new Locale("L3").equals(ctx.getLocale())) {
                    str = str.substring(0, i) + "logs.FUserType_L3" + str.substring(i + "userType".length());
                }
                found = true;
            }
            if ((i = str.indexOf("occurTime")) != -1) {
                String temp = str.substring(i + "occurTime".length());
                str = str.substring(0, i) + "logs.FOccurTime";
                str = str + temp;
                found = true;
            }
            if ((i = str.indexOf("clientIP")) != -1) {
                str = str.substring(0, i) + "logs.FClientIP" + str.substring(i + "clientIP".length());
                found = true;
            }
            if ((i = str.indexOf("clientName")) != -1) {
                str = str.substring(0, i) + "logs.FClientName" + str.substring(i + "clientName".length());
                found = true;
            }
            if ((i = str.indexOf("entityAlias")) != -1) {
                if (new Locale("L1").equals(ctx.getLocale())) {
                    str = str.substring(0, i) + "logs.FEntityAlias_L1" + str.substring(i + "entityAlias".length());
                }
                if (new Locale("L2").equals(ctx.getLocale())) {
                    str = str.substring(0, i) + "logs.FEntityAlias_L2" + str.substring(i + "entityAlias".length());
                }
                if (new Locale("L3").equals(ctx.getLocale())) {
                    str = str.substring(0, i) + "logs.FEntityAlias_L3" + str.substring(i + "entityAlias".length());
                }
                found = true;
            }
            if ((i = str.indexOf("methodAlias")) != -1) {
                if (new Locale("L1").equals(ctx.getLocale())) {
                    str = str.substring(0, i) + "logs.FMethodAlias_L1" + str.substring(i + "methodAlias".length());
                }
                if (new Locale("L2").equals(ctx.getLocale())) {
                    str = str.substring(0, i) + "logs.FMethodAlias_L2" + str.substring(i + "methodAlias".length());
                }
                if (new Locale("L3").equals(ctx.getLocale())) {
                    str = str.substring(0, i) + "logs.FMethodAlias_L3" + str.substring(i + "methodAlias".length());
                }
                found = true;
            }
            if ((i = str.indexOf("instanceNo")) != -1) {
                str = str.substring(0, i) + "logs.FInstanceNo" + str.substring(i + "instanceNo".length());
                found = true;
            }
            if ((i = str.indexOf("isSuccessed")) != -1) {
                str = str.substring(0, i) + "logs.FIsSuccessed" + str.substring(i + "isSuccessed".length());
                found = true;
            }
            if ((i = str.indexOf("cuID")) != -1) {
                str = str.substring(0, i) + "logs.FCUID" + str.substring(i + "cuID".length());
                found = true;
            }
            if ((i = str.indexOf("userID.bizAdmin")) != -1) {
                str = str.substring(0, i) + "users.FIsBizAdmin" + str.substring(i + "userID.bizAdmin".length());
                found = true;
            }
            if ((i = str.indexOf("userID.type")) != -1) {
                str = str.substring(0, i) + "users.FType" + str.substring(i + "userID.type".length());
                found = true;
            }
            if ((i = str.indexOf("userID.id")) != -1) {
                str = str.substring(0, i) + "users.Fid" + str.substring(i + "userID.id".length());
                found = true;
            }
            if ((i = str.indexOf("Item.type")) != -1) {
                str = str.substring(0, i) + "logItem.FType" + str.substring(i + "Item.type".length());
                found = true;
            }
            if ((i = str.indexOf("Item.alias")) == -1) continue;
            if (new Locale("L1").equals(ctx.getLocale())) {
                str = str.substring(0, i) + "logItem.FAlias_L1" + str.substring(i + "Item.alias".length());
            }
            if (new Locale("L2").equals(ctx.getLocale())) {
                str = str.substring(0, i) + "logItem.FAlias_L2" + str.substring(i + "Item.alias".length());
            }
            if (new Locale("L3").equals(ctx.getLocale())) {
                str = str.substring(0, i) + "logItem.FAlias_L3" + str.substring(i + "Item.alias".length());
            }
            found = true;
        }
        return str;
    }

    @Override
    protected void _upateLogStatus(Context ctx, IObjectPK pk) throws BOSException {
        if (pk != null) {
            String sql = "update t_log_app set FIsSuccessed = 1 where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getInstanceDetail(Context ctx, String id, int flag) throws BOSException {
        StringBuffer resultStr = new StringBuffer();
        StringBuffer selectSql = new StringBuffer("SELECT log.FInstanceDetail, log.FInstanceNo , det.faddmap,det.fupdatemap,det.fdeletemap FROM ");
        if (flag == 1) {
            selectSql.append("T_LOG_App log ");
        } else {
            selectSql.append("T_LOG_His log ");
        }
        selectSql.append(" left join t_log_detail det on det.flogid = log.fid ");
        selectSql.append(" WHERE log.FID = '").append(id).append("'");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectSql.toString());
            if (rs.next()) {
                byte[] detail = rs.getBytes(1);
                if (detail == null) {
                    resultStr.append(rs.getString(2));
                } else {
                    resultStr.append(new String(detail, "UTF-8"));
                }
                resultStr.append("\n");
                if (rs.getBytes(3) != null) {
                    resultStr.append(new String(rs.getBytes(3), "UTF-8"));
                    resultStr.append("======================== \n");
                }
                if (rs.getBytes(4) != null) {
                    resultStr.append(new String(rs.getBytes(4), "UTF-8"));
                    resultStr.append("======================== \n");
                }
                if (rs.getBytes(5) != null) {
                    resultStr.append(new String(rs.getBytes(5), "UTF-8"));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
                stmt = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
                conn = null;
            }
        }
        return resultStr.toString();
    }

    private static LogItemCollection removeDumplicatedItems(LogItemCollection itemCol) {
        LogItemCollection itemCollection = new LogItemCollection();
        HashMap<String, String> tempitemidMap = new HashMap<String, String>();
        HashMap<String, String> tempFnameMap = new HashMap<String, String>();
        for (int i = 0; i < itemCol.size(); ++i) {
            if (tempitemidMap.containsKey(itemCol.get(i).getInnerID().toString()) || tempFnameMap.containsKey(itemCol.get(i).getName())) continue;
            itemCollection.add(itemCol.get(i));
            tempitemidMap.put(itemCol.get(i).getInnerID().toString(), "");
            tempFnameMap.put(itemCol.get(i).getName(), "");
        }
        tempitemidMap = null;
        tempFnameMap = null;
        return itemCollection;
    }

    @Override
    protected void _sycLogItems(Context ctx) throws BOSException, EASBizException {
        com.kingdee.bos.service.log.define.LogInfo log = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getLog();
        if (log == null) {
            throw new BOSException("Log Service Err: cannot get log metadata from MetaDataLoaderFactory!");
        }
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            AppLogControllerBean.deployDB(ctx, cn, log);
            this.updateLogItemEn_UsLanguage(ctx);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private void updateLogItemEn_UsLanguage(Context ctx) throws BOSException {
        String language = "en_US";
        Boolean isAllUpdate = Boolean.FALSE;
        ArrayList<String> tables = new ArrayList<String>();
        tables.add("T_LOG_LOGITEM");
        try {
            BOSObjectType type = BOSObjectType.create((String)"A0D1CC9D");
            String methodName = "updateMLFieldResource";
            Object[] args = new Object[]{language, isAllUpdate, tables};
            DynamicObjectFactory.getLocalInstance((Context)ctx).invoke(type, methodName, args);
        }
        catch (Exception e) {
            logger.error((Object)"Update permission item english name failed.");
            logger.error((Object)e);
        }
    }

    private static void deployDB(Context ctx, Connection cn, com.kingdee.bos.service.log.define.LogInfo log) throws BOSException {
        PreparedStatement insertStmt = null;
        try {
            String sql = "DELETE FROM T_LOG_LogItem";
            PreparedStatement stmt = cn.prepareStatement(sql);
            stmt.execute();
            SQLUtils.cleanup((Statement)stmt);
            LanguageCollection langCol = AppLogControllerBean.getLanguages(ctx);
            LanguageInfo defaultLang = AppLogControllerBean.getDefaultLanguage(ctx);
            Locale defaultLocale = new Locale(defaultLang.getPostfix(), "");
            String insertSQL = AppLogControllerBean.getInsertSQL(langCol);
            insertStmt = cn.prepareStatement(insertSQL);
            LogItemCollection itemCol = log.getLogItems();
            LogItemCollection noDumplicateItem = AppLogControllerBean.removeDumplicatedItems(itemCol);
            LogItemInfo item = null;
            for (int i = 0; i < noDumplicateItem.size(); ++i) {
                item = noDumplicateItem.get(i);
                item.setDefaultLocale(defaultLocale);
                StringBuffer message = new StringBuffer().append("Inserted LogItem's info: ");
                insertStmt.setString(1, item.getInnerID());
                message.append("FitemID(" + item.getInnerID() + ")");
                insertStmt.setString(2, item.getName());
                message.append(", FName(" + item.getName() + ")");
                insertStmt.setInt(3, item.getType());
                message.append(", FType(" + item.getType() + ")");
                insertStmt.setInt(4, item.getLevel());
                message.append(", FLevel(" + item.getLevel() + ")");
                int index = 1;
                int n = langCol.size();
                for (int j = 0; j < n; ++j) {
                    LanguageInfo langInfo = langCol.get(j);
                    String postfix = langInfo.getPostfix();
                    Locale locale = new Locale(postfix, "");
                    Locale originalLocale = langInfo.getOriginalLocale();
                    insertStmt.setString(4 + index, item.getAlias(originalLocale));
                    message.append(", FAlias_" + locale + "(" + item.getAlias(originalLocale) + ")");
                    insertStmt.setString(4 + ++index, item.getDescription(originalLocale));
                    message.append(", FDescription_" + locale + "(" + item.getDescription(originalLocale) + ")");
                    insertStmt.setString(4 + ++index, item.getGroup(originalLocale));
                    message.append(", FGroup_" + locale + "(" + item.getGroup(originalLocale) + ")");
                    ++index;
                }
                insertStmt.addBatch();
                if ((i + 1) % 1000 != 0) continue;
                insertStmt.executeBatch();
            }
            insertStmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(insertStmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)insertStmt);
    }

    private static String getInsertSQL(LanguageCollection langCol) {
        StringBuffer sql = new StringBuffer().append("INSERT INTO T_LOG_LogItem(FLogItemID, FName, FType, FLevel, ");
        int n = langCol.size();
        for (int i = 0; i < n; ++i) {
            LanguageInfo langInfo = langCol.get(i);
            String postfix = langInfo.getPostfix();
            String itemAlias = "FAlias_" + postfix;
            sql.append(itemAlias);
            sql.append(", ");
            String itemDesc = "FDescription_" + postfix;
            sql.append(itemDesc);
            sql.append(", ");
            String itemGroup = "FGroup_" + postfix;
            sql.append(itemGroup);
            if (i == n - 1) continue;
            sql.append(", ");
        }
        sql.append(" ) VALUES (");
        int itemNum = 4 + 3 * langCol.size();
        for (int i = 0; i < itemNum; ++i) {
            sql.append("?");
            if (i == itemNum - 1) continue;
            sql.append(", ");
        }
        sql.append(")");
        return sql.toString();
    }

    private static void executeInsertSQL(Context ctx, PreparedStatement stmt, LogItemInfo logItem, LanguageCollection langCol) throws SQLException {
        StringBuffer message = new StringBuffer().append("Inserted LogItem's info: ");
        stmt.setString(1, logItem.getInnerID());
        message.append("FLogItemID(" + logItem.getInnerID() + ")");
        stmt.setString(2, logItem.getName());
        message.append(", FName(" + logItem.getName() + ")");
        stmt.setInt(3, logItem.getType());
        message.append(", FType(" + logItem.getType() + ")");
        stmt.setInt(4, logItem.getLevel());
        message.append(", FLevel(" + logItem.getLevel() + ")");
        int index = 1;
        int n = langCol.size();
        for (int i = 0; i < n; ++i) {
            LanguageInfo langInfo = langCol.get(i);
            String postfix = langInfo.getPostfix();
            Locale locale = new Locale(postfix, "");
            stmt.setString(4 + index, logItem.getAlias(locale));
            message.append(", FAlias_" + locale + "(" + logItem.getAlias(locale) + ")");
            stmt.setString(4 + ++index, logItem.getDescription(locale));
            message.append(", FDescription_" + locale + "(" + logItem.getDescription(locale) + ")");
            stmt.setString(4 + ++index, logItem.getGroup(locale));
            message.append(", FGroup_" + locale + "(" + logItem.getGroup(locale) + ")");
            ++index;
        }
    }

    private static LanguageCollection getLanguages(Context ctx) throws BOSException {
        SolutionCtrl ctrl = new SolutionCtrl(ctx);
        SolutionInfo solutionInfo = ctrl.getValue();
        LanguageCollection langs = solutionInfo.getLanguages();
        return langs;
    }

    private static LanguageInfo getDefaultLanguage(Context ctx) throws BOSException {
        SolutionCtrl ctrl = new SolutionCtrl(ctx);
        SolutionInfo solutionInfo = ctrl.getValue();
        return solutionInfo.getDefaultLanguage();
    }

    @Override
    protected int _getLogLevel(Context ctx) throws BOSException {
        String selectSql = "SELECT FLevel FROM T_LOG_LogSetting";
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(selectSql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            String insertSql = "INSERT INTO T_LOG_LogSetting (FLevel) VALUES (1)";
            pstmt = conn.prepareStatement(insertSql);
            pstmt.executeUpdate();
            int n = 1;
            return n;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sQLException) {}
                pstmt = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
                conn = null;
            }
        }
    }

    @Override
    protected void _setLogLevel(Context ctx, int level) throws BOSException {
        String selectSql = "SELECT FLevel FROM T_LOG_LogSetting";
        String insertSql = "INSERT INTO T_LOG_LogSetting (FLevel) VALUES (?)";
        String updateSql = "UPDATE T_LOG_LogSetting SET FLevel = ?";
        Connection conn = null;
        Statement stmt = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectSql);
            if (rs.next()) {
                pstmt = conn.prepareStatement(updateSql);
                pstmt.setInt(1, level);
                pstmt.executeUpdate();
            } else {
                pstmt = conn.prepareStatement(insertSql);
                pstmt.setInt(1, level);
                pstmt.executeUpdate();
            }
            LogServerUtil.setCurrentLevelSetting(ctx, level);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
                stmt = null;
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sQLException) {}
                pstmt = null;
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
                conn = null;
            }
        }
    }

    @Override
    protected IObjectPK _writeLog(Context ctx, String methodName, BOSObjectType bizObjectType, IObjectPK instancePK, String instanceDetail, String logItemName, String companyId) throws BOSException {
        return this._writeLog(ctx, methodName, bizObjectType, instancePK, instanceDetail, logItemName, companyId, null);
    }

    private static SolutionInfo getSolutionInfo(Context ctx) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        SolutionInfo soInfo = loader.getSolution();
        return soInfo;
    }

    @Override
    protected IObjectPK _writeLog(Context ctx, String methodName, BOSObjectType bizObjectType, IObjectPK instancePK, String instanceDetail, String logItemName, String companyId, String methodDescription) throws BOSException {
        int logItemLevel = LogServerUtil.getLogItemLevel(ctx, logItemName);
        int levelSetting = LogServerUtil.getCurrentLevelSetting(ctx);
        if (levelSetting == 3 && logItemLevel != 64) {
            return null;
        }
        if (levelSetting == 2 && logItemLevel == 256) {
            return null;
        }
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        hashLog.put("FEntityID", StringUtils.cnulls((Object)bizObjectType));
        LogServerUtil.setEntityAlias(ctx, bizObjectType, hashLog);
        hashLog.put("FMethodName", methodName);
        hashLog.put("FMethodAlias_" + ctx.getLocale().toString().toUpperCase(), methodName);
        hashLog.put("FInstanceID", instancePK);
        hashLog.put("FInstanceNo", instanceDetail);
        hashLog.put("FIsSuccessed", "0");
        hashLog.put("FItemName", logItemName);
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        LogServerUtil.setLogInfo(null, ctx, hashLog);
        OrgUnitInfo orgInfo = null;
        try {
            orgInfo = OrgUnitCommonFactory.getLocalInstance((Context)ctx).getOrgUnit(BOSUuid.read((String)companyId));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        SolutionInfo soluctionInfo = AppLogControllerBean.getSolutionInfo(ctx);
        if (orgInfo != null && soluctionInfo != null) {
            String strKey = "FCompanyName_";
            LanguageCollection langCol = soluctionInfo.getLanguages();
            String strDefPostfix = soluctionInfo.getDefaultLanguage().getPostfix();
            for (int i = 0; i < langCol.size(); ++i) {
                LanguageInfo langInfo = langCol.get(i);
                String key = strKey + langInfo.getPostfix().toUpperCase();
                if (langInfo.getPostfix().equals(strDefPostfix)) {
                    if (orgInfo == null) {
                        hashLog.put(key, "");
                        continue;
                    }
                    hashLog.put(key, orgInfo.getName());
                    continue;
                }
                if (orgInfo == null) {
                    hashLog.put(key, "");
                    continue;
                }
                hashLog.put(key, orgInfo.get("name", langInfo.getLocale()));
            }
        }
        this.putMethodDesc(hashLog, ctx, methodDescription);
        this._writeLog(ctx, hashLog);
        return new ObjectUuidPK(BOSUuid.read((String)hashLog.get("FID").toString()));
    }

    @Override
    protected IObjectPK _writeLogWithDescription(Context ctx, String methodName, BOSObjectType bizObjType, IObjectPK instancePK, String instanceDetail, String methodDescription) throws BOSException {
        return this.writeLogWithDesc(ctx, methodName, bizObjType, instancePK, instanceDetail, methodDescription);
    }

    private static class Lock {
        private Lock() {
        }
    }
}

