/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.util.Serialization;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.FunctionHelper;
import com.kingdee.bos.workflow.ext.app.Sql;
import com.kingdee.bos.workflow.monitor.app.DynamicWfService;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.participant.PositionInfo;
import com.kingdee.bos.workflow.service.IDynamicWfService;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.wfdesigner.service.ParticipantHelper;
import com.kingdee.eas.base.multiapprove.IAppendActivityUIFacade;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppendActivityUIFacade
implements IAppendActivityUIFacade {
    Context ctx;

    public AppendActivityUIFacade(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public boolean saveAsTemplate(HashMap map) throws Exception {
        String templateName = (String)map.get("templateName");
        String procDefId = (String)map.get("procDefId");
        Object activities = map.get("activities");
        Object appendMode = map.get("appendMode");
        Object routeMode = map.get("routeMode");
        Boolean abortCurrentActivity = Boolean.valueOf((String)map.get("abortCurrentActivity"));
        boolean isAppended = Boolean.valueOf((String)map.get("appendNode"));
        String actDefId = (String)map.get("actDefId");
        String personId = (String)map.get("personId");
        String temp = (String)map.get("isPublic");
        boolean isPublic = Boolean.valueOf(temp);
        templateName = templateName.trim().replaceAll("'", "");
        String sql = "select fid from t_wfr_appendacttmp where fprocDefId='" + procDefId + "' and fName='" + templateName + "'";
        sql = "insert into t_wfr_appendacttmp(fid,fProcDefId,fActDefId,fOwner,fIsPublic,fName,fTemplate) values(?, ?, ?, ?, ?, ?, ?)";
        Object[] template = new Object[]{activities, appendMode, routeMode, abortCurrentActivity};
        Object[] values = new Object[]{Uuid.randomUUID().toString() + "APACTTMP", procDefId, isAppended ? "APPENDED" : actDefId, personId, isPublic ? "Y" : "N", templateName, Serialization.toBytes((Object)template)};
        int[] types = new int[]{12, 12, 12, 12, 12, 12, -3};
        SQL.executeUpdate((Context)this.ctx, (String)sql, (int[])types, (Object[])values);
        return true;
    }

    @Override
    public List getAllTemplate(HashMap map) throws BOSException {
        String procDefId = (String)map.get("procDefId");
        boolean isAppended = Boolean.valueOf((String)map.get("appendNode"));
        String actDefId = (String)map.get("actDefId");
        String personId = (String)map.get("personId");
        String sql = "select fid,fname,fowner from t_wfr_appendacttmp where  fprocdefid='" + procDefId + "'  and factdefid='" + (isAppended ? "APPENDED" : actDefId) + "' and (fowner='" + personId + "' or fispublic='Y')";
        return Sql.query((Context)this.ctx, (String)sql);
    }

    @Override
    public void removeTemplate(String sql) throws BOSException {
        SQL.executeUpdate((Context)this.ctx, (String)sql);
    }

    @Override
    public Object[] loadTemplate(String sql) throws BOSException {
        Object o = Sql.getObject((Context)this.ctx, (String)sql);
        if (o != null) {
            return (Object[])Serialization.fromBytes((byte[])((byte[])o));
        }
        return null;
    }

    @Override
    public boolean appendActivity(HashMap map) throws BOSException {
        boolean flag = true;
        try {
            DynamicWfService svc = new DynamicWfService(this.ctx);
            String assignId = (String)map.get("assignId");
            IDynamicWfService.DynamicActivityDef[] activities = (IDynamicWfService.DynamicActivityDef[])map.get("activities");
            String appendMode = (String)map.get("appendMode");
            String routeMode = (String)map.get("routeMode");
            String temp = (String)map.get("abortCurrentActivity");
            boolean abortCurrentActivity = Boolean.valueOf(temp);
            svc.appendActivity(assignId, activities, appendMode, routeMode, abortCurrentActivity);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPositionByPersonId(String personId) throws Exception {
        ParticipantHelper helper;
        PositionInfo[] info;
        if (personId == null) {
            return "";
        }
        String positionName = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select p.fname_");
        sb.append(this.ctx.getLocale().getLanguage());
        sb.append(" FNAME from t_org_positionmember pm inner join t_org_position p on pm.fpositionid = p.fid");
        sb.append(" where fisPrimary =1 and pm.fpersonid = '");
        sb.append(personId);
        sb.append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
            if (rs.next()) {
                positionName = rs.getString("FNAME");
            }
        }
        catch (BOSException bOSException) {
        }
        catch (SQLException sQLException) {}
        if (positionName == null && (info = (helper = new ParticipantHelper(this.ctx)).getPositionArrayByEmployeeId(personId)).length > 0) {
            PositionInfo position = info[0];
            positionName = position.getName(this.ctx.getLocale());
        }
        return positionName;
    }

    @Override
    public String getBillName(String billId) throws Exception {
        BOSUuid id = BOSUuid.read((String)billId);
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)this.ctx, (BOSObjectType)id.getType());
        if (entity == null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"Billnotexist");
            throw new WfException("{" + id.getType() + "}" + msg);
        }
        return entity.getAlias(this.ctx.getLocale());
    }

    @Override
    public String getBillDetail(String billId) throws Exception {
        IObjectValue value = FunctionHelper.createObjectValueByBoId((String)billId, (Context)this.ctx);
        String name = value.getString("name");
        if (name == null) {
            name = value.getString("name_" + this.ctx.getLocale().toString());
        }
        String number = value.getString("number");
        if (name == null) {
            if (number == null) {
                return "";
            }
            return number;
        }
        if (number == null) {
            return name;
        }
        return name + "(" + number + ")";
    }

    @Override
    public Map<String, Object> initLock(Map<String, Object> params) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        String assignId = (String)params.get("assignId");
        AssignmentInfo info = svc.getAssignmentById(assignId);
        data.put("AssignmentInfo", info);
        Person person = (Person)params.get("person");
        Person holder = svc.lock(info.getProcInstId(), person);
        data.put("holder", holder);
        return data;
    }
}

