/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.UIConfSolutionInfo;
import com.kingdee.bos.workflow.biz.trans.Waf2UIConfSolutionInfo;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.service.ormrpc.IUIConfSolutionProvider;
import com.kingdee.eas.base.uict.BizConfigureCollection;
import com.kingdee.eas.base.uict.BizConfigureFactory;
import com.kingdee.eas.base.uict.BizConfigureInfo;
import com.kingdee.eas.base.uict.IBizConfigure;
import com.kingdee.eas.ep.EditUIConfigureCollection;
import com.kingdee.eas.ep.EditUIConfigureFactory;
import com.kingdee.eas.ep.EditUIConfigureInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class UIConfSolutionProvider
implements IUIConfSolutionProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIConfSolutionInfo[] getUIConfSolutionInfos(Context ctx, String orgID, String uiFullName) throws WfException {
        if (ConfigLoader.getConfig4Server().isDEPEnableInUIConfig()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo item = new FilterItemInfo("UIObjectPK", (Object)uiFullName, CompareType.EQUALS);
            filterInfo.getFilterItems().add(item);
            view.setFilter(filterInfo);
            try {
                EditUIConfigureCollection collection = EditUIConfigureFactory.getLocalInstance((Context)ctx).getEditUIConfigureCollection(view);
                ArrayList<UIConfSolutionInfo> tempList = new ArrayList<UIConfSolutionInfo>();
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    EditUIConfigureInfo editUIConfigureInfo = collection.get(i);
                    UIConfSolutionInfo info = new UIConfSolutionInfo();
                    info.setId(editUIConfigureInfo.getId().toString());
                    info.setName(editUIConfigureInfo.getName());
                    info.setDescription(editUIConfigureInfo.getDescription());
                    tempList.add(info);
                }
                return tempList.toArray(new UIConfSolutionInfo[tempList.size()]);
            }
            catch (BOSException e) {
                throw new WfException((Throwable)e);
            }
        }
        try {
            IBizConfigure iBizConfigure = BizConfigureFactory.getLocalInstance((Context)ctx);
            BizConfigureCollection collection = iBizConfigure.getBizConfigureCollection("SELECT id, name, description WHERE UIObjectPK = '" + uiFullName + "' AND Used = 1 AND (CU.id = '" + orgID + "' OR AssignOrgs LIKE ('%" + orgID + "%'))");
            ArrayList<UIConfSolutionInfo> list = new ArrayList<UIConfSolutionInfo>();
            String localStr = ctx.getLocale().getDisplayName();
            String sql = "select configure.fid ,configure.fname_" + localStr + ",configure.fdescription_" + localStr + " from T_UCT_OrgUict  org , T_UCT_BizConfigure configure   where configure.fid=org.fconfigureid and (configure.fuiobjectpk=? or configure.flistuiobjectpk=?) and org.forgid=?";
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                con = EJBFactory.getConnection((Context)ctx);
                ps = this.innerPrepareStatement(sql, con);
                ps.setString(1, uiFullName);
                ps.setString(2, uiFullName);
                ps.setString(3, orgID);
                rs = ps.executeQuery();
                while (rs.next()) {
                    UIConfSolutionInfo info = new UIConfSolutionInfo();
                    info.setId(rs.getString(1));
                    info.setName(rs.getString(2));
                    info.setDescription(rs.getString(3));
                    list.add(info);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
            ArrayList<UIConfSolutionInfo> tempList = new ArrayList<UIConfSolutionInfo>();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                BizConfigureInfo bizConfigureInfo = collection.get(i);
                UIConfSolutionInfo info = new UIConfSolutionInfo();
                info.setId(bizConfigureInfo.getId().toString());
                info.setName(bizConfigureInfo.getName());
                info.setDescription(bizConfigureInfo.getDescription());
                tempList.add(info);
            }
            tempList.addAll(list);
            return tempList.toArray(new UIConfSolutionInfo[tempList.size()]);
        }
        catch (Exception e) {
            throw new WfException((Throwable)e);
        }
    }

    public Waf2UIConfSolutionInfo[] getWaf2UIConfSolutionInfos(Context ctx, String orgID, String[] entityObjectNames) throws WfException {
        StringBuilder values = new StringBuilder();
        int length = entityObjectNames.length;
        for (int i = 0; i < length; ++i) {
            values.append("?,");
        }
        values = values.deleteCharAt(values.length() - 1);
        String sql = "select dynamiccfg.Fid,dynamiccfg.FName_l2,dynamiccfg.FDescription_l2,dynamiccfg.FWebUIObjectName,dynamiccfg.FPageType from T_DYN_DynamicConfigure dynamiccfg where FPageType in ('edit','view','custom','list') and  FentityObjectName in (" + values.toString() + ")";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Waf2UIConfSolutionInfo> list = new ArrayList<Waf2UIConfSolutionInfo>();
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = this.innerPrepareStatement(sql, con);
            int length2 = entityObjectNames.length;
            for (int i = 0; i < length2; ++i) {
                ps.setString(i + 1, entityObjectNames[i]);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Waf2UIConfSolutionInfo info = new Waf2UIConfSolutionInfo();
                info.setId(rs.getString(1));
                info.setName(rs.getString(2));
                info.setDescription(rs.getString(3));
                info.setUipk(rs.getString(4));
                info.setPageType(rs.getString(5));
                list.add(info);
            }
        }
        catch (SQLException e) {
            try {
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return list.toArray(new Waf2UIConfSolutionInfo[list.size()]);
    }

    private PreparedStatement innerPrepareStatement(String sql, Connection con) throws SQLException {
        return con.prepareStatement(sql);
    }

    public UIConfSolutionInfo getUIConfSolutionInfo(Context ctx, String uiConfSolutionID) throws WfException {
        if (ConfigLoader.getConfig4Server().isDEPEnableInUIConfig()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo item = new FilterItemInfo("id", (Object)uiConfSolutionID, CompareType.EQUALS);
            filterInfo.getFilterItems().add(item);
            view.setFilter(filterInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("description"));
            view.setSelector(sic);
            try {
                EditUIConfigureCollection collection = EditUIConfigureFactory.getLocalInstance((Context)ctx).getEditUIConfigureCollection(view);
                EditUIConfigureInfo editUIConfigureInfo = null;
                if (collection != null && collection.size() > 0) {
                    editUIConfigureInfo = collection.get(0);
                    UIConfSolutionInfo confSolutionInfo = new UIConfSolutionInfo();
                    confSolutionInfo.setId(editUIConfigureInfo.getId().toString());
                    confSolutionInfo.setName(editUIConfigureInfo.getName());
                    confSolutionInfo.setDescription(editUIConfigureInfo.getDescription());
                    return confSolutionInfo;
                }
                return null;
            }
            catch (BOSException e) {
                throw new WfException((Throwable)e);
            }
        }
        try {
            IBizConfigure iBizConfigure = BizConfigureFactory.getLocalInstance((Context)ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("description"));
            entityViewInfo.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)uiConfSolutionID));
            entityViewInfo.setFilter(filterInfo);
            BizConfigureCollection collection = iBizConfigure.getBizConfigureCollection(entityViewInfo);
            BizConfigureInfo bizConfigureInfo = null;
            if (collection != null && collection.size() > 0) {
                bizConfigureInfo = collection.get(0);
                UIConfSolutionInfo confSolutionInfo = new UIConfSolutionInfo();
                confSolutionInfo.setId(bizConfigureInfo.getId().toString());
                confSolutionInfo.setName(bizConfigureInfo.getName());
                confSolutionInfo.setDescription(bizConfigureInfo.getDescription());
                return confSolutionInfo;
            }
            return null;
        }
        catch (BOSException e) {
            throw new WfException((Throwable)e);
        }
    }

    public Waf2UIConfSolutionInfo getWaf2UIConfSolutionInfo(Context ctx, String solutionID) throws WfException {
        String sql = "select dynamiccfg.Fid,dynamiccfg.FName_l2,dynamiccfg.FDescription_l2,dynamiccfg.FWebUIObjectName,dynamiccfg.fPageType from T_DYN_DynamicConfigure dynamiccfg where dynamiccfg.Fid=?";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Waf2UIConfSolutionInfo info = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = this.innerPrepareStatement(sql, con);
            ps.setString(1, solutionID);
            rs = ps.executeQuery();
            while (rs.next()) {
                info = new Waf2UIConfSolutionInfo();
                info.setId(rs.getString(1));
                info.setName(rs.getString(2));
                info.setDescription(rs.getString(3));
                info.setUipk(rs.getString(4));
                info.setPageType(rs.getString(5));
            }
        }
        catch (SQLException e) {
            try {
                throw new WfException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return info;
    }
}

