/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.app.fastui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ParticipantCollection;
import com.kingdee.bos.workflow.define.ParticipantDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.ext.AbstractWfNextPersonExt;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.ext.IWfNextPersonExt;
import com.kingdee.bos.workflow.monitor.WfProcessDiagram;
import com.kingdee.bos.workflow.participant.ParticipantUtils;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ApproveUtil {
    private IWfNextPersonExt ext;
    private Context ctx;

    public ApproveUtil(Context ctx) {
        this.ctx = ctx;
    }

    public Map getApproveParams(String assignId) throws Exception {
        String str;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo assign = svc.getAssignmentById(assignId);
        Map attributes = svc.getExtendedAttributesFromActivityInst(assign.getActInstId());
        ProcessDef def = svc.getProcessDefByDefineHashValue(assign.getProcDefHashValue());
        ArrayList decisionItems = this.getDecisionItems(assign, def);
        attributes.put("decisions", decisionItems);
        ApproveActivityDef actDef = (ApproveActivityDef)def.getActivityDef(assign.getActDefId());
        attributes.put("canSpecifyNextPerformer", actDef.canSpecifyNextActivityPerformer());
        String opinion = this.getDefaultOpinion(def, actDef);
        attributes.put("defaultOpinion", opinion);
        boolean alwaysSetNextPersons = ConfigLoader.getConfig4Server().getBoolean("always.set.next.persons", assign.getBizObjectIds(), "false");
        if (alwaysSetNextPersons || "true".equals(attributes.get("alwaysSetNextPersons"))) {
            attributes.put("alwaysSetNextPersons", "true");
            Map item = (Map)decisionItems.get(0);
            String associatedLine = (String)item.get("associatedLine");
            ArrayList nextActs = new ArrayList();
            this.findNextActsAndPersons(svc, assign, def, associatedLine, nextActs);
            attributes.put("nextActs", nextActs);
        }
        if (!StringUtils.isEmpty((String)(str = ParamManager.getParamValue((Context)this.ctx, null, (String)"isOpenMessageSendOnUI"))) && "true".equals(str)) {
            attributes.put("isSendSMS", "true");
            attributes.put("isSendMail", "true");
        }
        return attributes;
    }

    public List findPostParticipants(String assignId, String associatedLine) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        ArrayList nextActs = new ArrayList();
        AssignmentInfo assign = svc.getAssignmentById(assignId);
        ProcessDef def = svc.getProcessDefByDefineHashValue(assign.getProcDefHashValue());
        this.findNextActsAndPersons(svc, assign, def, associatedLine, nextActs);
        return nextActs;
    }

    private void findNextActsAndPersons(IEnactmentService svc, AssignmentInfo assign, ProcessDef def, String associatedLine, ArrayList nextActs) throws BOSException, WfException, Exception {
        this.initNextPersonExt(assign);
        HashMap[] acts = this.searchNextActs(assign, associatedLine);
        if (acts.length == 0) {
            return;
        }
        this.calcAllNextParticipants(svc, assign, def, nextActs, acts);
    }

    private void calcAllNextParticipants(IEnactmentService svc, AssignmentInfo assign, ProcessDef def, ArrayList nextActs, HashMap[] acts) throws Exception {
        for (int k = 0; k < acts.length; ++k) {
            ManpowerActivityDef manActDef;
            ActivityDef actDef = (ActivityDef)acts[k].get("actDef");
            if (!(actDef instanceof ManpowerActivityDef) || this.ext.isIgnore(manActDef = (ManpowerActivityDef)actDef, assign.getAssignmentId(), null)) continue;
            String key = ParticipantUtils.createDesignatePerformerKey((ActivityDef)manActDef);
            List persons = this.calcParticipants(svc, assign, def, key, manActDef);
            Map candidates = this.eliminateDuplicatedPersons(persons);
            HashMap nextAct = this.assembleActAndPersonInfo(manActDef, key, candidates);
            nextActs.add(nextAct);
        }
    }

    private List calcParticipants(IEnactmentService svc, AssignmentInfo assign, ProcessDef def, String key, ManpowerActivityDef manActDef) throws Exception {
        List personIds = (List)svc.getProcessContext(assign.getProcInstId(), key);
        List persons = personIds == null || personIds.size() == 0 ? this.estimateParticipants(svc, assign, def, manActDef) : this.retrieveParticipants(svc, personIds);
        return persons;
    }

    private List retrieveParticipants(IEnactmentService svc, List personIds) throws Exception {
        ArrayList<Person> persons = new ArrayList<Person>();
        for (int i = 0; i < personIds.size(); ++i) {
            String personId = (String)personIds.get(i);
            Person[] tmp = svc.getPersonByPersonID(personId);
            for (int j = 0; j < tmp.length; ++j) {
                persons.add(tmp[j]);
            }
        }
        return persons;
    }

    private List estimateParticipants(IEnactmentService svc, AssignmentInfo assign, ProcessDef def, ManpowerActivityDef manActDef) throws Exception {
        ArrayList participants = this.getParticipantDefs(assign, manActDef);
        List persons = this.participantsToPersons(svc, assign, def, manActDef, participants);
        this.appendAdditionalPersons(svc, assign, manActDef, persons);
        return persons;
    }

    private void appendAdditionalPersons(IEnactmentService svc, AssignmentInfo assign, ManpowerActivityDef manActDef, List persons) throws Exception {
        String[] addedPersons = this.ext.getAddedCandidates(manActDef, assign.getAssignmentId(), null);
        if (addedPersons != null) {
            for (int i = 0; i < addedPersons.length; ++i) {
                Person[] tmp = svc.getPersonByPersonID(addedPersons[i]);
                for (int j = 0; j < tmp.length; ++j) {
                    persons.add(tmp[j]);
                }
            }
        }
    }

    private List participantsToPersons(IEnactmentService svc, AssignmentInfo assign, ProcessDef def, ManpowerActivityDef manActDef, ArrayList participants) throws WfException {
        String hashCode = ((ProcessDef)manActDef.getContainer()).getHashValue();
        List persons = hashCode.equals(def.getHashValue()) ? svc.getPersonsByParticipants(assign.getProcInstId(), manActDef.getID(), (List)participants) : svc.getPersonsByDefParticipants(hashCode, manActDef.getID(), (List)participants, this.ctx.getCaller().toString());
        return persons;
    }

    private ArrayList getParticipantDefs(AssignmentInfo assign, ManpowerActivityDef manActDef) {
        ArrayList<String> participants = new ArrayList<String>();
        ParticipantCollection pc = manActDef.getParticipants();
        for (int i = 0; i < pc.size(); ++i) {
            ParticipantDef p = pc.get(i);
            if (this.ext.isIgnore(p, assign.getAssignmentId(), null)) continue;
            participants.add(p.getID());
        }
        return participants;
    }

    private HashMap assembleActAndPersonInfo(ManpowerActivityDef manActDef, String key, Map candidates) {
        HashMap<String, Object> nextAct = new HashMap<String, Object>();
        nextAct.put("persons", candidates);
        nextAct.put("actKey", key);
        nextAct.put("actId", manActDef.getID());
        nextAct.put("actName", manActDef.getName(this.ctx.getLocale()));
        nextAct.put("isAllPersonAsPerformer", manActDef.isAllPersonAsPerformer());
        return nextAct;
    }

    private Map eliminateDuplicatedPersons(List persons) {
        HashMap<String, String> candidates = new HashMap<String, String>();
        for (int i = 0; i < persons.size(); ++i) {
            Person p = (Person)persons.get(i);
            candidates.put(p.getEmployeeId(), p.getEmployeeName(this.ctx.getLocale()));
        }
        return candidates;
    }

    private HashMap[] searchNextActs(AssignmentInfo assign, String associatedLine) throws BOSException {
        WfProcessDiagram diag = new WfProcessDiagram(this.ctx, associatedLine);
        String[] actIds = new String[]{assign.getActInstId()};
        HashMap[] acts = diag.findNextManpownerActivities(actIds);
        return acts;
    }

    private void initNextPersonExt(AssignmentInfo assign) {
        String billId = assign.getBizObjectIds();
        this.ext = ConfigLoader.getConfig4Server().getWfNextPersonExt(this.ctx, billId);
        if (this.ext == null) {
            this.ext = new AbstractWfNextPersonExt(this.ctx);
        }
    }

    private String getDefaultOpinion(ProcessDef def, ApproveActivityDef actDef) throws WfException {
        String opinion = "";
        ActualParameterCollection aParams = actDef.getActualParameters();
        if (aParams != null) {
            for (int i = 0; i < aParams.size(); ++i) {
                DataFieldDef dfDef;
                ActualParameterDef param = aParams.get(i);
                String name = param.getDataFieldName((ActivityDef)actDef);
                if (name == null || !name.startsWith("defaultOpinion") || (dfDef = def.getDataFieldDef(param.getExpr())) == null) continue;
                opinion = dfDef.getInitValue();
                break;
            }
        }
        return opinion;
    }

    private ArrayList getDecisionItems(AssignmentInfo assign, ProcessDef def) {
        String decisions = this.getDecisionText(assign, def);
        ArrayList<Map> decisionItems = new ArrayList<Map>();
        if (decisions != null && decisions.trim().length() > 0) {
            this.parseDecisionText(decisions, decisionItems);
        } else {
            decisionItems.add(this.toMap("0", "\u65e0", "true", "\u540c\u610f", "", true));
            decisionItems.add(this.toMap("0", "\u65e0", "false", "\u4e0d\u540c\u610f", "", true));
        }
        return decisionItems;
    }

    private void parseDecisionText(String decisions, ArrayList decisionItems) {
        String[] items = StringUtils.split((String)decisions, (String)":");
        for (int i = 0; i < items.length; ++i) {
            String line;
            String[] itemRow = StringUtils.split((String)items[i], (String)";");
            String key = itemRow[0];
            String text = itemRow[1];
            String type = itemRow.length == 2 ? "\u5168\u90e8" : itemRow[2];
            String string = line = itemRow.length < 4 ? "" : itemRow[3];
            if (type.equals("\u540c\u610f")) {
                decisionItems.add(this.toMap(key, text, "true", "\u540c\u610f", line, false));
                continue;
            }
            if (type.equals("\u4e0d\u540c\u610f")) {
                decisionItems.add(this.toMap(key, text, "false", "\u4e0d\u540c\u610f", line, false));
                continue;
            }
            if (!type.equals("\u5168\u90e8")) continue;
            decisionItems.add(this.toMap(key, text, "true", "\u540c\u610f", line, true));
            decisionItems.add(this.toMap(key, text, "false", "\u4e0d\u540c\u610f", line, true));
        }
    }

    private Map toMap(String key, String text, String result, String title, String associatedLine, boolean isAll) {
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("decisionKey", key);
        item.put("decisionText", text);
        item.put("approveResult", result);
        item.put("associatedLine", associatedLine);
        if (!isAll) {
            title = text;
        } else if (!text.equals("\u65e0") && text.length() > 0) {
            title = title + "\uff0c" + text;
        }
        item.put("title", title);
        return item;
    }

    private String getDecisionText(AssignmentInfo assign, ProcessDef def) {
        ApproveActivityDef actDef = (ApproveActivityDef)def.getActivityDef(assign.getActDefId());
        String decisions = actDef.getManualDecisionItems(this.ctx.getLocale());
        if (StringUtils.isEmpty((String)decisions) && StringUtils.isEmpty((String)(decisions = actDef.getManualDecisionItems()))) {
            decisions = actDef.getManualDecisionItems(new Locale("l2"));
        }
        ExtendedAttributeCollection eac = actDef.getActivityHeader().getExtendedAttributes();
        ExtendedAttributeDef ead = null;
        if (StringUtils.isEmpty((String)decisions)) {
            ead = eac.get("manualDecisionItems");
            decisions = ead != null ? ead.getValue() : null;
        }
        return decisions;
    }

    public boolean submit(Map approve, List nextActs) throws Exception {
        String assignId = (String)approve.get("assignId");
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo assign = svc.getAssignmentById(assignId);
        if (nextActs != null) {
            for (int i = 0; i < nextActs.size(); ++i) {
                Map act = (Map)nextActs.get(i);
                String key = (String)act.get("actKey");
                Map persons = (Map)act.get("persons");
                ArrayList personIds = new ArrayList();
                for (Map.Entry person : persons.entrySet()) {
                    if (person.getValue() == null || "".equals(person.getValue())) continue;
                    personIds.add(person.getKey());
                }
                svc.setProcessContext(assign.getProcInstId(), key, personIds);
            }
        }
        MultiApproveInfo info = new MultiApproveInfo();
        info.setAssignment(assignId);
        info.setBillId(BOSUuid.read((String)assign.getBizObjectIds()));
        info.setExtendedProperty("businuessObjectId", assign.getBizObjectIds());
        info.setExtendedProperty("assignmentID", assignId);
        info.setExtendedProperty("isAddNew", "isAddNew");
        boolean isSendSMS = "true".equals(approve.get("isSendSMS"));
        boolean isSendMail = "true".equals(approve.get("isSendMail"));
        info.setIsMailNotifyNext(isSendMail);
        info.setIsMobelNotifyNext(isSendSMS);
        info.setOpinion((String)approve.get("opinion"));
        String result = (String)approve.get("approveResult");
        info.setIsPass(ApproveResult.getEnum(result));
        String handlerOpinion = (String)approve.get("handlerOpinion");
        info.setHandlerOpinion(Integer.parseInt(handlerOpinion));
        String handlerContent = (String)approve.get("handlerContent");
        info.setHandlerContent(handlerContent);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        try {
            MultiApproveFactory.getLocalInstance(this.ctx).submit((CoreBaseInfo)info);
            return true;
        }
        catch (AlreadyInProcessQueueException e) {
            throw new Exception("\u4efb\u52a1\u5df2\u5904\u7406\u6216\u5de5\u4f5c\u6d41\u5fd9\uff0c\u8bf7\u5237\u65b0\u4efb\u52a1\u5217\u8868\u540e\u91cd\u8bd5\uff01");
        }
    }
}

