/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.ext.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.AssignmentEvent;
import com.kingdee.bos.workflow.enactment.IWfAssignment;
import com.kingdee.bos.workflow.enactment.handler.AbstractAssignmentEventHandler;
import com.kingdee.bos.workflow.engine.core.thread.WfJobHandler;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.multiapprove.ext.app.AutoApproveHandler;
import com.kingdee.eas.base.multiapprove.ext.app.AutoApproveHandler2;
import com.kingdee.util.LocaleUtils;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AutoApprove
extends AbstractAssignmentEventHandler {
    protected static final Logger logger = Logger.getLogger(AutoApprove.class);
    public static final String VAR_AutoApproveDelay = "AutoApproveDelay";
    public static final String VAR_IsAutoApprove = "IsAutoApprove";
    private static SecureRandom r = new SecureRandom();
    private static final long serialVersionUID = -6950957563327584805L;

    private static synchronized int rand() {
        return r.nextInt(200);
    }

    public void execute(AssignmentEvent event, IWfAssignment assignment) {
        try {
            this.handle(assignment);
        }
        catch (Throwable t) {
            logger.error((Object)("create job for auto approve failed, assign: " + assignment.getAssignmentInfo().getAssignmentId()), t);
        }
    }

    private void handle(IWfAssignment assignment) throws Exception {
        String autoApprove;
        AssignmentInfo assign = assignment.getAssignmentInfo();
        if (!"MultiApproveUIFunction".equals(assign.getBizFunction())) {
            return;
        }
        Object tmp = assignment.getActivity().getProcess().getDataField(VAR_IsAutoApprove);
        String string = autoApprove = tmp == null ? "false" : tmp.toString();
        if (!"true".equals(autoApprove)) {
            return;
        }
        Context ctx = Ctx.generateContext((String)assignment.getContext().getAIS(), (String)assign.getUserId(), null, null);
        String language = ctx.getLocale().getLanguage();
        ctx.setLocale(new Locale(language));
        String agreeAuto = "";
        String none = "";
        if (language.equals(LocaleUtils.locale_L2.toString()) || language.equals(LocaleUtils.locale_l2.toString()) || language.equals("zh_CN".toString())) {
            agreeAuto = "\u540c\u610f\uff08\u81ea\u52a8\u5ba1\u6279\uff09";
            none = "\u65e0";
        } else if (language.equals(LocaleUtils.locale_L3.toString()) || language.equals(LocaleUtils.locale_l3.toString()) || language.equals("zh_TW".toString())) {
            agreeAuto = "\u540c\u610f\uff08\u81ea\u52d5\u5be9\u6279\uff09";
            none = "\u7121";
        } else {
            agreeAuto = "agree(auto approve)";
            none = "none";
        }
        String opinion = ConfigLoader.getConfig4Server().getString("auto.approve.opinion", assign.getBizObjectIds(), agreeAuto);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setAssignment(assign.getAssignmentId());
        info.setBillId(BOSUuid.read((String)assign.getBizObjectIds()));
        info.setExtendedProperty("businuessObjectId", assign.getBizObjectIds());
        info.setExtendedProperty("assignmentID", assign.getAssignmentId());
        info.setExtendedProperty("isAddNew", "isAddNew");
        info.setIsMailNotifyNext(false);
        info.setIsMobelNotifyNext(false);
        info.setOpinion(opinion);
        info.setIsPass(ApproveResult.PASS);
        info.setHandlerOpinion(0);
        info.setHandlerContent(none);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        AutoApproveHandler2 h = new AutoApproveHandler2(info, assign.getProcInstId(), assign.getUserId());
        if (WfJobHandler.join((WfJobHandler)h)) {
            return;
        }
        JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)new AutoApproveHandler(), true, true, 500, null, null, JobIsolationLevel.Instance);
        Job job = new Job(ctx, "~\u81ea\u52a8\u5ba1\u6279(" + assign.getAssignmentId() + ")", cfg, (Object)info);
        tmp = assignment.getActivity().getProcess().getDataField(VAR_AutoApproveDelay);
        String autoApproveDelay = tmp == null ? ConfigLoader.getConfig4Server().getString("auto.approve.delay", assign.getBizObjectIds(), "28800") : tmp.toString();
        long delay = Long.parseLong(autoApproveDelay) * 1000L + (long)(AutoApprove.rand() * 1000);
        job.setScheduledTime(new Date(System.currentTimeMillis() + delay));
        JobServiceFactory.getLocalInstance((Context)ctx).createJobInstance(job);
    }
}

