/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.ext.app;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.NumberSignUtils;
import com.kingdee.eas.base.multiapprove.ext.IGoldGridNumberSignUIFacade;
import com.kingdee.eas.base.permission.NumberSignInfo;
import com.kingdee.eas.base.permission.numbersign.BatchSignInfo;
import com.kingdee.eas.base.permission.numbersign.NumberImageSignService;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.util.ArrayList;

public class GoldGridNumberSignUIFacade
implements IGoldGridNumberSignUIFacade {
    Context ctx;
    IEnactmentService wfsvc;
    ICoreBase corebase;

    public GoldGridNumberSignUIFacade(Context ctx) {
        this.ctx = ctx;
    }

    private void init(BOSUuid id) throws Exception {
        this.wfsvc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        this.corebase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)id.getType());
    }

    @Override
    public IGoldGridNumberSignUIFacade.Info4Sign getInfo4Sign(String billId, String assignmentId) throws Exception {
        IGoldGridNumberSignUIFacade.Info4Sign info = new IGoldGridNumberSignUIFacade.Info4Sign();
        info.enableNumberSign = false;
        BOSUuid id = BOSUuid.read((String)billId);
        NumberImageSignService svc = new NumberImageSignService();
        if (!svc.isStartNumberSign(this.ctx, this.ctx.getCaller())) {
            return info;
        }
        if (!svc.isStartNumberSign(this.ctx, id.getType().toString())) {
            return info;
        }
        this.init(id);
        info.enableNumberSign = true;
        info.info = this.getNumberSignInfo(assignmentId);
        info.billObject = this.getBillObject(id);
        info.currentUser = this.ctx.getCaller();
        return info;
    }

    private NumberSignInfo getNumberSignInfo(String assignmentId) throws Exception {
        AssignmentInfo assign = this.wfsvc.getAssignmentById(assignmentId);
        NumberSignInfo signInfo = new NumberSignInfo();
        signInfo.setFlowInstanceId(assign.getProcInstId());
        signInfo.setActiveInstanceId(assign.getActInstId());
        signInfo.setTaskId(assignmentId);
        String longNumber = NumberSignUtils.findLastSignLongNumber(this.ctx, assign.getProcInstId(), assign.getActDefId());
        signInfo.setLongnumber(longNumber);
        signInfo.setId(BOSUuid.create((BOSObjectType)new NumberSignInfo().getBOSType()));
        return signInfo;
    }

    private IObjectValue getBillObject(BOSUuid id) throws Exception {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CoreBaseInfo bo = this.corebase.getValue((IObjectPK)pk);
        return bo;
    }

    @Override
    public ArrayList getInfo4Sign(String[] billIds, String[] assignmentIds) throws Exception {
        BOSUuid id = BOSUuid.read((String)billIds[0]);
        NumberImageSignService svc = new NumberImageSignService();
        if (!svc.isStartNumberSign(this.ctx, this.ctx.getCaller())) {
            return null;
        }
        if (!svc.isStartNumberSign(this.ctx, id.getType().toString())) {
            return null;
        }
        this.init(id);
        ArrayList<BatchSignInfo> batchInfos = new ArrayList<BatchSignInfo>();
        for (int i = 0; i < billIds.length; ++i) {
            BatchSignInfo info = new BatchSignInfo();
            id = BOSUuid.read((String)billIds[i]);
            info.setIVo(this.getBillObject(id));
            info.setNumberSignInfo(this.getNumberSignInfo(assignmentIds[i]));
            batchInfos.add(info);
        }
        return batchInfos;
    }

    @Override
    public String getInfoAsString4Sign(String billIds, String assignmentIds) throws Exception {
        ArrayList list = this.getInfo4Sign(billIds.split(";"), assignmentIds.split(";"));
        if (list == null) {
            return "NONE";
        }
        StringBuffer procInstIds = new StringBuffer();
        StringBuffer actInstIds = new StringBuffer();
        StringBuffer longNumbers = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            NumberSignInfo info = ((BatchSignInfo)list.get(i)).getNumberSignInfo();
            if (i > 0) {
                procInstIds.append(";");
                actInstIds.append(";");
                longNumbers.append(";");
            }
            procInstIds.append(info.getFlowInstanceId());
            actInstIds.append(info.getActiveInstanceId());
            longNumbers.append(info.getLongnumber());
        }
        return procInstIds.append(",").append(actInstIds).append(",").append(longNumbers).toString();
    }
}

