/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.ISecurity;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PasswordType;
import com.kingdee.eas.base.permission.PermissionManagerFactory;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserLockTypeEnum;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.permission.util.strategy.IPasswordEncrypter;
import com.kingdee.eas.base.permission.util.strategy.MD5Encrypter;
import com.kingdee.eas.base.permission.util.strategy.SHA256Encrypter;
import com.kingdee.eas.base.permission.util.strategy.SM3Encrypter;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.CryptoUtil;
import com.kingdee.util.StringUtils;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PermissionUtils {
    private static Logger logger = Logger.getLogger(PermissionUtils.class);

    public static List getOrgStructureByCUList(Context ctx, String cuIdList) throws BOSException {
        IOrgStructure iStruct = null;
        iStruct = ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("tree.type"));
        viewInfo.getSelector().add(new SelectorItemInfo("tree.status"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.isunion"));
        viewInfo.getSorter().add(new SorterItemInfo("tree.CU.id"));
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.type", (Object)new Integer(8), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("unit.isunion", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tree.CU.id", (Object)cuIdList, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("tree.status", (Object)UnionVersionStatusEnum.START, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("tree.status", (Object)UnionVersionStatusEnum.ARCHIVE, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        viewInfo.setFilter(filter);
        OrgStructureCollection structCol = iStruct.getOrgStructureCollection(viewInfo);
        List list = ToolUtils.transCol2ListByPeroperty((IObjectCollection)structCol, new IObjectCol2List(){

            @Override
            public String getList(Object object) {
                if (object instanceof OrgStructureInfo) {
                    return ((OrgStructureInfo)object).getUnit().getId().toString();
                }
                return " ";
            }
        });
        return list;
    }

    public static String getOrgStructureByCUSQL(Context ctx, String cuIdSQL) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select unit.fid as forgid from T_ORG_Structure struct \r\n");
        sql.append("inner join T_ORG_Tree tree on struct.ftreeid = tree.fid \r\n");
        sql.append("inner join T_ORG_BaseUnit unit on struct.funitid = unit.fid \r\n");
        sql.append("where tree.ftype = 8 \r\n");
        sql.append("and unit.fisunion = 1 \r\n");
        sql.append("and tree.fcontrolunitid in (").append(cuIdSQL).append(") \r\n");
        sql.append("and (tree.fstatus = ").append(1).append(" or tree.fstatus = ").append(2).append(") \r\n");
        return sql.toString();
    }

    public static FullOrgUnitInfo[] getDifferentRoots(Context ctx, String idList) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idList, CompareType.INCLUDE));
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("longNumber"));
        SelectorItemCollection selectCol = new SelectorItemCollection();
        selectCol.add(new SelectorItemInfo("id"));
        selectCol.add(new SelectorItemInfo("longNumber"));
        view.setSelector(selectCol);
        view.setFilter(filter);
        view.setSorter(sortCol);
        IFullOrgUnit iFull = null;
        iFull = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection col = iFull.getFullOrgUnitCollection(view);
        Object[] infos = col.toArray();
        block0: for (int i = 0; i < infos.length; ++i) {
            String longNumber = ((FullOrgUnitInfo)infos[i]).getLongNumber();
            for (int j = 0; j < i; ++j) {
                if (!longNumber.startsWith(((FullOrgUnitInfo)infos[j]).getLongNumber() + "!")) continue;
                col.remove((FullOrgUnitInfo)infos[i]);
                continue block0;
            }
        }
        infos = col.toArray();
        FullOrgUnitInfo[] unitInfos = new FullOrgUnitInfo[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            unitInfos[i] = (FullOrgUnitInfo)infos[i];
        }
        return unitInfos;
    }

    public static FullOrgUnitInfo[] getDifferentRootsBySQL(Context ctx, String idSQL) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id in (" + idSQL + ")"));
        filter.getFilterItems().add(new FilterItemInfo("parent not in (" + idSQL + ")"));
        filter.getFilterItems().add(new FilterItemInfo("parent is null"));
        filter.setMaskString("#0 and (#1 or #2)");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("longNumber"));
        SelectorItemCollection selectCol = new SelectorItemCollection();
        selectCol.add(new SelectorItemInfo("id"));
        selectCol.add(new SelectorItemInfo("longNumber"));
        view.setSelector(selectCol);
        view.setFilter(filter);
        view.setSorter(sortCol);
        IFullOrgUnit iFull = null;
        iFull = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection col = iFull.getFullOrgUnitCollection(view);
        Object[] infos = col.toArray();
        block0: for (int i = 0; i < infos.length; ++i) {
            String longNumber = ((FullOrgUnitInfo)infos[i]).getLongNumber();
            for (int j = 0; j < i; ++j) {
                if (!longNumber.startsWith(((FullOrgUnitInfo)infos[j]).getLongNumber() + "!")) continue;
                col.remove((FullOrgUnitInfo)infos[i]);
                continue block0;
            }
        }
        infos = col.toArray();
        FullOrgUnitInfo[] unitInfos = new FullOrgUnitInfo[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            unitInfos[i] = (FullOrgUnitInfo)infos[i];
        }
        return unitInfos;
    }

    public static List getSubOrgIds(Context ctx, String orgIdList) throws Exception {
        FullOrgUnitInfo[] rootOrgs = PermissionUtils.getDifferentRoots(ctx, orgIdList);
        IFullOrgUnit iFull = null;
        iFull = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = rootOrgs.length - 1; i >= 0; --i) {
            FullOrgUnitInfo unit = rootOrgs[i];
            StringBuffer oql = new StringBuffer();
            oql.append("select id where longNumber like '").append(unit.getLongNumber()).append("%'");
            FullOrgUnitCollection col = iFull.getFullOrgUnitCollection(oql.toString());
            for (int j = col.size() - 1; j >= 0; --j) {
                list.add(col.get(j).getId().toString());
            }
        }
        return list;
    }

    public static String getSubOrgIdsBySQL(Context ctx, String orgIdSQL) throws Exception {
        FullOrgUnitInfo[] rootOrgs = PermissionUtils.getDifferentRootsBySQL(ctx, orgIdSQL);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid as forgid from T_ORG_BaseUnit  \r\n");
        sql.append(PermissionUtils.getLongNumberFilter(rootOrgs));
        return sql.toString();
    }

    private static String getLongNumberFilter(FullOrgUnitInfo[] rootOrgs) {
        if (rootOrgs == null || rootOrgs.length == 0) {
            return "";
        }
        StringBuffer sql = new StringBuffer();
        int size = rootOrgs.length;
        for (int i = 0; i < size; ++i) {
            FullOrgUnitInfo unit = rootOrgs[i];
            if (i == 0) {
                sql.append(" where FLongNumber like '").append(unit.getLongNumber()).append("%'");
                continue;
            }
            sql.append(" OR FLongNumber like '").append(unit.getLongNumber()).append("%'");
        }
        sql.append(" \r\n ");
        return sql.toString();
    }

    public static List getAllCU(Context ctx) throws EASBizException, BOSException {
        ICtrlUnit iCtrlUnit = null;
        iCtrlUnit = ctx == null ? CtrlUnitFactory.getRemoteInstance() : CtrlUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo entityInfo = new EntityViewInfo();
        entityInfo.getSelector().add("id");
        CtrlUnitCollection ctrlUnitCol = iCtrlUnit.getCtrlUnitCollection(entityInfo);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = ctrlUnitCol.size() - 1; i >= 0; --i) {
            if (ctrlUnitCol.get(i).getId().toString().equals("11111111-1111-1111-1111-111111111111CCE7AED4")) continue;
            list.add(ctrlUnitCol.get(i).getId().toString());
        }
        return list;
    }

    public static String encrypt(String userID, String password) throws EASBizException {
        assert (password != null);
        try {
            return CryptoUtil.encrypt((String)(userID + password.trim()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new UserException(UserException.ENCRYPT_FAIL);
        }
    }

    public static boolean isIncludeAuthenPerms(String roleIdStr) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)roleIdStr)) {
            return false;
        }
        return PermissionManagerFactory.getRemoteInstance().isRoleIncludeAuthenPerms(roleIdStr);
    }

    public static boolean isIncludeAuthenPerms(UserOrgPermCollection uops) throws EASBizException, BOSException {
        if (uops != null && uops.size() > 0) {
            ArrayList<String> permIdList = new ArrayList<String>();
            String permIdStr = "";
            for (int i = 0; i < uops.size(); ++i) {
                UserOrgPermInfo uopInfo = uops.get(i);
                permIdList.add(uopInfo.getPermItem().getId().toString());
            }
            permIdStr = ToolUtils.aryToStr(permIdList);
            return PermissionManagerFactory.getRemoteInstance().isIncludeAuthenPerms(permIdStr);
        }
        return false;
    }

    public static boolean isIncludeAuthenPerms(RolePermCollection rps) throws EASBizException, BOSException {
        if (rps != null && rps.size() > 0) {
            ArrayList<String> permIdList = new ArrayList<String>();
            String permIdStr = "";
            for (int i = 0; i < rps.size(); ++i) {
                RolePermInfo rolePermInfo = rps.get(i);
                permIdList.add(rolePermInfo.getPermItem().getId().toString());
            }
            permIdStr = ToolUtils.aryToStr(permIdList);
            return PermissionManagerFactory.getRemoteInstance().isIncludeAuthenPerms(permIdStr);
        }
        return false;
    }

    public static PasswordType getPasswordType(Context ctx) throws EASBizException, BOSException {
        String passwordType = ParamManager.getParamValue((Context)ctx, null, (String)"UserPasswordType");
        if ("0".equals(passwordType)) {
            return PasswordType.SHA256;
        }
        if ("1".equals(passwordType)) {
            return PasswordType.SM3;
        }
        return PasswordType.MD5;
    }

    public static String encrypt(String userID, String password, PasswordType passwordType) throws EASBizException {
        IPasswordEncrypter encrypter = null;
        encrypter = PasswordType.SHA256.equals((Object)passwordType) ? new SHA256Encrypter() : (PasswordType.SM3.equals((Object)passwordType) ? new SM3Encrypter() : new MD5Encrypter());
        return encrypter.encrypt(userID, password);
    }

    public static boolean matchPassword(UserInfo userInfo, String password) throws EASBizException {
        String oldPassword;
        String string = oldPassword = userInfo.getPassword() == null ? "" : userInfo.getPassword();
        if (StringUtils.isEmpty((String)password)) {
            return StringUtils.isEmpty((String)oldPassword);
        }
        if (oldPassword.length() == 24) {
            return PermissionUtils.encrypt(userInfo.getId().toString(), password, PasswordType.MD5).equals(oldPassword);
        }
        return PermissionUtils.encrypt(userInfo.getId().toString(), password, userInfo.getPasswordType()).equals(oldPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean matchPasswordWithSecurity(UserInfo userInfo, String password) throws EASBizException, BOSException {
        boolean isMatch = false;
        ISecurity iSecurity = SecurityFactory.getRemoteInstance();
        SecurityInfo securityInfo = iSecurity.getSecurityInfo((IObjectPK)new ObjectUuidPK(userInfo.getSecurity().getId()));
        userInfo.setSecurity(securityInfo);
        String userNumber = userInfo.getNumber();
        try {
            if (userInfo.isIsLocked()) {
                int lockedMinutes = UserLockTypeEnum.UPDATE_PASSWORD.equals((Object)userInfo.getLockType()) ? userInfo.getSecurity().getLockUpdatePwTime() : userInfo.getSecurity().getLockTime();
                int goneMinutes = (int)((System.currentTimeMillis() - userInfo.getLockedTime().getTime()) / 60000L);
                if (goneMinutes - lockedMinutes >= 0) {
                    PermissionUtils.autoUnlock(userInfo);
                    userInfo.setErrCount(0);
                    isMatch = PermissionUtils.matchPassword(userInfo, password);
                    if (!isMatch) {
                        if (userInfo.getSecurity().isNeedLocked()) {
                            if (userInfo.getSecurity().getLockCount() <= userInfo.getErrCount() + 1) {
                                throw new UserException(UserException.USER_IS_LOCKED, new Object[]{new Integer(lockedMinutes)});
                            }
                            logger.error((Object)("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\uff0c\u7528\u6237\uff1a" + userNumber));
                            throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
                        }
                        logger.error((Object)("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\uff0c\u7528\u6237\uff1a" + userNumber));
                        throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
                    }
                    logger.error((Object)("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\uff0c\u7528\u6237\uff1a" + userNumber));
                    throw new UserException(UserException.USER_IS_LOCKED, new Object[]{String.valueOf(lockedMinutes - goneMinutes)});
                }
            } else {
                isMatch = PermissionUtils.matchPassword(userInfo, password);
                if (!isMatch) {
                    if (userInfo.getSecurity().isNeedLocked()) {
                        if (userInfo.getSecurity().getLockCount() <= userInfo.getErrCount() + 1) {
                            throw new UserException(UserException.USER_IS_LOCKED, new Object[]{new Integer(userInfo.getSecurity().getLockTime())});
                        }
                        logger.error((Object)("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\uff0c\u7528\u6237\uff1a" + userNumber));
                        throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
                    }
                    logger.error((Object)("\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\uff0c\u7528\u6237\uff1a" + userNumber));
                    throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
                }
            }
        }
        finally {
            PermissionUtils.handleAfterMatch(userInfo, isMatch, password);
        }
        return isMatch;
    }

    private static void autoUnlock(UserInfo userInfo) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getRemoteInstance();
        iUser.lockUsers((IObjectPK[])new ObjectUuidPK[]{new ObjectUuidPK(userInfo.getId())}, false);
    }

    private static void handleAfterMatch(UserInfo userInfo, boolean isLogon, String logonPassword) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getRemoteInstance();
        if (userInfo.getSecurity().isNeedLocked()) {
            if (isLogon) {
                userInfo.setErrCount(0);
                userInfo.setLockedTime(null);
                userInfo.setIsLocked(false);
                userInfo.setLockType(UserLockTypeEnum.NONE);
                iUser.update((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectValue)userInfo, false);
            } else if (!userInfo.isIsLocked()) {
                if (userInfo.getSecurity().getLockCount() <= userInfo.getErrCount() + 1) {
                    userInfo.setErrCount(userInfo.getErrCount() + 1);
                    userInfo.setLockedTime(new Time(System.currentTimeMillis()));
                    userInfo.setLockType(UserLockTypeEnum.LOGIN);
                    userInfo.setIsLocked(true);
                    iUser.update((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectValue)userInfo, false);
                } else {
                    userInfo.setErrCount(userInfo.getErrCount() + 1);
                    iUser.update((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectValue)userInfo, false);
                }
            }
        }
    }
}

