/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.permission.IRule;
import com.kingdee.eas.base.permission.RuleCollection;
import com.kingdee.eas.base.permission.RuleFactory;
import com.kingdee.eas.base.permission.RuleInfo;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.HashSet;

public class RuleParser {
    private Context ctx = null;
    private EntityObjectInfo entity = null;
    private String ruleStructure = null;
    private RuleCollection rules = null;

    public RuleParser(EntityObjectInfo entity) {
        this.entity = entity;
    }

    public RuleParser(BOSObjectType entityType) {
        this.entity = this.getEntity(entityType);
    }

    public RuleParser(Context ctx, EntityObjectInfo entity) {
        this.ctx = ctx;
        this.entity = entity;
    }

    public RuleParser(Context ctx, BOSObjectType entityType) {
        this.ctx = ctx;
        this.entity = this.getEntity(entityType);
    }

    public void setRuleStructure(String ruleStructure) throws BOSException {
        this.ruleStructure = ruleStructure;
        if (!StringUtils.isEmpty((String)ruleStructure)) {
            this.rules = this.getRules(ruleStructure);
        }
    }

    private IRule getRuleInterface() throws BOSException {
        IRule iRule = null;
        iRule = this.ctx == null ? RuleFactory.getRemoteInstance() : RuleFactory.getLocalInstance(this.ctx);
        return iRule;
    }

    private RuleCollection getRules(String ruleStructure) throws BOSException {
        HashSet<String> ruleIDs = new HashSet<String>();
        String[] temps = StringUtils.split((String)ruleStructure, (String)" ");
        if (temps != null) {
            int length = temps.length;
            for (int i = 0; i < length; ++i) {
                if (!RuleUtil.isRuleID(temps[i])) continue;
                ruleIDs.add(temps[i]);
            }
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (ruleIDs.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", ruleIDs, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            IRule iRule = this.getRuleInterface();
            return iRule.getRuleCollection(entityViewInfo);
        }
        return null;
    }

    public String buildExpr() throws EASBizException, ParserException, BOSException {
        StringBuffer ruleExpr = new StringBuffer();
        if (!StringUtils.isEmpty((String)this.ruleStructure)) {
            for (String str : StringUtils.split((String)this.ruleStructure, (String)" ")) {
                if (RuleUtil.isRuleID(str)) {
                    ruleExpr.append(" ");
                    ruleExpr.append(this.buildRuleExpr(str));
                    ruleExpr.append(" ");
                    continue;
                }
                ruleExpr.append(" ");
                ruleExpr.append(str);
                ruleExpr.append(" ");
            }
        }
        return ruleExpr.toString();
    }

    private String buildRuleExpr(String ruleID) throws ParserException, EASBizException, BOSException {
        StringBuffer ruleExpr = new StringBuffer();
        RuleInfo ruleInfo = this.getRuleInfo(ruleID);
        ruleExpr.append("(");
        if (!StringUtils.isEmpty((String)ruleInfo.getScript())) {
            if (this.isSelfUsed(ruleInfo)) {
                ruleExpr.append("(");
                ruleExpr.append(ruleInfo.getScript());
                ruleExpr.append(")");
            } else if (RuleUtil.isEntryRule(this.entity, ruleInfo)) {
                ruleExpr.append(this.buildEntryRule(ruleInfo.getScript()));
            }
        }
        ruleExpr.append(this.getDataExpr(ruleInfo));
        ruleExpr.append(")");
        return ruleExpr.toString();
    }

    private String getDataExpr(RuleInfo ruleInfo) {
        LogicSignEnum logic = ruleInfo.getLogic();
        String dataIds = ruleInfo.getDataIds();
        StringBuffer expr = new StringBuffer();
        if (logic != null && !StringUtils.isEmpty((String)logic.getValue()) && !StringUtils.isEmpty((String)dataIds)) {
            if (!StringUtils.isEmpty((String)ruleInfo.getScript())) {
                expr.append(" ").append(logic.getValue());
            }
            expr.append(" id in (").append(dataIds).append(") ");
        }
        return expr.toString();
    }

    private String buildEntryRule(String script) throws ParserException {
        StringBuffer buffer = new StringBuffer();
        String entryPropertyName = RuleUtil.getEntryPropertyName(script);
        script = StringUtils.replace((String)script, (String)(entryPropertyName + "."), (String)"");
        buffer.append("(");
        buffer.append(script);
        buffer.append(")");
        return buffer.toString();
    }

    private boolean isSelfUsed(RuleInfo ruleInfo) throws EASBizException, ParserException, BOSException {
        boolean isSameEntity = this.entity.getType().toString().equals(ruleInfo.getBizObject());
        if (isSameEntity) {
            return !RuleUtil.isEntryRule(this.entity, ruleInfo);
        }
        return false;
    }

    private IMetaDataLoader getMetaDataLoader() {
        IMetaDataLoader loader = null;
        loader = this.ctx != null ? MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx) : MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader;
    }

    private EntityObjectInfo getEntity(BOSObjectType entityType) {
        IMetaDataLoader loader = this.getMetaDataLoader();
        EntityObjectInfo entityObjectInfo = loader.getEntity(entityType);
        return entityObjectInfo;
    }

    private RuleInfo getRuleInfo(String ruleID) {
        return this.rules.get(BOSUuid.read((String)ruleID));
    }
}

