/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.CacheUtil;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UserUtils {
    public static List getOrgRangeByType(UserInfo curUserInfo, OrgRangeType orgRangeType) {
        OrgRangeCollection orgCol;
        if (curUserInfo != null && curUserInfo.getOrgRange() != null && !(orgCol = curUserInfo.getOrgRange()).isEmpty()) {
            ArrayList<String> orgList = new ArrayList<String>();
            int size = orgCol.size();
            for (int i = 0; i < size; ++i) {
                OrgRangeInfo orgRangeInfo = orgCol.get(i);
                if (orgRangeInfo == null || orgRangeInfo.getOrg() == null || !orgRangeType.equals((Object)orgRangeInfo.getType())) continue;
                orgList.add(orgCol.get(i).getOrg().getId().toString());
            }
            return orgList;
        }
        return new ArrayList();
    }

    public static String getOrgRangeByTypeSQL(UserInfo curUserInfo, OrgRangeType orgRangeType) {
        String userId = curUserInfo.getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select distinct forgid from t_pm_orgrange where fuserid = '").append(userId).append("'");
        if (orgRangeType != null) {
            sb.append(" and ftype = ").append(orgRangeType.getValue());
        }
        return sb.toString();
    }

    public static List getCurrentUserOrgRangeListByAdmin(UserInfo curUserInfo) {
        return UserUtils.getOrgRangeByType(curUserInfo, OrgRangeType.BIZ_ORG_TYPE);
    }

    public static String getCurrentUserOrgRangeSQLByAdmin(UserInfo curUserInfo) {
        return UserUtils.getOrgRangeByTypeSQL(curUserInfo, OrgRangeType.BIZ_ORG_TYPE);
    }

    public static List getCurrentUserManageOrgRangeListByUser(UserInfo curUserInfo) {
        return UserUtils.getOrgRangeByType(curUserInfo, OrgRangeType.MANAGE_ORG_TYPE);
    }

    public static String getCurrentUserManageOrgRangeSQLByUser(UserInfo curUserInfo) {
        return UserUtils.getOrgRangeByTypeSQL(curUserInfo, OrgRangeType.MANAGE_ORG_TYPE);
    }

    public static List getManagedCuIDList(UserInfo curUserInfo) {
        if (Administrator.isAdminType(curUserInfo.getType())) {
            return UserUtils.getCurrentUserOrgRangeListByAdmin(curUserInfo);
        }
        return UserUtils.getCurrentUserManageOrgRangeListByUser(curUserInfo);
    }

    public static String getManagedCuIDSQL(UserInfo curUserInfo) {
        if (Administrator.isAdminType(curUserInfo.getType())) {
            return UserUtils.getCurrentUserOrgRangeSQLByAdmin(curUserInfo);
        }
        return UserUtils.getCurrentUserManageOrgRangeSQLByUser(curUserInfo);
    }

    public static FilterInfo getUserFilter(UserInfo userInfo, String fieldName) throws BOSException {
        if (Administrator.isSuperAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            return new FilterInfo();
        }
        FilterInfo cuFilter = UserUtils.getCuFilter(userInfo, fieldName);
        FilterInfo adminFilter = UserUtils.getAdminFilter(userInfo, fieldName);
        cuFilter.mergeFilter(adminFilter, "and");
        return cuFilter;
    }

    private static FilterInfo getCuFilter(UserInfo userInfo, String fieldName) {
        String cuIdSql = UserUtils.getManagedCuIDSQL(userInfo);
        FilterItemInfo filterItem = new FilterItemInfo(fieldName + ".CU.id in (" + cuIdSql + ")");
        FilterInfo cuFilter = new FilterInfo();
        cuFilter.getFilterItems().add(filterItem);
        return cuFilter;
    }

    public static FilterInfo getCUFilter(Context ctx, IObjectPK userPK, String fieldName) throws EASBizException, BOSException {
        UserInfo userInfo = CacheUtil.getCacheUserInfo(ctx, userPK.toString());
        return UserUtils.getCuFilter(userInfo, fieldName);
    }

    private static FilterInfo getAdminFilter(UserInfo userInfo, String fieldName) {
        FilterInfo userFilterInfo = new FilterInfo();
        if (Administrator.isAdminType(userInfo.getType())) {
            userFilterInfo.getFilterItems().add(new FilterItemInfo(fieldName + ".id", (Object)"00000000-0000-0000-0000-00000000000013B7DE7F", CompareType.NOTEQUALS));
            userFilterInfo.getFilterItems().add(new FilterItemInfo(fieldName + ".id", (Object)"00000000-0000-0000-0000-00000000000113B7DE7F", CompareType.NOTEQUALS));
            userFilterInfo.getFilterItems().add(new FilterItemInfo(fieldName + ".id", (Object)"00000000-0000-0000-0000-00000000000213B7DE7F", CompareType.NOTEQUALS));
        } else if (userInfo.isBizAdmin()) {
            userFilterInfo.getFilterItems().add(new FilterItemInfo(fieldName + ".type", (Object)"10", CompareType.NOTEQUALS));
        }
        return userFilterInfo;
    }

    public static FilterInfo getOrgUserFilter(Context ctx, IObjectPK orgPK, OrgRangeType type) throws Exception {
        FilterInfo ret = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("id", (Object)UserUtils.getUserIdSetByOrg(ctx, orgPK, type), CompareType.INCLUDE);
        ret.getFilterItems().add(item);
        return ret;
    }

    public static Set getUserIdSetByOrg(Context ctx, IObjectPK orgPK, OrgRangeType type) throws Exception {
        IOrgRange iOrgRange = null;
        iOrgRange = ctx == null ? OrgRangeFactory.getRemoteInstance() : OrgRangeFactory.getLocalInstance(ctx);
        HashSet<String> userIdSet = new HashSet<String>();
        OrgRangeCollection orgRangeCol = iOrgRange.getOrgRangeCollection("org.id='" + orgPK.toString() + "' and type=" + (Object)((Object)type));
        for (int i = 0; i < orgRangeCol.size(); ++i) {
            userIdSet.add(orgRangeCol.get(i).getUser().getId().toString());
        }
        return userIdSet;
    }
}

