/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.permission.AuthenModeTypeEnum;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.app.AbstractAuthenModeControllerBean;
import com.kingdee.eas.base.permission.app.plunin.PermissionChangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AuthenModeControllerBean
extends AbstractAuthenModeControllerBean {
    @Override
    protected void _update(Context ctx, AuthenModeTypeEnum typeEnum, boolean isEnable) throws BOSException {
        this.initAddNewUserAuthen(ctx, typeEnum);
        DbUtil.execute((Context)ctx, (String)"update T_PM_AuthenMode set FIsEnable = ? where FModeType = ?", (Object[])new Object[]{isEnable, typeEnum.getValue()});
        this.cleanCache(ctx);
    }

    public void cleanCache(Context ctx) throws BOSException {
        IRowSet rowSets = DbUtil.executeQuery((Context)ctx, (String)"select distinct FUSERID  from t_pm_authenschemeorguser");
        HashSet<ObjectStringPK> userIds = new HashSet<ObjectStringPK>();
        try {
            while (rowSets.next()) {
                userIds.add(new ObjectStringPK(rowSets.getString("FUSERID")));
            }
        }
        catch (SQLException e1) {
            logger.error((Object)e1);
            throw new BOSException((Throwable)e1);
        }
        PermissionChangeHelper helper = new PermissionChangeHelper();
        helper.setUserPKs(userIds.toArray(new IObjectPK[userIds.size()]));
        try {
            helper.exceChange(ctx);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _isEnabled(Context ctx, AuthenModeTypeEnum authenModeType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FIsEnable from T_PM_AuthenMode where FModeType = ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{authenModeType.getValue()});
        try {
            if (rowSet.next()) {
                return rowSet.getBoolean("FIsEnable");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected boolean _isEnabledAuthenticadeAdmin(Context ctx) throws BOSException {
        return this._isEnabled(ctx, AuthenModeTypeEnum.OpenAuthen);
    }

    protected void initPermAuthen(Context ctx) throws BOSException {
        if (this.isInitedPermAuthen(ctx)) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_PM_AuthenMode(FModeType,FIsEnable) values('20',1)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected boolean isInitedPermAuthen(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from T_PM_AuthenMode where fmodeType ='" + AuthenModeTypeEnum.UserPermChangeAuthen.getValue() + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected void initAddNewUserAuthen(Context ctx, AuthenModeTypeEnum authenModeTypeEnum) throws BOSException {
        String sql = "if not exists (select * from T_PM_AuthenMode where fmodeType='" + authenModeTypeEnum.getValue() + "') INSERT INTO T_PM_AuthenMode(FModeType,FIsEnable) values('" + authenModeTypeEnum.getValue() + "',1)";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected boolean _isEnablePermAuthen(Context ctx, List permList, List orgList) throws BOSException {
        int i;
        if (permList == null || permList.isEmpty() || orgList == null || orgList.isEmpty()) {
            return false;
        }
        if (!this._isEnabled(ctx, AuthenModeTypeEnum.UserPermChangeAuthen)) {
            return false;
        }
        StringBuilder permSb = new StringBuilder("''");
        for (int i2 = 0; i2 < permList.size(); ++i2) {
            String roleId = (String)permList.get(i2);
            permSb.append(",'").append(roleId).append("'");
        }
        ToolUtils.sqlCheck(permSb.toString());
        PermItemCollection permItemColl = PermItemFactory.getLocalInstance(ctx).getPermItemCollection("select id,longNumber where isleaf = 0 and id in (" + permSb + ")");
        StringBuilder whereLikeSb = new StringBuilder();
        ArrayList<String> isNotLeafPermItemList = new ArrayList<String>(permItemColl.size());
        if (permItemColl.size() != 0) {
            for (int i3 = 0; i3 < permItemColl.size(); ++i3) {
                whereLikeSb.append(" LongNumber like '%").append(permItemColl.get(i3).getLongNumber()).append("!%' ");
                whereLikeSb.append(i3 < permItemColl.size() - 1 ? " or " : "");
                isNotLeafPermItemList.add(permItemColl.get(i3).getId().toString());
            }
            permList.removeAll(isNotLeafPermItemList);
            PermItemCollection leafPermItemColl = PermItemFactory.getLocalInstance(ctx).getPermItemCollection("select id where isleaf = 1 and (" + whereLikeSb + ")");
            for (i = 0; i < leafPermItemColl.size(); ++i) {
                permList.add(leafPermItemColl.get(i).getId().toString());
            }
        }
        permSb = new StringBuilder("''");
        for (int i4 = 0; i4 < permList.size(); ++i4) {
            String roleId = (String)permList.get(i4);
            permSb.append(",'").append(roleId).append("'");
        }
        StringBuilder orgSb = new StringBuilder("'11111111-1111-1111-1111-111111111111CCE7AED4'");
        for (i = 0; i < orgList.size(); ++i) {
            String orgId = (String)orgList.get(i);
            orgSb.append(",'").append(orgId).append("'");
        }
        StringBuilder queryAuthentorSql = new StringBuilder();
        ToolUtils.sqlCheck(permSb.toString());
        queryAuthentorSql.append("select authenscheme.fid ").append("from T_PM_AuthenScheme AS authenscheme  where exists (select 1 from T_PM_AuthenSchemePerm AS schemeperm where authenscheme.fid = schemeperm.fauthenschemeid ").append(" and schemeperm.FPERMITEMID in (").append((CharSequence)permSb).append(")) ");
        if (!"all".equals(orgList.get(0))) {
            ToolUtils.sqlCheck(orgSb.toString());
            queryAuthentorSql.append(" and exists (select 1 from t_pm_authenschemeorguser orguser where orguser.FAuthenSchemeId = authenscheme.fid ").append(" and orguser.FOrgId in (").append((CharSequence)orgSb).append("))");
        }
        try {
            IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)queryAuthentorSql.toString());
            if (rowSet2.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected boolean _isEnableRoleAuthen(Context ctx, List roleList, List orgList) throws BOSException {
        if (roleList == null || roleList.isEmpty() || orgList == null || orgList.isEmpty()) {
            return false;
        }
        if (!this._isEnabled(ctx, AuthenModeTypeEnum.UserPermChangeAuthen)) {
            return false;
        }
        StringBuilder roleSb = new StringBuilder("''");
        for (int i = 0; i < roleList.size(); ++i) {
            String roleId = (String)roleList.get(i);
            roleSb.append(",'").append(roleId).append("'");
        }
        StringBuilder orgSb = new StringBuilder("'11111111-1111-1111-1111-111111111111CCE7AED4'");
        for (int i = 0; i < orgList.size(); ++i) {
            String orgId = (String)orgList.get(i);
            orgSb.append(",'").append(orgId).append("'");
        }
        StringBuilder queryAuthentorSql = new StringBuilder();
        ToolUtils.sqlCheck(roleSb.toString());
        ToolUtils.sqlCheck(orgSb.toString());
        queryAuthentorSql.append("select authenscheme.fid ").append("from T_PM_AuthenScheme AS authenscheme  where exists (select 1 from T_PM_AuthenSchemePerm AS schemeperm where authenscheme.fid = schemeperm.fauthenschemeid ").append(" and exists (select 1 from T_PM_RolePerm rp where rp.FPermItemID = schemeperm.FPERMITEMID and  rp.FRoleID in (").append((CharSequence)roleSb).append("))) ").append(" and exists (select 1 from t_pm_authenschemeorguser orguser where orguser.FAuthenSchemeId = authenscheme.fid ").append(" and orguser.FOrgId in (").append((CharSequence)orgSb).append("))");
        try {
            IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)queryAuthentorSql.toString());
            if (rowSet2.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private String getLongNumberFilter(UserOrgPermCollection uopParents) {
        PermItemInfo parentPerm = null;
        StringBuffer sql = new StringBuffer();
        if (uopParents == null || uopParents.size() == 0) {
            return "";
        }
        sql.append(" AND (");
        int size = uopParents.size();
        for (int i = 0; i < size; ++i) {
            parentPerm = uopParents.get(i).getPermItem();
            if (i == 0) {
                sql.append(" FLongNumber like '" + parentPerm.getLongNumber() + "!%'");
                continue;
            }
            sql.append(" OR FLongNumber like '" + parentPerm.getLongNumber() + "!%'");
        }
        sql.append(") \r\n ");
        return sql.toString();
    }

    private String getPermTypeFilter(String fieldName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" AND (");
        sql.append(fieldName).append("=").append(20);
        sql.append(" OR ").append(fieldName).append("=").append(30);
        sql.append(" )  \r\n");
        return sql.toString();
    }
}

