/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.AuthenSchemeOrgUserCollection;
import com.kingdee.eas.base.permission.AuthenSchemeOrgUserFactory;
import com.kingdee.eas.base.permission.AuthenSchemeOrgUserInfo;
import com.kingdee.eas.base.permission.app.AbstractAuthenSchemeOrgUserControllerBean;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AuthenSchemeOrgUserControllerBean
extends AbstractAuthenSchemeOrgUserControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.AuthenSchemeOrgUserControllerBean");
    private int MAX_RECORD_COUNT = 8000;

    @Override
    protected void _assignAuthenScheme(Context ctx, String authenSchemeId, Set orgIdSet, Set userIdSet, boolean isCheck) throws BOSException {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            Map authenSchemeOrgUserMap = this.getAuthenSchemeAllHasAssign(ctx, authenSchemeId);
            con = EJBFactory.getConnection((Context)ctx);
            Map canAssignOrg2UserMap = null;
            if (isCheck) {
                canAssignOrg2UserMap = this.getCanAssignOrg2UserMap(con, userIdSet, orgIdSet);
            }
            this.updateUserStatus(con, userIdSet);
            StringBuffer sql = new StringBuffer();
            sql.append("insert into t_pm_authenschemeorguser(fid, fauthenschemeid, forgid, fuserid) ").append("values(?, ?, ?, ?)");
            statement = con.prepareStatement(sql.toString());
            int count = 0;
            String recordId = null;
            String orgId = null;
            HashSet thisUserIdSet = null;
            HashSet needInsertUserIdSet = null;
            for (Object orgIdObj : orgIdSet) {
                orgId = (String)orgIdObj;
                thisUserIdSet = (HashSet)authenSchemeOrgUserMap.get(orgId);
                if (thisUserIdSet == null) {
                    thisUserIdSet = new HashSet(0);
                }
                needInsertUserIdSet = new HashSet();
                needInsertUserIdSet.addAll(userIdSet);
                needInsertUserIdSet.removeAll(thisUserIdSet);
                Set canAssignUserSet = null;
                if (isCheck && canAssignOrg2UserMap != null) {
                    canAssignUserSet = (Set)canAssignOrg2UserMap.get(orgIdObj);
                }
                for (Object userIdObj : needInsertUserIdSet) {
                    if (isCheck && !userIdObj.equals("00000000-0000-0000-0000-00000000000113B7DE7F") && (canAssignUserSet == null || !canAssignUserSet.contains(userIdObj))) continue;
                    recordId = BOSUuid.create((String)"D4935565").toString();
                    statement.setString(1, recordId);
                    statement.setString(2, authenSchemeId);
                    statement.setString(3, orgId);
                    statement.setObject(4, userIdObj);
                    statement.addBatch();
                    if (++count <= this.MAX_RECORD_COUNT) continue;
                    statement.executeBatch();
                    statement.clearBatch();
                    count = 0;
                }
            }
            if (count > 0) {
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    private Map getCanAssignOrg2UserMap(Connection conn, Set userIdSet, Set orgIdSet) throws BOSException {
        HashMap hashMap;
        PreparedStatement queryStatement = null;
        PreparedStatement queryStatementUser = null;
        ResultSet resultSet = null;
        ResultSet userSet = null;
        try {
            StringBuffer querySql = new StringBuffer();
            querySql.append("select orgrange.forgid orgid, orgrange.fuserid userid ").append("from t_pm_orgrange orgrange ").append("where orgrange.ftype = ? ").append(" AND orgrange.forgid in (").append(ToolUtils.aryToStr((Collection)orgIdSet, (boolean)true)).append(")").append(" AND orgrange.fuserid in (").append(ToolUtils.aryToStr((Collection)userIdSet, (boolean)true)).append(")").append("order by orgrange.forgid, orgrange.fuserid, orgrange.ftype");
            queryStatement = conn.prepareStatement(querySql.toString());
            queryStatement.setInt(1, 10);
            resultSet = queryStatement.executeQuery();
            HashMap org2UserMap = new HashMap();
            String orgId = null;
            String lastOrgId = null;
            String userId = null;
            HashSet<String> canAssignUserIdSet = null;
            while (resultSet.next()) {
                orgId = resultSet.getString("orgid");
                userId = resultSet.getString("userid");
                if (!orgId.equals(lastOrgId)) {
                    canAssignUserIdSet = (HashSet<String>)org2UserMap.get(orgId);
                }
                if (canAssignUserIdSet == null) {
                    canAssignUserIdSet = new HashSet<String>();
                    org2UserMap.put(orgId, canAssignUserIdSet);
                }
                canAssignUserIdSet.add(userId);
                lastOrgId = orgId;
            }
            querySql = new StringBuffer();
            querySql.append("select pmuser.fid userid, pmuser.ftype usertype ").append("from t_pm_user pmuser ").append("where pmuser.fid in (").append(ToolUtils.aryToStr((Collection)userIdSet, (boolean)true)).append(")").append(" AND pmuser.ftype = 60 ");
            queryStatementUser = conn.prepareStatement(querySql.toString());
            userSet = queryStatementUser.executeQuery();
            while (userSet.next()) {
                if (canAssignUserIdSet == null) {
                    canAssignUserIdSet = new HashSet();
                }
                canAssignUserIdSet.add(userSet.getString("userid"));
                for (Object id : orgIdSet) {
                    org2UserMap.put((String)id, canAssignUserIdSet);
                }
            }
            hashMap = org2UserMap;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, queryStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)queryStatement);
        return hashMap;
    }

    @Override
    protected void _cancelAssignAuthenScheme(Context ctx, String authenSchemeId, Set orgIdSet, Set userIdSet) throws BOSException {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("delete from t_pm_authenschemeorguser ").append("where forgid = ? and fuserid = ? and fauthenschemeid = ?");
            statement = con.prepareStatement(sql.toString());
            int count = 0;
            for (Object orgIdObj : orgIdSet) {
                for (Object userIdObj : userIdSet) {
                    statement.setObject(1, orgIdObj);
                    statement.setObject(2, userIdObj);
                    statement.setObject(3, authenSchemeId);
                    statement.addBatch();
                    if (++count <= this.MAX_RECORD_COUNT) continue;
                    statement.executeBatch();
                    statement.clearBatch();
                    count = 0;
                }
            }
            if (count > 0) {
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
            String updateUser = "UPDATE T_PM_USER  set FISAUTHENADMIN = 0  where fid in (" + ToolUtils.aryToStr((Collection)userIdSet, (boolean)true) + ") and fid <> '" + "00000000-0000-0000-0000-00000000000113B7DE7F" + "' and not exists(select 1 from t_pm_authenschemeorguser asou where asou.fuserid = T_PM_USER.fid)";
            DbUtil.execute((Context)ctx, (String)updateUser);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserStatus(Connection con, Set needUpdateUserIdSet) throws SQLException {
        PreparedStatement statement = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("update t_pm_user set fisauthenadmin = 1 where fid = ?");
            statement = con.prepareStatement(sql.toString());
            int count = 0;
            for (Object needUpdateUserIdObj : needUpdateUserIdSet) {
                statement.setObject(1, needUpdateUserIdObj);
                statement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                statement.executeBatch();
                statement.clearBatch();
                count = 0;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(statement);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)statement);
    }

    private Map getAuthenSchemeAllHasAssign(Context ctx, String authenSchemeId) throws BOSException {
        AuthenSchemeOrgUserCollection authenSchemeOrgUserCol = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection filterItemCol = filter.getFilterItems();
            filterItemCol.add(new FilterItemInfo("authenScheme", (Object)authenSchemeId, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection selectorItemCol = new SelectorItemCollection();
            selectorItemCol.add(new SelectorItemInfo("org.id"));
            selectorItemCol.add(new SelectorItemInfo("user.id"));
            view.setSelector(selectorItemCol);
            SorterItemCollection sorterItemCol = new SorterItemCollection();
            sorterItemCol.add(new SorterItemInfo("org.id"));
            view.setSorter(sorterItemCol);
            authenSchemeOrgUserCol = AuthenSchemeOrgUserFactory.getLocalInstance(ctx).getAuthenSchemeOrgUserCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        HashMap authenSchemeOrgUserMap = new HashMap();
        Iterator authenSchemeOrgUserIter = authenSchemeOrgUserCol.iterator();
        AuthenSchemeOrgUserInfo authenSchemeOrgUserInfo = null;
        String lastOrgUnitId = null;
        String orgUnitId = null;
        String userId = null;
        Set<String> userSet = null;
        while (authenSchemeOrgUserIter.hasNext()) {
            authenSchemeOrgUserInfo = (AuthenSchemeOrgUserInfo)authenSchemeOrgUserIter.next();
            orgUnitId = authenSchemeOrgUserInfo.getOrg().getId().toString();
            userId = authenSchemeOrgUserInfo.getUser().getId().toString();
            if (!StringUtils.isEmpty(lastOrgUnitId) && !lastOrgUnitId.equals(orgUnitId)) {
                userSet = (Set)authenSchemeOrgUserMap.get(orgUnitId);
            }
            if (userSet == null) {
                userSet = new HashSet<String>();
                authenSchemeOrgUserMap.put(orgUnitId, userSet);
            }
            userSet.add(userId);
            lastOrgUnitId = orgUnitId;
        }
        return authenSchemeOrgUserMap;
    }
}

